/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dataTable.HecDataTableFrame;
import hec.dssgui.Help;
import hec.dssgui.ListSelection;
import hec.dssgui.SelectRecords;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.HecDouble;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;

public class Search {
    protected ListSelection _listSelection;

    public Search(ListSelection listSelection) {
        this._listSelection = listSelection;
    }

    public void searchDb() {
        Object message;
        double tolerance;
        String previousSearchTol;
        HecDouble previousValueTol;
        DataReferenceSet drs = this._listSelection._selectionAndFilterPanel.getSelectedPathnames();
        for (int i = 0; i < drs.size(); ++i) {
            DataReference dataReference = drs.get(i);
            String path = dataReference.getPathname();
            int type = HecDataManager.pathnameDataType((String)path);
            if (type >= 100 && type < 300) continue;
            this._listSelection.setCursorDefault();
            String message2 = "Search Data Sets is currently implemented for time series and paired data only";
            System.out.println(message2);
            Search search = this;
            if (search._listSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this._listSelection, message2, "Search Data Sets", 2);
            }
            return;
        }
        String previousSearch = this._listSelection._preferences.get("previousSearch", "");
        HecDouble previousValue = new HecDouble(previousSearch);
        SearchDialog sd = new SearchDialog(this._listSelection, previousValue, previousValueTol = new HecDouble(previousSearchTol = this._listSelection._preferences.get("previousSearchTol", "")));
        if (sd.isCanceled()) {
            return;
        }
        HecDouble val = sd.getValue();
        if (!val.isDefined()) {
            String message3 = "Invalid number. ";
            System.out.println(message3);
            Search search = this;
            if (search._listSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this._listSelection, message3, "Search", 2);
            }
            return;
        }
        int type = sd.getSearchType();
        this._listSelection._preferences.put("previousSearch", val.toString());
        HecDouble tol = sd.getTolerance();
        if (tol.isDefined()) {
            tolerance = tol.value();
            this._listSelection._preferences.put("previousSearchTol", tol.toString());
        } else {
            tolerance = type == 1 ? val.getTolerances(val) : 0.0;
            this._listSelection._preferences.put("previousSearchTol", "");
        }
        SearchDouble value = new SearchDouble(val, type, tolerance);
        this._listSelection.setCursorWait("Reading data");
        Vector<DataReference> foundData = new Vector<DataReference>();
        for (int n = 0; n < drs.size(); ++n) {
            Object obj;
            int i;
            DataReference dataReference = drs.get(n);
            DataReferenceSet set = new DataReferenceSet();
            set.add((Object)dataReference);
            Vector[] dataSets = this._listSelection.readData(set, false);
            if (dataSets[0] != null && dataSets[0].size() > 0) {
                block2: for (i = 0; i < dataSets[0].size(); ++i) {
                    obj = dataSets[0].get(i);
                    if (!(obj instanceof TimeSeriesContainer)) continue;
                    TimeSeriesContainer tsc = (TimeSeriesContainer)obj;
                    this._listSelection.setCursorWait("Examining " + tsc.fullName);
                    tsc.removeAllMissing();
                    for (int j = 0; j < tsc.values.length; ++j) {
                        if (!value.compareValue(tsc.values[j])) continue;
                        foundData.add(dataReference);
                        continue block2;
                    }
                }
            }
            if (dataSets[1] == null || dataSets[1].size() <= 0) continue;
            block4: for (i = 0; i < dataSets[1].size(); ++i) {
                int j;
                obj = dataSets[1].get(i);
                if (!(obj instanceof PairedDataContainer)) continue;
                PairedDataContainer pdc = (PairedDataContainer)obj;
                this._listSelection.setCursorWait("Examining " + pdc.fullName);
                boolean found = false;
                for (j = 0; j < pdc.xOrdinates.length; ++j) {
                    if (!value.compareValue(pdc.xOrdinates[j])) continue;
                    foundData.add(dataReference);
                    found = true;
                    break;
                }
                if (found) continue;
                for (j = 0; j < pdc.yOrdinates.length; ++j) {
                    for (int k = 0; k < pdc.yOrdinates[j].length; ++k) {
                        if (!value.compareValue(pdc.xOrdinates[j])) continue;
                        foundData.add(dataReference);
                        found = true;
                        break;
                    }
                    if (found) continue block4;
                }
            }
        }
        this._listSelection.setCursorDefault();
        String sType = type == 1 ? "containing the value " : (type == 2 ? "with value(s) greater than " : (type == 3 ? "with value(s) less than " : (type == 4 ? "with value(s) greater than or equal to " : "with value(s) less than or equal to ")));
        if (foundData.size() > 0) {
            int opt;
            message = new StringBuffer();
            ((StringBuffer)message).append(foundData.size() + " data sets found " + sType + value);
            if (foundData.size() < 5) {
                ((StringBuffer)message).append("\n");
                for (int i = 0; i < foundData.size(); ++i) {
                    DataReference dr = (DataReference)foundData.elementAt(i);
                    ((StringBuffer)message).append("\n" + dr.pathname());
                }
                ((StringBuffer)message).append("\n\nTabulate data?");
            } else {
                ((StringBuffer)message).append("\nShow Pathnames?");
            }
            System.out.println(message);
            Search search = this;
            if (search._listSelection.isInteractive() && (opt = JOptionPane.showConfirmDialog(this._listSelection, message, "Found Values", 0)) == 0) {
                TabulateSearches tabulateSearches = new TabulateSearches(this._listSelection, type, sType, value, tolerance, foundData);
            }
        } else {
            message = "No data sets found " + sType + value;
            System.out.println((String)message);
            Search search = this;
            if (search._listSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this._listSelection, message);
            }
        }
    }

    class SearchDialog
    extends RmaJDialog {
        protected RmaJDecimalField _valueFld;
        protected RmaJDecimalField _toleranceFld;
        protected RmaJRadioButton _equal;
        protected RmaJRadioButton _greaterThan;
        protected RmaJRadioButton _lessThan;
        protected RmaJRadioButton _equalGreaterTo;
        protected RmaJRadioButton _equalLessTo;
        protected boolean _canceled;

        public SearchDialog(JFrame parent, HecDouble value, HecDouble tolerance) {
            super((Frame)parent, true);
            this._canceled = true;
            this.build();
            this.init(value, tolerance);
            Help.setHelp((RootPaneContainer)((Object)this), "29");
            this.setVisible(true);
        }

        protected void init(HecDouble value, HecDouble tolerance) {
            this._valueFld.setText(value.toString());
            this._toleranceFld.setText(tolerance.toString());
        }

        public boolean isCanceled() {
            return this._canceled;
        }

        public HecDouble getValue() {
            if (this._canceled) {
                return null;
            }
            return this._valueFld.getHecDouble();
        }

        public HecDouble getTolerance() {
            return this._toleranceFld.getHecDouble();
        }

        public int getSearchType() {
            if (this._equal.isSelected()) {
                return 1;
            }
            if (this._greaterThan.isSelected()) {
                return 2;
            }
            if (this._lessThan.isSelected()) {
                return 3;
            }
            if (this._equalGreaterTo.isSelected()) {
                return 4;
            }
            return 5;
        }

        protected void build() {
            this.setTitle("Enter Value to Search for");
            this.getContentPane().setLayout(new GridBagLayout());
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
            this.getContentPane().add((Component)panel, gbc);
            JLabel label = new JLabel("Search for: ");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
            panel.add((Component)label, gbc);
            this._valueFld = new RmaJDecimalField();
            this._valueFld.setColumns(10);
            label.setLabelFor((Component)this._valueFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)2, (int)0, (int)0);
            panel.add((Component)this._valueFld, gbc);
            label = new JLabel(" ");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            panel.add((Component)label, gbc);
            label = new JLabel("Within + - : ");
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
            panel.add((Component)label, gbc);
            this._toleranceFld = new RmaJDecimalField();
            this._toleranceFld.setColumns(8);
            label.setLabelFor((Component)this._toleranceFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 4;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)2, (int)0, (int)0);
            panel.add((Component)this._toleranceFld, gbc);
            label = new JLabel("  ");
            gbc = new GridBagConstraints();
            gbc.gridx = 5;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = RmaInsets.insets((int)5, (int)2, (int)0, (int)5);
            gbc.anchor = 18;
            gbc.fill = 2;
            panel.add((Component)label, gbc);
            this._equal = new RmaJRadioButton(" Equal");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)10, (int)15, (int)0, (int)0);
            this.getContentPane().add((Component)this._equal, gbc);
            this._greaterThan = new RmaJRadioButton(" Greater Than");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)15, (int)0, (int)0);
            this.getContentPane().add((Component)this._greaterThan, gbc);
            this._lessThan = new RmaJRadioButton(" Less Than");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)15, (int)0, (int)0);
            this.getContentPane().add((Component)this._lessThan, gbc);
            this._equalGreaterTo = new RmaJRadioButton(" Greater than or Equal to");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)15, (int)0, (int)0);
            this.getContentPane().add((Component)this._equalGreaterTo, gbc);
            this._equalLessTo = new RmaJRadioButton(" Less than or Equal to");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.weighty = 0.001;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)15, (int)0, (int)0);
            this.getContentPane().add((Component)this._equalLessTo, gbc);
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this._equal);
            bg.add((AbstractButton)this._greaterThan);
            bg.add((AbstractButton)this._lessThan);
            bg.add((AbstractButton)this._equalGreaterTo);
            bg.add((AbstractButton)this._equalLessTo);
            this._equal.setSelected(true);
            ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 16;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)10, (int)10, (int)5, (int)5);
            this.getContentPane().add((Component)cmdPanel, gbc);
            cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

                public void buttonCmdActionPerformed(ActionEvent e) {
                    switch (e.getID()) {
                        case 8: {
                            SearchDialog.this._canceled = false;
                            SearchDialog.this.setVisible(false);
                            break;
                        }
                        case 4: {
                            SearchDialog.this._canceled = true;
                            SearchDialog.this.setVisible(false);
                        }
                    }
                }
            });
            this.pack();
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.setSize(320, 260);
                this.setLocationRelativeTo(this.getParent());
            }
            super.setVisible(visible);
        }
    }

    class SearchDouble
    extends HecDouble {
        protected int type;
        protected double tol;

        public SearchDouble(HecDouble hecDouble, int itype, double dtol) {
            super(hecDouble);
            this.type = itype;
            this.tol = dtol;
        }

        public boolean compareValue(double val) {
            if (this.type == 1) {
                return this.equal(val, this.tol);
            }
            if (this.type == 2) {
                return this.lessThan(val, this.tol);
            }
            if (this.type == 3) {
                return this.greaterThan(val, this.tol);
            }
            if (this.type == 4) {
                return this.lessThanEqual(val, this.tol);
            }
            return this.greaterThanEqual(val, this.tol);
        }
    }

    class TabulateSearches
    extends SelectRecords {
        Vector<DataReference> _foundData;
        Vector<String> paths;
        int compareType;
        HecDouble value;
        double tolerance;
        int minimum;

        public TabulateSearches(JFrame parent, int type, String stype, HecDouble val, double tol, Vector<DataReference> foundData) {
            super(parent);
            this.paths = new Vector();
            this.minimum = 4;
            this.compareType = type;
            this.value = val;
            this.tolerance = tol;
            this.setTitle("Tabulate Data Sets " + stype + val);
            this.changeButtons();
            this._foundData = foundData;
            for (int i = 0; i < foundData.size(); ++i) {
                String path = foundData.elementAt(i).getNominalPathname();
                this.paths.add(path);
            }
            String[] p = this.paths.toArray(new String[0]);
            this.populateTable(p);
            if (this.paths.size() > this.minimum) {
                this.setVisible(true);
            } else {
                for (int i = 0; i < this._dataNamesTable.getRowCount(); ++i) {
                    this._dataNamesTable.setCell((Object)"true", i, 0);
                }
                this.jButtonOk_actionPerformed(null);
                this.dispose();
            }
        }

        protected void changeButtons() {
            JButton okButton = this.cmdPanel.getButton("OK");
            okButton.setText("Tabulate");
            JButton b = this.cmdPanel.getButton("Apply");
            this.cmdPanel.remove((Component)b);
        }

        @Override
        void jButtonOk_actionPerformed(ActionEvent event) {
            DssDataManager _dataManager = Search.this._listSelection.getDataManager();
            for (int i = 0; i < this._dataNamesTable.getRowCount(); ++i) {
                String select = this._dataNamesTable.getCell(i, 0).toString();
                if (!select.equals("true")) continue;
                Vector<Object> data = new Vector<Object>();
                DataReference dr = this._foundData.get(i);
                int type = _dataManager.recordType(dr.pathname());
                if (type >= 100 && type < 200) {
                    TimeSeriesContainer tsc1 = new TimeSeriesContainer();
                    _dataManager.readData(dr, tsc1);
                    data.add(tsc1);
                } else if (type >= 200 && type < 300) {
                    PairedDataContainer pdc1 = new PairedDataContainer();
                    _dataManager.readData(dr, pdc1);
                    data.add(pdc1);
                } else {
                    JOptionPane.showMessageDialog(this._parent, "Cannot tabulate this data type");
                    return;
                }
                HecDataTableFrame table = new HecDataTableFrame((Object)this._parent);
                table.setData(data);
                int[] rows = table.highlightValues(this.value, this.tolerance, this.compareType);
                int loc = 10 * i + 10;
                if (loc > 500) {
                    loc = 500;
                }
                table.setLocation(loc, loc);
                table.setVisible(true);
                table.setShownNextOrdinate(rows);
            }
        }

        @Override
        void jButtonCancel_actionPerformed(ActionEvent event) {
            this.dispose();
        }
    }
}

