/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.Help;
import hec.dssgui.IPanelController;
import hec.dssgui.IPathNamePanel;
import hec.dssgui.LinkedTabbedPane;
import hec.dssgui.ListSelection;
import hec.dssgui.ObservableClass;
import hec.dssgui.PathnamePanel;
import hec.dssgui.SelectionWrapperPanel;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.LocalDssDataManager;
import hec.heclib.util.HecTime;
import hec.heclib.util.booleanContainer;
import hec.util.ButtonTabComponent;
import hec.util.TimeWindowDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mil.army.usace.hec.rmi.heclib.dss.HecDSSUtilitiesRemote;
import rma.util.RMAIO;

public class SelectionAndFilterPanel
extends JPanel
implements Observer {
    public static final int PATHNAME_LIST = 0;
    public static final int PATHNAME_PARTS = 1;
    public static final int CONDENSED_CATALOG = 2;
    public static final int CONDENSED_GROUP_COLLECTIONS = 3;
    public static final int NO_PATHNAMES = 4;
    public static final int UNSORTED_LIST = 5;
    public static final int MULTIPLE_PATH_SELECTION = 0;
    public static final int SINGLE_PATH_SELECTION = 1;
    private int _selectionMode = 0;
    protected int _previousSplitPaneHeight = 0;
    protected double _dividerLocation = 0.8;
    protected IPanelController _currentPanel;
    protected PathnamePanel _currentPathnamePanel;
    protected ListSelectionModel _selectedListSelectionModel;
    protected DataReferenceSet _selectionList = new DataReferenceSet();
    protected DataReferenceSet _previousSelectionList = new DataReferenceSet();
    protected JList _selectedListDisplay;
    protected ObservableClass _observer;
    protected JPopupMenu _popup;
    protected TransferHandler _transferHandler = null;
    private JScrollPane _selectedScrollPane;
    protected LinkedTabbedPane _tabbedPane;
    protected TimeWindowDialog _timeWindowDialog;
    protected boolean _useTabbedPanes;
    private boolean _addingNewTab = false;
    public JPanel _selectionButtonsPanel;
    public JButton _selectButton;
    public JButton _unselectButton;
    public JButton _clearSelectionButton;
    public JButton _restoreSelectionButton;
    public JButton _setTimeWindowButton;
    public JButton _getTimeWindowButton;
    public JButton _addPathnamesButton;
    public JButton _replacePathnamesButton;
    protected String _dssFileName = "";
    private boolean _popupDeleteActionVisible = true;
    private Preferences _preferences;

    public SelectionAndFilterPanel(int initialTableType, boolean initialSearchByParts) {
        this(initialTableType, initialSearchByParts, false, null, null);
    }

    public SelectionAndFilterPanel(int initialTableType, boolean initialSearchByParts, boolean useTabbedPanes, String dssFileName, Preferences preferences) {
        this._useTabbedPanes = useTabbedPanes;
        this._dssFileName = useTabbedPanes ? null : dssFileName;
        this._observer = new ObservableClass();
        this._preferences = preferences;
        this.build(initialTableType, initialSearchByParts);
    }

    public void setMode(int mode) {
        if (mode == 2) {
            this._selectionButtonsPanel.remove(this._addPathnamesButton);
            this._selectionButtonsPanel.remove(this._replacePathnamesButton);
        } else if (mode == 1) {
            this._selectionButtonsPanel.remove(this._setTimeWindowButton);
            this._selectionButtonsPanel.remove(this._getTimeWindowButton);
        }
    }

    public int getSelectedPathnamesSize() {
        return this.getSelectedPathnamesSize(false);
    }

    public int getSelectedPathnamesSize(boolean quickOnly) {
        int number = this.getSelectionListSize();
        if (number == 0 || quickOnly) {
            number = this._currentPathnamePanel.getSelectedPathnamesSize();
        }
        return number;
    }

    public int getPathnamesDisplayedSize() {
        return this._currentPathnamePanel.getPathnamesDisplayedSize();
    }

    public String[] getPathnameList() {
        return this._currentPathnamePanel.getPathnameList();
    }

    public CondensedReference[] getCondensedCatalog() {
        return this._currentPathnamePanel.getCondensedCatalog();
    }

    public DataReferenceSet getSelectedPathnames() {
        return this.getSelectedPathnames(false);
    }

    public DataReferenceSet getSelectedPathnames(boolean quickOnly) {
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        booleanContainer applyAll = new booleanContainer();
        this.getTimeWindowDialog();
        boolean timesSet = this._timeWindowDialog.getTimeWindow(startTime, endTime, applyAll);
        if (!quickOnly && this._selectionList.size() > 0) {
            if (this._timeWindowDialog.isWaterYear()) {
                this._selectionList.setWaterYear(this._timeWindowDialog.getWaterYearStartDate());
            } else {
                this._selectionList.setTimeWindow(startTime, endTime);
            }
            return this._selectionList;
        }
        DataReferenceSet drs = this._currentPathnamePanel.getSelectedPathnames();
        if (drs.size() == 0) {
            Object[] selected = this._selectedListDisplay.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                drs.add(selected[i]);
            }
        }
        if (this._timeWindowDialog.isWaterYear()) {
            drs.setWaterYear(this._timeWindowDialog.getWaterYearStartDate());
        } else {
            drs.setTimeWindow(startTime, endTime);
        }
        return drs;
    }

    public int getSelectionListSize() {
        int number = 0;
        if (this._currentPathnamePanel.getTableType() == 2) {
            int len = this._selectionList.size();
            for (int i = 0; i < len; ++i) {
                number += this._selectionList.get(i).size();
            }
        } else {
            number = this._selectionList.size();
        }
        return number;
    }

    public int getTableType() {
        return this._currentPathnamePanel.getTableType();
    }

    public String getFirstSelectedPathname() {
        if (this._selectionList.size() > 0) {
            DataReference dataSet = this._selectionList.elementAt(0);
            return dataSet.getPathname();
        }
        return this._currentPathnamePanel.getFirstSelectedPathname();
    }

    public int getTabDroppedIndex() {
        Point p = this.getMousePosition(true);
        int idx = this._tabbedPane.indexAtLocation(p.x, p.y);
        return idx;
    }

    public int getSelectedIndex() {
        return this._tabbedPane.getSelectedIndex();
    }

    public DssDataManager getDataManager(int tab) {
        Component component = this._tabbedPane.getComponentAt(tab);
        if (component instanceof PathnamePanel) {
            PathnamePanel panel = (PathnamePanel)component;
            return panel.getDataManager();
        }
        return null;
    }

    public String getFilterSelection(int partNumber) {
        return this._currentPathnamePanel.getFilterSelection(partNumber);
    }

    public PathnamePanel getCurrentPathnamePanel() {
        return this._currentPathnamePanel;
    }

    public DssDataManager getDataManager() {
        DssDataManager dataManager = null;
        if (this._currentPanel != null) {
            dataManager = this._currentPanel.getDataManager();
        }
        return dataManager;
    }

    public DssDataManager getDataManager(String filename) {
        DssDataManager dataManager;
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            PathnamePanel panel;
            Component component = this._tabbedPane.getComponentAt(i);
            if (!(component instanceof PathnamePanel) || (dataManager = (panel = (PathnamePanel)this._tabbedPane.getComponentAt(i)).getDataManager()) == null || !dataManager.isSameFile(filename)) continue;
            return dataManager;
        }
        boolean remote = false;
        dataManager = this._currentPathnamePanel.getDataManager();
        if (dataManager != null) {
            remote = dataManager.isRemote();
        }
        if (!remote) {
            dataManager = new LocalDssDataManager();
            dataManager.setDSSFileName(filename);
        }
        return dataManager;
    }

    public Vector getDssFilenames() {
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            String name;
            PathnamePanel panel;
            DssDataManager dataManager;
            Component component = this._tabbedPane.getComponentAt(i);
            if (!(component instanceof PathnamePanel) || (dataManager = (panel = (PathnamePanel)component).getDataManager()) == null || (name = dataManager.DSSFileName()).length() <= 0) continue;
            names.add(name);
        }
        return names;
    }

    public void catalogUpdated() {
        this._currentPathnamePanel.catalogUpdated();
    }

    public void setSearchByPartsMethod(boolean searchByParts) {
        this._currentPathnamePanel.setSearchMethod(searchByParts);
    }

    public boolean getSearchMethod() {
        return this._currentPathnamePanel.getSearchMethod();
    }

    public void resetSearchString() {
        this._currentPathnamePanel.resetSearchString();
    }

    public void setColumnNamesForPartsTable(String[] names) {
        this._currentPathnamePanel.setColumnNamesForPartsTable(names);
    }

    public void setColumnNameForListTable(String name) {
        this._currentPathnamePanel.setColumnNameForListTable(name);
    }

    public void setPartNamesForFilter(String[] names) {
        this._currentPathnamePanel.setPartNamesForFilter(names);
    }

    public boolean hasLinkedTabs() {
        int nTabCount = this._tabbedPane.getTabCount();
        for (int i = 0; i < nTabCount; ++i) {
            List linkedTabs;
            Component comp = this._tabbedPane.getComponentAt(i);
            if (!(comp instanceof PathnamePanel) || (linkedTabs = ((PathnamePanel)comp).getLinkedTabs()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean setSelectedTabUsingFileName(String filePath) {
        if (filePath != null) {
            for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
                String name;
                PathnamePanel panel;
                DssDataManager dataManager;
                Component component = this._tabbedPane.getComponentAt(i);
                if (!(component instanceof PathnamePanel) || (dataManager = (panel = (PathnamePanel)component).getDataManager()) == null || (name = dataManager.DSSFileName()) == null || !name.equals(filePath)) continue;
                this._tabbedPane.setSelectedIndex(i);
                return true;
            }
        }
        return false;
    }

    public void selectLinkedTab() {
        int nTabCount = this._tabbedPane.getTabCount();
        Component selTab = this._tabbedPane.getSelectedComponent();
        for (int i = 0; i < nTabCount; ++i) {
            Component comp = this._tabbedPane.getComponentAt(i);
            if (!(comp instanceof PathnamePanel)) continue;
            List linkedTabs = ((PathnamePanel)comp).getLinkedTabs();
            if (linkedTabs.contains(selTab)) {
                return;
            }
            if (linkedTabs.isEmpty()) continue;
            this._tabbedPane.setSelectedIndex(i);
            return;
        }
    }

    public List getLinkedTabs() {
        int nTabCount = this._tabbedPane.getTabCount();
        for (int i = 0; i < nTabCount; ++i) {
            List linkedTabs;
            Component comp = this._tabbedPane.getComponentAt(i);
            if (!(comp instanceof PathnamePanel) || (linkedTabs = ((PathnamePanel)comp).getLinkedTabs()).isEmpty() || !linkedTabs.contains(this._currentPanel)) continue;
            ArrayList retList = new ArrayList();
            retList.addAll(linkedTabs);
            return retList;
        }
        return this._currentPathnamePanel.getLinkedTabs();
    }

    public void newTableView(int tableType, boolean newTab, Component component, String tabTitle) {
        this.newTableView(tableType, newTab, component, tabTitle, this._currentPathnamePanel, -1);
    }

    public void newTableView(int tableType, boolean newTab, Component component, String tabTitle, PathnamePanel linkTo, int insertAfter) {
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
        if (component instanceof IPanelController && component instanceof IPathNamePanel) {
            ((IPathNamePanel)((Object)component)).addObserver(this);
            SelectionWrapperPanel panel = new SelectionWrapperPanel(this._selectedScrollPane, component, (IPathNamePanel)((Object)component), (IPanelController)((Object)component));
            if (linkTo.getLinkedTabs().isEmpty()) {
                this._currentPathnamePanel = panel;
                linkTo = panel;
            }
            linkTo.addLinkedTab(panel);
            this.addPanelToTab(insertAfter, tabTitle, panel, null);
        } else {
            if (linkTo != null) {
                linkTo.addLinkedTab(component);
            }
            this.addPanelToTab(insertAfter, tabTitle, component, null);
        }
    }

    public void enableTabCloseButtons(boolean enable) {
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            Component component = this._tabbedPane.getTabComponentAt(i);
            if (!(component instanceof ButtonTabComponent)) continue;
            for (Component tabComponent : ((ButtonTabComponent)component).getComponents()) {
                tabComponent.setEnabled(enable);
            }
        }
    }

    private void addPanelToTab(int insertAfter, String tabTitle, Component component, String toolTip) {
        if (insertAfter < 0) {
            this._tabbedPane.addTab(tabTitle, null, component, toolTip);
        } else {
            this._tabbedPane.insertTab(tabTitle, null, component, toolTip, insertAfter);
        }
        boolean canClose = false;
        if (component instanceof PathnamePanel) {
            canClose = ((PathnamePanel)component).canClose();
            this.setCloseBtn((PathnamePanel)component);
        }
        int tabIndex = this._tabbedPane.indexOfComponent(component);
        this._tabbedPane.setForegroundAt(tabIndex, Color.BLUE);
        if (this._tabbedPane.getSelectedIndex() != tabIndex && canClose) {
            this._tabbedPane.setSelectedIndex(tabIndex);
        }
        if (this._tabbedPane.getTabCount() > 1) {
            this.removeEmptyTab();
        }
    }

    public void newTableView(int tableType, boolean newTab, String dssFileName) {
        this.newTableView(tableType, newTab, dssFileName, Color.black);
    }

    public void newTableView(int tableType, boolean newTab, String dssFileName, Color color) {
        this.newTableView(tableType, newTab, dssFileName, color, null);
    }

    private void removeEmptyTab() {
        Component comp;
        if (SwingUtilities.isEventDispatchThread() && this._useTabbedPanes && this._tabbedPane.getTabCount() > 0 && (comp = this._tabbedPane.getComponentAt(0)) instanceof PathnamePanel && ((PathnamePanel)comp).isEmpty()) {
            this._tabbedPane.remove(comp);
        }
    }

    private void setCloseBtn(PathnamePanel panel) {
        if (!panel.isEmpty() && panel.canClose()) {
            DssDataManager dataManager = panel.getDataManager();
            if (dataManager == null) {
                Container parent;
                for (parent = this.getParent(); parent != null && !(parent instanceof ListSelection); parent = parent.getParent()) {
                }
                if (parent instanceof ListSelection) {
                    dataManager = ((ListSelection)parent).getDataManager();
                }
            }
            String toolTip = null;
            if (dataManager != null) {
                toolTip = "Close file " + dataManager.DSSFileName();
            }
            ButtonTabComponent tabBtn = new ButtonTabComponent((JTabbedPane)this._tabbedPane, toolTip);
            if (dataManager != null) {
                tabBtn.setColor(panel.getTabTextColor());
            }
            int index = this._tabbedPane.indexOfComponent(panel);
            this._tabbedPane.setTabComponentAt(index, (Component)tabBtn);
        }
    }

    public void newTableView(int tableType, boolean newTab, String dssFileName, Color color, String title) {
        this.newTableView(tableType, newTab, dssFileName, color, title, false);
    }

    public void newTableView(int tableType, boolean newTab, String dssFileName, Color color, String title, boolean linkIt) {
        this._dssFileName = dssFileName;
        if (this._useTabbedPanes && newTab) {
            int divLoc = this._currentPathnamePanel.getDividerLocation();
            boolean searchByParts = this._currentPathnamePanel.getSearchMethod();
            IPanelController oldPanel = this._currentPanel;
            PathnamePanel newPanel = this.createPathnamePanel(tableType, searchByParts);
            if (linkIt) {
                newPanel.setClosable(false);
                this._currentPathnamePanel.addLinkedTab(newPanel);
                this._tabbedPane.setForeground(color);
            } else {
                this._currentPathnamePanel = newPanel;
                this._currentPanel = this._currentPathnamePanel;
            }
            newPanel.newTableView(tableType, dssFileName);
            String theTitle = title == null ? RMAIO.getFileFromPath((String)dssFileName) : title;
            this.addPanelToTab(-1, theTitle, newPanel, dssFileName);
            newPanel.setDividerLocation(divLoc);
        } else {
            Component comp;
            if (this._tabbedPane.getTabCount() > 0 && (comp = this._tabbedPane.getComponentAt(0)) != null && comp instanceof PathnamePanel && ((PathnamePanel)comp).isEmpty()) {
                this._tabbedPane.remove(comp);
            }
            this._currentPathnamePanel.newTableView(tableType, dssFileName);
        }
        if (this._useTabbedPanes) {
            DataReference._showFilename = true;
        } else {
            Component comp;
            DataReference._showFilename = false;
            if (this._tabbedPane.getTabCount() > 0 && (comp = this._tabbedPane.getComponentAt(0)) != null && comp instanceof PathnamePanel && ((PathnamePanel)comp).isEmpty()) {
                DataReference._showFilename = true;
            }
        }
    }

    public String getParentCatalogFilter() {
        String catalogFilter = null;
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ListSelection)) continue;
            ListSelection ls = (ListSelection)parent;
            if (!ls.useCatalogWildChars() || ls._catalogWithWildChars == null || ls._catalogWithWildChars.trim().length() <= 0) break;
            catalogFilter = ls._catalogWithWildChars.trim();
            break;
        }
        return catalogFilter;
    }

    public void setToolTipText(DssDataManager dataManager) {
        if (dataManager != null) {
            StringBuilder sb = new StringBuilder("<html>").append(dataManager.getDSSFileName());
            String catalogFilter = this.getParentCatalogFilter();
            if (catalogFilter != null) {
                sb.append("<br><pre>").append(catalogFilter).append("</pre>");
            }
            sb.append("</html>");
            int selectedIndex = this._tabbedPane.getSelectedIndex();
            if (selectedIndex >= 0) {
                this._tabbedPane.setToolTipTextAt(selectedIndex, sb.toString());
            }
        }
    }

    public void setPathnameList(String[] pathnameList, DssDataManager dataManager) {
        this.setPathnameList(pathnameList, dataManager, true);
        this.setToolTipText(dataManager);
    }

    public void setPathnameList(String[] pathnameList, DssDataManager dataManager, boolean bLinked) {
        if (pathnameList != null && this._currentPathnamePanel != null) {
            this._currentPathnamePanel.setPathnameList(pathnameList, dataManager);
            this._currentPathnamePanel.setCatalogFilter(this.getParentCatalogFilter());
            if (!bLinked) {
                return;
            }
            List linkedTabs = this.getLinkedTabs();
            for (Object tab : linkedTabs) {
                if (tab instanceof PathnamePanel) {
                    ((PathnamePanel)tab).setPathnameList(pathnameList, dataManager);
                    continue;
                }
                if (!(tab instanceof IPanelController) || pathnameList.length <= 0) continue;
                ((IPanelController)tab).pathnameListUpdated();
            }
            if (!linkedTabs.isEmpty() && this._currentPathnamePanel.getLinkedTabs().isEmpty()) {
                int nTabCount = this._tabbedPane.getTabCount();
                for (int i = 0; i < nTabCount; ++i) {
                    Component comp = this._tabbedPane.getComponentAt(i);
                    if (!(comp instanceof PathnamePanel) || (linkedTabs = ((PathnamePanel)comp).getLinkedTabs()).isEmpty()) continue;
                    ((PathnamePanel)comp).setPathnameList(pathnameList, dataManager);
                }
            }
        }
    }

    public void setCondensedCatalog(CondensedReference[] condensed, DssDataManager dataManager) {
        if (condensed != null && this._currentPathnamePanel != null) {
            this._currentPathnamePanel.setCondensedCatalog(condensed, dataManager);
            this._currentPathnamePanel.setCatalogFilter(this.getParentCatalogFilter());
            this.setToolTipText(dataManager);
        }
    }

    public void pathnameListUpdated() {
        List linkedTabs = this.getLinkedTabs();
        if (linkedTabs.contains(this._currentPathnamePanel)) {
            for (Object linkedTab : linkedTabs) {
                if (!(linkedTab instanceof PathnamePanel)) continue;
                ((PathnamePanel)linkedTab).pathnameListUpdated();
            }
        } else {
            this._currentPathnamePanel.pathnameListUpdated();
        }
        this.revalidate();
    }

    public void closeAllTabs() {
        Component[] comp = this._tabbedPane.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof PathnamePanel)) continue;
            DssDataManager dataManager = ((PathnamePanel)comp[i]).getDataManager();
            if (dataManager != null) {
                dataManager.close();
            }
            int index = i;
            Component pathNamePanel = comp[index];
            this._tabbedPane.remove(pathNamePanel);
        }
        this.dssFileClosed();
    }

    public void closeAllFileTabs() {
        Component[] comp = this._tabbedPane.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof PathnamePanel)) continue;
            DssDataManager dataManager = ((PathnamePanel)comp[i]).getDataManager();
            if (dataManager != null) {
                if (dataManager.dataManager() == null) continue;
                dataManager.close();
            }
            Component pathNamePanel = comp[i];
            this._tabbedPane.remove(pathNamePanel);
        }
        this.dssFileClosed();
    }

    protected List<Component> getLinkedTabs(int index) {
        Component comp = this._tabbedPane.getComponentAt(index);
        if (comp instanceof PathnamePanel) {
            List linkedTabs = ((PathnamePanel)comp).getLinkedTabs();
            return linkedTabs;
        }
        return new ArrayList<Component>();
    }

    protected void tabClosed(Component comp) {
        DssDataManager dataManager;
        if (comp instanceof PathnamePanel && (dataManager = ((PathnamePanel)comp).getDataManager()) != null) {
            dataManager.close();
            this.dssFileClosed();
            if (comp.isVisible()) {
                ((PathnamePanel)comp).setPathnameList(new String[0], null);
                ((PathnamePanel)comp).setCondensedCatalog(new CondensedReference[0], null);
            }
        }
    }

    protected void tabSelected() {
        Container parent;
        int divLoc;
        Component comp;
        if (this._addingNewTab) {
            return;
        }
        if (ListSelection.debug) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.FINE, "SelectionAndFilterPanel.tabSelected()");
        }
        if ((comp = this._tabbedPane.getSelectedComponent()) == null) {
            int type = this._currentPathnamePanel.getTableType();
            DssDataManager dataManager = this._currentPathnamePanel.getDataManager();
            this.newTableView(type, true, "", Color.black, null, false);
            this.setPathnameList(new String[0], dataManager);
            this.setCondensedCatalog(new CondensedReference[0], null);
            return;
        }
        if (this._selectionButtonsPanel != null) {
            if (this._currentPanel instanceof IPathNamePanel) {
                ((IPathNamePanel)((Object)this._currentPanel)).setBottom(null);
            }
            if (comp instanceof IPanelController) {
                IPanelController panelController = (IPanelController)((Object)comp);
                this._selectionButtonsPanel.setVisible(panelController.showSelectionPanel());
            } else {
                if (this._currentPanel instanceof IPathNamePanel) {
                    ((IPathNamePanel)((Object)this._currentPanel)).setBottom(null);
                }
                this._selectionButtonsPanel.setVisible(true);
            }
        }
        if (!(comp instanceof PathnamePanel)) {
            if (comp instanceof IPanelController) {
                Container parent2;
                this._currentPanel = (IPanelController)((Object)comp);
                this.dssFileChanged();
                for (parent2 = this.getParent(); parent2 != null && !(parent2 instanceof ListSelection); parent2 = parent2.getParent()) {
                }
                if (parent2 instanceof ListSelection) {
                    ((ListSelection)parent2).setPrimaryDb(this._currentPanel.getDataManager());
                }
            }
            List linkedTabs = this.getLinkedTabs();
            block1: for (Object linkedTab : linkedTabs) {
                if (linkedTab != this._currentPanel) continue;
                for (Object linkedTabPP : linkedTabs) {
                    if (!(linkedTabPP instanceof PathnamePanel)) continue;
                    this._currentPathnamePanel = (PathnamePanel)linkedTabPP;
                    break block1;
                }
            }
            return;
        }
        if (this._getTimeWindowButton != null) {
            this._getTimeWindowButton.setVisible(comp instanceof IPathNamePanel && !((IPathNamePanel)((Object)comp)).getLinkedTabs().isEmpty());
        }
        PathnamePanel selectedPanel = (PathnamePanel)comp;
        if (ListSelection.debug) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.FINE, "SelectionAndFilterPanel.tab switched");
        }
        if (this._currentPanel instanceof PathnamePanel) {
            divLoc = ((PathnamePanel)this._currentPanel).getDividerLocation();
        } else if (this._currentPanel instanceof IPathNamePanel) {
            divLoc = ((IPathNamePanel)((Object)this._currentPanel)).getDividerLocation();
        } else {
            divLoc = selectedPanel.getSplitLocation();
            if (divLoc < 0) {
                divLoc = selectedPanel._splitPane.getLeftComponent().getHeight() - selectedPanel.getFilterOffset();
            }
        }
        if (divLoc < 0) {
            divLoc = selectedPanel._splitPane.getLeftComponent().getHeight() - selectedPanel.getFilterOffset();
        }
        if (divLoc <= 0) {
            selectedPanel._splitPane.setDividerLocation(this._dividerLocation);
        } else {
            selectedPanel.setDividerLocation(divLoc);
        }
        if (selectedPanel == this._currentPanel || selectedPanel.isEmpty()) {
            return;
        }
        this._currentPathnamePanel = selectedPanel;
        this._currentPanel = selectedPanel;
        this.dssFileChanged();
        for (parent = this.getParent(); parent != null && !(parent instanceof ListSelection); parent = parent.getParent()) {
        }
        if (parent instanceof ListSelection && this._currentPathnamePanel != null && this._currentPathnamePanel.getDataManager() != null) {
            ((ListSelection)parent).setPrimaryDb(this._currentPanel.getDataManager());
        }
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
            this._currentPathnamePanel.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void done() {
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }

    public void setPopup(JPopupMenu popup) {
        this._popup = popup;
        this._currentPathnamePanel.setPopup(this._popup);
    }

    protected void displayPopup(MouseEvent event, Component invoker) {
        int x = event.getX();
        int y = event.getY();
        Dimension dim = this._popup.getPreferredSize();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrnsiz = toolkit.getScreenSize();
        Point pt0 = this.getLocationOnScreen();
        int windowsToolBarHeight = 50;
        int offset = scrnsiz.height - (pt0.y + y + dim.height + windowsToolBarHeight);
        if (offset < 0) {
            y += offset;
        }
        int n = this._popup.getComponentCount();
        Component deleteMenuItem = null;
        for (int ii = 0; ii < n; ++ii) {
            if (!"Delete".equals(this._popup.getComponent(ii).getName())) continue;
            deleteMenuItem = this._popup.getComponent(ii);
            deleteMenuItem.setVisible(true);
        }
        if (invoker instanceof JList) {
            JList list;
            int[] sel;
            if (deleteMenuItem != null) {
                deleteMenuItem.setVisible(this._popupDeleteActionVisible);
            }
            if ((sel = (list = (JList)invoker).getSelectedIndices()).length == 1) {
                if (n < 5) {
                    return;
                }
                for (int i = n - 5; i < n; ++i) {
                    this._popup.getComponent(i).setVisible(true);
                }
                boolean enableup = true;
                boolean enabledown = true;
                ListModel model = list.getModel();
                int size = model.getSize();
                if (sel[0] == size - 1) {
                    enabledown = false;
                }
                if (sel[0] == 0) {
                    enableup = false;
                }
                this._popup.getComponent(n - 4).setEnabled(enableup);
                this._popup.getComponent(n - 3).setEnabled(enableup);
                this._popup.getComponent(n - 2).setEnabled(enabledown);
                this._popup.getComponent(n - 1).setEnabled(enabledown);
                this._popup.show(invoker, x, y);
                return;
            }
        }
        for (int i = n - 3; i < n; ++i) {
            this._popup.getComponent(i).setVisible(false);
        }
        this._popup.show(invoker, x, y);
    }

    protected void runDefaultDisplay() {
        this.updateSelectionButtons();
        ActionEvent event = new ActionEvent(this, 1001, "defaultDisplay");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    protected void runDefaultSelection() {
        if (this._selectionMode == 1) {
            this.addPathnames();
        } else {
            this.addToSelection();
        }
        this.updateSelectionButtons();
    }

    protected void setPathnameInSearch() {
        String pathname = this._currentPathnamePanel.getSearchText();
        this.addToSelection(pathname);
    }

    protected void selectionUpdated() {
        this.updateSelectionButtons();
        ActionEvent event = new ActionEvent(this, 1001, "selectionUpdated");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    protected void dssFileChanged() {
        this.updateSelectionButtons();
        ActionEvent event = new ActionEvent(this, 1001, "dssFileChanged");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    protected void dssFileClosed() {
        this.updateSelectionButtons();
        ActionEvent event = new ActionEvent(this, 1001, "dssFileClosed");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    protected void getTimeWindow() {
        this._currentPathnamePanel.getTimeWindow();
    }

    protected void addPathnames() {
        this.updateSelectionButtons();
        ActionEvent event = new ActionEvent(this, 1001, "addPathnames");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    protected void replacePathnames() {
        this.updateSelectionButtons();
        ActionEvent event = new ActionEvent(this, 1001, "replacePathnames");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    protected TimeWindowDialog getTimeWindowDialog() {
        if (this._timeWindowDialog == null) {
            Window parent = SwingUtilities.windowForComponent(this);
            this._timeWindowDialog = new TimeWindowDialog(parent, "Set Time Window", this._preferences, false, true);
            Help.setHelp((RootPaneContainer)this._timeWindowDialog, "28");
        }
        return this._timeWindowDialog;
    }

    public void openTimeWindowDialog() {
        this.getTimeWindowDialog();
        this._timeWindowDialog.addObserver((Observer)this);
        this._timeWindowDialog.setModal(true);
        this._timeWindowDialog.setVisible(true);
    }

    public String getTimeWindowMessage() {
        this.getTimeWindowDialog();
        return this._timeWindowDialog.getTimeWindowMessage();
    }

    public void setTimeWindow(HecTime start, HecTime end, boolean applyAll) {
        this.getTimeWindowDialog();
        this._timeWindowDialog.setTimeWindow(start, end, applyAll);
    }

    public void setDataTimeWindow(HecTime start, HecTime end, boolean applyAll) {
        if (applyAll) {
            for (int i = 0; i < this._selectionList.size(); ++i) {
                DataReference dataSet = this._selectionList.get(i);
                dataSet.setTimeWindow(start, end);
            }
        }
    }

    public void printCatalog(boolean showPreview) {
        this._currentPathnamePanel.printCatalog(showPreview);
    }

    protected void build(int initialTableType, boolean initialSearchByParts) {
        this.setLayout(new GridBagLayout());
        this.buildSelectionPanel(initialTableType, initialSearchByParts);
        this.buildSelectionButtons();
    }

    protected void buildSelectionPanel(int tableType, boolean initialSearchByParts) {
        this._tabbedPane = new LinkedTabbedPane(this);
        this._tabbedPane.addChangeListener(e -> this.tabSelected());
        this._selectedListDisplay = new JList();
        this._selectedListDisplay.setListData(this._selectionList);
        this._selectedListDisplay.setBackground(Color.white);
        this._selectedScrollPane = new JScrollPane();
        this._selectedScrollPane.setMinimumSize(new Dimension(300, 60));
        this._selectedScrollPane.getViewport().add(this._selectedListDisplay);
        this._selectedScrollPane.setVerticalScrollBarPolicy(22);
        this._selectedListSelectionModel = this._selectedListDisplay.getSelectionModel();
        this._selectedListSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectionAndFilterPanel.this.selectionUpdated();
            }
        });
        this._selectedListDisplay.addMouseListener(new MouseListener());
        this._currentPathnamePanel = this.createPathnamePanel(tableType, initialSearchByParts);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        if (this._useTabbedPanes) {
            PathnamePanel panelToAdd = this._currentPathnamePanel;
            String fileName = this._dssFileName;
            this._tabbedPane.addTab(RMAIO.getFileFromPath((String)fileName), null, panelToAdd, fileName);
            this.setCloseBtn(panelToAdd);
            if (this._tabbedPane.getTabCount() > 1) {
                this.removeEmptyTab();
            }
            this.add((Component)this._tabbedPane, gbc);
        } else {
            this.add((Component)this._currentPathnamePanel, gbc);
        }
    }

    protected void buildSelectionButtons() {
        this._selectionButtonsPanel = new JPanel();
        this._selectionButtonsPanel.setBounds(0, 387, 734, 45);
        this._selectionButtonsPanel.setForeground(new Color(0, 0, 0));
        this.add(this._selectionButtonsPanel);
        GridBagLayout gridLayout = new GridBagLayout();
        this._selectionButtonsPanel.setLayout(gridLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(16, 6, 6, 0);
        this._selectButton = new JButton("Select");
        this._selectButton.setMnemonic('l');
        this._selectButton.setActionCommand("Select");
        this._selectButton.setToolTipText("Add highlighted pathname(s) to selection list");
        this._selectButton.setBounds(122, 10, 119, 25);
        this._selectButton.setForeground(new Color(0, 0, 0));
        this._selectionButtonsPanel.add((Component)this._selectButton, gbc);
        this._selectButton.setEnabled(false);
        this._selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionAndFilterPanel.this.addToSelection();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(16, 6, 6, 0);
        this._unselectButton = new JButton("De-Select");
        this._unselectButton.setMnemonic('t');
        this._unselectButton.setActionCommand("De-Select");
        this._unselectButton.setToolTipText("Remove highlighted pathname(s) from the selection list");
        this._unselectButton.setBounds(192, 10, 81, 25);
        this._unselectButton.setForeground(new Color(0, 0, 0));
        this._selectionButtonsPanel.add((Component)this._unselectButton, gbc);
        this._unselectButton.setEnabled(false);
        this._unselectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionAndFilterPanel.this.removeFromSelection();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.anchor = 10;
        gbc.insets = new Insets(16, 6, 6, 0);
        this._clearSelectionButton = new JButton("Clear Selections");
        this._clearSelectionButton.setMnemonic('C');
        this._clearSelectionButton.setActionCommand("Clear Selections");
        this._clearSelectionButton.setToolTipText("Remove all pathnames from the selection list");
        this._clearSelectionButton.setBounds(278, 10, 59, 25);
        this._clearSelectionButton.setForeground(new Color(0, 0, 0));
        this._selectionButtonsPanel.add((Component)this._clearSelectionButton, gbc);
        this._clearSelectionButton.setEnabled(false);
        this._clearSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionAndFilterPanel.this.clearSelection();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.anchor = 10;
        gbc.insets = new Insets(16, 6, 6, 0);
        this._restoreSelectionButton = new JButton("Restore Selections");
        this._restoreSelectionButton.setMnemonic('R');
        this._restoreSelectionButton.setActionCommand("Restore Selections");
        this._restoreSelectionButton.setToolTipText("Restore pathnames from the previous selection list");
        this._restoreSelectionButton.setBounds(342, 10, 73, 25);
        this._restoreSelectionButton.setForeground(new Color(0, 0, 0));
        this._selectionButtonsPanel.add((Component)this._restoreSelectionButton, gbc);
        this._restoreSelectionButton.setEnabled(false);
        this._restoreSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionAndFilterPanel.this.restoreSelection();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.anchor = 10;
        gbc.insets = new Insets(16, 6, 6, 0);
        this._setTimeWindowButton = new JButton("Set Time Window");
        this._setTimeWindowButton.setMnemonic('W');
        this._setTimeWindowButton.setToolTipText("Set a Time Window for time series data sets");
        this._setTimeWindowButton.setActionCommand("Set Time Window");
        this._setTimeWindowButton.setBounds(492, 10, 119, 25);
        this._setTimeWindowButton.setForeground(new Color(0, 0, 0));
        this._selectionButtonsPanel.add((Component)this._setTimeWindowButton, gbc);
        this._setTimeWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionAndFilterPanel.this.openTimeWindowDialog();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.anchor = 10;
        gbc.insets = new Insets(16, 6, 6, 0);
        this._getTimeWindowButton = new JButton("Get Time Range");
        this._getTimeWindowButton.setMnemonic('G');
        this._getTimeWindowButton.setToolTipText("Get the time range for selected time series data sets");
        this._getTimeWindowButton.setActionCommand("Get Time Range");
        this._getTimeWindowButton.setBounds(492, 10, 119, 25);
        this._getTimeWindowButton.setForeground(new Color(0, 0, 0));
        this._selectionButtonsPanel.add((Component)this._getTimeWindowButton, gbc);
        this._getTimeWindowButton.setVisible(false);
        this._getTimeWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionAndFilterPanel.this.getTimeWindow();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.anchor = 10;
        gbc.insets = new Insets(16, 6, 6, 0);
        this._addPathnamesButton = new JButton("Add Pathnames");
        this._addPathnamesButton.setMnemonic('A');
        this._addPathnamesButton.setActionCommand("Add Pathnames");
        this._addPathnamesButton.setToolTipText("Add selected pathnames to the current list");
        this._addPathnamesButton.setBounds(342, 10, 73, 25);
        this._addPathnamesButton.setForeground(new Color(0, 0, 0));
        this._selectionButtonsPanel.add((Component)this._addPathnamesButton, gbc);
        this._addPathnamesButton.setEnabled(false);
        this._addPathnamesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionAndFilterPanel.this.addPathnames();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.anchor = 10;
        gbc.insets = new Insets(16, 6, 6, 0);
        this._replacePathnamesButton = new JButton("Replace Pathnames");
        this._replacePathnamesButton.setMnemonic('R');
        this._replacePathnamesButton.setActionCommand("Replace Pathnames");
        this._replacePathnamesButton.setToolTipText("Replace the list with the selected pathnames");
        this._replacePathnamesButton.setBounds(492, 10, 119, 25);
        this._replacePathnamesButton.setForeground(new Color(0, 0, 0));
        this._selectionButtonsPanel.add((Component)this._replacePathnamesButton, gbc);
        this._replacePathnamesButton.setEnabled(false);
        this._replacePathnamesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionAndFilterPanel.this.replacePathnames();
            }
        });
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this._transferHandler = transferHandler;
        super.setTransferHandler(transferHandler);
        if (this._selectedListDisplay != null) {
            this._selectedListDisplay.setTransferHandler(this._transferHandler);
        }
        if (this._currentPathnamePanel != null) {
            this._currentPathnamePanel.setTransferHandler(this._transferHandler);
        }
    }

    public void setFilter(String pathFilter) {
        this._currentPathnamePanel.setFilter(pathFilter);
    }

    protected PathnamePanel createPathnamePanel(int tableType, boolean initialSearchByParts) {
        PathnamePanel pathnamePanel = new PathnamePanel(this._dssFileName, tableType, initialSearchByParts, this._selectedScrollPane);
        pathnamePanel.addObserver(this);
        pathnamePanel.setForeground(new Color(0, 0, 0));
        if (this._selectionMode == 1) {
            pathnamePanel.setSelectionMode(0);
        } else {
            pathnamePanel.setSelectionMode(2);
        }
        if (this._transferHandler != null) {
            pathnamePanel.setTransferHandler(this._transferHandler);
        }
        if (this._popup != null) {
            pathnamePanel.setPopup(this._popup);
        }
        if (this._observer != null) {
            // empty if block
        }
        return pathnamePanel;
    }

    public void setPathSelectionMode(int mode) {
        this._selectionMode = mode;
        this.setPathSelectionMode();
    }

    public void setPathSelectionMode() {
        boolean multiSelect = this._selectionMode != 1;
        this._selectButton.setVisible(multiSelect);
        this._clearSelectionButton.setVisible(multiSelect);
        this._clearSelectionButton.setVisible(multiSelect);
        this._unselectButton.setVisible(multiSelect);
        this._restoreSelectionButton.setVisible(multiSelect);
        this._replacePathnamesButton.setVisible(multiSelect);
        this._selectedScrollPane.setVisible(multiSelect);
        if (multiSelect) {
            this._addPathnamesButton.setText("Add Pathnames");
            this._currentPathnamePanel.setSelectionMode(2);
        } else {
            this._addPathnamesButton.setText("Set Pathname");
            this._currentPathnamePanel.setSelectionMode(0);
        }
    }

    public void setSelectionButtonsPanelVisible(boolean visible) {
        this._selectionButtonsPanel.setVisible(visible);
    }

    public boolean isSelectionButtonsPanelVisible() {
        return this._selectionButtonsPanel.isVisible();
    }

    public void addToSelection() {
        String parsingRegexp = "(.*)//(.*):(.*)/(.*)";
        Pattern parsingPattern = Pattern.compile(parsingRegexp);
        DssDataManager dataManager = this._currentPathnamePanel.getDataManager();
        String strUrl = "";
        DataReferenceSet drs = this._currentPathnamePanel.getSelectedPathnames();
        if (drs.size() == 0) {
            return;
        }
        if (dataManager != null && dataManager.isRemote()) {
            Logger logger;
            try {
                strUrl = ((HecDSSUtilitiesRemote)dataManager.dataManager()).getRemoteDSSManager().getServerUrl();
                Matcher m = parsingPattern.matcher(strUrl);
                if (m.matches() && m.groupCount() == 4) {
                    String host = m.group(2);
                    String port = m.group(3);
                    Integer iPort = Integer.parseInt(port);
                    for (int i = 0; i < drs.size(); ++i) {
                        DataReference dataSet = drs.elementAt(i);
                        dataSet.setHost(host);
                        dataSet.setPort(iPort);
                    }
                }
            }
            catch (RemoteException e) {
                logger = Logger.getLogger(this.getClass().getName());
                logger.log(Level.FINE, "Error connecting to remote dss manager.", e);
            }
            catch (Exception ex) {
                logger = Logger.getLogger(this.getClass().getName());
                logger.log(Level.FINE, "Error retrieving remote data.", ex);
            }
        }
        booleanContainer applyAll = new booleanContainer();
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        this.getTimeWindowDialog();
        boolean timesSet = this._timeWindowDialog.getTimeWindow(startTime, endTime, applyAll);
        if (this._selectionList.size() == 0) {
            this._selectionList.addAll((Collection)drs);
        } else {
            for (int i = 0; i < drs.size(); ++i) {
                DataReference dataSet = drs.elementAt(i);
                String pathname = dataSet.getNominalPathname();
                if (this._selectionList.containsString(pathname)) continue;
                if (timesSet) {
                    dataSet.setTimeWindow(startTime, endTime);
                }
                if (this._selectionMode == 1) {
                    this._selectionList.removeAllElements();
                }
                this._selectionList.addElement((Object)dataSet);
            }
        }
        this._currentPathnamePanel.clearSelection();
        this._selectedListDisplay.setListData(this._selectionList);
        this.selectionUpdated();
        this._currentPathnamePanel.revalidate();
    }

    public void addToSelection(DataReferenceSet drs) {
        this.addToSelection(drs, -1);
    }

    public void addToSelection(DataReferenceSet drs, int idx) {
        if (drs.size() == 0) {
            return;
        }
        for (int i = 0; i < drs.size(); ++i) {
            DataReference dataSet = drs.get(i);
            String pathname = dataSet.toString();
            if (this._selectionList.containsString(pathname)) continue;
            if (idx < 0 || idx > this._selectionList.size()) {
                this._selectionList.addElement((Object)dataSet);
                continue;
            }
            this._selectionList.add(idx, (Object)dataSet);
        }
        this._currentPathnamePanel.clearSelection();
        this._selectedListDisplay.setListData(this._selectionList);
        this.selectionUpdated();
        this.repaint();
    }

    public void addToSelection(String pathname) {
        booleanContainer applyAll = new booleanContainer();
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        this.getTimeWindowDialog();
        boolean timesSet = this._timeWindowDialog.getTimeWindow(startTime, endTime, applyAll);
        if (!this._selectionList.containsString(pathname)) {
            DataReference dataSet = new DataReference(pathname, this._dssFileName);
            if (timesSet) {
                dataSet.setTimeWindow(startTime, endTime);
            }
            if (this._selectionMode == 1) {
                this._selectionList.removeAllElements();
            }
            this._selectionList.addElement((Object)dataSet);
        }
        this._selectedListDisplay.setListData(this._selectionList);
        this.selectionUpdated();
        this.repaint();
    }

    public void selectAll() {
        DataReference dataSet;
        int i;
        booleanContainer applyAll = new booleanContainer();
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        this.getTimeWindowDialog();
        boolean timesSet = this._timeWindowDialog.getTimeWindow(startTime, endTime, applyAll);
        DataReferenceSet dataReferenceSet = this._currentPathnamePanel.getAllPathnames();
        if (timesSet) {
            for (i = 0; i < dataReferenceSet.size(); ++i) {
                dataSet = dataReferenceSet.elementAt(i);
                dataSet.setTimeWindow(startTime, endTime);
            }
        }
        if (this._selectionList.size() == 0) {
            this._selectionList.addAll((Collection)dataReferenceSet);
        } else {
            for (i = dataReferenceSet.size() - 1; i >= 0; --i) {
                dataSet = dataReferenceSet.elementAt(i);
                if (!this._selectionList.containsString(dataSet.pathname())) continue;
                dataReferenceSet.remove(i);
            }
            this._selectionList.addAll((Collection)dataReferenceSet);
        }
        this._currentPathnamePanel.clearSelection();
        this._selectedListDisplay.setListData(this._selectionList);
        this.selectionUpdated();
        this.repaint();
    }

    public void removeFromSelection() {
        if (this._selectedListDisplay.isSelectionEmpty()) {
            return;
        }
        Object[] selected = this._selectedListDisplay.getSelectedValues();
        if (selected.length == 0) {
            return;
        }
        for (int i = 0; i < selected.length; ++i) {
            DataReference dr = (DataReference)selected[i];
            int j = this._selectionList.indexOfString(selected[i].toString());
            if (j < 0) continue;
            this._selectionList.removeElementAt(j);
            this._previousSelectionList.add(selected[i]);
        }
        this._selectedListDisplay.setListData(this._selectionList);
        this.selectionUpdated();
        this.repaint();
    }

    public void clearSelection() {
        if (this._selectionList.size() > 0) {
            this._previousSelectionList.removeAllElements();
            for (int i = 0; i < this._selectionList.size(); ++i) {
                this._previousSelectionList.addElement((Object)this._selectionList.get(i));
            }
            this._selectionList.removeAllElements();
            if (this._previousSelectionList.size() > 0) {
                this._restoreSelectionButton.setEnabled(true);
            } else {
                this._restoreSelectionButton.setEnabled(false);
            }
        }
        this.selectionUpdated();
        this.repaint();
    }

    void restoreSelection() {
        for (int i = 0; i < this._previousSelectionList.size(); ++i) {
            if (this._selectionList.contains((Object)this._previousSelectionList.get(i))) continue;
            this._selectionList.addElement((Object)this._previousSelectionList.get(i));
        }
        this._selectedListDisplay.setListData(this._selectionList);
        this._previousSelectionList.removeAllElements();
        this.selectionUpdated();
        this._restoreSelectionButton.setEnabled(false);
        this.repaint();
    }

    public void setDividerLocation(int dividerLoc) {
        this._currentPathnamePanel.setDividerLocation(dividerLoc);
    }

    public int getDividerLocation() {
        return this._currentPathnamePanel.getDividerLocation();
    }

    void updateSelectionButtons() {
        if (this._selectButton == null) {
            return;
        }
        if (this._currentPathnamePanel.getSelectedPathnamesSize() == 0) {
            this._selectButton.setEnabled(false);
        } else {
            this._selectButton.setEnabled(true);
        }
        if (this._selectedListDisplay.isSelectionEmpty()) {
            this._unselectButton.setEnabled(false);
        } else {
            this._unselectButton.setEnabled(true);
        }
        if (this._selectedListDisplay.getModel().getSize() == 0) {
            this._clearSelectionButton.setEnabled(false);
        } else {
            this._clearSelectionButton.setEnabled(true);
        }
        if (this.getSelectedPathnamesSize() > 0) {
            this._addPathnamesButton.setEnabled(true);
            this._replacePathnamesButton.setEnabled(true);
        } else {
            this._addPathnamesButton.setEnabled(false);
            this._replacePathnamesButton.setEnabled(false);
        }
    }

    public boolean getTimeWindow(HecTime startTime, HecTime endTime) {
        booleanContainer applyToAll = new booleanContainer();
        this.getTimeWindowDialog();
        return this._timeWindowDialog.getTimeWindow(startTime, endTime, applyToAll) && !this._timeWindowDialog.isWaterYear();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ActionEvent) {
            ActionEvent event = (ActionEvent)arg;
            String eventName = event.getActionCommand();
            if (eventName.compareTo("timesUpdated") == 0) {
                if (this._timeWindowDialog != null) {
                    HecTime startTime = new HecTime();
                    HecTime endTime = new HecTime();
                    booleanContainer applyToAll = new booleanContainer();
                    this._timeWindowDialog.getTimeWindow(startTime, endTime, applyToAll);
                    this.setDataTimeWindow(startTime, endTime, applyToAll.value);
                    if (this._observer != null) {
                        this._observer.notifyObservers(event);
                    }
                }
            } else if (eventName.compareTo("pathnameSelected") == 0) {
                this.selectionUpdated();
            } else if (eventName.compareTo("pathnamesShownUpdated") == 0) {
                this.selectionUpdated();
            } else if (eventName.compareTo("runDefaultSelection") == 0) {
                this.runDefaultSelection();
            } else if (eventName.compareTo("pathnameSetInSearch") == 0) {
                this.setPathnameInSearch();
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this._selectedListSelectionModel.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this._selectedListSelectionModel.removeListSelectionListener(listener);
    }

    public JList getSelectionList() {
        return this._selectedListDisplay;
    }

    public void moveTop() {
        int sel = this._selectedListDisplay.getSelectedIndex();
        Object obj = this._selectionList.remove(sel);
        this._selectionList.add(0, obj);
        this._selectedListDisplay.setListData(this._selectionList);
        this._selectedListDisplay.clearSelection();
        this._selectedListDisplay.setSelectedIndex(0);
        this.repaint();
    }

    public void moveUp() {
        int sel = this._selectedListDisplay.getSelectedIndex();
        Object obj = this._selectionList.remove(sel);
        this._selectionList.add(sel - 1, obj);
        this._selectedListDisplay.setListData(this._selectionList);
        this._selectedListDisplay.clearSelection();
        this._selectedListDisplay.setSelectedIndex(sel - 1);
        this.repaint();
    }

    public void moveDown() {
        int sel = this._selectedListDisplay.getSelectedIndex();
        Object obj = this._selectionList.remove(sel);
        this._selectionList.add(sel + 1, obj);
        this._selectedListDisplay.setListData(this._selectionList);
        this._selectedListDisplay.clearSelection();
        this._selectedListDisplay.setSelectedIndex(sel + 1);
        this.repaint();
    }

    public void moveBottom() {
        int sel = this._selectedListDisplay.getSelectedIndex();
        Object obj = this._selectionList.remove(sel);
        this._selectionList.add(obj);
        this._selectedListDisplay.setListData(this._selectionList);
        this._selectedListDisplay.clearSelection();
        this._selectedListDisplay.setSelectedIndex(this._selectionList.size() - 1);
        this.repaint();
    }

    public String getDssFileName() {
        return this._dssFileName;
    }

    public void setPopupDeleteActionVisible(boolean visible) {
        this._popupDeleteActionVisible = visible;
        this._currentPathnamePanel.setPopupDeleteActionVisible(visible);
    }

    class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Object object = event.getSource();
            if (object == SelectionAndFilterPanel.this._selectedListDisplay) {
                if (event.getClickCount() >= 2) {
                    SelectionAndFilterPanel.this.removeFromSelection();
                } else if (SwingUtilities.isRightMouseButton(event)) {
                    SelectionAndFilterPanel.this.displayPopup(event, SelectionAndFilterPanel.this._selectedListDisplay);
                }
            }
        }
    }
}

