/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.IPanelController;
import hec.dssgui.IPathNamePanel;
import hec.dssgui.PathnamePanel;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.dss.DssDataManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

final class SelectionWrapperPanel
extends PathnamePanel {
    private final Component _wrappedComponent;
    private final IPathNamePanel _pathNamePanel;
    private final IPanelController _panelController;

    SelectionWrapperPanel(JScrollPane selectedScrollPane, Component wrappedComponent, IPathNamePanel pathNamePanel, IPanelController panelController) {
        super("", 2, false, selectedScrollPane);
        this._wrappedComponent = wrappedComponent;
        this._pathNamePanel = pathNamePanel;
        this._panelController = panelController;
        this.build();
    }

    private void build() {
        this.setLayout(new GridBagLayout());
        this._wrappedComponent.setMinimumSize(new Dimension(300, 80));
        this._splitPane = new JSplitPane(0, this._wrappedComponent, this._selectedScrollPane);
        this._splitPane.setDividerSize(4);
        this._splitPane.setDividerLocation(0.8);
        this._wrappedComponent.addComponentListener(new Adapter());
        this._selectedScrollPane.addComponentListener(new Adapter());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._splitPane, gbc);
    }

    @Override
    protected void build(boolean searchByParts) {
    }

    @Override
    public boolean showSelectionPanel() {
        return true;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void commit() {
    }

    @Override
    public List<Component> getLinkedTabs() {
        List linkedTabs = this._pathNamePanel.getLinkedTabs();
        ArrayList<Component> retList = new ArrayList<Component>();
        if (linkedTabs != null) {
            retList.addAll(linkedTabs);
        }
        return retList;
    }

    @Override
    public void setDividerLocation(int dividerLoc) {
        if (this._selectedScrollPane != null) {
            this._splitPane.setBottomComponent(this._selectedScrollPane);
        }
        if (this._splitPane.getLeftComponent() != null) {
            this._splitPane.getLeftComponent().setVisible(true);
        }
        this._splitPane.setDividerLocation(dividerLoc);
        this._splitPane.revalidate();
    }

    @Override
    public DssDataManager getDataManager() {
        return this._pathNamePanel.getDataManager();
    }

    @Override
    public void addObserver(Observer o) {
        this._pathNamePanel.addObserver(o);
    }

    @Override
    public void setPartNamesForFilter(String[] names) {
    }

    @Override
    public boolean getSearchMethod() {
        return false;
    }

    @Override
    public String[] getPathnameList() {
        return this._pathNamePanel.getPathnameList();
    }

    @Override
    public DataReferenceSet getAllPathnames() {
        return this._pathNamePanel.getAllPathnames();
    }

    @Override
    public void printCatalog(boolean showPreview) {
        this._pathNamePanel.printCatalog(showPreview);
    }

    @Override
    public void getTimeWindow() {
        this._pathNamePanel.getTimeWindow();
    }

    @Override
    public int getSelectedPathnamesSize() {
        return this._pathNamePanel.getSelectedPathnamesSize();
    }

    @Override
    public String getFirstSelectedPathname() {
        return this._pathNamePanel.getFirstSelectedPathname();
    }

    @Override
    public DataReferenceSet getSelectedPathnames() {
        return this._pathNamePanel.getSelectedPathnames();
    }

    @Override
    public void pathnameListUpdated() {
        double dividerLocation = this._dividerLocation;
        this._pathNamePanel.pathnameListUpdated();
        this._splitPane.setDividerLocation(dividerLocation);
    }

    @Override
    public void setBottom(Component comp) {
        if (comp != null) {
            this._splitPane.setBottomComponent(comp);
        }
    }

    @Override
    public int getPathnamesDisplayedSize() {
        return this._pathNamePanel.getPathnamesDisplayedSize();
    }

    @Override
    public void setPathnameList(String[] pathnameList, DssDataManager dataManager) {
        this._pathNamePanel.setPathnameList(pathnameList, dataManager);
    }

    @Override
    public CondensedReference[] getCondensedCatalog() {
        return this._pathNamePanel.getCondensedCatalog();
    }

    @Override
    public String getFilterSelection(int partNumber) {
        return this._pathNamePanel.getFilterSelection(partNumber);
    }

    @Override
    public int getTableType() {
        return this._pathNamePanel.getTableType();
    }

    @Override
    public void clearSelection() {
        this._pathNamePanel.clearSelection();
    }

    @Override
    public void catalogUpdated() {
        this._pathNamePanel.catalogUpdated();
    }

    @Override
    public void setSearchMethod(boolean searchByParts) {
        this._pathNamePanel.setSearchMethod(searchByParts);
    }

    @Override
    public void resetSearchString() {
        this._pathNamePanel.resetSearchString();
    }

    @Override
    public void setColumnNamesForPartsTable(String[] partColumns) {
        this._pathNamePanel.setColumnNamesForPartsTable(partColumns);
    }

    @Override
    public void setColumnNameForListTable(String listColumn) {
        this._pathNamePanel.setColumnNameForListTable(listColumn);
    }

    @Override
    public void addLinkedTab(Component tab) {
        this._pathNamePanel.addLinkedTab(tab);
    }

    @Override
    public void newTableView(int tableType, String dssFileName) {
        this._pathNamePanel.newTableView(tableType, dssFileName);
    }

    @Override
    public boolean isEmpty() {
        return this._pathNamePanel.isEmpty();
    }

    @Override
    public void setCondensedCatalog(CondensedReference[] condensedList, DssDataManager dataManager) {
        this._pathNamePanel.setCondensedCatalog(condensedList, dataManager);
    }

    @Override
    public void setPopup(JPopupMenu popup) {
        this._pathNamePanel.setPopup(popup);
    }

    @Override
    public String getSearchText() {
        return this._pathNamePanel.getSearchText();
    }

    @Override
    public void setFilter(String pathFilter) {
        this._pathNamePanel.setFilter(pathFilter);
    }

    @Override
    public void setSelectionMode(int mode) {
        this._pathNamePanel.setSelectionMode(mode);
    }

    @Override
    public void setVisible(boolean bVis) {
        this._wrappedComponent.setVisible(bVis);
        super.setVisible(bVis);
    }

    @Override
    public boolean canClose() {
        return this._panelController.canClose();
    }

    @Override
    public Color getTabTextColor() {
        return this._pathNamePanel.getTabTextColor();
    }

    private final class Adapter
    extends PathnamePanel.ComponentAdapter {
        private Adapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            int splitPaneHeight = 0;
            for (int i = 0; i < SelectionWrapperPanel.this._splitPane.getComponentCount(); ++i) {
                splitPaneHeight += SelectionWrapperPanel.this._splitPane.getComponent((int)i).getSize().height;
            }
            splitPaneHeight = SelectionWrapperPanel.this._splitPane.getHeight();
            if (splitPaneHeight == SelectionWrapperPanel.this._previousSplitPaneHeight) {
                double dividerLocation = (double)SelectionWrapperPanel.this._splitPane.getDividerLocation() / (double)splitPaneHeight;
                if (dividerLocation > 0.05 && dividerLocation < 0.95) {
                    SelectionWrapperPanel.this._dividerLocation = dividerLocation;
                }
                return;
            }
            SelectionWrapperPanel.this._previousSplitPaneHeight = splitPaneHeight;
            SelectionWrapperPanel.this._splitPane.setDividerLocation(SelectionWrapperPanel.this._dividerLocation);
        }
    }
}

