/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ListSelection;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.stringContainer;
import hec.io.TimeSeriesContainer;
import hec.util.TextUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;

public class ShefImportExport {
    private String python3Command = null;
    private ListSelection listSelection = null;

    public ShefImportExport(ListSelection listSelection) {
        this.listSelection = listSelection;
    }

    protected String getPython3Command() {
        if (this.python3Command == null) {
            Object[][] commandObjects = new Object[][]{{"cmd.exe /c python3 --version", 2}, {"cmd.exe /c python --version", 2}, {"python3 --version", 0}, {"python --version", 0}};
            StringBuilder errorMessage = new StringBuilder("Could not find a Python v3 interpreter with any of the following:");
            for (int i = 0; i < commandObjects.length; ++i) {
                try {
                    String line;
                    String cmd = (String)commandObjects[i][0];
                    int pos = (Integer)commandObjects[i][1];
                    ProcessBuilder pb = new ProcessBuilder(cmd.split(" "));
                    Process p = pb.start();
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("Python 3")) continue;
                        this.python3Command = cmd.replace(" --version", "");
                        System.out.println(line + " found via command " + cmd.split(" ")[pos]);
                    }
                    p.waitFor();
                    if (this.python3Command != null) {
                        break;
                    }
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
                errorMessage.append("\n\t").append(commandObjects[i][0]);
            }
            if (this.python3Command == null) {
                System.out.println(errorMessage.toString());
            }
        }
        return this.python3Command;
    }

    protected void fileError(boolean showStatusDialog, String message, String title) {
        System.out.println(message);
        if (showStatusDialog) {
            ShefImportExport shefImportExport = this;
            if (shefImportExport.listSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this.listSelection, message, title, 2);
            }
        }
    }

    protected int importShef(File[] files, boolean showStatusDialog, stringContainer message) {
        File parmFile;
        Pattern pathnameLinePattern = Pattern.compile("^/(.*?)/(.+?)/(.+?)//(.+?)/(.*?)/$");
        Pattern loadInfoLinePattern = Pattern.compile("^\\s+(\\{.+?\\})$");
        Pattern loadInfoItemPattern = Pattern.compile("'([^']+)'\\s*:\\s*'?([^']+)'?(\\s*,\\s*)?");
        Pattern timeValueLinePattern = Pattern.compile("^\\s+\\['(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})', ([+-]?\\d*(\\.(\\d*))?)\\]$");
        if (this.python3Command == null) {
            this.getPython3Command();
        }
        if (this.python3Command == null) {
            message.string = "Python v3 not found, cannot import SHEF data";
            this.fileError(showStatusDialog, message.string, "Python v3 not found on system");
            return -1;
        }
        File parserFile = new File(this.listSelection.getOptions().getShefParserFile());
        if (!parserFile.exists()) {
            message.string = "Required file does not exist: " + parserFile.getAbsolutePath();
            this.fileError(showStatusDialog, message.string, "File does not exist");
            return -1;
        }
        String parmFilename = this.listSelection.getOptions().getShefParmFile();
        if (parmFilename != null && parmFilename.length() > 0 && !(parmFile = new File(parmFilename)).exists()) {
            message.string = "Specified file does not exist: " + parmFile.getAbsolutePath();
            this.fileError(showStatusDialog, message.string, "File does not exist");
            return -1;
        }
        File sensorFile = new File(this.listSelection.getOptions().getShefSensorFile());
        if (!sensorFile.exists()) {
            message.string = "Required file does not exist: " + sensorFile.getAbsolutePath();
            this.fileError(showStatusDialog, message.string, "File does not exist");
            return -1;
        }
        File parameterFile = new File(this.listSelection.getOptions().getShefParameterFile());
        if (!parameterFile.exists()) {
            message.string = "Required file does not exist: " + parameterFile.getAbsolutePath();
            this.fileError(showStatusDialog, message.string, "File does not exist");
            return -1;
        }
        if (this.listSelection.getShefLogFile() == null) {
            this.listSelection.setShefLogFile(ListSelection.getLogFileName("ShefImportExport", null));
        }
        String outFilename = this.listSelection.getShefLogFile().replace(".log", ".out");
        int[] ntotal = new int[1];
        int[] nsets = new int[1];
        this.listSelection.setCursorWait();
        ArrayList<Integer> times = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        HashMap<String, String> info = new HashMap<String, String>();
        HashSet<String> pathnames = new HashSet<String>();
        for (int i = 0; i < files.length; ++i) {
            try {
                ArrayList<String> cmdParts = new ArrayList<String>();
                for (String s : this.python3Command.split(" ")) {
                    cmdParts.add(s);
                }
                cmdParts.add(parserFile.getAbsolutePath());
                cmdParts.add("-i");
                cmdParts.add(files[i].getAbsolutePath());
                cmdParts.add("-o");
                cmdParts.add(outFilename);
                cmdParts.add("-l");
                cmdParts.add(this.listSelection.getShefLogFile());
                if (i > 0) {
                    cmdParts.add("--append_log");
                }
                if (parmFilename == null || parmFilename.length() == 0) {
                    cmdParts.add("--defaults");
                } else {
                    cmdParts.add(" -s ");
                    cmdParts.add(parmFilename);
                }
                cmdParts.add("--loader");
                cmdParts.add(String.format("dssvue[%s][%s]", sensorFile.getAbsolutePath(), parameterFile.getAbsolutePath()));
                Process p = new ProcessBuilder(cmdParts.toArray(new String[cmdParts.size()])).start();
                p.waitFor();
                try (PythonStyleLogger shefLogger = new PythonStyleLogger(this.listSelection.getShefLogFile(), true);){
                    shefLogger.info("----------------------------------------------------------------------");
                    shefLogger.info("HEC-DSSVue reading time series from " + outFilename);
                    shefLogger.info("----------------------------------------------------------------------");
                    BufferedReader br = new BufferedReader(new FileReader(outFilename));
                    TimeSeriesContainer tsc = null;
                    HecTime t = new HecTime();
                    try {
                        String errorInfo;
                        String line;
                        while ((line = br.readLine()) != null) {
                            Matcher matcher = pathnameLinePattern.matcher(line);
                            if (matcher.matches()) {
                                if (tsc != null) {
                                    tsc.numberValues = times.size();
                                    tsc.times = new int[tsc.numberValues];
                                    tsc.values = new double[tsc.numberValues];
                                    for (int j = 0; j < tsc.numberValues; ++j) {
                                        tsc.times[j] = (Integer)times.get(j);
                                        tsc.values[j] = (Double)values.get(j);
                                    }
                                    times.clear();
                                    values.clear();
                                    shefLogger.info("Storing %2d value(s) to %s:%s", tsc.numberValues, this.listSelection.getDataManager().getDSSFileName(), tsc.getFullName());
                                    int status = this.listSelection.getDataManager().writeData(tsc);
                                    if (status == 0) {
                                        nsets[0] = nsets[0] + 1;
                                        ntotal[0] = ntotal[0] + tsc.numberValues;
                                        pathnames.add(tsc.getFullName());
                                    } else {
                                        errorInfo = Heclib.getErrorInfo((int)status);
                                        if (errorInfo == null) {
                                            shefLogger.error("write status = " + status);
                                        } else {
                                            shefLogger.error(errorInfo);
                                        }
                                    }
                                    tsc = null;
                                }
                                tsc = new TimeSeriesContainer();
                                tsc.setFullName(line);
                                tsc.watershed = matcher.group(1);
                                String[] parts = matcher.group(2).split("-", 2);
                                tsc.location = parts[0];
                                if (parts.length == 2) {
                                    tsc.subLocation = parts[1];
                                }
                                parts = matcher.group(3).split("-", 2);
                                tsc.parameter = parts[0];
                                if (parts.length == 2) {
                                    tsc.subParameter = parts[1];
                                }
                                try {
                                    tsc.interval = ((Interval)IntervalFactory.findAnyDss7((Predicate)IntervalFactory.equalsName((String)matcher.group(4))).get()).getMinutes();
                                }
                                catch (NoSuchElementException errorInfo2) {
                                    // empty catch block
                                }
                                parts = matcher.group(5).split("-", 2);
                                tsc.version = parts[0];
                                if (parts.length != 2) continue;
                                tsc.subVersion = parts[1];
                                continue;
                            }
                            matcher = loadInfoLinePattern.matcher(line);
                            if (matcher.matches()) {
                                info.clear();
                                matcher = loadInfoItemPattern.matcher(matcher.group(1));
                                while (matcher.find()) {
                                    info.put(matcher.group(1), matcher.group(2));
                                }
                                tsc.units = (String)info.get("unit");
                                tsc.type = (String)info.get("type");
                                continue;
                            }
                            matcher = timeValueLinePattern.matcher(line);
                            if (matcher.matches()) {
                                t.set(matcher.group(1));
                                times.add(t.value());
                                values.add(Double.parseDouble(matcher.group(2)));
                                continue;
                            }
                            throw new RuntimeException("Unexpected line: " + line);
                        }
                        br.close();
                        if (tsc == null) continue;
                        tsc.numberValues = times.size();
                        tsc.times = new int[tsc.numberValues];
                        tsc.values = new double[tsc.numberValues];
                        for (int j = 0; j < tsc.numberValues; ++j) {
                            tsc.times[j] = (Integer)times.get(j);
                            tsc.values[j] = (Double)values.get(j);
                        }
                        times.clear();
                        values.clear();
                        shefLogger.info("Storing %2d value(s) to %s:%s", tsc.numberValues, this.listSelection.getDataManager().getDSSFileName(), tsc.getFullName());
                        int status = this.listSelection.getDataManager().writeData(tsc);
                        if (status == 0) {
                            pathnames.add(tsc.getFullName());
                            nsets[0] = nsets[0] + 1;
                            ntotal[0] = ntotal[0] + tsc.numberValues;
                        } else {
                            errorInfo = Heclib.getErrorInfo((int)status);
                            if (errorInfo == null) {
                                shefLogger.error("write status = " + status);
                            } else {
                                shefLogger.error(errorInfo);
                            }
                        }
                        shefLogger.info("--[Summary]-----------------------------------------------------------");
                        shefLogger.info("%d values stored in %d writes to %d data sets", ntotal[0], nsets[0], pathnames.size());
                    }
                    catch (Throwable t2) {
                        shefLogger.critical(t2.getMessage());
                        throw t2;
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.listSelection.updateCatalog();
        this.listSelection.setCursorDefault();
        message.string = Integer.toString(ntotal[0]) + " values stored in " + Integer.toString(nsets[0]) + " data sets.";
        System.out.println(message.string);
        this.listSelection.miViewShefLog.setVisible(true);
        if (showStatusDialog) {
            ShefImportExport shefImportExport = this;
            if (shefImportExport.listSelection.isInteractive()) {
                Object[] options = new Object[]{"OK", "View Log"};
                ShefImportExport shefImportExport2 = this;
                if (1 == JOptionPane.showOptionDialog(this.listSelection, String.format("%d values stored in %d data sets", ntotal[0], nsets[0]), shefImportExport2.listSelection.getProgramName(), -1, 1, null, options, options[1])) {
                    this.listSelection.displayShefLog();
                }
            }
        }
        return ntotal[0];
    }

    public void exportShef(String exportFileName, Vector timeSeriesContainers) {
        if (this.python3Command == null) {
            this.getPython3Command();
        }
        if (this.python3Command == null) {
            String message = "Python v3 not found, cannot import SHEF data";
            this.fileError(true, message, "Python v3 not found on system");
            return;
        }
        File parserFile = new File(this.listSelection.getOptions().getShefParserFile());
        if (!parserFile.exists()) {
            String message = "Required file does not exist: " + parserFile.getAbsolutePath();
            this.fileError(true, message, "File does not exist");
            return;
        }
        File parameterFile = new File(this.listSelection.getOptions().getShefParameterFile());
        if (!parameterFile.exists()) {
            String message = "Required file does not exist: " + parameterFile.getAbsolutePath();
            this.fileError(true, message, "File does not exist");
            return;
        }
        File sensorFile = new File(this.listSelection.getOptions().getShefSensorFile());
        if (!sensorFile.exists()) {
            String message = "Required file does not exist: " + sensorFile.getAbsolutePath();
            this.fileError(true, message, "File does not exist");
            return;
        }
        File f = new File(exportFileName);
        boolean overwriteExport = false;
        try {
            if (!f.exists()) {
                f.createNewFile();
            } else {
                ShefImportExport shefImportExport = this;
                if (shefImportExport.listSelection.isInteractive()) {
                    String message = String.format("File already exists: %s\nWhat do you want to do?", exportFileName);
                    Object[] options = new Object[]{"Overwrite File", "Append to File"};
                    ShefImportExport shefImportExport2 = this;
                    if (0 == JOptionPane.showOptionDialog(this.listSelection, message, shefImportExport2.listSelection.getProgramName(), -1, 1, null, options, options[1])) {
                        overwriteExport = true;
                    }
                }
            }
            if (!f.canWrite()) {
                throw new Exception("Cannot write to file");
            }
        }
        catch (Exception e) {
            String message = "Cannot access file " + exportFileName + "\n" + e.toString();
            System.out.println(message);
            ShefImportExport shefImportExport = this;
            if (shefImportExport.listSelection.isInteractive()) {
                ShefImportExport shefImportExport3 = this;
                JOptionPane.showMessageDialog(this.listSelection, message, shefImportExport3.listSelection.getProgramName(), 2);
            }
            return;
        }
        if (this.listSelection.getShefLogFile() == null) {
            this.listSelection.setShefLogFile(ListSelection.getLogFileName("ShefImportExport", null));
        }
        String inFilename = this.listSelection.getShefLogFile().replace(".log", ".in");
        File infile = new File(inFilename);
        try {
            if (!infile.exists()) {
                infile.createNewFile();
            }
        }
        catch (Exception e) {
            String message = "Cannot access file " + inFilename + "\n" + e.toString();
            System.out.println(message);
            ShefImportExport shefImportExport = this;
            if (shefImportExport.listSelection.isInteractive()) {
                ShefImportExport shefImportExport4 = this;
                JOptionPane.showMessageDialog(this.listSelection, message, shefImportExport4.listSelection.getProgramName(), 2);
            }
            return;
        }
        this.listSelection.setCursorWait();
        int ncount = 0;
        try {
            PythonStyleLogger shefLogger = new PythonStyleLogger(this.listSelection.getShefLogFile(), false);
            try {
                shefLogger.info("----------------------------------------------------------------------");
                shefLogger.info("HEC-DSSVue writing time series to " + inFilename);
                shefLogger.info("----------------------------------------------------------------------");
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(infile));){
                    for (int i = 0; i < timeSeriesContainers.size(); ++i) {
                        TimeSeriesContainer tsc = (TimeSeriesContainer)timeSeriesContainers.elementAt(i);
                        if (tsc.numberValues == 0) {
                            System.out.println("TimeSeriesContainer is empty, skipping SHEF export ");
                            continue;
                        }
                        shefLogger.info("Writing %6d values for %s", tsc.numberValues, tsc.getFullName());
                        bw.write(tsc.getFullName() + "\n");
                        bw.write(String.format("\t{'unit': '%s', 'type': '%s'}\n", tsc.units, tsc.type));
                        for (int j = 0; j < tsc.numberValues; ++j) {
                            HecTime t = tsc.getHecTime(j);
                            bw.write(String.format("\t['%s:00', %f]\n", t.dateAndTime(-13).replaceAll(",", ""), tsc.getValue(j)));
                        }
                        ncount += tsc.numberValues;
                    }
                }
                catch (IOException e) {
                    shefLogger.critical(e.getMessage());
                    String message = "Error writing to file " + inFilename + "\n" + e.toString();
                    System.out.println(message);
                    this.listSelection.setCursorDefault();
                    ShefImportExport shefImportExport = this;
                    if (shefImportExport.listSelection.isInteractive()) {
                        ShefImportExport shefImportExport5 = this;
                        JOptionPane.showMessageDialog(this.listSelection, message, shefImportExport5.listSelection.getProgramName(), 2);
                    }
                    shefLogger.close();
                    return;
                }
                shefLogger.info("--[Summary]-----------------------------------------------------------");
                shefLogger.info("%d values in %d data sets written to\n\t%s", ncount, timeSeriesContainers.size(), inFilename);
            }
            finally {
                try {
                    shefLogger.close();
                }
                catch (Throwable message) {
                    Throwable e;
                    e.addSuppressed(message);
                }
            }
        }
        catch (Exception e) {
            String message = "Error writing to file " + inFilename + "\n" + e.toString();
            System.out.println(message);
            this.listSelection.setCursorDefault();
            ShefImportExport shefImportExport = this;
            if (shefImportExport.listSelection.isInteractive()) {
                ShefImportExport shefImportExport6 = this;
                JOptionPane.showMessageDialog(this.listSelection, message, shefImportExport6.listSelection.getProgramName(), 2);
            }
            return;
        }
        ArrayList<String> cmdParts = new ArrayList<String>();
        for (String s : this.python3Command.split(" ")) {
            cmdParts.add(s);
        }
        cmdParts.add(parserFile.getAbsolutePath());
        cmdParts.add("-i");
        cmdParts.add(infile.getAbsolutePath());
        cmdParts.add("-o");
        cmdParts.add(exportFileName);
        if (!overwriteExport) {
            cmdParts.add("--append_out");
        }
        cmdParts.add("-l");
        cmdParts.add(this.listSelection.getShefLogFile());
        cmdParts.add("--append_log");
        cmdParts.add("--loader");
        cmdParts.add(String.format("dssvue[%s][%s]", sensorFile.getAbsolutePath(), parameterFile.getAbsolutePath()));
        cmdParts.add("--unload");
        try {
            long last_pos;
            String cmd = TextUtil.join((String)" ", (String[])cmdParts.toArray(new String[cmdParts.size()]));
            Process p = new ProcessBuilder(cmdParts.toArray(new String[cmdParts.size()])).start();
            p.waitFor();
            RandomAccessFile logfile = new RandomAccessFile(new File(this.listSelection.getShefLogFile()), "r");
            StringBuilder sb = new StringBuilder();
            for (long pos = last_pos = logfile.length() - 1L; pos >= 0L; --pos) {
                logfile.seek(pos);
                char c = (char)logfile.read();
                if (c == '\n' || c == '\r') {
                    if (sb.length() != 0) break;
                    continue;
                }
                sb.append(c);
            }
            logfile.close();
            String message = String.format("%s to\n%s", sb.reverse().toString().replace("INFO: ", ""), exportFileName);
            System.out.println(message);
            this.listSelection.setCursorDefault();
            this.listSelection.miViewShefLog.setVisible(true);
            ShefImportExport shefImportExport = this;
            if (shefImportExport.listSelection.isInteractive()) {
                Object[] options = new Object[]{"OK", "View Log"};
                ShefImportExport shefImportExport7 = this;
                if (1 == JOptionPane.showOptionDialog(this.listSelection, message, shefImportExport7.listSelection.getProgramName(), -1, 1, null, options, options[1])) {
                    this.listSelection.displayShefLog();
                }
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        this.listSelection.setCursorDefault();
    }

    class PythonStyleLogger
    implements AutoCloseable {
        private PrintWriter pw = null;

        PythonStyleLogger(String logFileName, boolean append) throws IOException {
            this.pw = new PrintWriter(new FileWriter(logFileName, append));
        }

        void debug(String message) {
            this.pw.printf("DEBUG: %s\n", message);
        }

        void debug(String format, Object ... args) {
            this.debug(String.format(format, args));
        }

        void info(String message) {
            this.pw.printf("INFO: %s\n", message);
        }

        void info(String format, Object ... args) {
            this.info(String.format(format, args));
        }

        void warning(String message) {
            this.pw.printf("WARNING: %s\n", message);
        }

        void warning(String format, Object ... args) {
            this.warning(String.format(format, args));
        }

        void error(String message) {
            this.pw.printf("ERROR: %s\n", message);
        }

        void error(String format, Object ... args) {
            this.error(String.format(format, args));
        }

        void critical(String message) {
            this.pw.printf("CRITICAL: %s\n", message);
        }

        void critical(String format, Object ... args) {
            this.critical(String.format(format, args));
        }

        void log(PythonLoggingLevel level, String message) {
            switch (level) {
                case DEBUG: {
                    this.debug(message);
                    break;
                }
                case INFO: {
                    this.info(message);
                    break;
                }
                case WARNING: {
                    this.warning(message);
                    break;
                }
                case ERROR: {
                    this.error(message);
                    break;
                }
                case CRITICAL: {
                    this.critical(message);
                }
            }
        }

        void log(PythonLoggingLevel level, String format, Object ... args) {
            this.log(level, String.format(format, args));
        }

        @Override
        public void close() throws Exception {
            if (this.pw != null) {
                this.pw.close();
            }
        }
    }

    static enum PythonLoggingLevel {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        CRITICAL;

    }
}

