/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.data.Units;
import hec.dssgui.MathFrame2;
import hec.dssgui.MathPanel;
import hec.dssgui.MathTab;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJList;
import rma.swing.RmaJRadioButton;
import rma.swing.list.RmaListModel;

public class SimpleMathTab
extends MathPanel
implements MathTab {
    private static final String SINGLE_OR_DATASET = "SingleOrDataSet";
    private static final String MULTIPLE_SELECTION = "MultipleSelection";
    private static final String MULTIPLE_SELECTION_TS = "MultipleSelectionTimeSeties";
    private static final String ADD = "Add";
    private static final String SUBTRACT = "Subtract";
    private static final String MULTIPLY = "Multiply";
    private static final String DIVIDE = "Divide";
    private static final String EXPONENTIATION = "Exponentiation";
    private static final String ABSOLUTE_VALUE = "Absolute Value";
    private static final String SQUARE_ROOT = "Square Root";
    private static final String LOG = "Log e";
    private static final String LOG10 = "Log Base 10";
    private static final String SIN = "Sine";
    private static final String COS = "Cosine";
    private static final String TAN = "Tangent";
    private static final String INVERSE = "Inverse";
    private static final String ACCUMULATION = "Accumulation";
    private static final String SUCCESSIVE_DIFFERENCES = "Successive Differences";
    private static final String TIME_DERIVATIVE = "Time Derivative";
    protected static String[] _operators = new String[]{"Add", "Subtract", "Multiply", "Divide", "Exponentiation", "Absolute Value", "Square Root", "Log e", "Log Base 10", "Sine", "Cosine", "Tangent", "Inverse", "Accumulation", "Successive Differences", "Time Derivative"};
    protected static String[] _opPanelTypes = new String[]{"SingleOrDataSet", "SingleOrDataSet", "SingleOrDataSet", "SingleOrDataSet", "Exponentiation", "MultipleSelection", "MultipleSelection", "MultipleSelection", "MultipleSelection", "MultipleSelection", "MultipleSelection", "MultipleSelection", "MultipleSelection", "MultipleSelectionTimeSeties", "MultipleSelectionTimeSeties", "MultipleSelectionTimeSeties"};
    JComboBox _pairedDataCurveCombo;
    private JLabel _pairedDataCurveLabel;
    private ConstantOrDataSetPanel _constDataPanel;
    private MathPanel.DataSetListPanel _dataListPanel;
    private MathPanel.DataSetListPanelTS _dataListPanelTS;
    private SingleFieldPanel _exponentPanel;

    public SimpleMathTab(MathFrame2 parent) {
        super(parent);
    }

    @Override
    protected void buildPanel() {
        super.buildPanel();
        this._pairedDataCurveLabel = new JLabel("Select Paired Data Curve:");
        this._pairedDataCurveLabel.setDisplayedMnemonic('P');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this._pairedDataCurveLabel, gbc);
        this._pairedDataCurveCombo = new JComboBox();
        this._pairedDataCurveCombo.setModel(new RmaListModel(false));
        this._pairedDataCurveCombo.setVerifyInputWhenFocusTarget(false);
        this._pairedDataCurveLabel.setLabelFor(this._pairedDataCurveCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this._pairedDataCurveCombo, gbc);
        this._opCombo.setModel(new RmaListModel(false, (Object[])_operators));
        this._opCombo.setMaximumRowCount(_operators.length);
        final CardLayout cl = (CardLayout)this._cardPanel.getLayout();
        this._constDataPanel = new ConstantOrDataSetPanel();
        this._dataListPanel = new MathPanel.DataSetListPanel();
        this._dataListPanelTS = new MathPanel.DataSetListPanelTS();
        this._exponentPanel = new SingleFieldPanel();
        this._exponentPanel.setLabelText("Power:", 'P');
        this._cardPanel.add(SINGLE_OR_DATASET, this._constDataPanel);
        this._cardPanel.add(MULTIPLE_SELECTION, this._dataListPanel);
        this._cardPanel.add(MULTIPLE_SELECTION_TS, this._dataListPanelTS);
        this._cardPanel.add(EXPONENTIATION, this._exponentPanel);
        this._opCombo.setSelectedIndex(-1);
        this._opCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = SimpleMathTab.this._opCombo.getSelectedIndex();
                cl.show(SimpleMathTab.this._cardPanel, _opPanelTypes[idx]);
                SimpleMathTab.this.setComputeButtonEnabled(SimpleMathTab.this.isComputable());
            }
        });
        this._opCombo.setSelectedIndex(0);
    }

    @Override
    public boolean compute() {
        int selectedNumber;
        TimeSeriesContainer outputDc = null;
        TimeSeriesMath mathGuy = null;
        HecMath outputMath = null;
        RmaJList panelDataList = null;
        int[] selection = null;
        String op = (String)this._opCombo.getSelectedItem();
        int idx = this._opCombo.getSelectedIndex();
        if (_opPanelTypes[idx].equals(SINGLE_OR_DATASET)) {
            panelDataList = this._constDataPanel.getDataSetList();
            selection = this._constDataPanel.getSelectedIndices();
        } else if (_opPanelTypes[idx].equals(MULTIPLE_SELECTION)) {
            panelDataList = this._dataListPanel.getDataSetList();
            selection = this._dataListPanel.getSelectedIndices();
        } else if (_opPanelTypes[idx].equals(MULTIPLE_SELECTION_TS)) {
            panelDataList = this._dataListPanelTS.getDataSetList();
            selection = this._dataListPanelTS.getSelectedIndices();
        } else if (_opPanelTypes[idx].equals(EXPONENTIATION)) {
            panelDataList = this._exponentPanel.getDataSetList();
            selection = this._exponentPanel.getSelectedIndices();
        } else {
            panelDataList = this._dataListPanel.getDataSetList();
        }
        boolean selectionFromList = false;
        if (selection != null && selection.length > 0) {
            selectedNumber = selection.length;
            selectionFromList = true;
        } else {
            selectedNumber = 1;
            selection = new int[]{this._parent.getSelectedIndex()};
        }
        for (int j = 0; j < selectedNumber; ++j) {
            DataContainer dc;
            if (selectionFromList) {
                if (this._constDataPanel.isConstant()) {
                    this._parent.setSelectedIndex(selection[j]);
                } else {
                    panelDataList.setSelectedIndex(selection[j]);
                }
            }
            if ((dc = this._parent.getSelectedDataSet()) instanceof TimeSeriesContainer) {
                mathGuy = this._tsmath;
                outputDc = new TimeSeriesContainer();
            } else if (dc instanceof PairedDataContainer) {
                int curve;
                mathGuy = this._pdmath;
                outputDc = new PairedDataContainer();
                try {
                    curve = this.getSelectedPairedDataCurve();
                }
                catch (IllegalStateException ise) {
                    return false;
                }
                try {
                    this._pdmath.setCurve(curve);
                }
                catch (HecMathException hme) {
                    System.out.println("compute: error setting PairedDataCurve " + hme);
                    JOptionPane.showMessageDialog(this, hme.toString(), "Error setting PairedData Curve", 0);
                }
            }
            if (mathGuy == null) {
                return false;
            }
            try {
                mathGuy.setData(dc);
            }
            catch (HecMathException e) {
                System.out.println("compute: Exception : " + e);
                JOptionPane.showMessageDialog(this, e.toString(), "Error during compute", 0);
                return false;
            }
            try {
                if (ADD.equals(op)) {
                    if (this._constDataPanel.isConstant()) {
                        double constant = this._constDataPanel.getConstant();
                        if (constant == -3.4028234663852886E38) {
                            return false;
                        }
                        outputMath = mathGuy.add(constant);
                    } else {
                        HecMath tmpMath = HecMath.createInstance((DataContainer)this._constDataPanel.getSelectedDataContainer());
                        if (this.unitsOk((HecMath)mathGuy, tmpMath)) {
                            outputMath = mathGuy.add(tmpMath);
                        }
                    }
                } else if (SUBTRACT.equals(op)) {
                    if (this._constDataPanel.isConstant()) {
                        double constant = this._constDataPanel.getConstant();
                        if (constant == -3.4028234663852886E38) {
                            return false;
                        }
                        outputMath = mathGuy.subtract(constant);
                    } else {
                        HecMath tmpMath = HecMath.createInstance((DataContainer)this._constDataPanel.getSelectedDataContainer());
                        if (this.unitsOk((HecMath)mathGuy, tmpMath)) {
                            outputMath = mathGuy.subtract(tmpMath);
                        }
                    }
                } else if (MULTIPLY.equals(op)) {
                    if (this._constDataPanel.isConstant()) {
                        double constant = this._constDataPanel.getConstant();
                        if (constant == -3.4028234663852886E38) {
                            return false;
                        }
                        outputMath = mathGuy.multiply(constant);
                    } else {
                        HecMath tmpMath = HecMath.createInstance((DataContainer)this._constDataPanel.getSelectedDataContainer());
                        outputMath = mathGuy.multiply(tmpMath);
                    }
                } else if (DIVIDE.equals(op)) {
                    if (this._constDataPanel.isConstant()) {
                        double constant = this._constDataPanel.getConstant();
                        if (constant == -3.4028234663852886E38) {
                            return false;
                        }
                        outputMath = mathGuy.divide(constant);
                    } else {
                        HecMath tmpMath = HecMath.createInstance((DataContainer)this._constDataPanel.getSelectedDataContainer());
                        outputMath = mathGuy.divide(tmpMath);
                    }
                } else if (EXPONENTIATION.equals(op)) {
                    double constant = this._exponentPanel.getConstant();
                    if (constant == -3.4028234663852886E38) {
                        return false;
                    }
                    outputMath = mathGuy.exponentiation(constant);
                } else if (ABSOLUTE_VALUE.equals(op)) {
                    outputMath = mathGuy.abs();
                } else if (SQUARE_ROOT.equals(op)) {
                    outputMath = mathGuy.sqrt();
                } else if (LOG.equals(op)) {
                    outputMath = mathGuy.log();
                } else if (LOG10.equals(op)) {
                    outputMath = mathGuy.log10();
                } else if (SIN.equals(op)) {
                    outputMath = mathGuy.sin();
                } else if (COS.equals(op)) {
                    outputMath = mathGuy.cos();
                } else if (TAN.equals(op)) {
                    outputMath = mathGuy.tan();
                } else if (INVERSE.equals(op)) {
                    outputMath = mathGuy.inverse();
                } else if (ACCUMULATION.equals(op)) {
                    outputMath = this._tsmath.accumulation();
                } else if (SUCCESSIVE_DIFFERENCES.equals(op)) {
                    outputMath = this._tsmath.successiveDifferences();
                } else if (TIME_DERIVATIVE.equals(op)) {
                    outputMath = this._tsmath.timeDerivative();
                }
                if (outputMath == null) continue;
                outputMath.getData((DataContainer)outputDc);
                this._parent.setSelectedIndex(selection[j]);
                this._parent.updateSelectedDataSet((DataContainer)outputDc);
                continue;
            }
            catch (Exception e) {
                System.out.println("compute: Exception " + e);
                JOptionPane.showMessageDialog(this, e.toString(), "Compute Error", 0);
                return false;
            }
        }
        if (outputMath != null) {
            this.setSelectedIndices(selection);
            return true;
        }
        return false;
    }

    @Override
    public Vector getSelectedDataSets() {
        int idx = this._opCombo.getSelectedIndex();
        if (_opPanelTypes[idx] == MULTIPLE_SELECTION) {
            return this._dataListPanel.getSelectedDataSets();
        }
        if (_opPanelTypes[idx] == MULTIPLE_SELECTION_TS) {
            return this._dataListPanelTS.getSelectedDataSets();
        }
        if (_opPanelTypes[idx] == SINGLE_OR_DATASET) {
            return this._constDataPanel.getSelectedDataSets();
        }
        if (_opPanelTypes[idx] == EXPONENTIATION) {
            return this._exponentPanel.getSelectedDataSets();
        }
        return super.getSelectedDataSets();
    }

    @Override
    public int[] getSelectedIndices() {
        int[] selected = null;
        int idx = this._opCombo.getSelectedIndex();
        if (_opPanelTypes[idx] == MULTIPLE_SELECTION) {
            selected = this._dataListPanel.getSelectedIndices();
        } else if (_opPanelTypes[idx] == MULTIPLE_SELECTION_TS) {
            selected = this._dataListPanelTS.getSelectedIndices();
        } else if (_opPanelTypes[idx] == SINGLE_OR_DATASET) {
            selected = this._constDataPanel.getSelectedIndices();
        } else if (_opPanelTypes[idx] == EXPONENTIATION) {
            selected = this._exponentPanel.getSelectedIndices();
        }
        if (selected != null && selected.length > 0) {
            return selected;
        }
        return super.getSelectedIndices();
    }

    public void setSelectedIndices(int[] selected) {
        int idx = this._opCombo.getSelectedIndex();
        if (selected != null && selected.length > 0) {
            if (_opPanelTypes[idx] == MULTIPLE_SELECTION) {
                this._dataListPanel.setSelectedIndices(selected);
            } else if (_opPanelTypes[idx] == MULTIPLE_SELECTION_TS) {
                this._dataListPanelTS.setSelectedIndices(selected);
            } else if (_opPanelTypes[idx] == SINGLE_OR_DATASET) {
                this._constDataPanel.setSelectedIndices(selected);
            } else if (_opPanelTypes[idx] == EXPONENTIATION) {
                this._exponentPanel.setSelectedIndices(selected);
            }
        }
    }

    private boolean unitsOk(HecMath math1, HecMath math2) {
        try {
            String units1 = math1.getUnits().trim();
            String units2 = math2.getUnits().trim();
            if (units1.equalsIgnoreCase(units2)) {
                return true;
            }
            units1 = Units.getUnitsForAlias((String)math1.getStandardUnits());
            units2 = Units.getUnitsForAlias((String)math2.getStandardUnits());
            if (units1 == null || units2 == null) {
                String msg;
                int opt;
                units1 = math1.getUnits();
                if (units1 == null || units1.length() < 1) {
                    units1 = "<no units>";
                }
                if ((units2 = math2.getUnits()) == null || units2.length() < 1) {
                    units2 = "<no units>";
                }
                return (opt = JOptionPane.showConfirmDialog(this, msg = "Problem determining standard units for data sets. \nUnits name for first data set is: " + units1 + "\nUnits name for second data set is: " + units2 + "\n\n Compute anyway?", "Units Mismatch", 0)) == 0;
            }
            if (!units1.equals(units2)) {
                int opt = JOptionPane.showConfirmDialog(this, "Units don't match. Selected DataSet's units are in " + units1 + " and other DataSet's units are in " + units2 + "\n Compute anyway?", "Units Mismatch", 0);
                return opt == 0;
            }
        }
        catch (Exception e) {
            String units1 = null;
            String units2 = null;
            try {
                units1 = math1.getUnits();
            }
            catch (Exception opt) {
                // empty catch block
            }
            if (units1 == null || units1.length() < 1) {
                units1 = "<no units>";
            }
            try {
                units2 = math1.getUnits();
            }
            catch (Exception opt) {
                // empty catch block
            }
            if (units2 == null || units2.length() < 1) {
                units2 = "<no units>";
            }
            String msg = "Problem determining standard units for data sets. \nUnits name for first data set is: " + units1 + "\nUnits name for second data set is: " + units2;
            JOptionPane.showMessageDialog(this, msg, "Compute Error", 0);
            return false;
        }
        return true;
    }

    @Override
    public void setSelectedDataContainer(DataContainer dc) {
        this.buildPairedDataMenu(dc);
        this._constDataPanel.setSelectedDataContainer(dc);
        this._dataListPanel.setSelectedDataContainer(dc);
        this._dataListPanelTS.setSelectedDataContainer(dc);
        if (dc == null) {
            this._constDataPanel.setDataContainers(null);
            this._dataListPanel.setDataContainers(null);
            this._dataListPanelTS.setDataContainers(null);
            return;
        }
        if (this._dataContainers == null) {
            this._constDataPanel.setDataContainers(null);
            this._dataListPanel.setDataContainers(null);
            this._dataListPanelTS.setDataContainers(null);
            return;
        }
        Vector v = new Vector();
        for (int i = 0; i < this._dataContainers.size(); ++i) {
            Object obj = this._dataContainers.get(i);
            if (!obj.getClass().isInstance(dc)) continue;
            v.add(obj);
        }
        this._constDataPanel.setDataContainers(v);
        this._dataListPanel.setDataContainers(v);
        this._dataListPanelTS.setDataContainers(v);
    }

    protected void buildPairedDataMenu(DataContainer dc) {
        boolean visible = dc instanceof PairedDataContainer;
        this._pairedDataCurveCombo.setVisible(visible);
        this._pairedDataCurveLabel.setVisible(visible);
        PairedDataContainer pdc = null;
        if (!visible) {
            return;
        }
        pdc = (PairedDataContainer)dc;
        this._pairedDataCurveCombo.setEnabled(pdc != null && pdc.yOrdinates != null);
        if (pdc == null || pdc.yOrdinates == null) {
            return;
        }
        RmaListModel model = new RmaListModel(false);
        model.addElement((Object)pdc.xparameter);
        if (pdc.numberCurves == 1) {
            model.addElement((Object)pdc.yparameter);
        } else {
            for (int i = 0; i < pdc.yOrdinates.length; ++i) {
                if (pdc.labelsUsed && pdc.labels != null && pdc.labels[i] != null) {
                    model.addElement((Object)pdc.labels[i]);
                    continue;
                }
                model.addElement((Object)(pdc.yparameter + "  " + String.valueOf(i + 1)));
            }
        }
        if (model.size() == 2) {
            model.addElement((Object)"Both");
        } else {
            model.addElement((Object)"All y");
            model.addElement((Object)"All y and x");
        }
        RmaListModel currentModel = (RmaListModel)this._pairedDataCurveCombo.getModel();
        if (model.size() == currentModel.size()) {
            boolean same = true;
            for (int i = 0; i < model.size(); ++i) {
                if (model.elementAt(i).equals(currentModel.elementAt(i))) continue;
                same = false;
                break;
            }
            if (same) {
                return;
            }
        }
        this._pairedDataCurveCombo.setModel(model);
        this._pairedDataCurveCombo.setSelectedIndex(model.size() - 1);
        this._pairedDataCurveCombo.setEnabled(model.getSize() > 0);
    }

    public int getSelectedPairedDataCurve() throws IllegalStateException {
        if (!this._pairedDataCurveCombo.isEnabled()) {
            return -100;
        }
        String item = (String)this._pairedDataCurveCombo.getSelectedItem();
        if ("All y".equals(item)) {
            return -1;
        }
        if ("Both".equals(item)) {
            return -3;
        }
        if ("All y and x".equals(item)) {
            return -3;
        }
        int curveNumber = this._pairedDataCurveCombo.getSelectedIndex() - 1;
        if (curveNumber < 0) {
            return -2;
        }
        return curveNumber;
    }

    @Override
    public void setDataContainers(Vector dcList) {
        this._dataContainers = dcList;
        this._exponentPanel.setDataContainers(dcList);
    }

    @Override
    public String getTabName() {
        return "Arithmetic";
    }

    public class ConstantOrDataSetPanel
    extends MathPanel.MathCardPanel
    implements ActionListener {
        private RmaJRadioButton _constantRB;
        private RmaJRadioButton _dataSetRB;
        protected RmaJList _dataSetList;
        private RmaJDecimalField _constantTxt;

        public ConstantOrDataSetPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._constantRB = new RmaJRadioButton("Constant", true);
            this._constantRB.setMnemonic('n');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._constantRB, gbc);
            this._constantTxt = new RmaJDecimalField();
            this._constantTxt.setColumns(10);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.ipadx = 100;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._constantTxt, gbc);
            this._dataSetRB = new RmaJRadioButton("Data Set");
            this._dataSetRB.setMnemonic('a');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._dataSetRB, gbc);
            this._dataSetList = new RmaJList(){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    return d;
                }
            };
            this._dataSetList.setSelectionMode(2);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.5;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add((Component)new JScrollPane((Component)this._dataSetList), gbc);
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this._constantRB);
            bg.add((AbstractButton)this._dataSetRB);
            this._constantRB.addActionListener((ActionListener)this);
            this._dataSetRB.addActionListener((ActionListener)this);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._constantTxt.addKeyListener((KeyListener)kl);
            this._dataSetList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SimpleMathTab.this.setComputeButtonEnabled(ConstantOrDataSetPanel.this.isComputable());
                }
            });
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this._constantTxt.setText("");
                this._constantRB.doClick();
            }
            super.setVisible(b);
            this.isComputable();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == this._constantRB) {
                this._constantTxt.setEnabled(true);
            } else if (obj == this._dataSetRB) {
                this._constantTxt.setEnabled(false);
            }
            SimpleMathTab.this.setComputeButtonEnabled(this.isComputable());
        }

        @Override
        public void setDataContainers(Vector containers) {
            if (containers == null) {
                this._dataSetList.setListData((Vector)null);
                return;
            }
            DefaultListModel newModel = new DefaultListModel();
            for (int i = 0; i < containers.size(); ++i) {
                newModel.addElement(containers.get(i));
            }
            this._dataSetList.setModel(newModel);
            boolean enable = true;
            for (int i = 0; i < containers.size(); ++i) {
                Object obj = containers.elementAt(i);
                if (!(obj instanceof PairedDataContainer)) continue;
                enable = false;
            }
            this._dataSetRB.setEnabled(enable);
            this._dataSetList.setEnabled(enable);
        }

        @Override
        public boolean isComputable() {
            boolean b = false;
            if (this._constantRB.isSelected()) {
                boolean bl = b = this._constantTxt.getText().length() != 0;
                if (!b) {
                    this.setStatusLineText("No ", (JComponent)this._constantRB, " entered.");
                    return false;
                }
            } else if (this._dataSetRB.isSelected()) {
                boolean bl = b = this._dataSetList.getSelectedIndex() != -1;
                if (!b) {
                    this.setStatusLineText("No DataSet Selected");
                    return false;
                }
            }
            this.clearStatusLineText();
            return true;
        }

        public boolean isConstant() {
            return this._constantRB.isSelected();
        }

        public double getConstant() {
            if (this._constantRB.isSelected()) {
                double value = this._constantTxt.getValueUndefined();
                if (value == Double.NEGATIVE_INFINITY) {
                    return -3.4028234663852886E38;
                }
                return value;
            }
            return -3.4028234663852886E38;
        }

        public DataContainer getSelectedDataContainer() {
            if (this._dataSetRB.isSelected()) {
                return (DataContainer)this._dataSetList.getSelectedValue();
            }
            return null;
        }

        public RmaJList getDataSetList() {
            return this._dataSetList;
        }

        public int[] getSelectedIndices() {
            return this._dataSetList.getSelectedIndices();
        }

        public void setSelectedIndices(int[] selected) {
            this._dataSetList.setSelectedIndices(selected);
        }

        public Vector getSelectedDataSets() {
            int[] indicies;
            Vector<Object> v = new Vector<Object>();
            if (this._constantRB.isSelected() && (indicies = this._dataSetList.getSelectedIndices()) != null) {
                for (int i = 0; i < indicies.length; ++i) {
                    v.add(this._dataSetList.getValueAt(indicies[i]));
                }
            }
            if (v.size() == 0) {
                DataContainer dc = SimpleMathTab.this._parent.getSelectedDataSet();
                v.add(dc);
            }
            return v;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            boolean enabled = true;
            this._dataSetRB.setEnabled(enabled);
            this._dataSetList.setEnabled(enabled);
            if (!enabled && this._dataSetRB.isSelected()) {
                this._constantRB.doClick();
            }
        }
    }

    public class SingleFieldPanel
    extends MathPanel.MathCardListPanel {
        private RmaJDecimalField _constantTxt;
        private JLabel _constantLabel;

        public SingleFieldPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._constantLabel = new JLabel("Value:");
            this._constantLabel.setDisplayedMnemonic('V');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._constantLabel, gbc);
            this._constantTxt = new RmaJDecimalField();
            this._constantTxt.setColumns(10);
            this._constantLabel.setLabelFor((Component)this._constantTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.ipadx = 100;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._constantTxt, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 3;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._constantTxt.addKeyListener((KeyListener)kl);
        }

        public void setLabelText(String text, char mnemonic) {
            if (text == null) {
                this._constantLabel.setText("");
            } else {
                this._constantLabel.setText(text);
            }
            if (mnemonic != '\u0000') {
                this._constantLabel.setDisplayedMnemonic(mnemonic);
            }
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this._constantTxt.setText("");
            }
            super.setVisible(b);
            this._dataSetListPanel.setVisible(b);
            this.isComputable();
        }

        @Override
        public boolean isComputable() {
            boolean b;
            boolean bl = b = this._constantTxt.getText().length() != 0;
            if (!b) {
                this.setStatusLineText("No ", this._constantLabel, " entered.");
            } else {
                this.clearStatusLineText();
            }
            return b;
        }

        public double getConstant() {
            double value = this._constantTxt.getValueUndefined();
            if (value == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return value;
        }
    }
}

