/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.heclib.dss.DSSPathname;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.map.GridGlyphDataRecord;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.crs.CoordinateReferenceSystem;
import java.util.Vector;
import rma.util.ColorContour;
import rma.util.PrecipColorContour;

public class SingleGrid
implements MapObjectInterface {
    public static final float NODATA = -9999.0f;
    private GridInfo _info;
    private GridData _data;
    private String _pathName;
    private WorldRect _extents;
    GridGlyphDataRecord _glyphDataRec;

    public SingleGrid(GridData data, String pathName) {
        this._data = data;
        this._pathName = pathName;
        this._info = data != null ? data.getGridInfo() : null;
    }

    public GridInfo getGridInfo() {
        return this._info;
    }

    public GridData getGridData() {
        return this._data;
    }

    public float[] getData() {
        if (this._data == null) {
            return new float[0];
        }
        return this._data.getData();
    }

    public int getAreaWidth() {
        if (this._info == null) {
            return 0;
        }
        return this._info.getNumberOfCellsX();
    }

    public int getAreaHeight() {
        if (this._info == null) {
            return 0;
        }
        return this._info.getNumberOfCellsY();
    }

    public double getResolutionX() {
        if (this._info == null) {
            return 0.0;
        }
        return this._info.getCellSize();
    }

    public double getResolutionY() {
        if (this._info == null) {
            return 0.0;
        }
        return this._info.getCellSize();
    }

    public void unload() {
    }

    public void load() {
    }

    public WorldRect getExtent() {
        if (this._extents == null) {
            if (this._info == null) {
                return null;
            }
            double cellSize = this._info.getCellSize();
            double x = this._info.getLowerLeftCellX();
            double y = this._info.getLowerLeftCellY();
            double nx = this._info.getNumberOfCellsX();
            double ny = this._info.getNumberOfCellsY();
            this._extents = new WorldRect(x * cellSize, y * cellSize, (x + nx) * cellSize, (y + ny) * cellSize);
        }
        return this._extents;
    }

    public double getNoDataValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getElevation(WorldPt pt) {
        float f = this.getValueAtPt(pt);
        if (f == Float.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return f;
    }

    public float getValueAtPt(WorldPt pt) {
        WorldRect rect = this.getExtent();
        if (rect == null) {
            return Float.NEGATIVE_INFINITY;
        }
        if (!rect.contains(pt)) {
            return Float.NEGATIVE_INFINITY;
        }
        int numrow = this.getAreaHeight();
        --numrow;
        int numcol = this.getAreaWidth();
        double cellsize = this.getGridInfo().getCellSize();
        int icol = (int)((pt.e - rect.w) / cellsize);
        if (icol >= numcol) {
            return Float.NEGATIVE_INFINITY;
        }
        int irow = numrow - (int)((rect.n - pt.n) / cellsize);
        if (irow < 0) {
            return Float.NEGATIVE_INFINITY;
        }
        int idx = irow * numcol + icol;
        float[] data = this.getData();
        if (idx < data.length) {
            return data[idx];
        }
        return Float.NEGATIVE_INFINITY;
    }

    public void setExtent(WorldRect extent) {
    }

    public String getName() {
        return this.getPathName();
    }

    public String getPathName() {
        return this._pathName;
    }

    public MapIdentifier getMapIdentifier() {
        return new MapIdentifier();
    }

    public void setMapIdentifier(MapIdentifier mapId) {
    }

    public double getMinimumElevation() {
        if (this._info != null) {
            return this._info.getMinDataValue();
        }
        return 0.0;
    }

    public double getMaximumElevation() {
        if (this._info != null) {
            return (double)this._info.getMaxDataValue() + 0.01;
        }
        return 0.0;
    }

    public int[] getRowColAtPt(WorldPt pt) {
        WorldRect rect = this.getExtent();
        int[] xy = new int[2];
        xy[1] = -1;
        xy[0] = -1;
        if (rect == null) {
            return xy;
        }
        if (this._info == null || this._data == null) {
            return xy;
        }
        if (!rect.contains(pt)) {
            return xy;
        }
        int numrow = this.getAreaHeight();
        --numrow;
        int numcol = this.getAreaWidth();
        double cellsize = this.getGridInfo().getCellSize();
        int icol = (int)((pt.e - rect.w) / cellsize);
        if (icol >= numcol) {
            return xy;
        }
        int irow = numrow - (int)((rect.n - pt.n) / cellsize);
        if (irow < 0) {
            return xy;
        }
        int idx = irow * numcol + icol;
        float[] data = this.getData();
        if (idx < data.length) {
            double x = this._info.getLowerLeftCellX();
            double y = this._info.getLowerLeftCellY();
            xy[0] = irow + (int)x;
            xy[1] = icol + (int)y;
            return xy;
        }
        return xy;
    }

    public GridGlyphDataRecord getDataRecord() {
        if (this._glyphDataRec == null) {
            this._glyphDataRec = new GridGlyphDataRecord();
            String pathName = this.getPathName();
            Vector pathNames = DSSPathname.parseDssPath((String)pathName);
            if (pathNames == null || pathNames.size() < 5) {
                return this._glyphDataRec;
            }
            String cPart = pathNames.elementAt(2).toString().toUpperCase();
            if (cPart.equals("PRECIP") || cPart.equals("PRECIPITATION")) {
                this._glyphDataRec.setColorContour((ColorContour)new PrecipColorContour());
            }
        }
        return this._glyphDataRec;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }
}

