/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.dssgui.SingleGrid;
import hec.heclib.dss.DSSPathname;
import hec.lang.Logger;
import hec.map.ElevationGlyph;
import hec.map.GlyphDataRecord;
import hec.map.GridGlyphDataRecord;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.transform.CoordinateInfo;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import java.util.Date;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SingleGridGlyph
extends MapGlyph
implements ImageObserver,
ElevationGlyph {
    protected BufferedImage _bImg;
    protected BufferedImage _bImage;
    protected int _areaWidth = Integer.MIN_VALUE;
    protected int _areaHeight = Integer.MIN_VALUE;
    protected DSSPathname _path;
    protected Parameter _param;
    SingleGrid _singleGrid;
    WorldRect _bounds = null;
    int _tsPosition = -1;
    CoordinateInfo _wkspCi;
    CoordinateInfo _gridSetCi;
    ParamDouble _paramDouble;
    double[] inxCoor = new double[9];
    double[] inyCoor = new double[9];
    double[] outxCoor = new double[9];
    double[] outyCoor = new double[9];

    public SingleGridGlyph(MapPanel panel, SingleGrid singleGrid) {
        super(panel, (MapObjectInterface)singleGrid);
        this._path = new DSSPathname();
        this._param = new Parameter();
        this._paramDouble = new ParamDouble();
        this._singleGrid = singleGrid;
        this._areaWidth = singleGrid.getAreaWidth();
        this._areaHeight = singleGrid.getAreaHeight();
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void createImage() {
        try {
            if (Logger.canDebug((String)"GridUtil")) {
                System.out.println("SingleGridGlyph createImage");
            }
            t1 = new Date().getTime();
            map = (SingleGrid)this._map;
            data = map.getDataRecord();
            if (data == null) {
                data = new GridGlyphDataRecord();
                this.setDataRecord((GlyphDataRecord)data);
            }
            if (!data.getSet()) {
                data.setGlyph((ElevationGlyph)this);
            }
            if (map.getGridInfo() != null) {
                data.setUnits(map.getGridInfo().getDataUnits());
            }
            areaWidth = map.getAreaWidth();
            areaHeight = map.getAreaHeight();
            if (areaWidth <= 0 && areaHeight <= 0) {
                this._bImg = null;
                return;
            }
            if (this._bImage == null || areaWidth != this._areaWidth || areaHeight != this._areaHeight) {
                this._bImage = new BufferedImage(areaWidth, areaHeight, 2);
            }
            this._areaWidth = areaWidth;
            this._areaHeight = areaHeight;
            buffer = (DataBufferInt)this._bImage.getWritableTile(0, 0).getDataBuffer();
            pix = buffer.getData();
            boundingBox = map.getExtent();
            pixIdx = this._areaHeight * this._areaWidth - this._areaWidth;
            ii = 0;
            aa = data.getAspectAngle();
            theta = -0.017453292519943295 * (aa - 90.0);
            cosTheta = Math.cos(theta);
            sinTheta = Math.sin(theta);
            sinPhi = 0.5;
            aaMag = Math.sqrt(cosTheta * cosTheta + sinTheta * sinTheta + sinPhi * sinPhi);
            cosTheta /= aaMag;
            sinTheta /= aaMag;
            sinPhi /= aaMag;
            vec0 = new double[3];
            vec1 = new double[3];
            cross = new double[3];
            demData = map.getData();
            if (demData == null) {
                if (Logger.canDebug((String)"GridUtil")) {
                    System.out.println("SingleGridGlyph.createImage: no data!");
                }
                return;
            }
            idx = false;
            resolutionX = map.getResolutionX();
            resolutionY = map.getResolutionY();
            for (id = 0; id < demData.length; ++id) {
                block23: {
                    val = demData[id];
                    if (val == -9999.0f || (double)val == -3.4028234663852886E38) {
                        pos = (this._areaHeight - (id / this._areaWidth + 1)) * this._areaWidth + id % this._areaWidth;
                        pix[pos] = 0;
                        continue;
                    }
                    cc = data.getColorContour();
                    lafc = 1.0;
                    if (!data.getAspectEnabled()) break block23;
                    is = id - this._areaWidth;
                    if (is < 0) ** GOTO lbl-1000
                    if (demData[is] == -9999.0f || (double)demData[is] == -3.4028234663852886E38) lbl-1000:
                    // 2 sources

                    {
                        eleS = val;
                    } else {
                        eleS = demData[is];
                    }
                    ie = id + 1;
                    if (ie % this._areaWidth == 0) ** GOTO lbl-1000
                    if (demData[ie] == -9999.0f || (double)demData[ie] == -3.4028234663852886E38) lbl-1000:
                    // 2 sources

                    {
                        eleE = val;
                    } else {
                        eleE = demData[ie];
                    }
                    in = id + this._areaWidth;
                    if (in >= demData.length) ** GOTO lbl-1000
                    if (demData[in] == -9999.0f || (double)demData[in] == -3.4028234663852886E38) lbl-1000:
                    // 2 sources

                    {
                        eleN = val;
                    } else {
                        eleN = demData[in];
                    }
                    iw = id - 1;
                    if (id % this._areaWidth == 0) ** GOTO lbl-1000
                    if (demData[iw] == -9999.0f || (double)demData[iw] == -3.4028234663852886E38) lbl-1000:
                    // 2 sources

                    {
                        eleW = val;
                    } else {
                        eleW = demData[iw];
                    }
                    vec0[0] = 2.0 * resolutionX;
                    vec0[1] = 0.0;
                    vec0[2] = (eleE - eleW) * 10.0f;
                    vec1[0] = 0.0;
                    vec1[1] = 2.0 * resolutionY;
                    vec1[2] = (eleN - eleS) * 10.0f;
                    cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                    cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                    cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                    nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                    dot = 1.0;
                    if (nMag != 0.0) {
                        dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                    }
                    if (cross[2] < 0.0) {
                        dot *= -1.0;
                    }
                    lafc = (dot + 1.25) / 2.25;
                }
                rgb = cc.getRGB((double)val, lafc);
                pos = (this._areaHeight - (id / this._areaWidth + 1)) * this._areaWidth + id % this._areaWidth;
                pix[pos] = rgb;
                if ((pixIdx -= this._areaWidth) >= 0) continue;
                pixIdx = this._areaHeight * this._areaWidth - this._areaWidth + ++ii;
            }
            this._bImg = this._bImage;
            this._bounds = boundingBox;
            if (Logger.canDebug((String)"GridUtil")) {
                t2 = new Date().getTime();
                System.out.println("SingleGridGlyph Image Build took  " + (t2 - t1) + " ms.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }

    public boolean isShown() {
        return true;
    }

    public void fillMap(boolean load) {
        super.fillMap(load);
        if (load) {
            this.createImage();
        }
    }

    public void draw(Graphics g, MapScale scl) {
        SingleGrid map = (SingleGrid)this._map;
        GridGlyphDataRecord data = map.getDataRecord();
        if (data.isModified()) {
            this.createImage();
            data.setModified(false);
        }
        if (data == null) {
            data = new GridGlyphDataRecord();
        }
        if (this._bImg == null) {
            this.createImage();
        }
        if (this._bImg == null && Logger.canDebug((String)"GridUtil")) {
            System.out.println("SingleGridGlyph.draw: no image!");
        }
        WorldRect swr = scl.getWorldRect();
        WorldRect mwr = this.getBounds();
        if (mwr == null) {
            System.out.println("SingleGridGlyph.draw: no Bounds");
            return;
        }
        WorldRect iwr = swr.getIntersection(mwr);
        if (_paintOk && iwr != null) {
            if (this._areaWidth == Integer.MIN_VALUE || this._areaHeight == Integer.MIN_VALUE) {
                if (Logger.canDebug((String)"GridUtil")) {
                    System.out.println("SingleGridGlyph.draw: invalid width(" + this._areaWidth + ") or height(" + this._areaHeight + ")");
                }
                return;
            }
            if (this._bImg == null) {
                if (Logger.canDebug((String)"GridUtil")) {
                    System.out.println("SingleGridGlyph.draw: no Image!");
                }
                return;
            }
            WritableRaster wr = this._bImg.getWritableTile(0, 0);
            if (wr == null) {
                this.createImage();
                return;
            }
            Graphics2D g2 = null;
            Composite oldac = null;
            AlphaComposite ac = null;
            float alpha = data.getAlpha();
            if (alpha == 0.0f) {
                return;
            }
            if (g instanceof Graphics2D && alpha != 1.0f) {
                g2 = (Graphics2D)g;
                oldac = g2.getComposite();
                ac = AlphaComposite.getInstance(3, alpha);
            }
            DataBufferInt buffer = (DataBufferInt)wr.getDataBuffer();
            int[] pix = buffer.getData();
            double xscl = (double)this._bImg.getWidth() / (mwr.e - mwr.w);
            double yscl = (double)this._bImg.getHeight() / (mwr.n - mwr.s);
            LocalRect ilr = scl.wr2lr(iwr);
            double zoom = scl.getZoom();
            int dx1 = ilr.l;
            int dy1 = ilr.t;
            int dx2 = ilr.r;
            int dy2 = ilr.b;
            int sx1 = (int)((iwr.w - mwr.w) * xscl);
            int sy1 = (int)((mwr.n - iwr.n) * yscl);
            int sx2 = (int)((iwr.e - mwr.w) * xscl);
            int sy2 = (int)((mwr.n - iwr.s) * yscl);
            if (ac != null) {
                g2.setComposite(ac);
            }
            g.drawImage(this._bImg, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
            if (oldac != null) {
                g2.setComposite(oldac);
            }
        } else if (iwr == null && Logger.canDebug((String)"GridUtil")) {
            System.out.println("SingleGridGlyph.draw:no intersection between mappanel " + swr + " and gridset " + mwr);
        }
    }

    public void drawElevationStats(Graphics g, LocalRegion region) {
    }

    public float getElevationAt(int ix, int iy) {
        WorldPt wpt = new WorldPt(this._mapPanel.scale().x2e(ix), this._mapPanel.scale().y2n(iy));
        return (float)this.getElevation(wpt);
    }

    public double getNoDataValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getElevation(WorldPt pt) {
        SingleGrid map = (SingleGrid)this._map;
        return map.getElevation(pt);
    }

    public double getMaximumElevation() {
        return this._singleGrid.getMaximumElevation();
    }

    public double getMinimumElevation() {
        return this._singleGrid.getMinimumElevation();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    public String getToolTipText(WorldPt wpt, MouseEvent e) {
        SingleGrid map = (SingleGrid)this._map;
        if (e != null && e.isControlDown()) {
            int[] xy = map.getRowColAtPt(wpt);
            if (xy[0] == -1 || xy[0] == -1) {
                return "Unknown";
            }
            String s = xy[0] + ", " + xy[1];
            return s;
        }
        double d = this.getElevation(wpt);
        if (RMAConst.isUndefinedValue((double)d)) {
            return "No Data";
        }
        return RMAIO.setPrecision((double)d, (int)2);
    }
}

