/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.MathFrame2;
import hec.dssgui.MathPanel;
import hec.dssgui.MathTab;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJIntegerField;
import rma.swing.list.RmaListModel;
import rma.swing.text.RmaIntegerVerifier;

public class SmoothingTab
extends MathPanel
implements MathTab {
    public static final String CENTERED_MOVING_AVERAGE = "Centered Moving Average";
    public static final String OLYMPIC_SMOOTHING_AVERAGE = "Olympic Smoothing Average";
    public static final String FORWARD_MOVING_AVERAGE = "Forward Moving Average";
    private static String[] _operators = new String[]{"Centered Moving Average", "Olympic Smoothing Average", "Forward Moving Average"};
    private CenteredMovingAveragePanel _centerMovingAvePanel;
    private CenteredMovingAveragePanel _olympicSmoothingPanel;
    private ForwardMovingAveragePanel _forwardMovingAvePanel;

    public SmoothingTab(MathFrame2 parent) {
        super(parent);
    }

    @Override
    protected void buildPanel() {
        super.buildPanel();
        this._opCombo.setModel(new RmaListModel(false, (Object[])_operators));
        this._opCombo.setMaximumRowCount(_operators.length);
        final CardLayout cl = (CardLayout)this._cardPanel.getLayout();
        this._centerMovingAvePanel = new CenteredMovingAveragePanel();
        this._forwardMovingAvePanel = new ForwardMovingAveragePanel();
        this._olympicSmoothingPanel = new CenteredMovingAveragePanel();
        this._cardPanel.add(OLYMPIC_SMOOTHING_AVERAGE, this._olympicSmoothingPanel);
        this._cardPanel.add(FORWARD_MOVING_AVERAGE, this._forwardMovingAvePanel);
        this._cardPanel.add(CENTERED_MOVING_AVERAGE, this._centerMovingAvePanel);
        this._opCombo.setSelectedIndex(-1);
        this._opCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cl.show(SmoothingTab.this._cardPanel, (String)SmoothingTab.this._opCombo.getSelectedItem());
                SmoothingTab.this.setComputeButtonEnabled(SmoothingTab.this.isComputable());
            }
        });
        this._opCombo.setSelectedIndex(0);
    }

    @Override
    public boolean compute() {
        TimeSeriesContainer outputDc = null;
        TimeSeriesMath mathGuy = null;
        HecMath outputMath = null;
        String op = (String)this._opCombo.getSelectedItem();
        int[] selection = this.getSelectedIndices();
        DataContainer[] containers = this._parent.getDataSets(selection);
        for (int j = 0; j < selection.length; ++j) {
            DataContainer dc = containers[j];
            if (dc instanceof TimeSeriesContainer) {
                mathGuy = this._tsmath;
                outputDc = new TimeSeriesContainer();
            } else if (dc instanceof PairedDataContainer) {
                mathGuy = this._pdmath;
                outputDc = new PairedDataContainer();
            }
            if (mathGuy == null) {
                return false;
            }
            try {
                mathGuy.setData(dc);
            }
            catch (HecMathException e) {
                System.out.println("compute: Exception : " + e);
                return false;
            }
            try {
                if (CENTERED_MOVING_AVERAGE.equals(op)) {
                    outputMath = this._tsmath.centeredMovingAverage(this._centerMovingAvePanel.getNumberToAverageOver(), this._centerMovingAvePanel.useOnlyValidValues(), this._centerMovingAvePanel.useReducedValues());
                } else if (OLYMPIC_SMOOTHING_AVERAGE.equals(op)) {
                    outputMath = this._tsmath.olympicSmoothing(this._olympicSmoothingPanel.getNumberToAverageOver(), this._olympicSmoothingPanel.useOnlyValidValues(), this._olympicSmoothingPanel.useReducedValues());
                } else if (FORWARD_MOVING_AVERAGE.equals(op)) {
                    outputMath = this._tsmath.forwardMovingAverage(this._forwardMovingAvePanel.getNumberToAverageOver());
                }
                if (outputMath == null) continue;
                outputMath.getData((DataContainer)outputDc);
                this._parent.setSelectedIndex(selection[j]);
                this._parent.updateSelectedDataSet((DataContainer)outputDc);
                continue;
            }
            catch (Exception e) {
                System.out.println("compute: Exception " + e);
                JOptionPane.showMessageDialog(this, e.toString(), "Compute Error", 0);
                return false;
            }
        }
        return outputMath != null;
    }

    @Override
    public Vector getSelectedDataSets() {
        String op = (String)this._opCombo.getSelectedItem();
        if (op.equals(CENTERED_MOVING_AVERAGE)) {
            return this._centerMovingAvePanel.getSelectedDataSets();
        }
        if (op.equals(OLYMPIC_SMOOTHING_AVERAGE)) {
            return this._olympicSmoothingPanel.getSelectedDataSets();
        }
        if (op.equals(FORWARD_MOVING_AVERAGE)) {
            return this._forwardMovingAvePanel.getSelectedDataSets();
        }
        return super.getSelectedDataSets();
    }

    @Override
    public int[] getSelectedIndices() {
        String op = (String)this._opCombo.getSelectedItem();
        if (op.equals(CENTERED_MOVING_AVERAGE)) {
            return this._centerMovingAvePanel.getSelectedIndices();
        }
        if (op.equals(OLYMPIC_SMOOTHING_AVERAGE)) {
            return this._olympicSmoothingPanel.getSelectedIndices();
        }
        if (op.equals(FORWARD_MOVING_AVERAGE)) {
            return this._forwardMovingAvePanel.getSelectedIndices();
        }
        return super.getSelectedIndices();
    }

    public void clearSelection() {
        String op = (String)this._opCombo.getSelectedItem();
        if (op.equals(CENTERED_MOVING_AVERAGE)) {
            this._centerMovingAvePanel.getDataSetList().clearSelection();
        } else if (op.equals(OLYMPIC_SMOOTHING_AVERAGE)) {
            this._olympicSmoothingPanel.getDataSetList().clearSelection();
        } else if (op.equals(FORWARD_MOVING_AVERAGE)) {
            this._forwardMovingAvePanel.getDataSetList().clearSelection();
        }
    }

    @Override
    public String getTabName() {
        return "Smoothing";
    }

    class CenteredMovingAveragePanel
    extends ForwardMovingAveragePanel {
        private RmaJCheckBox _onlyValidValuesCB;
        private RmaJCheckBox _useReducedCB;

        CenteredMovingAveragePanel() {
        }

        @Override
        protected int addOptions(int lastY) {
            GridBagConstraints gbc = ((GridBagLayout)this.getLayout()).getConstraints((Component)this._numberToAveTxt);
            gbc.weighty = 0.0;
            ((GridBagLayout)this.getLayout()).setConstraints((Component)this._numberToAveTxt, gbc);
            this._onlyValidValuesCB = new RmaJCheckBox("Only Valid Values");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            ++lastY;
            gbc.gridy = lastY++;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
            this.add((Component)this._onlyValidValuesCB, gbc);
            this._useReducedCB = new RmaJCheckBox("Use Reduced Number of Values");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = lastY;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
            this.add((Component)this._useReducedCB, gbc);
            return lastY + 1;
        }

        public boolean useReducedValues() {
            return this._useReducedCB.isSelected();
        }

        public boolean useOnlyValidValues() {
            return this._onlyValidValuesCB.isSelected();
        }
    }

    class ForwardMovingAveragePanel
    extends MathPanel.MathCardListPanel {
        protected RmaJIntegerField _numberToAveTxt;
        protected JLabel _numberToAveLabel;

        ForwardMovingAveragePanel() {
            this.buildPanel(false);
        }

        @Override
        protected void buildPanel() {
            this.buildPanel(false);
        }

        protected void buildPanel(boolean setInputVerifier) {
            this._numberToAveLabel = new JLabel("Number to Average Over:");
            this._numberToAveLabel.setDisplayedMnemonic('N');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._numberToAveLabel, gbc);
            this._numberToAveTxt = new RmaJIntegerField();
            this._numberToAveTxt.setMinValue(3);
            this._numberToAveTxt.setColumns(5);
            if (setInputVerifier) {
                this._numberToAveTxt.setInputVerifier((InputVerifier)new NumToAveVerifier());
            }
            this._numberToAveLabel.setLabelFor((Component)this._numberToAveTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.ipadx = 25;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._numberToAveTxt, gbc);
            int nextY = this.addOptions(gbc.gridy);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = nextY;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = nextY + 1;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            this._numberToAveTxt.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SmoothingTab.this.setComputeButtonEnabled(ForwardMovingAveragePanel.this.isComputable());
                }
            });
        }

        protected int addOptions(int lastY) {
            return lastY + 1;
        }

        @Override
        public boolean isComputable() {
            if (this._numberToAveTxt.getText().length() == 0) {
                this.setStatusLineText("No ", this._numberToAveLabel, " entered.");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        public int getNumberToAverageOver() {
            return this._numberToAveTxt.getValue();
        }
    }

    class NumToAveVerifier
    extends InputVerifier {
        NumToAveVerifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verify(JComponent input) {
            RmaJIntegerField txtFld = (RmaJIntegerField)input;
            try {
                txtFld.setInputVerifier(null);
                if (!RmaIntegerVerifier.getVerifier().verify(input)) {
                    boolean bl = false;
                    return bl;
                }
                if (txtFld.getText().length() == 0) {
                    boolean bl = true;
                    return bl;
                }
                int num = txtFld.getValue();
                if (num % 2 == 1) {
                    boolean bl = true;
                    return bl;
                }
                JOptionPane.showMessageDialog((Component)txtFld, "Number to Average Over must be odd and greater than 2", "Warning", 2);
                boolean bl = false;
                return bl;
            }
            finally {
                txtFld.setInputVerifier((InputVerifier)this);
            }
        }
    }
}

