/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.list.RmaListModel;

public class SortDialog<E>
extends RmaJDialog {
    private List<E> _items;
    private RmaJList _itemList;
    private JButton _moveToTopBtn;
    private JButton _moveUpBtn;
    private JButton _moveDownBtn;
    private JButton _moveToBottomBtn;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private RmaListModel<E> _model;

    public SortDialog(JFrame parent, String title, List<E> items) {
        super((Frame)parent, true);
        this._items = items;
        this.buildControls(title);
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected void buildControls(String title) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(title);
        this._itemList = new RmaJList();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)new JScrollPane((Component)this._itemList), gbc);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)rightPanel, gbc);
        this._moveToTopBtn = new JButton(RmaImage.getImageIcon((String)"Images/spinTop.gif"));
        this._moveToTopBtn.setToolTipText("Move to Top");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        rightPanel.add((Component)this._moveToTopBtn, gbc);
        this._moveUpBtn = new JButton(RmaImage.getImageIcon((String)"Images/spinUp.gif"));
        this._moveUpBtn.setToolTipText("Move Up");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        rightPanel.add((Component)this._moveUpBtn, gbc);
        this._moveDownBtn = new JButton(RmaImage.getImageIcon((String)"Images/spinDown.gif"));
        this._moveDownBtn.setToolTipText("Move Down");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        rightPanel.add((Component)this._moveDownBtn, gbc);
        this._moveToBottomBtn = new JButton(RmaImage.getImageIcon((String)"Images/spinBottom.gif"));
        this._moveDownBtn.setToolTipText("Move to Bottom");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0E-4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        rightPanel.add((Component)this._moveToBottomBtn, gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this.listSelectionChanged();
    }

    private void addListeners() {
        this._moveToTopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDialog.this.moveToTopAction();
            }
        });
        this._moveToBottomBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDialog.this.moveToBottomAction();
            }
        });
        this._moveUpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDialog.this.moveAction(-1);
            }
        });
        this._moveDownBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDialog.this.moveAction(1);
            }
        });
        this._itemList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SortDialog.this.listSelectionChanged();
            }
        });
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        SortDialog.this._canceled = false;
                        SortDialog.this.saveForm();
                        SortDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        SortDialog.this._canceled = true;
                        SortDialog.this.setVisible(false);
                    }
                }
            }
        });
    }

    protected void listSelectionChanged() {
        int idx = this._itemList.getSelectedIndex();
        if (idx == -1) {
            this._moveToTopBtn.setEnabled(false);
            this._moveUpBtn.setEnabled(false);
            this._moveToBottomBtn.setEnabled(false);
            this._moveDownBtn.setEnabled(false);
            return;
        }
        if (idx == 0) {
            this._moveToTopBtn.setEnabled(false);
            this._moveUpBtn.setEnabled(false);
            this._moveToBottomBtn.setEnabled(true);
            this._moveDownBtn.setEnabled(true);
        } else if (idx == this._itemList.getItemCount() - 1) {
            this._moveToTopBtn.setEnabled(true);
            this._moveUpBtn.setEnabled(true);
            this._moveToBottomBtn.setEnabled(false);
            this._moveDownBtn.setEnabled(false);
        } else {
            this._moveToTopBtn.setEnabled(true);
            this._moveUpBtn.setEnabled(true);
            this._moveToBottomBtn.setEnabled(true);
            this._moveDownBtn.setEnabled(true);
        }
    }

    protected void saveForm() {
        if (this.isModified()) {
            // empty if block
        }
        this.setModified(false);
    }

    public List<E> getItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (int i = 0; i < this._model.size(); ++i) {
            items.add(this._model.getElementAt(i));
        }
        return items;
    }

    private void fillForm() {
        this._model = new RmaListModel(false, this._items);
        this._itemList.setModel(this._model);
        this.setModified(false);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    protected void moveToTopAction() {
        int idx = this._itemList.getSelectedIndex();
        Object item = this._model.getElementAt(idx);
        this._model.removeElement(item);
        this._model.insertElementAt(item, 0);
        this._model.fireContentsChanged(0, this._model.size() - 1);
        this._itemList.setSelectedIndex(0);
        this.setModified(true);
    }

    protected void moveToBottomAction() {
        int idx = this._itemList.getSelectedIndex();
        Object item = this._model.getElementAt(idx);
        this._model.removeElement(item);
        this._model.insertElementAt(item, this._model.size());
        this._model.fireContentsChanged(0, this._model.size());
        this._itemList.setSelectedIndex(this._model.size() - 1);
        this.setModified(true);
    }

    protected void moveAction(int direction) {
        int idx = this._itemList.getSelectedIndex();
        Object item = this._model.getElementAt(idx);
        this._model.removeElement(item);
        this._model.insertElementAt(item, idx += direction);
        this._model.fireContentsChanged(0, this._model.size() - 1);
        this._itemList.setSelectedIndex(idx);
        this.setModified(true);
    }
}

