/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.MathFrame2;
import hec.dssgui.MathPanel;
import hec.dssgui.MathTab;
import hec.dssgui.SaveAs;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.hecmath.DurationAnalysis;
import hec.hecmath.DurationPeriod;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.LinearRegressionStatistics;
import hec.hecmath.PairedDataMath;
import hec.hecmath.SimpleFrequencyAnalysis;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.util.GeneralTableEditor;
import hec.util.GeneralTableModel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import rma.swing.FlatPanelButton;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJList;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaTableModel;

public class StatisticMathTab
extends MathPanel
implements MathTab {
    public static final String BASIC = "Basic";
    public static final String LINEAR_REGRESSION = "Linear Regression";
    public static final String CYCLIC_ANALYSIS = "Cyclic Analysis";
    public static final String DURATION_ANAYLSIS = "Duration Analysis";
    public static final String FREQUENCY_PLOT = "Frequency Plot";
    private static String[] _operators = new String[]{"Basic", "Linear Regression", "Cyclic Analysis", "Duration Analysis", "Frequency Plot"};
    protected static final Color _backgroundColor = (Color)UIManager.get("TextField.disabledBackground");
    protected LinearRegressionPanel _linearRegressionPanel;
    protected BasicStatisticsPanel _basicPanel;
    protected CyclicAnalysisPanel _cyclicAnalysisPanel;
    protected DurationAnalysisPanel _durationAnalysisPanel;
    protected FrequencyPlotPanel _frequencyPlotPanel;
    private FocusListener _fl = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            Object obj = e.getSource();
            if (obj instanceof JTextField) {
                ((JTextField)obj).selectAll();
            }
        }
    };

    public StatisticMathTab(MathFrame2 parent) {
        super(parent);
    }

    @Override
    protected void buildPanel() {
        super.buildPanel();
        this.setOpLabelText("Type:", 'T');
        this._opCombo.setModel(new RmaListModel(false, (Object[])_operators));
        this._opCombo.setMaximumRowCount(_operators.length);
        final CardLayout cl = (CardLayout)this._cardPanel.getLayout();
        this._basicPanel = new BasicStatisticsPanel();
        this._cardPanel.add(BASIC, this._basicPanel);
        this._linearRegressionPanel = new LinearRegressionPanel();
        this._cardPanel.add(LINEAR_REGRESSION, this._linearRegressionPanel);
        this._cyclicAnalysisPanel = new CyclicAnalysisPanel();
        this._cardPanel.add(CYCLIC_ANALYSIS, this._cyclicAnalysisPanel);
        Preferences preferences = this._parent.getListSelection().getPreferences();
        this._durationAnalysisPanel = new DurationAnalysisPanel(preferences);
        this._cardPanel.add(DURATION_ANAYLSIS, this._durationAnalysisPanel);
        this._frequencyPlotPanel = new FrequencyPlotPanel();
        this._cardPanel.add(FREQUENCY_PLOT, this._frequencyPlotPanel);
        this._opCombo.setSelectedIndex(-1);
        this._opCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = StatisticMathTab.this._opCombo.getSelectedIndex();
                cl.show(StatisticMathTab.this._cardPanel, (String)StatisticMathTab.this._opCombo.getSelectedItem());
                StatisticMathTab.this.setComputeButtonEnabled(StatisticMathTab.this.isComputable());
            }
        });
        this._opCombo.setSelectedIndex(0);
    }

    @Override
    public boolean compute() {
        TimeSeriesMath mathGuy = null;
        String op = (String)this._opCombo.getSelectedItem();
        DataContainer dc = this._parent.getSelectedDataSet();
        if (dc instanceof TimeSeriesContainer) {
            mathGuy = this._tsmath;
        } else if (dc instanceof PairedDataContainer) {
            mathGuy = this._pdmath;
        }
        if (mathGuy == null) {
            return false;
        }
        try {
            mathGuy.setData(dc);
        }
        catch (HecMathException e) {
            System.out.println("compute: Exception : " + e);
            return false;
        }
        try {
            if (BASIC.equals(op)) {
                return this._basicPanel.compute();
            }
            if (LINEAR_REGRESSION.equals(op)) {
                HecMath tmpMath = HecMath.createInstance((DataContainer)this._linearRegressionPanel.getSelectedDataContainer());
                LinearRegressionStatistics lrs = this._tsmath.correlationCoefficients(tmpMath);
                this._linearRegressionPanel.setLinearRegressionStatistics(lrs);
            } else {
                if (CYCLIC_ANALYSIS.equals(op)) {
                    HecMath[] results = this._tsmath.cyclicAnalysis();
                    this._cyclicAnalysisPanel.setResults(results);
                    return true;
                }
                if (DURATION_ANAYLSIS.equals(op)) {
                    return this._durationAnalysisPanel.compute();
                }
                if (FREQUENCY_PLOT.equals(op)) {
                    return this._frequencyPlotPanel.compute();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString(), "Compute Error", 0);
            System.out.println("compute: Exception " + e);
            return false;
        }
        return true;
    }

    @Override
    public boolean canRestore() {
        String op = (String)this._opCombo.getSelectedItem();
        return DURATION_ANAYLSIS.equals(op);
    }

    @Override
    public Vector getSelectedDataSets() {
        String op = (String)this._opCombo.getSelectedItem();
        if (DURATION_ANAYLSIS.equals(op)) {
            return this._parent.getModifiedDataSets();
        }
        return super.getSelectedDataSets();
    }

    private HecMath getHecMath(DataContainer dc) {
        TimeSeriesMath mathGuy = null;
        try {
            if (dc instanceof TimeSeriesContainer) {
                this._tsmath.setData(dc);
                mathGuy = this._tsmath;
            } else if (dc instanceof PairedDataContainer) {
                this._pdmath.setData(dc);
                mathGuy = this._pdmath;
            }
        }
        catch (HecMathException e) {
            System.out.println("getHecMath: error on setData()" + e);
        }
        return mathGuy;
    }

    @Override
    public String getTabName() {
        return "Statistics";
    }

    @Override
    public void tabChangedTo() {
        String op = (String)this._opCombo.getSelectedItem();
        if (BASIC.equals(op) || LINEAR_REGRESSION.equals(op)) {
            this._basicPanel.compute();
        }
    }

    class BasicStatisticsPanel
    extends MathPanel.MathCardPanel {
        private JTextField _validCntTxt;
        private JTextField _missingCntTxt;
        private JTextField _lastValidTxt;
        private JTextField _lastValidDateTxt;
        private JTextField _maxTxt;
        private JTextField _maxDateTxt;
        private JTextField _minTxt;
        private JTextField _minDateTxt;
        private JTextField _meanTxt;
        private JTextField _standardDeviationTxt;
        private JTextField _skewCoefficentTxt;
        private JTextField _accumulatedAmtTxt;
        private JTextField _typeTxt;
        private JLabel _unitsLabel1;
        private JTextField _unitsTxt;
        private JLabel _unitsLabel2;
        private JTextField _yunitsTxt;

        public BasicStatisticsPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            Insets insets5505 = new Insets(5, 5, 0, 5);
            JLabel label = new JLabel("Number of Valid Values:");
            label.setDisplayedMnemonic('N');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._validCntTxt = new StatTextField(10);
            this._validCntTxt.addFocusListener(StatisticMathTab.this._fl);
            this._validCntTxt.setBackground(_backgroundColor);
            this._validCntTxt.setHorizontalAlignment(4);
            this._validCntTxt.setEditable(false);
            label.setLabelFor(this._validCntTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._validCntTxt, gbc);
            label = new JLabel("Number of Missing Values:");
            label.setDisplayedMnemonic('u');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._missingCntTxt = new StatTextField(10);
            this._missingCntTxt.addFocusListener(StatisticMathTab.this._fl);
            this._missingCntTxt.setEditable(false);
            this._missingCntTxt.setBackground(_backgroundColor);
            this._missingCntTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._missingCntTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._missingCntTxt, gbc);
            label = new JLabel("Last Valid Value:");
            label.setDisplayedMnemonic('L');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._lastValidTxt = new StatTextField(10);
            this._lastValidTxt.addFocusListener(StatisticMathTab.this._fl);
            this._lastValidTxt.setEditable(false);
            this._lastValidTxt.setBackground(_backgroundColor);
            this._lastValidTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._lastValidTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._lastValidTxt, gbc);
            label = new JLabel("at");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._lastValidDateTxt = new StatTextField(15);
            this._lastValidDateTxt.addFocusListener(StatisticMathTab.this._fl);
            this._lastValidDateTxt.setEditable(false);
            this._lastValidDateTxt.setBackground(_backgroundColor);
            this._lastValidDateTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._lastValidDateTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._lastValidDateTxt, gbc);
            label = new JLabel("Minimum Value:");
            label.setDisplayedMnemonic('V');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._minTxt = new StatTextField(10);
            this._minTxt.addFocusListener(StatisticMathTab.this._fl);
            this._minTxt.setEditable(false);
            this._minTxt.setBackground(_backgroundColor);
            this._minTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._minTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._minTxt, gbc);
            label = new JLabel("at");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._minDateTxt = new StatTextField(15);
            this._minDateTxt.addFocusListener(StatisticMathTab.this._fl);
            this._minDateTxt.setEditable(false);
            this._minDateTxt.setBackground(_backgroundColor);
            this._minDateTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._minDateTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._minDateTxt, gbc);
            label = new JLabel("Mean Value:");
            label.setDisplayedMnemonic('e');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._meanTxt = new StatTextField(10);
            this._meanTxt.addFocusListener(StatisticMathTab.this._fl);
            this._meanTxt.setEditable(false);
            this._meanTxt.setBackground(_backgroundColor);
            this._meanTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._meanTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._meanTxt, gbc);
            label = new JLabel("Maximum Value:");
            label.setDisplayedMnemonic('a');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._maxTxt = new StatTextField(10);
            this._maxTxt.addFocusListener(StatisticMathTab.this._fl);
            this._maxTxt.setEditable(false);
            this._maxTxt.setBackground(_backgroundColor);
            this._maxTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._maxTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._maxTxt, gbc);
            label = new JLabel("at");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._maxDateTxt = new StatTextField(15);
            this._maxDateTxt.addFocusListener(StatisticMathTab.this._fl);
            this._maxDateTxt.setEditable(false);
            this._maxDateTxt.setBackground(_backgroundColor);
            this._maxDateTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._maxDateTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._maxDateTxt, gbc);
            label = new JLabel("Accumulated Amount:");
            label.setDisplayedMnemonic('A');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._accumulatedAmtTxt = new StatTextField(10);
            this._accumulatedAmtTxt.addFocusListener(StatisticMathTab.this._fl);
            this._accumulatedAmtTxt.setEditable(false);
            this._accumulatedAmtTxt.setBackground(_backgroundColor);
            this._accumulatedAmtTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._accumulatedAmtTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._accumulatedAmtTxt, gbc);
            label = new JLabel("Standard Deviation:");
            label.setDisplayedMnemonic('d');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 7;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._standardDeviationTxt = new StatTextField(10);
            this._standardDeviationTxt.addFocusListener(StatisticMathTab.this._fl);
            this._standardDeviationTxt.setEditable(false);
            this._standardDeviationTxt.setBackground(_backgroundColor);
            this._standardDeviationTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._standardDeviationTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 7;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._standardDeviationTxt, gbc);
            label = new JLabel("Skew Coefficent:");
            label.setDisplayedMnemonic('w');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 8;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._skewCoefficentTxt = new StatTextField(10);
            this._skewCoefficentTxt.addFocusListener(StatisticMathTab.this._fl);
            this._skewCoefficentTxt.setEditable(false);
            this._skewCoefficentTxt.setBackground(_backgroundColor);
            this._skewCoefficentTxt.setHorizontalAlignment(4);
            label.setLabelFor(this._skewCoefficentTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 8;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._skewCoefficentTxt, gbc);
            label = new JLabel("Data Type:");
            label.setDisplayedMnemonic('y');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 9;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)label, gbc);
            this._typeTxt = new StatTextField(10);
            this._typeTxt.setHorizontalAlignment(4);
            this._typeTxt.addFocusListener(StatisticMathTab.this._fl);
            this._typeTxt.setEditable(false);
            this._typeTxt.setBackground(_backgroundColor);
            label.setLabelFor(this._typeTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 9;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._typeTxt, gbc);
            this._unitsLabel1 = new JLabel("Units:");
            this._unitsLabel1.setDisplayedMnemonic('n');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 10;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)this._unitsLabel1, gbc);
            this._unitsTxt = new StatTextField(10);
            this._unitsTxt.setHorizontalAlignment(4);
            this._unitsTxt.addFocusListener(StatisticMathTab.this._fl);
            this._unitsTxt.setEditable(false);
            this._unitsTxt.setBackground(_backgroundColor);
            this._unitsLabel1.setLabelFor(this._unitsTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 10;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._unitsTxt, gbc);
            this._unitsLabel2 = new JLabel("Y Units:");
            this._unitsLabel2.setDisplayedMnemonic('Y');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 11;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.add((Component)this._unitsLabel2, gbc);
            this._yunitsTxt = new StatTextField(10);
            this._yunitsTxt.setHorizontalAlignment(4);
            this._yunitsTxt.addFocusListener(StatisticMathTab.this._fl);
            this._yunitsTxt.setEditable(false);
            this._yunitsTxt.setBackground(_backgroundColor);
            this._unitsLabel2.setLabelFor(this._yunitsTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 11;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets5505;
            this.add((Component)this._yunitsTxt, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 12;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = insets5505;
            this.add((Component)new JLabel("  "), gbc);
        }

        public boolean compute() {
            DataContainer dc = StatisticMathTab.this._parent.getSelectedDataSet();
            HecMath mathGuy = StatisticMathTab.this.getHecMath(dc);
            String units = "";
            String type = "";
            this.clearPanel();
            if (dc instanceof TimeSeriesContainer) {
                units = ((TimeSeriesContainer)dc).units;
                type = ((TimeSeriesContainer)dc).type;
                this._unitsTxt.setText(units);
                this._yunitsTxt.setVisible(false);
                this._unitsLabel2.setVisible(false);
                this._unitsLabel1.setText("Units:");
            } else if (dc instanceof PairedDataContainer) {
                this._yunitsTxt.setVisible(true);
                this._unitsLabel2.setVisible(true);
                this._unitsTxt.setText(((PairedDataContainer)dc).xunits);
                this._yunitsTxt.setText(((PairedDataContainer)dc).yunits);
                this._unitsLabel1.setText("X Units:");
            } else {
                this.setStatusLineText("Invalid DataSet Type");
                return false;
            }
            this._typeTxt.setText(type);
            try {
                HecTime hectime = new HecTime();
                this._validCntTxt.setText(String.valueOf(StatisticMathTab.this._tsmath.numberValidValues()));
                this._missingCntTxt.setText(String.valueOf(StatisticMathTab.this._tsmath.numberMissingValues()));
                this._lastValidTxt.setText(String.valueOf((float)StatisticMathTab.this._tsmath.lastValidValue()));
                this._accumulatedAmtTxt.setText(String.valueOf((float)StatisticMathTab.this._tsmath.sum()));
                this._minTxt.setText(String.valueOf((float)StatisticMathTab.this._tsmath.min()));
                this._maxTxt.setText(String.valueOf((float)StatisticMathTab.this._tsmath.max()));
                this._meanTxt.setText(String.valueOf((float)StatisticMathTab.this._tsmath.mean()));
                int time = StatisticMathTab.this._tsmath.minDate();
                if (time != Integer.MIN_VALUE) {
                    hectime.set(time);
                    this._minDateTxt.setText(hectime.dateAndTime(104));
                } else {
                    this._minDateTxt.setText("");
                }
                time = StatisticMathTab.this._tsmath.maxDate();
                if (time != Integer.MIN_VALUE) {
                    hectime.set(time);
                    this._maxDateTxt.setText(hectime.dateAndTime(104));
                } else {
                    this._maxDateTxt.setText("");
                }
                time = StatisticMathTab.this._tsmath.lastValidDate();
                if (time != Integer.MIN_VALUE) {
                    hectime.set(time);
                    this._lastValidDateTxt.setText(hectime.dateAndTime(104));
                } else {
                    this._lastValidDateTxt.setText("");
                }
            }
            catch (Exception e) {
                System.out.println("compute: Error on getting statistics " + e);
                JOptionPane.showMessageDialog(this, e.toString(), "Compute Error", 2);
            }
            try {
                this._standardDeviationTxt.setText(String.valueOf((float)StatisticMathTab.this._tsmath.standardDeviation()));
            }
            catch (Exception e) {
                System.out.println("compute: Error on getting standardDeviation " + e);
                JOptionPane.showMessageDialog(this, e.toString(), "Compute Error", 2);
            }
            try {
                this._skewCoefficentTxt.setText(String.valueOf((float)StatisticMathTab.this._tsmath.skewCoefficient()));
            }
            catch (Exception e) {
                System.out.println("compute: Error on getting skewCoefficient " + e);
                JOptionPane.showMessageDialog(this, e.toString(), "Compute Error", 2);
            }
            return true;
        }

        public void clearPanel() {
            this._minTxt.setText("");
            this._maxTxt.setText("");
            this._meanTxt.setText("");
            this._validCntTxt.setText("");
            this._missingCntTxt.setText("");
            this._lastValidTxt.setText("");
            this._standardDeviationTxt.setText("");
            this._skewCoefficentTxt.setText("");
            this._unitsTxt.setText("");
            this._yunitsTxt.setText("");
            this._yunitsTxt.setVisible(false);
            this._typeTxt.setText("");
            this._unitsLabel2.setVisible(false);
            this._unitsLabel1.setText("Units:");
        }

        @Override
        public void show() {
            super.show();
            StatisticMathTab.this._basicPanel.compute();
        }

        @Override
        public boolean isComputable() {
            DataContainer obj = StatisticMathTab.this._parent.getSelectedDataSet();
            if (obj != null) {
                this.setStatusLineText("");
            } else {
                this.setStatusLineText("No Data Set Selected");
            }
            return obj instanceof TimeSeriesContainer;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            super.setSelectedDataContainer(dc);
            if (StatisticMathTab.this._parent.getSelectedTab() == StatisticMathTab.this && this.isComputable()) {
                StatisticMathTab.this._basicPanel.compute();
            }
        }
    }

    class LinearRegressionPanel
    extends MathPanel.MathCardPanel {
        private RmaJList _dataSetList;
        private RmaJIntegerField _numberValidValuesTxt;
        private RmaJDecimalField _regressionConstantTxt;
        private RmaJDecimalField _regressionCoefficientTxt;
        private RmaJDecimalField _determinationCoefficientTxt;
        private RmaJDecimalField _standardErrorOfRegressionTxt;
        private RmaJDecimalField _adjustedDeterminationCoefficientTxt;
        private RmaJDecimalField _adjustedStandardErrorOfRegressionTxt;

        LinearRegressionPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            JLabel label = new JLabel("Dependent Data Set");
            label.setDisplayedMnemonic('I');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._dataSetList = new RmaJList(){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    return d;
                }
            };
            label.setLabelFor((Component)this._dataSetList);
            this._dataSetList.setSelectionMode(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.weightx = 1.0;
            gbc.weighty = 1.5;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add((Component)new JScrollPane((Component)this._dataSetList), gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 3;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)sep, gbc);
            label = new JLabel("Number of Valid Values:");
            label.setDisplayedMnemonic('N');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._numberValidValuesTxt = new RmaJIntegerField();
            this._numberValidValuesTxt.setColumns(10);
            this._numberValidValuesTxt.addFocusListener(StatisticMathTab.this._fl);
            this._numberValidValuesTxt.setEditable(false);
            this._numberValidValuesTxt.setBackground(_backgroundColor);
            label.setLabelFor((Component)this._numberValidValuesTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._numberValidValuesTxt, gbc);
            label = new JLabel("                ");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            label = new JLabel("Regression Constant:");
            label.setDisplayedMnemonic('R');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._regressionConstantTxt = new RmaJDecimalField();
            this._regressionConstantTxt.setColumns(10);
            this._regressionConstantTxt.addFocusListener(StatisticMathTab.this._fl);
            this._regressionConstantTxt.setEditable(false);
            this._regressionConstantTxt.setBackground(_backgroundColor);
            label.setLabelFor((Component)this._regressionConstantTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._regressionConstantTxt, gbc);
            label = new JLabel("Regression Coefficient:");
            label.setDisplayedMnemonic('e');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._regressionCoefficientTxt = new RmaJDecimalField();
            this._regressionCoefficientTxt.setColumns(10);
            this._regressionCoefficientTxt.addFocusListener(StatisticMathTab.this._fl);
            this._regressionCoefficientTxt.setEditable(false);
            this._regressionCoefficientTxt.setBackground(_backgroundColor);
            label.setLabelFor((Component)this._regressionCoefficientTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._regressionCoefficientTxt, gbc);
            label = new JLabel("Determination Coefficient:");
            label.setDisplayedMnemonic('D');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._determinationCoefficientTxt = new RmaJDecimalField();
            this._determinationCoefficientTxt.setColumns(10);
            this._determinationCoefficientTxt.addFocusListener(StatisticMathTab.this._fl);
            this._determinationCoefficientTxt.setEditable(false);
            this._determinationCoefficientTxt.setBackground(_backgroundColor);
            label.setLabelFor((Component)this._determinationCoefficientTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._determinationCoefficientTxt, gbc);
            label = new JLabel("Standard Error of Regression:");
            label.setDisplayedMnemonic('S');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 7;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._standardErrorOfRegressionTxt = new RmaJDecimalField();
            this._standardErrorOfRegressionTxt.setColumns(10);
            this._standardErrorOfRegressionTxt.addFocusListener(StatisticMathTab.this._fl);
            this._standardErrorOfRegressionTxt.setEditable(false);
            this._standardErrorOfRegressionTxt.setBackground(_backgroundColor);
            label.setLabelFor((Component)this._standardErrorOfRegressionTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 7;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._standardErrorOfRegressionTxt, gbc);
            label = new JLabel("Adjusted Determination Coefficient:");
            label.setDisplayedMnemonic('A');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 8;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._adjustedDeterminationCoefficientTxt = new RmaJDecimalField();
            this._adjustedDeterminationCoefficientTxt.setColumns(10);
            this._adjustedDeterminationCoefficientTxt.addFocusListener(StatisticMathTab.this._fl);
            this._adjustedDeterminationCoefficientTxt.setEditable(false);
            this._adjustedDeterminationCoefficientTxt.setBackground(_backgroundColor);
            label.setLabelFor((Component)this._adjustedDeterminationCoefficientTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 8;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._adjustedDeterminationCoefficientTxt, gbc);
            label = new JLabel("Adjusted Standard Error of Regression:");
            label.setDisplayedMnemonic('d');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 9;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._adjustedStandardErrorOfRegressionTxt = new RmaJDecimalField();
            this._adjustedStandardErrorOfRegressionTxt.setColumns(10);
            this._adjustedStandardErrorOfRegressionTxt.addFocusListener(StatisticMathTab.this._fl);
            this._adjustedStandardErrorOfRegressionTxt.setEditable(false);
            this._adjustedStandardErrorOfRegressionTxt.setBackground(_backgroundColor);
            label.setLabelFor((Component)this._adjustedStandardErrorOfRegressionTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 9;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._adjustedStandardErrorOfRegressionTxt, gbc);
            this._dataSetList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    boolean computable = LinearRegressionPanel.this.isComputable();
                    StatisticMathTab.this.setComputeButtonEnabled(computable);
                    if (computable) {
                        StatisticMathTab.this._basicPanel.compute();
                    } else {
                        LinearRegressionPanel.this.clearPanel();
                    }
                }
            });
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            if (b) {
                StatisticMathTab.this.setComputeButtonEnabled(this.isComputable());
            }
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            this.setEnabled(dc instanceof TimeSeriesContainer);
            if (this.isComputable()) {
                StatisticMathTab.this._basicPanel.compute();
            } else {
                this.clearPanel();
            }
        }

        @Override
        public void setDataContainers(Vector v) {
            if (v == null) {
                this._dataSetList.setListData((Vector)null);
                return;
            }
            DefaultListModel newModel = new DefaultListModel();
            for (int i = 0; i < v.size(); ++i) {
                Object obj = v.get(i);
                if (!(obj instanceof TimeSeriesContainer)) continue;
                newModel.addElement(v.get(i));
            }
            this._dataSetList.setModel(newModel);
        }

        public DataContainer getSelectedDataContainer() {
            return (DataContainer)this._dataSetList.getSelectedValue();
        }

        void setLinearRegressionStatistics(LinearRegressionStatistics lrs) {
            if (lrs == null) {
                this.clearPanel();
                return;
            }
            this._numberValidValuesTxt.setValue(lrs.numberValidValues);
            this._regressionConstantTxt.setValue(lrs.regressionConstant);
            this._regressionCoefficientTxt.setValue(lrs.regressionCoefficient);
            this._determinationCoefficientTxt.setValue(lrs.determinationCoefficient);
            this._standardErrorOfRegressionTxt.setValue(lrs.standardErrorOfRegression);
            this._adjustedDeterminationCoefficientTxt.setValue(lrs.adjustedDeterminationCoefficient);
            this._adjustedStandardErrorOfRegressionTxt.setValue(lrs.adjustedStandardErrorOfRegression);
        }

        void clearPanel() {
            this._numberValidValuesTxt.setText("");
            this._regressionConstantTxt.setText("");
            this._regressionCoefficientTxt.setText("");
            this._determinationCoefficientTxt.setText("");
            this._standardErrorOfRegressionTxt.setText("");
            this._adjustedDeterminationCoefficientTxt.setText("");
            this._adjustedStandardErrorOfRegressionTxt.setText("");
        }

        @Override
        public boolean isComputable() {
            DataContainer dc = StatisticMathTab.this._parent.getSelectedDataSet();
            if (dc instanceof TimeSeriesContainer) {
                boolean b;
                TimeSeriesContainer selTs = (TimeSeriesContainer)dc;
                TimeSeriesContainer ts = (TimeSeriesContainer)this._dataSetList.getSelectedValue();
                if (ts == null) {
                    this.setStatusLineText("Nothing selected in DataSet list");
                    return false;
                }
                boolean bl = b = selTs.values.length == ts.values.length;
                if (!b) {
                    this.setStatusLineText("TimeSeries not the same length");
                } else {
                    this.setStatusLineText("");
                }
                return b;
            }
            this.setStatusLineText("Selected DataSet not a TimeSeries");
            return false;
        }
    }

    class CyclicAnalysisPanel
    extends MathPanel.MathCardPanel {
        private JLabel _resultsListLabel;
        private RmaJList _resultsList;
        private JPanel _buttonPanel;
        private JButton _saveButton;
        private JButton _saveAsButton;
        private JButton _plotButton;
        private JButton _tabulateButton;
        private Action _saveAction;
        private Action _saveAsAction;
        private Action _plotAction;
        private Action _tabulateAction;
        private TimeSeriesContainer _computedTsc;

        CyclicAnalysisPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this.createActions();
            this.setLayout(new GridBagLayout());
            this._buttonPanel = new JPanel();
            this._buttonPanel.setLayout(new BoxLayout(this._buttonPanel, 0));
            this._buttonPanel.setBorder(BorderFactory.createEtchedBorder());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._buttonPanel, gbc);
            Insets zeroInsets = new Insets(0, 0, 0, 0);
            this._saveButton = new FlatPanelButton(this._saveAction);
            this._saveButton.setToolTipText("Save Selected Results");
            this._saveButton.setText(null);
            this._saveButton.setMargin(zeroInsets);
            this._saveButton.setVerticalAlignment(1);
            this._buttonPanel.add(this._saveButton);
            this._saveAsButton = new FlatPanelButton(this._saveAsAction);
            this._saveAsButton.setToolTipText("Save Selected Results As");
            this._saveAsButton.setText(null);
            this._saveAsButton.setMargin(zeroInsets);
            this._saveAsButton.setVerticalAlignment(1);
            this._buttonPanel.add(this._saveAsButton);
            this._plotButton = new FlatPanelButton(this._plotAction);
            this._plotButton.setToolTipText("Plot Selected Results");
            this._plotButton.setText(null);
            this._plotButton.setMargin(zeroInsets);
            this._plotButton.setVerticalAlignment(1);
            this._buttonPanel.add(this._plotButton);
            this._tabulateButton = new FlatPanelButton(this._tabulateAction);
            this._tabulateButton.setToolTipText("Tabulate Selected Results");
            this._tabulateButton.setText(null);
            this._tabulateButton.setMargin(zeroInsets);
            this._tabulateButton.setVerticalAlignment(1);
            this._buttonPanel.add(this._tabulateButton);
            this._resultsListLabel = new JLabel("Results");
            this._resultsListLabel.setDisplayedMnemonic('R');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._resultsListLabel, gbc);
            this._resultsList = new RmaJList((ListModel)new RmaListModel(true)){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 300;
                    return d;
                }
            };
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets((int)2, (int)5, (int)0, (int)5);
            this.add((Component)new JScrollPane((Component)this._resultsList), gbc);
            this._resultsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent lse) {
                    boolean enabled = CyclicAnalysisPanel.this._resultsList.getSelectedIndex() > -1;
                    CyclicAnalysisPanel.this._saveButton.setEnabled(enabled);
                    CyclicAnalysisPanel.this._saveAsButton.setEnabled(enabled);
                    CyclicAnalysisPanel.this._plotButton.setEnabled(enabled);
                    CyclicAnalysisPanel.this._tabulateButton.setEnabled(enabled);
                }
            });
        }

        private void createActions() {
            this._saveAction = new AbstractAction("Save", RmaImage.getImageIcon((String)"Images/Save.gif")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CyclicAnalysisPanel.this.saveAction();
                }
            };
            this._saveAction.setEnabled(false);
            this._saveAsAction = new AbstractAction("Save As", RmaImage.getImageIcon((String)"Images/saveAs.gif")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CyclicAnalysisPanel.this.saveAsAction();
                }
            };
            this._saveAsAction.setEnabled(false);
            this._plotAction = new AbstractAction("Plot", RmaImage.getImageIcon((String)"Images/smallPlot.gif")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CyclicAnalysisPanel.this.plotAction();
                }
            };
            this._plotAction.setEnabled(false);
            this._tabulateAction = new AbstractAction("Tabulate", RmaImage.getImageIcon((String)"Images/smallTabulate.gif")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CyclicAnalysisPanel.this.tabulateAction();
                }
            };
            this._tabulateAction.setEnabled(false);
        }

        private void saveAction() {
            Vector selections = this.getSelectedResults();
            int size = selections.size();
            if (size == 0) {
                JOptionPane.showMessageDialog(this, "No Results selected to save", "Nothing to Save", 1);
                return;
            }
            for (int i = 0; i < size; ++i) {
                DataContainer dc = (DataContainer)selections.get(i);
                StatisticMathTab.this._parent.addDataSet(dc);
            }
            if (size == 1) {
                StatisticMathTab.this._parent.getListSelection().save((DataContainer)selections.get(0));
            } else {
                int saved = StatisticMathTab.this._parent.getListSelection().save(selections);
                if (saved == 0) {
                    saved = selections.size();
                }
                String mess = String.valueOf(saved) + " records saved";
                JOptionPane.showMessageDialog(this, mess, "", 1);
            }
            StatisticMathTab.this._parent.setActionsEnabled(true);
        }

        private void saveAsAction() {
            Vector selections = this.getSelectedResults();
            int size = selections.size();
            if (size == 0) {
                JOptionPane.showMessageDialog(this, "No Results selected to Save As", "Nothing to Save As", 1);
                return;
            }
            for (int i = 0; i < size; ++i) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)selections.get(i);
                SaveAs saveAsDlg = new SaveAs((Frame)((Object)StatisticMathTab.this._parent), StatisticMathTab.this._parent.getListSelection().getDataManager(), (DataContainer)tsc);
                saveAsDlg.setLocationRelativeTo((Component)((Object)StatisticMathTab.this._parent));
                saveAsDlg.setVisible(true);
                StatisticMathTab.this._parent.addDataSet((DataContainer)tsc);
            }
        }

        private void plotAction() {
            List[] results = new Vector[4];
            results[0] = this.getSelectedResults();
            StatisticMathTab.this._parent.getListSelection().plot(results);
        }

        private void tabulateAction() {
            List[] results = new Vector[4];
            results[0] = this.getSelectedResults();
            StatisticMathTab.this._parent.getListSelection().tabulate(results, false);
        }

        private Vector getSelectedResults() {
            Object[] objs = this._resultsList.getSelectedValues();
            Vector<Object> v = new Vector<Object>(objs.length);
            for (int i = 0; i < objs.length; ++i) {
                v.add(objs[i]);
            }
            return v;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            boolean enabled = dc instanceof TimeSeriesContainer;
            if (dc != this._computedTsc) {
                this._saveAction.setEnabled(false);
                this._saveAsAction.setEnabled(false);
                this._plotAction.setEnabled(false);
                this._tabulateAction.setEnabled(false);
                this._resultsList.clearPerformed();
                this._resultsList.setEnabled(false);
            }
            if (enabled) {
                this.clearStatusLineText();
            } else {
                this.setStatusLineText("Selected Data Set not a TimeSeries");
            }
        }

        @Override
        public boolean isComputable() {
            boolean computable = StatisticMathTab.this._parent.getSelectedDataSet() instanceof TimeSeriesContainer;
            if (computable) {
                this.clearStatusLineText();
            } else {
                this.setStatusLineText("Selected Data Set not a TimeSeries");
            }
            return computable;
        }

        public void setResults(HecMath[] results) {
            this._resultsList.clearPerformed();
            this._saveAction.setEnabled(false);
            this._saveAsAction.setEnabled(false);
            this._plotAction.setEnabled(false);
            this._tabulateAction.setEnabled(false);
            this._computedTsc = null;
            if (!(results instanceof TimeSeriesMath[])) {
                return;
            }
            this._computedTsc = (TimeSeriesContainer)StatisticMathTab.this._parent.getSelectedDataSet();
            Vector<TimeSeriesContainer> v = new Vector<TimeSeriesContainer>(results.length);
            for (int i = 0; i < results.length; ++i) {
                try {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    results[i].getData((DataContainer)tsc);
                    v.add(tsc);
                    continue;
                }
                catch (HecMathException hme) {
                    System.out.println("setResults: Exception on getData: " + hme);
                }
            }
            this._resultsList.setListData(v);
            this._resultsList.setEnabled(true);
        }
    }

    class DurationAnalysisPanel
    extends MathPanel.MathCardPanel {
        protected JLabel _startLabel;
        protected JLabel _endLabel;
        protected RmaJRadioButton _standardMethod;
        protected RmaJRadioButton _binMethod;
        protected RmaJRadioButton _frequencyXaxis;
        protected RmaJRadioButton _frequencyYaxis;
        protected RmaJComboBox _durationPeriodCombo;
        protected RmaJTable _otherPeriodTable;
        protected RmaJRadioButton _standardPointsRadio;
        protected RmaJRadioButton _userDefPointsRadio;
        protected String[] _durationPeriods = DurationPeriod.DURATION_PERIOD_STRINGS;
        protected RmaJRadioButton _evenDistrbuteBin;
        protected RmaJRadioButton _userBinLimits;
        protected RmaJRadioButton _evenSpacingRadio;
        protected RmaJRadioButton _logSpacingRadio;
        protected JSpinner _numberBinsSpinner;
        protected JLabel _numberBinLabel;
        protected JButton _setLimits;
        protected RmaJRadioButton _allPointsRadio;
        protected JLabel _numberLabel;
        protected JLabel _minimumLabel;
        protected JLabel _maximumLabel;
        protected RmaJRadioButton _linearHorizontalRadio;
        protected RmaJRadioButton _probabilityHorizontalRadio;
        protected RmaJRadioButton _linearVerticalRadio;
        protected RmaJRadioButton _logVerticalRadio;
        protected JButton _setPoints;
        protected JPanel _lowerPanel;
        protected JPanel _bottomPanel;
        protected JPanel _plottingPointsPanel;
        protected JPanel _binPanel;
        protected JPanel _numberPanel;
        protected JPanel _scalePanel;
        protected JPanel _spacingPanel;
        protected JLabel _spacingLabel;
        protected String _allPoints = "";
        protected String _allBins = "All Bins";
        protected Preferences _preferences;

        public DurationAnalysisPanel(Preferences preferences) {
            this._preferences = preferences;
            this.buildPanel();
            this.addListeners();
            this.fillForm();
        }

        protected boolean compute() throws Exception {
            int j;
            PairedDataMath[] result = null;
            boolean standardMethod = this._standardMethod.isSelected();
            DurationPeriod[] durationPeriods = null;
            String periodType = this.getDurationPeriodType();
            if (periodType.equalsIgnoreCase(DurationPeriod.DURATION_PERIOD_STRINGS[3])) {
                durationPeriods = this.getOtherDefinedPeriods();
            }
            int iplottingPointsMethod = this.getPlottingPointsMethod();
            double[] userDefinedPoints = this.getUserDefinedPlottingPoints();
            int horizontalScale = this.getHorizontalPlottingScale();
            int verticalScale = this.getVerticalPlottingScale();
            if (standardMethod) {
                result = StatisticMathTab.this._tsmath.durationAnalysisStandard(periodType, durationPeriods, iplottingPointsMethod, userDefinedPoints, horizontalScale, verticalScale);
            } else {
                int binDistribution = this.getBinDistributionType();
                int numberBins = this.getNumberBins();
                double[] binLimits = this.getUserDefinedBinLimits();
                result = StatisticMathTab.this._tsmath.durationAnalysisBin(periodType, durationPeriods, binDistribution, numberBins, binLimits, iplottingPointsMethod, userDefinedPoints, horizontalScale, verticalScale);
            }
            if (result == null || result.length == 0) {
                return false;
            }
            PairedDataMath firstPdm = null;
            PairedDataMath pdm = null;
            boolean canMerge = true;
            for (j = 0; j < result.length && result[j] instanceof PairedDataMath; ++j) {
                pdm = result[j];
                PairedDataContainer pdc = new PairedDataContainer();
                pdm.getData((DataContainer)pdc);
                pdc.modified = true;
                if (result.length > 1) {
                    pdc.labels = new String[1];
                    pdc.labels[0] = pdc.other;
                    pdc.labelsUsed = true;
                }
                pdm.setData((DataContainer)pdc);
                if (this._frequencyYaxis.isSelected()) {
                    pdm = pdm.translateXY();
                }
                result[j] = pdm;
                if (j <= 0 || !canMerge) continue;
                canMerge = this.sameXordinates(result[0], result[j]);
            }
            if (result.length == 1) {
                canMerge = false;
            }
            for (j = 0; j < result.length; ++j) {
                pdm = result[j];
                if (j == 0 || !canMerge) {
                    firstPdm = pdm;
                } else {
                    pdm.setCurve(-1);
                    firstPdm = (PairedDataMath)firstPdm.mergePairedDataSets((HecMath)pdm);
                }
                if (j != result.length - 1 && canMerge) continue;
                PairedDataContainer pdc = (PairedDataContainer)firstPdm.getData();
                int idx = -1;
                Vector dcVec = StatisticMathTab.this._parent.getDataSets();
                for (int i = 0; i < dcVec.size(); ++i) {
                    DataContainer dc0 = (DataContainer)dcVec.get(i);
                    if (dc0 == null || !dc0.fullName.equalsIgnoreCase(pdc.fullName)) continue;
                    idx = i;
                    break;
                }
                if (idx >= 0) {
                    StatisticMathTab.this._parent.updateDataSet((DataContainer)pdc);
                    StatisticMathTab.this._parent.setSelectedIndex(idx);
                    continue;
                }
                boolean addToOriginalDataList = false;
                StatisticMathTab.this._parent.addDataSet((DataContainer)pdc, addToOriginalDataList);
            }
            return true;
        }

        protected boolean sameXordinates(PairedDataMath pdm1, PairedDataMath pdm2) {
            PairedDataContainer pdc1 = new PairedDataContainer();
            PairedDataContainer pdc2 = new PairedDataContainer();
            try {
                pdm1.getData((DataContainer)pdc1);
                pdm2.getData((DataContainer)pdc2);
            }
            catch (Exception e) {
                return false;
            }
            if (pdc1.numberOrdinates != pdc2.numberOrdinates) {
                return false;
            }
            if (pdc1.xOrdinates.length != pdc2.xOrdinates.length) {
                return false;
            }
            for (int i = 0; i < pdc1.xOrdinates.length; ++i) {
                if (pdc1.xOrdinates[i] == pdc2.xOrdinates[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void buildPanel() {
            this.setLayout(new GridBagLayout());
            int gridy = 0;
            JPanel panel = new JPanel(new GridLayout(2, 1));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.INSETS0505;
            this.add((Component)panel, gbc);
            this._standardMethod = new RmaJRadioButton("Standard Method");
            panel.add((Component)this._standardMethod);
            this._binMethod = new RmaJRadioButton("Bin (STATS) Method");
            panel.add((Component)this._binMethod);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 4;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.INSETS5505;
            this.add((Component)new JSeparator(), gbc);
            JPanel minMaxPanel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 4;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.INSETS5505;
            this.add((Component)minMaxPanel, gbc);
            gbc = new GridBagConstraints();
            JLabel label = new JLabel("Number:");
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            this._numberLabel = new JLabel();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)this._numberLabel, gbc);
            gbc = new GridBagConstraints();
            label = new JLabel("Minimum:");
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            this._minimumLabel = new JLabel();
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)this._minimumLabel, gbc);
            gbc = new GridBagConstraints();
            label = new JLabel("Maximum:");
            gbc.gridx = 4;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            this._maximumLabel = new JLabel();
            gbc.gridx = 5;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)this._maximumLabel, gbc);
            gbc = new GridBagConstraints();
            label = new JLabel("Start:");
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            this._startLabel = new JLabel("");
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)this._startLabel, gbc);
            gbc = new GridBagConstraints();
            label = new JLabel("End:");
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            this._endLabel = new JLabel("");
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            minMaxPanel.add((Component)this._endLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 4;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.INSETS5505;
            this.add((Component)new JSeparator(), gbc);
            this._lowerPanel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._lowerPanel, gbc);
            JPanel p = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS0000;
            this._lowerPanel.add((Component)p, gbc);
            label = new JLabel("Duration Period:");
            label.setDisplayedMnemonic('D');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)7, (int)5, (int)0, (int)5);
            p.add((Component)label, gbc);
            this._durationPeriodCombo = new RmaJComboBox((Object[])this._durationPeriods);
            label.setLabelFor((Component)this._durationPeriodCombo);
            gbc = new GridBagConstraints();
            gbc.ipadx = 20;
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            p.add((Component)this._durationPeriodCombo, gbc);
            Object[] headers = new String[]{"Name", "Start of Period", "End of Period"};
            this._otherPeriodTable = new RmaJTable(this, headers){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = this.getRowHeight() * 4;
                    return d;
                }

                public boolean isCellEditable(int row, int col) {
                    String item = (String)DurationAnalysisPanel.this._durationPeriodCombo.getSelectedItem();
                    return DurationAnalysisPanel.this._durationPeriods[DurationAnalysisPanel.this._durationPeriods.length - 1].equals(item);
                }
            };
            this._otherPeriodTable.setDateCellEditor(1, "DDMMM");
            this._otherPeriodTable.setDateCellEditor(2, "DDMMM");
            this._otherPeriodTable.deleteCells();
            this._otherPeriodTable.appendRows(5);
            gbc = new GridBagConstraints();
            gbc.ipadx = 0;
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 2;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
            this._lowerPanel.add((Component)this._otherPeriodTable.getScrollPane(), gbc);
            this._bottomPanel = new JPanel(new GridLayout(1, 3));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
            this._lowerPanel.add((Component)this._bottomPanel, gbc);
            this._binPanel = new JPanel(new GridBagLayout());
            this._binPanel.setBorder(BorderFactory.createTitledBorder("Bins"));
            this._bottomPanel.add(this._binPanel);
            this._evenDistrbuteBin = new RmaJRadioButton("Evenly Distrubuted");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            this._binPanel.add((Component)this._evenDistrbuteBin, gbc);
            this._numberPanel = new JPanel();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            this._binPanel.add((Component)this._numberPanel, gbc);
            this._numberBinLabel = new JLabel("Number:  ");
            this._numberPanel.add(this._numberBinLabel);
            this._numberBinsSpinner = new JSpinner(new SpinnerNumberModel(23, 2, 200, 1));
            this._numberPanel.add(this._numberBinsSpinner);
            this._spacingPanel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(0, 5, 0, 0);
            gbc.anchor = 18;
            this._binPanel.add((Component)this._spacingPanel, gbc);
            this._spacingLabel = new JLabel("Spacing:");
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 5, 0, 0);
            gbc.anchor = 18;
            gbc.fill = 0;
            this._spacingPanel.add((Component)this._spacingLabel, gbc);
            this._logSpacingRadio = new RmaJRadioButton("Log");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            this._spacingPanel.add((Component)this._logSpacingRadio, gbc);
            this._evenSpacingRadio = new RmaJRadioButton("Linear");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            this._spacingPanel.add((Component)this._evenSpacingRadio, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 5, 4, 5);
            gbc.anchor = 18;
            gbc.fill = 2;
            this._binPanel.add((Component)new JSeparator(), gbc);
            this._userBinLimits = new RmaJRadioButton("User Defined:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            this._binPanel.add((Component)this._userBinLimits, gbc);
            this._setLimits = new JButton("Set Limits");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)20, (int)0, (int)0);
            this._binPanel.add((Component)this._setLimits, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 18;
            this._binPanel.add((Component)new JLabel(""), gbc);
            this._plottingPointsPanel = new JPanel(new GridBagLayout());
            this._plottingPointsPanel.setBorder(BorderFactory.createTitledBorder("Plotting Points"));
            this._bottomPanel.add(this._plottingPointsPanel);
            this._frequencyXaxis = new RmaJRadioButton("Frequency on X axis");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            this._plottingPointsPanel.add((Component)this._frequencyXaxis, gbc);
            this._frequencyYaxis = new RmaJRadioButton("Frequency on Y axis");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            this._plottingPointsPanel.add((Component)this._frequencyYaxis, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
            gbc.fill = 2;
            this._plottingPointsPanel.add((Component)new JSeparator(), gbc);
            this._allPointsRadio = new RmaJRadioButton("All", true);
            this._allPointsRadio.setMnemonic('A');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            this._plottingPointsPanel.add((Component)this._allPointsRadio, gbc);
            this._standardPointsRadio = new RmaJRadioButton("Standard (23 points)");
            this._standardPointsRadio.setMnemonic('S');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            this._plottingPointsPanel.add((Component)this._standardPointsRadio, gbc);
            this._userDefPointsRadio = new RmaJRadioButton("User Defined:");
            this._userDefPointsRadio.setMnemonic('U');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            this._plottingPointsPanel.add((Component)this._userDefPointsRadio, gbc);
            this._setPoints = new JButton("Set Points");
            this._setPoints.setEnabled(false);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.weightx = 1.0E-4;
            gbc.weighty = 1.0E-4;
            gbc.anchor = 18;
            gbc.insets = RmaInsets.insets((int)0, (int)25, (int)0, (int)0);
            this._plottingPointsPanel.add((Component)this._setPoints, gbc);
            this._scalePanel = new JPanel(new GridLayout(2, 1));
            this._bottomPanel.add(this._scalePanel);
            JPanel horizontalAxisPanel = new JPanel(new GridBagLayout());
            horizontalAxisPanel.setBorder(BorderFactory.createTitledBorder("Horizontal Axis"));
            this._scalePanel.add(horizontalAxisPanel);
            this._linearHorizontalRadio = new RmaJRadioButton("Linear", true);
            this._linearHorizontalRadio.setMnemonic('L');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            horizontalAxisPanel.add((Component)this._linearHorizontalRadio, gbc);
            this._probabilityHorizontalRadio = new RmaJRadioButton("Probability");
            this._probabilityHorizontalRadio.setMnemonic('P');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0E-4;
            gbc.weighty = 1.0E-4;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            horizontalAxisPanel.add((Component)this._probabilityHorizontalRadio, gbc);
            JPanel verticalAxisPanel = new JPanel(new GridBagLayout());
            verticalAxisPanel.setBorder(BorderFactory.createTitledBorder("Vertical Axis"));
            this._scalePanel.add(verticalAxisPanel);
            this._linearVerticalRadio = new RmaJRadioButton("Linear", true);
            this._linearVerticalRadio.setMnemonic('L');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            verticalAxisPanel.add((Component)this._linearVerticalRadio, gbc);
            this._logVerticalRadio = new RmaJRadioButton("Log");
            this._logVerticalRadio.setMnemonic('P');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0E-4;
            gbc.weighty = 1.0E-4;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            verticalAxisPanel.add((Component)this._logVerticalRadio, gbc);
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this._allPointsRadio);
            bg.add((AbstractButton)this._standardPointsRadio);
            bg.add((AbstractButton)this._userDefPointsRadio);
            this._allPointsRadio.setSelected(true);
            this._standardMethod.setSelected(true);
            bg = new ButtonGroup();
            bg.add((AbstractButton)this._standardMethod);
            bg.add((AbstractButton)this._binMethod);
            this._frequencyXaxis.setSelected(true);
            bg = new ButtonGroup();
            bg.add((AbstractButton)this._frequencyXaxis);
            bg.add((AbstractButton)this._frequencyYaxis);
            bg = new ButtonGroup();
            bg.add((AbstractButton)this._evenDistrbuteBin);
            bg.add((AbstractButton)this._userBinLimits);
            this._evenDistrbuteBin.setSelected(true);
            bg = new ButtonGroup();
            bg.add((AbstractButton)this._linearHorizontalRadio);
            bg.add((AbstractButton)this._probabilityHorizontalRadio);
            bg = new ButtonGroup();
            bg.add((AbstractButton)this._linearVerticalRadio);
            bg.add((AbstractButton)this._logVerticalRadio);
            bg = new ButtonGroup();
            bg.add((AbstractButton)this._logSpacingRadio);
            bg.add((AbstractButton)this._evenSpacingRadio);
            this._logSpacingRadio.setSelected(true);
            this.enableBinPanel(this._binMethod.isSelected());
        }

        protected void enableBinPanel(boolean enable) {
            this._binPanel.setEnabled(enable);
            this._evenDistrbuteBin.setEnabled(enable);
            this._userBinLimits.setEnabled(enable);
            this._numberBinsSpinner.setEnabled(enable);
            this._numberBinLabel.setEnabled(enable);
            this._spacingPanel.setEnabled(enable);
            this._spacingLabel.setEnabled(enable);
            this._evenSpacingRadio.setEnabled(enable);
            this._logSpacingRadio.setEnabled(enable);
            if (enable) {
                boolean b = this._evenDistrbuteBin.isSelected();
                this.enableTopBinPanel(b);
                this.enableBottomBinPanel(!b);
                this._allPointsRadio.setText(this._allBins);
            } else {
                this.enableTopBinPanel(false);
                this.enableBottomBinPanel(false);
                this._allPointsRadio.setText(this._allPoints);
            }
            this._lowerPanel.repaint();
        }

        protected void enableTopBinPanel(boolean enable) {
            this._numberPanel.setEnabled(enable);
        }

        protected void enableBottomBinPanel(boolean enable) {
            this._setLimits.setEnabled(enable);
        }

        protected void addListeners() {
            this._durationPeriodCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    String type = (String)DurationAnalysisPanel.this._durationPeriodCombo.getSelectedItem();
                    boolean isOtherType = DurationAnalysisPanel.this._durationPeriods[DurationAnalysisPanel.this._durationPeriods.length - 1].equalsIgnoreCase(type);
                    DurationAnalysisPanel.this._otherPeriodTable.commitEdit(true);
                    DurationAnalysisPanel.this._otherPeriodTable.repaint();
                }
            });
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean userDefSelected = DurationAnalysisPanel.this._userDefPointsRadio.isSelected();
                    DurationAnalysisPanel.this._setPoints.setEnabled(userDefSelected);
                }
            };
            this._allPointsRadio.addActionListener(al);
            this._standardPointsRadio.addActionListener(al);
            this._userDefPointsRadio.addActionListener(al);
            StatisticMathTab.this._parent.getDataSetCombo().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    DurationAnalysisPanel.this.fillForm();
                }
            });
            final DurationAnalysisPanel parent = this;
            this._setPoints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HecDoubleArray userPoints = null;
                    String pp = DurationAnalysisPanel.this._preferences.get("DurationPlottingPoints", null);
                    if (pp != null) {
                        userPoints = new HecDoubleArray();
                        userPoints.set(pp, ",");
                        if (userPoints.numberElements() == 0) {
                            userPoints = null;
                        }
                    }
                    HecDoubleArray defaultPoints = new HecDoubleArray(DurationAnalysis.defaultFrequencies);
                    defaultPoints.setPrecision(2);
                    DurationEditor durEdit = new DurationEditor(parent, defaultPoints, userPoints, false);
                    durEdit.setVisible(true);
                }
            });
            this._setLimits.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HecDoubleArray userLimits = null;
                    String s = DurationAnalysisPanel.this._preferences.get("DurationBinLimits", null);
                    if (s != null) {
                        userLimits = new HecDoubleArray();
                        userLimits.set(s, ",");
                        if (userLimits.numberElements() == 0) {
                            userLimits = null;
                        }
                    }
                    int n = DurationAnalysisPanel.this.getNumberBins();
                    boolean log = DurationAnalysisPanel.this._logSpacingRadio.isSelected();
                    HecDoubleArray defaultLimits = DurationAnalysisPanel.this.getDefaultBinLimits(n, log);
                    DurationEditor durEdit = new DurationEditor(parent, defaultLimits, userLimits, true);
                    durEdit.setVisible(true);
                }
            });
            ActionListener methodChanged = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DurationAnalysisPanel.this._standardMethod.isSelected()) {
                        DurationAnalysisPanel.this.enableBinPanel(false);
                    } else {
                        DurationAnalysisPanel.this.enableBinPanel(true);
                    }
                }
            };
            this._standardMethod.addActionListener(methodChanged);
            this._binMethod.addActionListener(methodChanged);
            this._evenDistrbuteBin.addActionListener(methodChanged);
            this._userBinLimits.addActionListener(methodChanged);
        }

        protected void fillForm() {
            DataContainer dc = StatisticMathTab.this._parent.getSelectedDataSet();
            if (dc instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                String param = tsc.parameter;
                if (param.length() > 12) {
                    param = param.substring(0, 12);
                }
                this._frequencyYaxis.setText(param + " on X Axis");
                HecTime time = new HecTime();
                int ntimes = tsc.numberValues;
                time.set(tsc.times[0], tsc.timeGranularitySeconds, tsc.julianBaseDate);
                this._startLabel.setText(time.date(7));
                time.set(tsc.times[ntimes - 1], tsc.timeGranularitySeconds, tsc.julianBaseDate);
                this._endLabel.setText(time.date(7));
                if (tsc.interval >= 525600) {
                    this._durationPeriodCombo.setSelectedItem((Object)DurationPeriod.DURATION_PERIOD_STRINGS[0]);
                    this._durationPeriodCombo.setEnabled(false);
                } else {
                    this._durationPeriodCombo.setEnabled(true);
                }
                try {
                    TimeSeriesMath mathGuy = (TimeSeriesMath)StatisticMathTab.this.getHecMath(dc);
                    int number = mathGuy.numberValidValues();
                    String nvals = String.valueOf(number);
                    this._numberLabel.setText(nvals);
                    this._allPoints = "All  " + nvals + " points";
                    this._allPointsRadio.setText(this._allPoints);
                    ((SpinnerNumberModel)this._numberBinsSpinner.getModel()).setMaximum(new Integer(nvals));
                    HecDouble hdouble = new HecDouble();
                    hdouble.set(mathGuy.min());
                    this._minimumLabel.setText(hdouble.toString());
                    hdouble.set(mathGuy.max());
                    this._maximumLabel.setText(hdouble.toString());
                    this._spacingPanel.setEnabled(this._userBinLimits.isSelected());
                }
                catch (Exception e) {
                    System.out.println("compute: Error on getting statistics " + e);
                    JOptionPane.showMessageDialog(this, e.toString(), "Compute Error", 2);
                }
            }
        }

        public String getDurationPeriodType() {
            return this._durationPeriodCombo.getSelectedItem().toString();
        }

        public DurationPeriod[] getOtherDefinedPeriods() {
            this._otherPeriodTable.commitEdit(true);
            Vector rows = ((RmaTableModel)this._otherPeriodTable.getModel()).getDataVector();
            Vector<DurationPeriod> durationPeriodList = new Vector<DurationPeriod>();
            for (int i = 0; i < rows.size(); ++i) {
                Vector row = (Vector)rows.get(i);
                if (row.get(0) == null || row.get(1) == null || row.get(2) == null) continue;
                String name = row.get(0).toString();
                String startDate = row.get(1).toString();
                String endDate = row.get(2).toString();
                if (name.length() < 1 || startDate.length() < 1 || endDate.length() < 1) break;
                DurationPeriod durationPeriod = new DurationPeriod(3, startDate, endDate);
                durationPeriod.setName(name);
                durationPeriodList.add(durationPeriod);
            }
            if (durationPeriodList.size() < 1) {
                return null;
            }
            DurationPeriod[] durationPeriods = new DurationPeriod[durationPeriodList.size()];
            for (int i = 0; i < durationPeriodList.size(); ++i) {
                durationPeriods[i] = (DurationPeriod)durationPeriodList.get(i);
            }
            return durationPeriods;
        }

        public PairedDataContainer getOtherDefinedPeriodsDc() {
            this._otherPeriodTable.commitEdit(true);
            Vector rows = ((RmaTableModel)this._otherPeriodTable.getModel()).getDataVector();
            StringBuffer strbuf = new StringBuffer();
            Object allNames = "";
            int nrows = 0;
            for (int i = 0; i < rows.size(); ++i) {
                Vector row = (Vector)rows.get(i);
                String name = row.get(0).toString();
                String startDate = row.get(1).toString();
                String endDate = row.get(2).toString();
                if (name.length() < 1 || startDate.length() < 1 || endDate.length() < 1) break;
                strbuf.append(name + ";" + startDate + ";" + startDate + "\n");
                allNames = i > 0 ? (String)allNames + "-" + name : name;
                ++nrows;
            }
            String[] labels = new String[nrows];
            double[] xordinates = new double[2];
            double[][] yordinates = new double[nrows][2];
            HecTime stime = new HecTime();
            HecTime etime = new HecTime();
            xordinates[0] = 1.0;
            xordinates[1] = 2.0;
            for (int i = 0; i < nrows; ++i) {
                String name;
                Vector row = (Vector)rows.get(i);
                labels[i] = name = row.get(0).toString();
                String startDate = row.get(1).toString() + "1900";
                String endDate = row.get(2).toString() + "1900";
                stime.set(startDate);
                etime.set(endDate);
                yordinates[i][0] = stime.dayOfYear();
                yordinates[i][1] = etime.dayOfYear();
            }
            if (strbuf.length() < 1) {
                return null;
            }
            PairedDataContainer pdc = new PairedDataContainer();
            pdc.supplementalInfo = strbuf.toString();
            pdc.version = allNames;
            pdc.location = "Duration Periods";
            pdc.numberCurves = nrows;
            pdc.numberOrdinates = 2;
            pdc.labels = labels;
            pdc.labelsUsed = true;
            pdc.xOrdinates = xordinates;
            pdc.yOrdinates = yordinates;
            return pdc;
        }

        protected int getHorizontalPlottingScale() {
            if (this._probabilityHorizontalRadio.isSelected()) {
                return 1;
            }
            return 0;
        }

        protected int getVerticalPlottingScale() {
            if (this._linearVerticalRadio.isSelected()) {
                return 0;
            }
            return 1;
        }

        protected int getPlottingPointsMethod() {
            if (this._userDefPointsRadio.isSelected()) {
                return 1;
            }
            if (this._allPointsRadio.isSelected()) {
                return 2;
            }
            return 0;
        }

        protected int getBinDistributionType() {
            if (this._evenDistrbuteBin.isSelected()) {
                if (this._logSpacingRadio.isSelected()) {
                    return 1;
                }
                return 0;
            }
            return 2;
        }

        protected int getNumberBins() {
            int inumber = ((SpinnerNumberModel)this._numberBinsSpinner.getModel()).getNumber().intValue();
            return inumber;
        }

        protected void setUserDefinedPlottingPoints(HecDoubleArray doubleArray) {
            String userPoints = doubleArray.toString(",");
            this._preferences.put("DurationPlottingPoints", userPoints);
        }

        protected double[] getUserDefinedPlottingPoints() {
            String userPoints;
            if (this._userDefPointsRadio.isSelected() && (userPoints = this._preferences.get("DurationPlottingPoints", null)) != null) {
                HecDoubleArray doubleArray = new HecDoubleArray();
                doubleArray.set(userPoints, ",");
                if (doubleArray.numberElements() == 0) {
                    return null;
                }
                return doubleArray.getDoubleArray();
            }
            return null;
        }

        protected HecDoubleArray getDefaultBinLimits(int numberLimits, boolean log) {
            double min = Double.parseDouble(this._minimumLabel.getText());
            double max = Double.parseDouble(this._maximumLabel.getText());
            double increment = (max - min) / (double)numberLimits;
            HecDoubleArray da = new HecDoubleArray(numberLimits + 1);
            if (log) {
                double minLog = Math.log10(min);
                double maxLog = Math.log10(max);
                double binSpan = (maxLog - minLog) / (double)numberLimits;
                double nextBinLog = minLog;
                for (int i = 0; i < numberLimits; ++i) {
                    double val = Math.pow(10.0, nextBinLog);
                    da.element(i).set(val);
                    nextBinLog += binSpan;
                }
            } else {
                for (int i = 0; i < numberLimits; ++i) {
                    da.element(i).set(min + increment * (double)i);
                }
            }
            da.element(numberLimits).set(max);
            return da;
        }

        public void setUserDefinedBinLimits(HecDoubleArray doubleArray) {
            String userPoints = doubleArray.toString(",");
            this._preferences.put("DurationBinLimits", userPoints);
        }

        public double[] getUserDefinedBinLimits() {
            String userPoints;
            if (this._userBinLimits.isSelected() && (userPoints = this._preferences.get("DurationBinLimits", null)) != null) {
                HecDoubleArray doubleArray = new HecDoubleArray();
                doubleArray.set(userPoints, ",");
                if (doubleArray.numberElements() == 0) {
                    return null;
                }
                return doubleArray.getDoubleArray();
            }
            return null;
        }

        @Override
        public boolean isComputable() {
            boolean computable = false;
            Object tsc = null;
            if (StatisticMathTab.this._parent.getSelectedDataSet() instanceof TimeSeriesContainer) {
                computable = true;
            } else {
                this.setStatusLineText("Selected Data Set not a TimeSeries");
            }
            return computable;
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.fillForm();
            }
        }
    }

    class FrequencyPlotPanel
    extends MathPanel.MathCardPanel {
        protected JCheckBox _showComputedCurve;

        public FrequencyPlotPanel() {
            this.buildPanel();
        }

        @Override
        public boolean isComputable() {
            DataContainer obj = StatisticMathTab.this._parent.getSelectedDataSet();
            if (obj == null) {
                this.setStatusLineText("No Data Set Selected");
                return false;
            }
            if (!(obj instanceof TimeSeriesContainer)) {
                this.setStatusLineText("No Time Series Data Selected");
                return false;
            }
            TimeSeriesContainer tsc = (TimeSeriesContainer)obj;
            int timeDiff = tsc.endTime - tsc.startTime;
            int years = timeDiff / 525600;
            if (years < 10) {
                this.setStatusLineText("Insufficient number of data values to compute analysis.");
                return false;
            }
            return true;
        }

        @Override
        protected void buildPanel() {
            this.setLayout(new GridBagLayout());
            this._showComputedCurve = new JCheckBox("Show computed curve with observed points");
            this._showComputedCurve.setSelected(true);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(10, 10, 10, 10);
            this.add((Component)this._showComputedCurve, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            this.add((Component)new JPanel(), gbc);
        }

        protected boolean compute() {
            Object obj;
            StatisticMathTab.this._parent.setStatusLineText("Computing...");
            StatisticMathTab.this._parent.setCursor(new Cursor(3));
            this.setCursor(new Cursor(3));
            Vector<PairedDataContainer> result = null;
            Vector data = StatisticMathTab.this.getSelectedDataSets();
            if (data.size() > 0 && (obj = data.elementAt(0)) instanceof TimeSeriesContainer) {
                try {
                    TimeSeriesContainer tsc = (TimeSeriesContainer)obj;
                    SimpleFrequencyAnalysis fa = new SimpleFrequencyAnalysis(tsc);
                    fa.compute();
                    result = new Vector<PairedDataContainer>(2);
                    result.add(fa.getPairedDataPeaks());
                    result.add(fa.getPairedDataComputed());
                    Object outlierMessage = "";
                    for (Double d : fa.getDroppedOutliers()) {
                        outlierMessage = (String)outlierMessage + " \n" + String.format("%.2f", d);
                    }
                    if (outlierMessage != "") {
                        JOptionPane.showMessageDialog((Component)((Object)StatisticMathTab.this._parent), "note: " + fa.getDroppedOutliers().size() + " outliers were dropped:" + (String)outlierMessage, StatisticMathTab.FREQUENCY_PLOT, 2);
                    }
                }
                catch (Exception e) {
                    this.setStatusLineText("");
                    StatisticMathTab.this._parent.setCursor(Cursor.getDefaultCursor());
                    this.setCursor(Cursor.getDefaultCursor());
                    JOptionPane.showMessageDialog((Component)((Object)StatisticMathTab.this._parent), e.toString(), StatisticMathTab.FREQUENCY_PLOT, 0);
                    return false;
                }
            }
            if (result == null || result.size() == 0) {
                this.setStatusLineText("");
                StatisticMathTab.this._parent.setCursor(Cursor.getDefaultCursor());
                this.setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog((Component)((Object)StatisticMathTab.this._parent), "Error in computations", StatisticMathTab.FREQUENCY_PLOT, 0);
                return false;
            }
            obj = result.elementAt(0);
            if (obj instanceof PairedDataContainer) {
                PairedDataContainer pdc = (PairedDataContainer)obj;
                pdc.modified = true;
                int idx = -1;
                Vector dcVec = StatisticMathTab.this._parent.getDataSets();
                for (int i = 0; i < dcVec.size(); ++i) {
                    DataContainer dc0 = (DataContainer)dcVec.get(i);
                    if (dc0 == null || !dc0.fullName.equalsIgnoreCase(pdc.fullName)) continue;
                    idx = i;
                    break;
                }
                if (idx >= 0) {
                    StatisticMathTab.this._parent.updateDataSet((DataContainer)pdc);
                    StatisticMathTab.this._parent.setSelectedIndex(idx);
                } else {
                    boolean addToOriginalDataList = false;
                    StatisticMathTab.this._parent.addDataSet((DataContainer)pdc, addToOriginalDataList);
                }
                if (this._showComputedCurve.isSelected()) {
                    StatisticMathTab.this._parent.plotFrequency(result);
                } else {
                    Vector<PairedDataContainer> v = new Vector<PairedDataContainer>(1);
                    v.add(pdc);
                    StatisticMathTab.this._parent.plotFrequency(v);
                }
            }
            StatisticMathTab.this._parent.setCursor(Cursor.getDefaultCursor());
            this.setCursor(Cursor.getDefaultCursor());
            this.setStatusLineText("");
            return true;
        }
    }

    class StatTextField
    extends JTextField {
        public StatTextField(int col) {
            super(col);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = this.getColumnWidth() * this.getColumns();
            return d;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public class DurationTableModel
    extends GeneralTableModel {
        boolean _setLimits;

        public DurationTableModel(boolean setLimits) {
            this._setLimits = setLimits;
        }

        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return Integer.toString(row + 1);
            }
            return super.getValueAt(row, column);
        }
    }

    class DurationEditor
    extends GeneralTableEditor {
        DurationAnalysisPanel _parent;
        HecDoubleArray _defaultVals;
        boolean _setLimits;
        String[] _columnNames = new String[]{"Ordinate", "Percent Exceedance (0 < f < 100)"};
        protected int[] colWidths = new int[]{80, 200};

        public DurationEditor(DurationAnalysisPanel parent, HecDoubleArray defaultVals, HecDoubleArray userVals, boolean setLimits) {
            this._parent = parent;
            this._defaultVals = defaultVals;
            this._setLimits = setLimits;
            HecDoubleArray values = userVals;
            if (values == null || values.numberElements() == 0) {
                values = this._defaultVals;
            }
            this.init();
            if (this._setLimits) {
                this.setTitle("Bin Limits");
                this._columnNames[1] = "Bin Limit";
            } else {
                this.setTitle("Plotting Points");
            }
            Vector<String[]> v = new Vector<String[]>(values.numberElements());
            for (int i = 0; i < values.numberElements(); ++i) {
                String[] row = new String[]{Integer.toString(i + 1), values.string(i)};
                v.add(row);
            }
            this.initialize(this._columnNames, v);
            this._table.setEditable(true);
            int width = 0;
            for (int i = 0; i < this.colWidths.length; ++i) {
                width += this.colWidths[i];
                TableColumn tc = this._table.getColumnModel().getColumn(i);
                tc.setPreferredWidth(this.colWidths[i]);
            }
            this.setSize(width, 500);
            this.setLocation(100, 100);
            this._table.setHorizontalAlignment(0, 0);
            this._table.setHorizontalAlignment(0, 1);
            this._fileMenu.setVisible(false);
            this._editMenu.addSeparator();
            JMenuItem restore = new JMenuItem("Restore Defaults");
            this._editMenu.add(restore);
            restore.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DurationEditor.this.restoreDefaults();
                }
            });
            JButton button = this._cmdPanel.getButton(8);
            button.setText("OK");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DurationEditor.this.okPressed();
                }
            });
            button = new JButton("Defaults");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DurationEditor.this.restoreDefaults();
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.getContentPane().add((Component)button, gbc);
        }

        protected void init() {
            this._tableModel = new DurationTableModel(this._setLimits);
            this._table = new RmaJTable((Component)((Object)this)){

                public void setEditable(boolean editable) {
                    super.setEditable(editable);
                    TableModel model = this.getModel();
                    if (model instanceof GeneralTableModel) {
                        ((GeneralTableModel)model).setEditable(editable);
                    }
                }
            };
            this._table.setModel((TableModel)this._tableModel);
            this.setDefaultCloseOperation(0);
        }

        protected void restoreDefaults() {
            Vector<String[]> v = new Vector<String[]>(this._defaultVals.numberElements());
            for (int i = 0; i < this._defaultVals.numberElements(); ++i) {
                String[] row = new String[]{Integer.toString(i + 1), this._defaultVals.string(i)};
                v.add(row);
            }
            this._tableModel.setRows(v);
        }

        protected void okPressed() {
            this.stopEditing();
            HecDoubleArray doubleArray = new HecDoubleArray(this._table.getRowCount());
            int count = 0;
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                String s = this._table.getValueAt(i, 1).toString();
                if (s.length() <= 0) continue;
                HecDouble d = doubleArray.element(count++);
                d.set(s);
                if (d.isDefined()) continue;
                System.out.println("Undefined value at row " + (i + 1) + ",  value = " + s);
                --count;
            }
            if (this._setLimits) {
                this._parent.setUserDefinedBinLimits(doubleArray);
            } else {
                this._parent.setUserDefinedPlottingPoints(doubleArray);
            }
            this.close();
        }
    }
}

