/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.dssgui.Help;
import hec.dssgui.ListSelection;
import hec.dssgui.SupplementalInfoControlBuilder;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTextArea;
import rma.swing.list.RmaListModel;

public class SupplementalInfo7
extends RmaJDialog {
    private static final Logger logger = Logger.getLogger(SupplementalInfo7.class.getName());
    private RmaJComboBox<DataContainerHolder> _pathCombo;
    private JTextArea _supplementalInfo;
    private RmaJDecimalField _xOrdinateFld;
    private RmaJDecimalField _yOrdinateFld;
    private RmaJDecimalField _zOrdinateFld;
    private RmaJComboBox _coordinateSystemCombo;
    private RmaJIntegerField _coordinateIDFld;
    private RmaJComboBox _horizontalUnitsCombo;
    private RmaJComboBox _horizontalDatumCombo;
    private JTextField _typeField;
    private JTextField _recTypeField;
    private JTextField _lastWrittenField;
    private JTextField _programNameField;
    private JTextField _versionField;
    private JTextField _precisionField;
    private JTextField _displayPrecisionField;
    private JTextField _passwordProtectedField;
    private JTextField _numberValues;
    private JTextField _units;
    private JTextField _spaceAllocated;
    private JTextField _sizeEachValue;
    private JTextField _quality;
    private JTextField _sizeEachQuality;
    private JTextField _sizeIntegerNotes;
    private JTextField _lengthCharacterNotes;
    private RmaJDecimalField _shiftNGVD29Field;
    private RmaJDecimalField _shiftNAVD88Field;
    private JTextField _verticalDatumUnitsField;
    private JTextField _verticalDatumField;
    private VerticalDatumContainer _verticalDatum;
    private ButtonCmdPanel _cmdPanel;
    private DataContainerHolder _dc;
    private ListSelection _listSelection;
    private String _title;
    private JLabel _timeZoneIdLabel;
    private JTextField _timeZoneIdFld;
    private JLabel _labelNAVD88;
    private JLabel _labelNGVD29;

    public SupplementalInfo7(ListSelection parent) {
        super((Frame)parent, false);
        this._listSelection = parent;
        this.buildControls();
        this.pack();
        this.setLocationRelativeTo(this._listSelection);
        Help.setHelp((RootPaneContainer)((Object)this), "27");
    }

    protected void buildControls() {
        this._title = "Location and Supplemental Information";
        this.setTitle(this._title);
        Color backgroundColor = new Color(245, 245, 245);
        this.getContentPane().setLayout(new GridBagLayout());
        boolean gridy = false;
        SupplementalInfoControlBuilder cb = new SupplementalInfoControlBuilder(this.getContentPane());
        this._pathCombo = cb.addComboBox("Data Set:", null, null, 0, 0, 3, true);
        this._recTypeField = cb.addTextField("Record Type:", 0, 1, 3);
        this._lastWrittenField = cb.addTextField("Last Written:", 0, 2, 1);
        this._programNameField = cb.addTextField("By Program:", 2, 2, 1);
        this._versionField = cb.addTextField("Version:", 0, 3, 1);
        this._displayPrecisionField = cb.addTextField("Display Precision:", 2, 3, 1);
        this._typeField = cb.addTextField("Type:", 0, 4, 1);
        this._passwordProtectedField = cb.addTextField("Password Protected:", 2, 4, 1);
        this._numberValues = cb.addTextField("Number Values:", 0, 5, 1);
        this._spaceAllocated = cb.addTextField("Space Allocated:", 2, 5, 1);
        this._precisionField = cb.addTextField("Precision:", 0, 6, 1);
        this._sizeEachValue = cb.addTextField("Size of Each Value:", 2, 6, 1);
        this._quality = cb.addTextField("Quality:", 0, 7, 1);
        this._sizeEachQuality = cb.addTextField("Size of Each Quality:", 2, 7, 1);
        this._sizeIntegerNotes = cb.addTextField("Size of Integer Notes:", 0, 8, 1);
        this._lengthCharacterNotes = cb.addTextField("Number Bytes Character Notes:", 2, 8, 1);
        this._units = cb.addTextField("Units:", 0, 9, 1);
        cb.addSeparator(0, 10, 4);
        JLabel labelNotes = cb.addLabel("Notes:", 0, 11);
        labelNotes.setDisplayedMnemonic('S');
        this.setupSupplementalTextArea(11, labelNotes);
        cb.addSeparator(0, 13, 4);
        this._coordinateSystemCombo = cb.addComboBox("Coordinate System:", Character.valueOf('C'), new String[]{"No Coordinates set", "No Coordinates set", "Lat/long", "State Plane, FIPS", "State Plane, ADS", "UTM", "Local (other)"}, 0, 15, 1, false);
        this._coordinateIDFld = cb.addIntegerField("Coordinate ID:", Character.valueOf('o'), 2, 15, 1);
        this._horizontalDatumCombo = cb.addComboBox("Horizontal Datum:", Character.valueOf('H'), new String[]{"unset", "NAD83", "NAD27", "WGS84", "WGS72", "Local (other)"}, 0, 16, 1, false);
        this._horizontalUnitsCombo = cb.addComboBox("Datum Units:", Character.valueOf('D'), new String[]{"Not Specified", "English", "SI", "Decimal Degrees", "Degrees Minutes Seconds"}, 2, 16, 1, false);
        this._xOrdinateFld = cb.addDoubleField("X Coordinate:", Character.valueOf('X'), 0, 17, 1, false);
        this._yOrdinateFld = cb.addDoubleField("Y Coordinate:", Character.valueOf('Y'), 2, 17, 1, false);
        cb.addSeparator(0, 18, 4);
        this._verticalDatumField = cb.addTextField("Vertical Datum:", Character.valueOf('V'), 0, 19, 1);
        this._verticalDatumUnitsField = cb.addTextField("Vertical Datum Units:", Character.valueOf('L'), 2, 19, 1);
        this._labelNAVD88 = new JLabel(this.getNAVD88Label());
        this._shiftNAVD88Field = cb.addDoubleField(this.getNAVD88Label(), Character.valueOf('8'), 0, 20, 1, true);
        this._labelNGVD29 = new JLabel(this.getNGVD29Label());
        this._shiftNGVD29Field = cb.addDoubleField(this._labelNGVD29, Character.valueOf('2'), 2, 20, 1, true);
        cb.addSeparator(0, 21, 4);
        GridBagConstraints gbc = new GridBagConstraints();
        this._timeZoneIdLabel = new JLabel("Time Zone ID:");
        this._timeZoneIdFld = cb.addTextField(this._timeZoneIdLabel, Character.valueOf('T'), 0, 21, 1);
        this._cmdPanel = new ButtonCmdPanel(12);
        cb.addPanel((JPanel)this._cmdPanel, 0, 25, 4);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        SupplementalInfo7.this.saveForm();
                        SupplementalInfo7.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        SupplementalInfo7.this.setVisible(false);
                    }
                }
            }
        });
        this._pathCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    SupplementalInfo7.this.saveDataContainer();
                    return;
                }
                DataContainerHolder dch = (DataContainerHolder)SupplementalInfo7.this._pathCombo.getSelectedItem();
                SupplementalInfo7.this.fillForm(dch);
            }
        });
    }

    private void setupSupplementalTextArea(int gridy, JLabel label) {
        String toolTip = "<html>Supplemental Info is any additional information that describes this data or location<br>It <b>MUST</b> be in a <i>Keyword:Item;</i> format.  The keyword is separated from the item<br>by a colon <b>:</b>, and the item is terminated by a simi-colon <b>;</b><br>Items may or may not be a number.<br>Keyword1:Item1;Keyword2:Item2;Keyword3:Item3;<br>Examples:<br>Offset:1.2;Shift:3.4;Datum:5.6;Transform:LogLog;</html>";
        this._supplementalInfo = new RmaJTextArea(5, 40){

            public String getToolTipText(MouseEvent e) {
                return "<html>Supplemental Info is any additional information that describes this data or location<br>It <b>MUST</b> be in a <i>Keyword:Item;</i> format.  The keyword is separated from the item<br>by a colon <b>:</b>, and the item is terminated by a simi-colon <b>;</b><br>Items may or may not be a number.<br>Keyword1:Item1;Keyword2:Item2;Keyword3:Item3;<br>Examples:<br>Offset:1.2;Shift:3.4;Datum:5.6;Transform:LogLog;</html>";
            }

            public String getToolTipText() {
                return "<html>Supplemental Info is any additional information that describes this data or location<br>It <b>MUST</b> be in a <i>Keyword:Item;</i> format.  The keyword is separated from the item<br>by a colon <b>:</b>, and the item is terminated by a simi-colon <b>;</b><br>Items may or may not be a number.<br>Keyword1:Item1;Keyword2:Item2;Keyword3:Item3;<br>Examples:<br>Offset:1.2;Shift:3.4;Datum:5.6;Transform:LogLog;</html>";
            }
        };
        this._supplementalInfo.setToolTipText(" ");
        this._supplementalInfo.setEditable(false);
        label.setLabelFor(this._supplementalInfo);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)new JScrollPane(this._supplementalInfo), gbc);
    }

    protected void saveDataContainer() {
        if (this.isModified() && this._dc != null) {
            this._dc.dataContainer.supplementalInfo = this._supplementalInfo.getText();
            this._dc.dataContainer.coordinateSystem = this._coordinateSystemCombo.getSelectedIndex();
            this._dc.dataContainer.coordinateID = this._coordinateIDFld.getValue();
            this._dc.dataContainer.horizontalDatum = this._horizontalDatumCombo.getSelectedIndex();
            this._dc.dataContainer.horizontalUnits = this._horizontalUnitsCombo.getSelectedIndex();
            this._dc.dataContainer.xOrdinate = this._xOrdinateFld.getValue();
            this._dc.dataContainer.yOrdinate = this._yOrdinateFld.getValue();
            if (this._dc.dataContainer instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)this._dc.dataContainer;
                tsc.timeZoneID = this._timeZoneIdFld.getText();
                tsc.timeZoneRawOffset = 0;
            } else {
                this._dc.dataContainer.locationTimezone = this._timeZoneIdFld.getText();
            }
            if (this._verticalDatum != null) {
                try {
                    this._dc.dataContainer.insertVerticalDatum(this._verticalDatum);
                }
                catch (IOException | VerticalDatumException e) {
                    logger.log(Level.WARNING, "Failed to insert Vertical Datum", e);
                }
            }
            this._dc.modified = true;
        } else if (this._dc.dataContainer instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)this._dc.dataContainer;
            String timeZoneId = this._timeZoneIdFld.getText();
            if (tsc.timeZoneID != null && !timeZoneId.equals(tsc.timeZoneID)) {
                tsc.timeZoneID = timeZoneId;
                tsc.timeZoneRawOffset = 0;
                this._dc.modified = true;
            }
        }
    }

    protected void saveForm() {
        this.saveDataContainer();
        RmaListModel model = (RmaListModel)this._pathCombo.getModel();
        Vector<DataContainer> modifiedDataContainers = new Vector<DataContainer>();
        for (int i = 0; i < model.getSize(); ++i) {
            DataContainerHolder dch = (DataContainerHolder)model.get(i);
            if (!dch.modified) continue;
            modifiedDataContainers.add(dch.dataContainer);
        }
        if (modifiedDataContainers.size() > 0) {
            this._listSelection.save(modifiedDataContainers);
        }
    }

    public void fillForm(List dataContainers) {
        this.clearForm();
        RmaListModel model = new RmaListModel(false);
        for (int i = 0; i < dataContainers.size(); ++i) {
            model.addElement((Object)new DataContainerHolder((DataContainer)dataContainers.get(i)));
        }
        this._pathCombo.setModel((ComboBoxModel)model);
        this._pathCombo.setSelectedIndex(0);
    }

    public void fillForm(DataContainerHolder dc) {
        this._dc = dc;
        if (dc == null) {
            this.clearForm();
            this.setModified(false);
            return;
        }
        try {
            this._verticalDatum = dc.dataContainer.extractVerticalDatum();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to extract Vertical Datum", e);
        }
        if (dc.dataContainer.otherInfo instanceof HecDSSRecordInfo) {
            HecDSSRecordInfo ri = (HecDSSRecordInfo)dc.dataContainer.otherInfo;
            String type = Integer.toString(ri.recordType) + ":  " + ri.recordTypeDescription;
            this._recTypeField.setText(type);
            if (dc.dataContainer instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc.dataContainer;
                if (tsc.type != null) {
                    this._typeField.setText(tsc.type);
                }
            }
            HecTime hTime = new HecTime(10);
            hTime.setTimeInMillis(dc.dataContainer.lastWriteTimeMillis);
            this._lastWrittenField.setText(hTime.toString(8));
            this._programNameField.setText(ri.programName);
            this._versionField.setText(Integer.toString(ri.version));
            if (ri.doubles) {
                this._precisionField.setText("Double");
            } else {
                this._precisionField.setText("Regular");
            }
            String dp = SupplementalInfo7.getDisplayPrecision(ri.precision, ri.recordType);
            this._displayPrecisionField.setText(dp);
            if (ri.passwordProtected) {
                this._passwordProtectedField.setText("Yes");
            } else {
                this._passwordProtectedField.setText("No");
            }
            this._numberValues.setText(Integer.toString(ri.numberData));
            this._spaceAllocated.setText(Integer.toString(ri.spaceAllocated));
            this._sizeEachValue.setText(Integer.toString(ri.sizeEachValue));
            if (ri.sizeEachQuality > 0) {
                this._quality.setText("Yes");
            } else {
                this._quality.setText("No");
            }
            this._sizeEachQuality.setText(Integer.toString(ri.sizeEachQuality));
            this._sizeIntegerNotes.setText(Integer.toString(ri.sizeEachInote));
            this._lengthCharacterNotes.setText(Integer.toString(ri.lengthCnotes));
            if (dc.dataContainer instanceof TimeSeriesContainer) {
                this._units.setText(((TimeSeriesContainer)dc.dataContainer).units);
            } else if (dc.dataContainer instanceof PairedDataContainer) {
                this._units.setText(((PairedDataContainer)dc.dataContainer).getYUnits());
            }
        }
        if (this._lastWrittenField.getText().trim().isEmpty()) {
            double dval = (double)dc.dataContainer.lastWriteTimeMillis / 1000.0;
            int val = (int)dval;
            HecTime time = new HecTime(val, 0);
            this._lastWrittenField.setText(time.toString(8));
        }
        if (dc.dataContainer.supplementalInfo != null) {
            VerticalDatumContainer vdc = null;
            try {
                vdc = dc.dataContainer.extractVerticalDatum();
                dc.dataContainer.insertVerticalDatum(null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to remove Vertical Datum from supplemental info", e);
            }
            this._supplementalInfo.setText(dc.dataContainer.supplementalInfo);
            if (vdc != null) {
                try {
                    dc.dataContainer.insertVerticalDatum(vdc);
                }
                catch (IOException | VerticalDatumException e) {
                    logger.log(Level.WARNING, "Failed to insert Vertical Datum", e);
                }
            }
        }
        this._coordinateSystemCombo.setSelectedIndex(this._dc.dataContainer.coordinateSystem);
        this._coordinateIDFld.setValue(this._dc.dataContainer.coordinateID);
        this._horizontalDatumCombo.setSelectedIndex(this._dc.dataContainer.horizontalDatum);
        this._horizontalUnitsCombo.setSelectedIndex(this._dc.dataContainer.horizontalUnits);
        this._xOrdinateFld.setValue(this._dc.dataContainer.xOrdinate);
        this._yOrdinateFld.setValue(this._dc.dataContainer.yOrdinate);
        if (this._verticalDatum != null) {
            this.fillVerticalDatum();
        }
        if (this._dc.dataContainer instanceof TimeSeriesContainer) {
            this._timeZoneIdFld.setEnabled(true);
            this._timeZoneIdLabel.setEnabled(true);
            TimeSeriesContainer tsc = (TimeSeriesContainer)dc.dataContainer;
            this._timeZoneIdFld.setText(tsc.timeZoneID);
        } else {
            this._timeZoneIdFld.setText(this._dc.dataContainer.locationTimezone);
        }
        this.setModified(this._dc.modified);
    }

    private void fillVerticalDatumValues() {
        try {
            double navd88 = Units.convertUnits((double)this._verticalDatum.getNAVD88Offset(), (String)this._verticalDatum.unit, (String)this.getVerticalDisplayUnit());
            this._shiftNAVD88Field.setValue(navd88);
        }
        catch (UnitsConversionException | VerticalDatumException ex) {
            this._shiftNAVD88Field.setText("");
        }
        try {
            double ngvd29 = Units.convertUnits((double)(this._verticalDatum.getNAVD88Offset() - this._verticalDatum.getNGVD29Offset()), (String)this._verticalDatum.unit, (String)this.getVerticalDisplayUnit());
            this._shiftNGVD29Field.setValue(ngvd29);
        }
        catch (UnitsConversionException | VerticalDatumException ex) {
            this._shiftNGVD29Field.setText("");
        }
    }

    private void fillVerticalDatum() {
        try {
            this._verticalDatumField.setText(this._verticalDatum.getCurrentVerticalDatum());
            this._verticalDatumUnitsField.setText(this._verticalDatum.unit);
            this.fillVerticalDatumValues();
            this._labelNAVD88.setText(this.getNAVD88Label());
            this._labelNGVD29.setText(this.getNGVD29Label());
        }
        catch (VerticalDatumException e) {
            logger.log(Level.WARNING, "Failed to get Vertical Datum", e);
        }
    }

    public void setModified(boolean b) {
        super.setModified(b);
        this.setTitle(this._title + (b ? "*" : ""));
    }

    public static String getDisplayPrecision(int precision, int recordType) {
        if (precision < 1) {
            return "Not Specified";
        }
        if (recordType >= 200 && recordType < 300) {
            int xprecision = precision / 10;
            int yprecision = precision - xprecision * 10;
            return HecDouble.formatPattern((int)xprecision) + ", " + HecDouble.formatPattern((int)yprecision);
        }
        return HecDouble.formatPattern((int)precision);
    }

    private String getVerticalDisplayUnit() {
        String unitStr;
        String string = unitStr = this._verticalDatum != null ? this._verticalDatum.unit : "";
        if (Units.isValidUnitsSystem((int)this._listSelection.getUnitSystem())) {
            try {
                Parameter elev = new Parameter("Elev");
                unitStr = elev.getUnitsStringForSystem(this._listSelection.getUnitSystem());
            }
            catch (DataSetIllegalArgumentException e) {
                logger.log(Level.WARNING, "Failed to get parameter for Elev", e);
            }
        }
        return unitStr;
    }

    private String getNAVD88Label() {
        String unitStr = "(" + this.getVerticalDisplayUnit() + ")";
        return "Shift to NAVD88" + unitStr + ":";
    }

    private String getNGVD29Label() {
        String unitStr = "(" + this.getVerticalDisplayUnit() + ")";
        return "Shift to NAVD88 from NGVD29" + unitStr + ":";
    }

    private class DataContainerHolder {
        DataContainer dataContainer;
        boolean modified;

        public DataContainerHolder(DataContainer dc) {
            this.dataContainer = dc;
        }

        public String toString() {
            return this.dataContainer.fullName;
        }
    }
}

