/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;

public class SupplementalInfoControlBuilder {
    private static final Insets INSET = new Insets(5, 5, 0, 5);
    Container container;
    GridBagConstraints gbc;

    public SupplementalInfoControlBuilder(Container container) {
        this.container = container;
        this.gbc = new GridBagConstraints();
    }

    RmaJComboBox addComboBox(String text, Character mnemonic, String[] choices, int x, int y, int width, boolean readOnly) {
        Vector<String> items = new Vector<String>();
        for (int i = 0; choices != null && i < choices.length; ++i) {
            items.add(choices[i]);
        }
        JLabel label = this.addLabel(text, x, y);
        if (mnemonic != null) {
            label.setDisplayedMnemonic(mnemonic.charValue());
        }
        RmaJComboBox comboBox = new RmaJComboBox(items);
        comboBox.setModifiable(!readOnly);
        label.setLabelFor((Component)comboBox);
        this.gbc.gridx = x + 1;
        this.gbc.gridy = y;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridwidth = width;
        this.gbc.anchor = 18;
        this.gbc.fill = 2;
        this.gbc.insets = INSET;
        this.container.add((Component)comboBox, this.gbc);
        return comboBox;
    }

    JLabel addLabel(String text, int x, int y) {
        JLabel label = new JLabel(text);
        return this.addLabel(label, x, y);
    }

    private JLabel addLabel(JLabel label, int x, int y) {
        this.gbc.gridx = x;
        this.gbc.gridy = y;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 18;
        this.gbc.fill = 0;
        this.gbc.insets = INSET;
        this.container.add((Component)label, this.gbc);
        return label;
    }

    JTextField addTextField(String text, int x, int y, int width) {
        return this.addTextField(text, null, x, y, width);
    }

    JTextField addTextField(String text, Character mnemonic, int x, int y, int width) {
        JLabel label = this.addLabel(text, x, y);
        return this.addTextField(label, mnemonic, x, y, width);
    }

    JTextField addTextField(JLabel label, Character mnemonic, int x, int y, int width) {
        this.addLabel(label, x, y);
        if (mnemonic != null) {
            label.setDisplayedMnemonic(mnemonic.charValue());
        }
        JTextField field = this.addTextField(x + 1, y, width);
        label.setLabelFor(field);
        return field;
    }

    RmaJIntegerField addIntegerField(String text, Character mnemonic, int x, int y, int width) {
        JLabel label = this.addLabel(text, x, y);
        RmaJIntegerField field = new RmaJIntegerField();
        if (mnemonic != null) {
            label.setDisplayedMnemonic(mnemonic.charValue());
        }
        label.setLabelFor((Component)field);
        this.gbc.gridx = x + 1;
        this.gbc.gridy = y;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 18;
        this.gbc.fill = 2;
        this.gbc.insets = INSET;
        this.container.add((Component)field, this.gbc);
        return field;
    }

    RmaJDecimalField addDoubleField(JLabel label, Character mnemonic, int x, int y, int width, boolean readOnly) {
        this.addLabel(label, x, y);
        RmaJDecimalField field = new RmaJDecimalField();
        if (mnemonic != null) {
            label.setDisplayedMnemonic(mnemonic.charValue());
        }
        label.setLabelFor((Component)field);
        field.setEditable(!readOnly);
        this.gbc.gridx = x + 1;
        this.gbc.gridy = y;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 18;
        this.gbc.fill = 2;
        this.gbc.insets = INSET;
        this.container.add((Component)field, this.gbc);
        return field;
    }

    RmaJDecimalField addDoubleField(String text, Character mnemonic, int x, int y, int width, boolean readOnly) {
        JLabel label = this.addLabel(text, x, y);
        return this.addDoubleField(label, mnemonic, x, y, width, readOnly);
    }

    private JTextField addTextField(int x, int y, int width) {
        JTextField field = new JTextField();
        field.setEditable(false);
        Color backgroundColor = new Color(245, 245, 245);
        field.setBackground(backgroundColor);
        this.gbc.gridx = x;
        this.gbc.gridy = y;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridwidth = width;
        this.gbc.anchor = 18;
        this.gbc.fill = 2;
        this.gbc.insets = INSET;
        this.container.add((Component)field, this.gbc);
        return field;
    }

    void addSeparator(int x, int y, int width) {
        JSeparator sep = new JSeparator();
        this.gbc.gridx = x;
        this.gbc.gridy = y;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridwidth = width;
        this.gbc.anchor = 18;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 5, 5);
        this.container.add((Component)sep, this.gbc);
    }

    public void addPanel(JPanel panel, int x, int y, int width) {
        this.gbc.gridx = x;
        this.gbc.gridy = y;
        this.gbc.gridwidth = width;
        this.gbc.anchor = 16;
        this.gbc.fill = 2;
        this.container.add((Component)panel, this.gbc);
    }
}

