/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.heclib.dss.DssIntervalUtility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;
import rma.swing.RmaJComboBox;

public class TimeIntervalPanel
extends JPanel
implements FocusListener {
    protected RmaJComboBox<String> _intervalCombo;
    public static final int REGULAR = 1;
    public static final int IRREGULAR = 2;
    public static final int BOTH = 3;

    public TimeIntervalPanel() {
        super(new GridBagLayout());
        this.buildControls(1, false);
    }

    public TimeIntervalPanel(int type) {
        super(new GridBagLayout());
        this.buildControls(type, false);
    }

    public TimeIntervalPanel(int type, boolean custom) {
        super(new GridBagLayout());
        this.buildControls(type, custom);
    }

    public void setMinimumInterval(int interval) {
        Object selected = null;
        if (this._intervalCombo.getSelectedIndex() > -1) {
            selected = this._intervalCombo.getSelectedItem();
        }
        List<String> intervals = TimeIntervalPanel.getIntervals(1, false);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this._intervalCombo.getModel();
        for (int i = 0; i < intervals.size(); ++i) {
            String s = intervals.get(i);
            if (s.startsWith("IR")) {
                model.removeElement(s);
                continue;
            }
            int intl = DssIntervalUtility.lookupSeconds((String)s) / 60;
            if (intl == -1 || intl >= interval) continue;
            model.removeElement(s);
        }
        this._intervalCombo.setSelectedIndex(-1);
        if (selected != null) {
            this._intervalCombo.setSelectedItem(selected);
        }
    }

    protected void buildControls(int type, boolean includeWaterYear) {
        List<String> intervals = TimeIntervalPanel.getIntervals(type, includeWaterYear);
        this._intervalCombo = new RmaJComboBox(intervals.toArray());
        this._intervalCombo.setSelectedIndex(-1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this._intervalCombo, gbc);
    }

    private static List<String> getIntervals(int type, boolean includeWaterYear) {
        List<String> intervals = new ArrayList<String>();
        if (type == 1) {
            intervals = IntervalFactory.findAllDss7(x -> x.isRegular()).stream().sorted(Comparator.comparingInt(Interval::getSeconds)).map(Object::toString).collect(Collectors.toList());
        } else if (type == 2) {
            intervals = IntervalFactory.findAllDss7(x -> !x.isRegular() && x.toString().startsWith("IR")).stream().map(Object::toString).collect(Collectors.toList());
        }
        if (includeWaterYear) {
            intervals.add("Water Year");
        }
        return intervals;
    }

    public String getIntervalString() {
        if (!this.hasValidData()) {
            return null;
        }
        return (String)this._intervalCombo.getSelectedItem();
    }

    public boolean hasValidData() {
        return this._intervalCombo.getSelectedIndex() >= 0;
    }

    @Override
    public void addKeyListener(KeyListener kl) {
    }

    public void addActionListener(ActionListener al) {
        this._intervalCombo.addActionListener(al);
    }

    public void addTimeIntervalFocusListener(FocusListener fl) {
        this.listenerList.add(FocusListener.class, fl);
        EventListener[] listeners = this.getListeners(FocusListener.class);
        if (listeners.length == 1) {
            this._intervalCombo.addFocusListener((FocusListener)this);
        }
    }

    @Override
    public void focusGained(FocusEvent fe) {
        EventListener[] listeners = this.getListeners(FocusListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((FocusListener)listeners[i]).focusGained(fe);
        }
    }

    @Override
    public void focusLost(FocusEvent fe) {
        EventListener[] listeners = this.getListeners(FocusListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((FocusListener)listeners[i]).focusLost(fe);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int cnt = this.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c = this.getComponent(i);
            c.setEnabled(enabled);
        }
    }

    @Override
    public void requestFocus() {
        this._intervalCombo.requestFocus();
    }
}

