/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.EventListener;
import javax.swing.JPanel;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;

public class TimeOffsetPanel
extends JPanel
implements FocusListener {
    protected RmaJIntegerField _offsetAmtFld;
    protected RmaJComboBox _offsetCombo;
    protected RmaJCheckBox _specifyOffsetCheck;
    protected String[] _offsetLengths = new String[]{"Minute", "Hour", "Day", "Week", "Month", "Year"};
    private boolean _optionalOffset;

    public TimeOffsetPanel() {
        this(true);
    }

    public TimeOffsetPanel(boolean optionalOffset) {
        super(new GridBagLayout());
        this.buildControls(optionalOffset);
    }

    protected void buildControls(boolean optionalOffset) {
        GridBagConstraints gbc;
        this._optionalOffset = optionalOffset;
        this._specifyOffsetCheck = new RmaJCheckBox("  Offset");
        this._specifyOffsetCheck.setMnemonic('O');
        if (optionalOffset) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this._specifyOffsetCheck, gbc);
        } else {
            this._specifyOffsetCheck.setSelected(true);
        }
        this._offsetAmtFld = new RmaJIntegerField();
        this._offsetAmtFld.setMinValue(0);
        this._offsetAmtFld.setColumns(5);
        this._offsetAmtFld.setEditable(!optionalOffset);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.ipadx = 20;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this._offsetAmtFld, gbc);
        this._offsetCombo = new RmaJComboBox((Object[])this._offsetLengths);
        this._offsetCombo.setEnabled(!optionalOffset);
        Font f = this._offsetAmtFld.getFont();
        if (f != null) {
            this._offsetCombo.setFont(f);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this._offsetCombo, gbc);
        this._specifyOffsetCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = TimeOffsetPanel.this._specifyOffsetCheck.isSelected();
                TimeOffsetPanel.this._offsetAmtFld.setEditable(enabled);
                TimeOffsetPanel.this._offsetCombo.setEnabled(enabled);
            }
        });
    }

    public String getIntervalString() {
        if (!this.hasValidData()) {
            return null;
        }
        if (this._specifyOffsetCheck.isSelected()) {
            return this._offsetAmtFld.getText() + this._offsetCombo.getSelectedItem();
        }
        return "0" + this._offsetLengths[0];
    }

    public boolean isOffsetSelected() {
        return this._specifyOffsetCheck.isSelected();
    }

    public boolean hasValidData() {
        if (!this._specifyOffsetCheck.isSelected()) {
            return true;
        }
        if (this._offsetAmtFld.getText().length() < 1) {
            return false;
        }
        int amt = this._offsetAmtFld.getValue();
        return this._offsetCombo.getSelectedIndex() >= 0;
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        this._offsetAmtFld.addKeyListener(kl);
    }

    public void addActionListener(ActionListener al) {
        this._specifyOffsetCheck.addActionListener(al);
    }

    public void addTimeIntervalFocusListener(FocusListener fl) {
        this.listenerList.add(FocusListener.class, fl);
        EventListener[] listeners = this.getListeners(FocusListener.class);
        if (listeners.length == 1) {
            this._offsetAmtFld.addFocusListener((FocusListener)this);
            this._offsetCombo.addFocusListener((FocusListener)this);
        }
    }

    @Override
    public void focusGained(FocusEvent fe) {
        EventListener[] listeners = this.getListeners(FocusListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((FocusListener)listeners[i]).focusGained(fe);
        }
    }

    @Override
    public void focusLost(FocusEvent fe) {
        EventListener[] listeners = this.getListeners(FocusListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((FocusListener)listeners[i]).focusLost(fe);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int cnt = this.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c = this.getComponent(i);
            c.setEnabled(enabled);
        }
        if (this._optionalOffset) {
            enabled = this._specifyOffsetCheck.isSelected();
            this._offsetAmtFld.setEditable(enabled);
            this._offsetCombo.setEnabled(enabled);
        }
    }

    @Override
    public void requestFocus() {
        if (this._optionalOffset) {
            this._specifyOffsetCheck.requestFocus();
        } else {
            this._offsetAmtFld.requestFocus();
        }
    }

    public void setMinimumValue(int minVal) {
        this._offsetAmtFld.setMinValue(minVal);
    }
}

