/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.Help;
import hec.dssgui.ListSelection;
import hec.dssgui.TimeSeriesDataEntryPanel;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataManager;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import rma.swing.RmaJDialog;

public class TimeSeriesDataEntry
extends RmaJDialog {
    protected TimeSeriesDataEntryPanel _entryPanel;
    protected JPanel _buttonPanel;
    protected JButton _plotButton;
    protected JButton _graphicalEditButton;
    protected JButton _saveButton;
    protected JButton _cancelButton;
    protected DssDataManager _dataManager = null;
    protected boolean _dataSaved = false;
    protected JFrame _parent = null;
    protected int _writeStatus = 0;
    protected TimeSeriesContainer _timeSeriesContainer;
    boolean _fComponentsAdjusted = false;

    public TimeSeriesDataEntry(JFrame parent, DssDataManager dataManager) {
        this(parent, dataManager, null);
    }

    public TimeSeriesDataEntry(JFrame parent, DssDataManager dataManager, TimeSeriesContainer timeSeriesContainer) {
        super((Frame)parent);
        this._parent = parent;
        this.setDefaultCloseOperation(0);
        this._dataManager = dataManager;
        this._timeSeriesContainer = timeSeriesContainer;
        this.setup();
        if (this._timeSeriesContainer != null && this._timeSeriesContainer.numberValues > 0) {
            this.setData(timeSeriesContainer);
        }
    }

    public void setPathname(String pathname) {
        this._entryPanel.setDSSPathname(pathname);
    }

    public String getPathname() {
        DSSPathname path = this._entryPanel.getDSSPathname();
        return path.getPathname();
    }

    public void setStartTime(String dateTime) {
        HecTime time = new HecTime(dateTime);
        if (time.isDefined()) {
            this._entryPanel.setStartTime(time);
        }
    }

    public void setup() {
        this.setTitle("Time Series Data Entry");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setSize(500, 700);
        this.setLocationRelativeTo(this.getParent());
        this._plotButton = new JButton();
        this._graphicalEditButton = new JButton();
        this._saveButton = new JButton();
        this._cancelButton = new JButton();
        this.build();
        if (this._timeSeriesContainer != null) {
            this.enableButtons();
        }
    }

    protected void enableButtons() {
        this._plotButton.setEnabled(true);
        this._graphicalEditButton.setEnabled(true);
        this._saveButton.setEnabled(true);
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this._fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this._fComponentsAdjusted = true;
    }

    protected void graphicalEdit() {
        if (this._parent instanceof ListSelection) {
            this._entryPanel.updateContainers();
            ((ListSelection)this._parent).graphicalEdit(this._entryPanel.getData());
        }
    }

    public boolean saveData() {
        return this._entryPanel.saveData();
    }

    public void setData(List data) {
        this._entryPanel.setData(data);
        this.enableButtons();
    }

    public void setData(TimeSeriesContainer tsc) {
        this._entryPanel.setData(tsc);
        this.enableButtons();
    }

    public void setCheckDataAlreadyExists(boolean checkDataAlreadyExists) {
        this._entryPanel.setCheckDataAlreadyExists(checkDataAlreadyExists);
    }

    protected void setStartDate() {
        this._entryPanel.setStartDate();
    }

    protected void setStartTime() {
        this._entryPanel.setStartTime();
    }

    protected void setEndDate() {
        this._entryPanel.setEndDate();
    }

    protected void setEndTime() {
        this._entryPanel.setEndTime();
    }

    protected void build() {
        this.buildEntryPanel();
        this.buildOKButtonPanel();
        this.registerListeners();
        Help.setHelp((RootPaneContainer)((Object)this), "34");
    }

    protected void buildEntryPanel() {
        this._entryPanel = new TimeSeriesDataEntryPanel(this._parent, this._dataManager, this._timeSeriesContainer);
        this._entryPanel.build();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)((Object)this._entryPanel), gbc);
    }

    protected void buildOKButtonPanel() {
        this._buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._buttonPanel, gbc);
        this._plotButton.setText("Plot");
        this._plotButton.setEnabled(false);
        this._plotButton.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(36, 0, 16, 0);
        gbc.ipadx = 15;
        gbc.ipady = 3;
        this._buttonPanel.add((Component)this._plotButton, gbc);
        this._graphicalEditButton.setText("Graphically Edit");
        this._graphicalEditButton.setEnabled(false);
        this._graphicalEditButton.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(36, 20, 16, 0);
        gbc.ipadx = 15;
        gbc.ipady = 3;
        this._buttonPanel.add((Component)this._graphicalEditButton, gbc);
        this._saveButton.setText("Save");
        this._saveButton.setEnabled(false);
        this._saveButton.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(36, 20, 16, 0);
        gbc.ipadx = 15;
        gbc.ipady = 3;
        this._buttonPanel.add((Component)this._saveButton, gbc);
        this._cancelButton.setText("Cancel");
        this._cancelButton.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(36, 20, 16, 0);
        gbc.ipadx = 15;
        gbc.ipady = 3;
        this._buttonPanel.add((Component)this._cancelButton, gbc);
    }

    protected void registerListeners() {
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this._plotButton.addActionListener(lSymAction);
        this._graphicalEditButton.addActionListener(lSymAction);
        this._cancelButton.addActionListener(lSymAction);
        this._saveButton.addActionListener(lSymAction);
    }

    protected boolean cancelButtonActionPerformed() {
        if (this._entryPanel.hasDataChanged()) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Save data?", "Save Changes", 1);
            if (n == 0) {
                this.saveData();
            } else if (n == 2) {
                return true;
            }
        }
        this._writeStatus = 0;
        this.setVisible(false);
        if (this._dataSaved && this._parent instanceof ListSelection) {
            ListSelection parent = (ListSelection)this._parent;
            parent.updateCatalog();
        }
        return false;
    }

    void plotButtonActionPerformed(ActionEvent event) {
        this._entryPanel.updateContainers();
        this._entryPanel.getTable().plot(this._parent);
    }

    void okButtonActionPerformed(ActionEvent event) {
        boolean status = this.saveData();
        if (status) {
            this._writeStatus = 0;
            this.setVisible(false);
            if (this._dataSaved && this._parent instanceof ListSelection) {
                ListSelection parent = (ListSelection)this._parent;
                parent.updateCatalog();
            }
        }
    }

    void JFrame1_WindowClosing(WindowEvent event) {
        this.cancelButtonActionPerformed();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == TimeSeriesDataEntry.this) {
                TimeSeriesDataEntry.this.JFrame1_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == TimeSeriesDataEntry.this._plotButton) {
                TimeSeriesDataEntry.this.plotButtonActionPerformed(event);
            } else if (object == TimeSeriesDataEntry.this._graphicalEditButton) {
                TimeSeriesDataEntry.this.graphicalEdit();
            } else if (object == TimeSeriesDataEntry.this._saveButton) {
                TimeSeriesDataEntry.this.okButtonActionPerformed(event);
            } else if (object == TimeSeriesDataEntry.this._cancelButton) {
                TimeSeriesDataEntry.this.cancelButtonActionPerformed();
            }
        }
    }
}

