/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dataTable.HecDataTable;
import hec.dataTable.TimeSeriesDataModel;
import hec.dssgui.ListSelection;
import hec.dssgui.TimeSeriesDataEntry;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.HecTime;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class TimeSeriesDataEntryPanel
extends hec.dataui.dataentry.TimeSeriesDataEntryPanel {
    protected DssDataManager _dataManager = null;
    protected boolean _dataSaved = false;
    protected boolean _checkDataAlreadyExists = true;
    protected JFrame _parent = null;
    protected int _writeStatus = 0;

    public TimeSeriesDataEntryPanel(JFrame parent, DssDataManager dataManager) {
        this(parent, dataManager, null);
    }

    public TimeSeriesDataEntryPanel(JFrame parent, DssDataManager dataManager, TimeSeriesContainer timeSeriesContainer) {
        super(timeSeriesContainer);
        this._parent = parent;
        this._dataManager = dataManager;
    }

    protected HecDataTable createTable() {
        return new HecDataTable((Component)this._parent);
    }

    protected void graphicalEdit() {
        this.updateContainers();
        if (this._timeSeriesContainer == null || this._timeSeriesContainer.values.length == 0 || this._timeSeriesContainer.times.length == 0) {
            JOptionPane.showMessageDialog(null, "There are no values in the table", "", 2);
            return;
        }
        if (this._parent instanceof ListSelection) {
            this.updateContainers();
            ((ListSelection)this._parent).graphicalEdit(this._timeSeriesContainer);
        }
    }

    public void updateContainers() {
        if (this._timeSeriesContainer != null) {
            this._timeSeriesContainer.times = null;
            this._timeSeriesContainer.values = null;
        }
        super.updateContainers();
        if (this._timeSeriesContainer != null) {
            this._table.setData((DataContainer)this._timeSeriesContainer, false, 0);
            this._table.setEditable(true);
            this._table.setExtendable(true, 2);
        }
    }

    public boolean saveData() {
        String defaultFileName;
        this.updateContainers();
        if (this._timeSeriesContainer == null || this._timeSeriesContainer.values == null || this._timeSeriesContainer.values.length == 0 || this._timeSeriesContainer.times == null || this._timeSeriesContainer.times.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "There are no values in the table", "", 2);
            return false;
        }
        if (this._timeSeriesContainer != null && this._timeSeriesContainer.interval == 0 && this._timeSeriesContainer.times.length > 1) {
            int previousTime = this._timeSeriesContainer.times[0];
            for (int i = 1; i < this._timeSeriesContainer.times.length; ++i) {
                if (this._timeSeriesContainer.times[i] < previousTime) {
                    HecTime prevTime = new HecTime();
                    prevTime.setSeconds((long)previousTime);
                    HecTime thisTime = new HecTime();
                    thisTime.setSeconds((long)this._timeSeriesContainer.times[i]);
                    String message = "Date / time is not ascending:\n" + thisTime.toString() + " (row " + (i + 1) + ") occurs before\n" + prevTime.toString() + " (row " + i + ")";
                    JOptionPane.showMessageDialog((Component)((Object)this), message, "", 2);
                    return false;
                }
                previousTime = this._timeSeriesContainer.times[i];
            }
        }
        if (TimeSeriesDataModel.getGlobalViewTimeZone() != null) {
            this._timeSeriesContainer.timeZoneID = TimeSeriesDataModel.getGlobalViewTimeZone().getID();
            this._timeSeriesContainer.timeZoneRawOffset = TimeSeriesDataModel.getGlobalViewTimeZone().getRawOffset();
        }
        if (this._writeStatus != 0 && !this._dataManager.fileOpened() && (defaultFileName = HecDataManager.defaultDSSFileName()) != null && defaultFileName.length() > 0) {
            this._dataManager.setDSSFileName(defaultFileName, true);
        }
        if (this._parent instanceof ListSelection && this._checkDataAlreadyExists) {
            Vector<String> paths = new Vector<String>();
            paths.add(this._timeSeriesContainer.fullName);
            Vector<String> paths2 = new Vector<String>();
            paths2.add(this._timeSeriesContainer.fullName);
            ListSelection parent = (ListSelection)this._parent;
            int option = parent.checkOverwriteRecords(this._dataManager, paths, paths2);
            if (option == 2) {
                return false;
            }
            if (option == 1) {
                return false;
            }
        }
        this._writeStatus = this._timeSeriesContainer != null ? this._dataManager.writeData(this._timeSeriesContainer) : -1;
        if (this._writeStatus >= 0 && this._writeStatus < 10) {
            int answer;
            this._writeStatus = 0;
            this._dataSaved = true;
            this._table.setDataChanged(false);
            if (this._parent instanceof ListSelection) {
                ListSelection parent = (ListSelection)this._parent;
                parent.refreshCatalog();
            }
            return (answer = this.askReturnToDataEntryScreen()) != 0;
        }
        String message = "Error in saving record:  " + this._timeSeriesContainer.fullName + "\nCheck log window for error message.";
        JOptionPane.showMessageDialog((Component)((Object)this), message, "Could Not Save Data Set", 2);
        this._timeSeriesContainer.fileName = "";
        return false;
    }

    protected int askReturnToDataEntryScreen() {
        String message = "Record saved:  " + this._timeSeriesContainer.fullName + "\nReturn to data entry screen?";
        int answer = JOptionPane.showConfirmDialog((Component)((Object)this), message, "Data Set Saved", 0);
        return answer;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent event) {
        Object object = event.getSource();
        if (object == this._startDateTextField) {
            this.setStartDate();
        } else if (object == this._startTimeTextField) {
            this.setStartTime();
        } else if (object == this._endDateTextField) {
            this.setEndDate();
        } else if (object == this._endTimeTextField) {
            this.setEndTime();
        } else if (object == this._unitsTextField) {
            this.updateUnits();
        }
    }

    protected void setButtonsEnabled() {
        super.setButtonsEnabled();
        Window w = SwingUtilities.windowForComponent((Component)((Object)this));
        if (w instanceof TimeSeriesDataEntry) {
            TimeSeriesDataEntry parent = (TimeSeriesDataEntry)((Object)w);
            parent._plotButton.setEnabled(true);
            parent._graphicalEditButton.setEnabled(true);
            parent._saveButton.setEnabled(true);
        }
    }

    public void setCheckDataAlreadyExists(boolean checkDataAlreadyExists) {
        this._checkDataAlreadyExists = checkDataAlreadyExists;
    }

    protected void setStartDate() {
        super.setStartDate();
    }

    protected void setStartTime() {
        super.setStartTime();
    }

    protected void setEndDate() {
        super.setEndDate();
    }

    protected void setEndTime() {
        super.setEndTime();
    }

    protected HecDataTable getTable() {
        return this._table;
    }

    public TimeSeriesContainer getContainer() {
        return this.getData();
    }

    public boolean hasDataChanged() {
        return this._table.hasDataChanged();
    }

    public boolean wasDataSaved() {
        return this._dataSaved;
    }
}

