/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ComputablePanel;
import hec.dssgui.MathFrame2;
import hec.dssgui.MathPanel;
import hec.dssgui.MathTab;
import hec.dssgui.TimeIntervalPanel;
import hec.dssgui.TimeOffsetPanel;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssIntervalUtility;
import hec.heclib.util.HecTime;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import rma.swing.CheckBoxPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJRadioButton;
import rma.swing.list.RmaListModel;

public class TransformTab
extends MathPanel
implements MathTab {
    private static final String[] _functionStrings = new String[]{"Interpolate at end of Period", "Maximum for Period", "Minimum for Period", "Average over Period", "Accumulation over Period", "Volume for Period", "Integration over Period", "Number of Valid Data over Period"};
    private static final String[] _functions = new String[]{"INT", "MAX", "MIN", "AVE", "ACC", "VOL", "ITG", "NUM"};
    public static final String CHANGE_INTERVAL = "Change Time Interval";
    public static final String VALUE_OVER_PERIOD = "Min/Max/Avg/... Over Period";
    public static final String IRREGULAR_TO_REGULAR = "Irregular to Regular";
    public static final String REGULAR_TO_IRREGULAR = "Regular to Irregular";
    public static final String IRREGULAR_TO_PSEUDO = "Irregular to Pseudo-regular";
    public static final String PSEUDO_TO_IRREGULAR = "Pseudo-regular to Irregular";
    public static final String TIME_COPY = "Copy in Time";
    public static final String TIME_SHIFT = "Shift in Time";
    public static final String EXTRACT_TIMESERIES = "Extract Time Series";
    public static final String TO_IRREGULAR_PATTERN = "To Irregular using Pattern";
    private static String[] _operators = new String[]{"Min/Max/Avg/... Over Period", "Copy in Time", "Shift in Time", "Change Time Interval", "Irregular to Regular", "Regular to Irregular", "Irregular to Pseudo-regular", "Pseudo-regular to Irregular", "To Irregular using Pattern", "Extract Time Series"};
    protected TransformTSPanel _transformTSPanel;
    protected IrregularToRegularPanel _irregular2RegularPanel;
    protected IrregularToPseudoPanel _irregularToPseudoPanel;
    protected PseudoToIrregularPanel _pseudoToIrregularPanel;
    protected TimeShiftPanel _timeShiftPanel;
    protected TimeShiftPanel _timeCopyPanel;
    protected ExtractTimeSeriesPanel _extractTimeSeriesPanel;
    protected TransformTimeSeriesPanel _transFormTimeSeriesPanel;
    protected InterpolateAtRegularPanel _interpolateAtRegularPanel;
    protected RegularToIrregularPanel _regularToIrregularPanel;

    public TransformTab(MathFrame2 parent) {
        super(parent);
    }

    @Override
    protected void buildPanel() {
        super.buildPanel();
        this._opCombo.setModel(new RmaListModel(false, (Object[])_operators));
        this._opCombo.setMaximumRowCount(_operators.length);
        final CardLayout cl = (CardLayout)this._cardPanel.getLayout();
        this._interpolateAtRegularPanel = new InterpolateAtRegularPanel();
        this._cardPanel.add(CHANGE_INTERVAL, this._interpolateAtRegularPanel);
        this._irregular2RegularPanel = new IrregularToRegularPanel();
        this._cardPanel.add(IRREGULAR_TO_REGULAR, this._irregular2RegularPanel);
        this._irregularToPseudoPanel = new IrregularToPseudoPanel();
        this._cardPanel.add(IRREGULAR_TO_PSEUDO, this._irregularToPseudoPanel);
        this._pseudoToIrregularPanel = new PseudoToIrregularPanel();
        this._cardPanel.add(PSEUDO_TO_IRREGULAR, this._pseudoToIrregularPanel);
        this._transformTSPanel = new TransformTSPanel();
        this._cardPanel.add(VALUE_OVER_PERIOD, this._transformTSPanel);
        this._regularToIrregularPanel = new RegularToIrregularPanel();
        this._cardPanel.add(REGULAR_TO_IRREGULAR, this._regularToIrregularPanel);
        this._timeShiftPanel = new TimeShiftPanel("Shift");
        this._cardPanel.add(TIME_SHIFT, this._timeShiftPanel);
        this._timeCopyPanel = new TimeShiftPanel("Copy");
        this._cardPanel.add(TIME_COPY, this._timeCopyPanel);
        this._extractTimeSeriesPanel = new ExtractTimeSeriesPanel();
        this._cardPanel.add(EXTRACT_TIMESERIES, this._extractTimeSeriesPanel);
        this._transFormTimeSeriesPanel = new TransformTimeSeriesPanel();
        this._transFormTimeSeriesPanel.setShowSelectedContainer(false);
        this._transFormTimeSeriesPanel.setListClassType(TimeSeriesContainer.class);
        this._transFormTimeSeriesPanel.setSelectedClassType(TimeSeriesContainer.class);
        this._transFormTimeSeriesPanel.setDataSetLabel("Data Set for Time Pattern", 'D');
        this._cardPanel.add(TO_IRREGULAR_PATTERN, this._transFormTimeSeriesPanel);
        this._opCombo.setSelectedIndex(-1);
        this._opCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransformTab.this._opCombo.getSelectedIndex();
                cl.show(TransformTab.this._cardPanel, (String)TransformTab.this._opCombo.getSelectedItem());
                TransformTab.this.setComputeButtonEnabled(TransformTab.this.isComputable());
            }
        });
        this._opCombo.setSelectedIndex(0);
    }

    @Override
    public boolean compute() {
        TimeSeriesContainer outputDc = null;
        TimeSeriesMath mathGuy = null;
        TimeSeriesMath outputMath = null;
        ArrayList<TimeSeriesContainer> timeShiftContainers = new ArrayList<TimeSeriesContainer>();
        ArrayList<TimeSeriesContainer> timeShiftContainersUpdated = new ArrayList<TimeSeriesContainer>();
        String op = (String)this._opCombo.getSelectedItem();
        int[] selection = this.getSelectedIndices();
        DataContainer[] containers = this._parent.getDataSets(selection);
        for (int j = 0; j < selection.length; ++j) {
            DataContainer dc = containers[j];
            if (!(dc instanceof TimeSeriesContainer)) {
                return false;
            }
            mathGuy = this._tsmath;
            outputDc = new TimeSeriesContainer();
            try {
                mathGuy.setData(dc);
            }
            catch (HecMathException e) {
                System.out.println("compute: Exception : " + e);
                return false;
            }
            try {
                HecMath tmpMath;
                int i;
                if (VALUE_OVER_PERIOD.equals(op)) {
                    String msg;
                    int opt;
                    this._transformTSPanel.setSelectedDataContainer(dc);
                    boolean toIrregular = this._transformTSPanel.isSetAsIrregular();
                    if (this._transformTSPanel.getFunction() == "ACC" && ((TimeSeriesContainer)dc).type.equalsIgnoreCase("INST-CUM") && (opt = JOptionPane.showConfirmDialog(this, (msg = "Selected time series data is of type INST-CUM.  Performing an \naccumulation of this type of data may not produce the desired result.") + "\n\n Do you wish to continue with the compute?", "Performing Accumulation on INST-CUM data", 0)) == 1) {
                        return false;
                    }
                    String intl = this._transformTSPanel.getTimeIntervalString();
                    boolean waterYear = false;
                    if (intl.equals("Water Year")) {
                        waterYear = true;
                        intl = "1Year";
                        this._tsmath = (TimeSeriesMath)this._tsmath.shiftInTime("92Days");
                    }
                    outputMath = this._tsmath.transformTimeSeries(intl, this._transformTSPanel.getTimeOffsetString(), this._transformTSPanel.getFunction(), toIrregular);
                    if (waterYear) {
                        outputMath = outputMath.shiftInTime("-92Days");
                        DSSPathname path = new DSSPathname(outputMath.getPath());
                        String fPart = path.getFPart();
                        path.setFPart(fPart + " - WY");
                        outputMath.setPathname(path.pathname());
                    }
                    if (toIrregular) {
                        outputMath = outputMath.convertToIrregular(this._transformTSPanel.getBlockSize());
                    }
                } else if (IRREGULAR_TO_REGULAR.equals(op)) {
                    this._irregular2RegularPanel.setSelectedDataContainer(dc);
                    outputMath = this._irregular2RegularPanel.isSnapSelected() ? this._tsmath.snapToRegularInterval(this._irregular2RegularPanel.getTimeIntervalString(), this._irregular2RegularPanel.getTimeOffsetString(), this._irregular2RegularPanel.getTimeBackString(), this._irregular2RegularPanel.getTimeForwardString()) : this._tsmath.interpolateDataAtRegularInterval(this._irregular2RegularPanel.getTimeIntervalString(), this._irregular2RegularPanel.getTimeOffsetString());
                } else if (IRREGULAR_TO_PSEUDO.equals(op)) {
                    this._irregularToPseudoPanel.setSelectedDataContainer(dc);
                    outputMath = this._irregularToPseudoPanel.compute(this._tsmath);
                    this._parent.setForceCatalogUpdate(true);
                } else if (PSEUDO_TO_IRREGULAR.equals(op)) {
                    this._pseudoToIrregularPanel.setSelectedDataContainer(dc);
                    outputMath = this._pseudoToIrregularPanel.compute(this._tsmath);
                    this._parent.setForceCatalogUpdate(true);
                } else if (TIME_COPY.equals(op)) {
                    this._timeCopyPanel.setSelectedDataContainer(dc);
                    String amount = this._timeCopyPanel.getTimeShiftString();
                    outputMath = this._tsmath.shiftInTime(amount);
                } else if (TIME_SHIFT.equals(op)) {
                    this._timeShiftPanel.setSelectedDataContainer(dc);
                    TimeSeriesContainer tsc = (TimeSeriesContainer)((TimeSeriesContainer)dc).clone();
                    String amount = this._timeShiftPanel.getTimeShiftString();
                    outputMath = this._tsmath.shiftInTime(amount);
                    for (i = 0; i < tsc.numberValues; ++i) {
                        tsc.values[i] = -3.4028234663852886E38;
                    }
                    tsc.modified = true;
                    timeShiftContainers.add(tsc);
                    tsc = (TimeSeriesContainer)outputMath.getData();
                    tsc.modified = true;
                    timeShiftContainers.add(tsc);
                    timeShiftContainersUpdated.add(tsc);
                    outputMath = null;
                } else if (CHANGE_INTERVAL.equals(op)) {
                    this._interpolateAtRegularPanel.setSelectedDataContainer(dc);
                    outputMath = this._tsmath.interpolateDataAtRegularInterval(this._interpolateAtRegularPanel.getTimeIntervalString(), this._interpolateAtRegularPanel.getTimeOffsetString());
                } else if (REGULAR_TO_IRREGULAR.equals(op)) {
                    this._regularToIrregularPanel.setSelectedDataContainer(dc);
                    outputMath = this._tsmath.convertToIrregular(this._regularToIrregularPanel.getTimeIntervalString(), this._regularToIrregularPanel.getRemoveMissing());
                } else if (EXTRACT_TIMESERIES.equals(op)) {
                    this._extractTimeSeriesPanel.setSelectedDataContainer(dc);
                    String timeLevel = this._extractTimeSeriesPanel.getTimeLevelString();
                    String range = this._extractTimeSeriesPanel.getRange();
                    boolean isInclusive = this._extractTimeSeriesPanel.isInclusive();
                    int intervalWindow = this._extractTimeSeriesPanel.getIntervalWindow();
                    boolean setAsIrregular = this._extractTimeSeriesPanel.getIsIrregular();
                    outputMath = this._tsmath.extractTimeSeriesDataForTimeSpecification(timeLevel, range, isInclusive, intervalWindow, setAsIrregular);
                    if (outputMath != null) {
                        TimeSeriesContainer tsc = new TimeSeriesContainer();
                        outputMath.getData((DataContainer)tsc);
                        tsc.modified = true;
                        this._parent.addDataSet((DataContainer)tsc);
                        return true;
                    }
                } else if (TO_IRREGULAR_PATTERN.equals(op) && (outputMath = this._tsmath.transformTimeSeries(tmpMath = HecMath.createInstance((DataContainer)this._transFormTimeSeriesPanel.getSelectedDataContainer()), this._transFormTimeSeriesPanel.getFunction(), true)) != null) {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)tsc);
                    tsc.modified = true;
                    this._parent.addDataSet((DataContainer)tsc);
                    return true;
                }
                if (outputMath == null) continue;
                outputMath.getData((DataContainer)outputDc);
                TimeSeriesContainer tsc = outputDc;
                if (tsc.values == null || tsc.values.length < 1) {
                    throw new Exception("No valid values computed");
                }
                boolean allMissing = true;
                for (i = 0; i < tsc.values.length; ++i) {
                    if (tsc.values[i] == -3.4028234663852886E38) continue;
                    allMissing = false;
                    break;
                }
                if (allMissing) {
                    throw new Exception("No valid values computed");
                }
                this._parent.setSelectedIndex(selection[j]);
                this._parent.updateSelectedDataSet((DataContainer)outputDc);
                continue;
            }
            catch (Exception e) {
                System.out.println("Compute: Exception. Operator: " + op + " " + e);
                JOptionPane.showMessageDialog(this, e.toString(), "Compute Error.  Operator:" + op, 0);
                return false;
            }
        }
        if (TIME_SHIFT.equals(op)) {
            return this.savetimeShiftResults(selection, timeShiftContainers, timeShiftContainersUpdated);
        }
        return outputMath != null;
    }

    private boolean savetimeShiftResults(int[] selection, List<TimeSeriesContainer> timeShiftContainers, List<TimeSeriesContainer> timeShiftContainersUpdated) {
        boolean bCwms = false;
        ArrayList<TimeSeriesContainer> nonCWmsTimeShiftContainers = new ArrayList<TimeSeriesContainer>();
        ArrayList<TimeSeriesContainer> nonCwmsTimeShiftContainersUpdated = new ArrayList<TimeSeriesContainer>();
        ArrayList<Integer> nonCwmsSelection = new ArrayList<Integer>();
        ArrayList<String> oracleRecords = new ArrayList<String>();
        for (int index = 0; index < timeShiftContainers.size() / 2; ++index) {
            TimeSeriesContainer tsContainer = timeShiftContainers.get(2 * index);
            TimeSeriesContainer tsContainerShifted = timeShiftContainers.get(2 * index + 1);
            DSSPathname dssPathName = new DSSPathname(tsContainer.fullName);
            if (dssPathName.isCwmsTsId()) {
                bCwms = true;
                oracleRecords.add(tsContainer.fullName);
                continue;
            }
            nonCWmsTimeShiftContainers.add(tsContainer);
            nonCWmsTimeShiftContainers.add(tsContainerShifted);
            nonCwmsTimeShiftContainersUpdated.add(timeShiftContainersUpdated.get(index));
            nonCwmsSelection.add(selection[index]);
        }
        if (bCwms) {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("Timeshift function is disabled for CWMS Database timeseries:");
            for (int i = 0; i < (oracleRecords.size() > 3 ? 3 : oracleRecords.size()); ++i) {
                strBuilder.append("\n");
                strBuilder.append((String)oracleRecords.get(i));
            }
            if (oracleRecords.size() > 3) {
                strBuilder.append("\n...");
            }
            strBuilder.append("\nPlease export the " + oracleRecords.size() + " CWMS timeseries into a DSS file and shift time in DSS\nand import the timeseries back into CWMS database");
            JOptionPane.showMessageDialog(this, strBuilder.toString(), "Time Shift Function Disabled for CWMS Database", 1);
            if (nonCwmsSelection.isEmpty()) {
                return false;
            }
        }
        String mess = "Compute complete.\nTime Shift requires original data to be removed before saving shifted data.\nOkay to remove original and save shifted data now,\nor save with a different name?";
        Object[] options = new Object[]{"Remove", "Save As", "Cancel"};
        switch (JOptionPane.showOptionDialog(this, mess, "Save to Disk", -1, 3, null, options, options[0])) {
            case 0: {
                this._parent.saveAction(new Vector(nonCWmsTimeShiftContainers));
                this.updateSelectedDataSet(nonCwmsTimeShiftContainersUpdated, nonCwmsSelection);
                return true;
            }
            case 1: {
                this._parent.save(new Vector(nonCwmsTimeShiftContainersUpdated), true);
                this.updateSelectedDataSet(nonCwmsTimeShiftContainersUpdated, nonCwmsSelection);
                return true;
            }
        }
        JOptionPane.showMessageDialog(this, "Operation canceled.");
        return false;
    }

    private void updateSelectedDataSet(List<TimeSeriesContainer> nonCwmsTimeShiftContainersUpdated, List<Integer> nonCwmsSelection) {
        for (int j = 0; j < nonCwmsTimeShiftContainersUpdated.size(); ++j) {
            TimeSeriesContainer tsc = nonCwmsTimeShiftContainersUpdated.get(j);
            tsc.modified = false;
            this._parent.setSelectedIndex(nonCwmsSelection.get(j));
            this._parent.updateSelectedDataSet((DataContainer)tsc);
            tsc.modified = false;
        }
        this._parent.setModified(false);
        this._parent.setForceCatalogUpdate(true);
    }

    @Override
    public Vector getSelectedDataSets() {
        String op = (String)this._opCombo.getSelectedItem();
        if (op.equals(TIME_SHIFT)) {
            return this._timeShiftPanel.getSelectedDataSets();
        }
        if (op.equals(TIME_COPY)) {
            return this._timeCopyPanel.getSelectedDataSets();
        }
        if (op.equals(CHANGE_INTERVAL)) {
            return this._interpolateAtRegularPanel.getSelectedDataSets();
        }
        if (op.equals(VALUE_OVER_PERIOD)) {
            return this._transformTSPanel.getSelectedDataSets();
        }
        if (op.equals(IRREGULAR_TO_REGULAR)) {
            return this._irregular2RegularPanel.getSelectedDataSets();
        }
        if (op.equals(REGULAR_TO_IRREGULAR)) {
            return this._regularToIrregularPanel.getSelectedDataSets();
        }
        if (IRREGULAR_TO_PSEUDO.equals(op)) {
            return this._irregularToPseudoPanel.getSelectedDataSets();
        }
        if (PSEUDO_TO_IRREGULAR.equals(op)) {
            return this._pseudoToIrregularPanel.getSelectedDataSets();
        }
        return super.getSelectedDataSets();
    }

    @Override
    public int[] getSelectedIndices() {
        String op = (String)this._opCombo.getSelectedItem();
        if (op.equals(TIME_SHIFT)) {
            return this._timeShiftPanel.getSelectedIndices();
        }
        if (op.equals(TIME_COPY)) {
            return this._timeCopyPanel.getSelectedIndices();
        }
        if (op.equals(CHANGE_INTERVAL)) {
            return this._interpolateAtRegularPanel.getSelectedIndices();
        }
        if (op.equals(VALUE_OVER_PERIOD)) {
            return this._transformTSPanel.getSelectedIndices();
        }
        if (op.equals(IRREGULAR_TO_REGULAR)) {
            return this._irregular2RegularPanel.getSelectedIndices();
        }
        if (op.equals(REGULAR_TO_IRREGULAR)) {
            return this._regularToIrregularPanel.getSelectedIndices();
        }
        if (IRREGULAR_TO_PSEUDO.equals(op)) {
            return this._irregularToPseudoPanel.getSelectedIndices();
        }
        if (PSEUDO_TO_IRREGULAR.equals(op)) {
            return this._pseudoToIrregularPanel.getSelectedIndices();
        }
        return super.getSelectedIndices();
    }

    protected void clearSelection() {
        String op = (String)this._opCombo.getSelectedItem();
        if (op.equals(TIME_SHIFT)) {
            this._timeShiftPanel.getDataSetList().clearSelection();
        } else if (op.equals(TIME_COPY)) {
            this._timeCopyPanel.getDataSetList().clearSelection();
        } else if (op.equals(CHANGE_INTERVAL)) {
            this._interpolateAtRegularPanel.getDataSetList().clearSelection();
        } else if (op.equals(VALUE_OVER_PERIOD)) {
            this._transformTSPanel.getDataSetList().clearSelection();
        } else if (op.equals(IRREGULAR_TO_REGULAR)) {
            this._irregular2RegularPanel.getDataSetList().clearSelection();
        } else if (op.equals(REGULAR_TO_IRREGULAR)) {
            this._regularToIrregularPanel.getDataSetList().clearSelection();
        } else if (IRREGULAR_TO_PSEUDO.equals(op)) {
            this._irregularToPseudoPanel.getDataSetList().clearSelection();
        } else if (PSEUDO_TO_IRREGULAR.equals(op)) {
            this._pseudoToIrregularPanel.getDataSetList().clearSelection();
        }
    }

    @Override
    public String getTabName() {
        return "Time Functions";
    }

    @Override
    public boolean isComputable() {
        int cnt = this._cardPanel.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c = this._cardPanel.getComponent(i);
            if (!c.isVisible() || !(c instanceof ComputablePanel)) continue;
            return ((ComputablePanel)((Object)c)).isComputable();
        }
        return false;
    }

    private static void initializeSelection(RmaJComboBox<String> combo, TimeSeriesContainer tsc) {
        int sel = combo.getSelectedIndex();
        if (sel <= 0) {
            int interval = TransformTab.estimateInterval(tsc);
            String intl = DssIntervalUtility.lookupRegularInterval((int)(interval * 60), (String)"1Hour");
            combo.setSelectedItem((Object)intl);
        }
    }

    private static int estimateInterval(TimeSeriesContainer tsc) {
        if (tsc == null) {
            return 0;
        }
        int interval = tsc.interval;
        if (interval <= 0 && tsc.numberValues > 1) {
            interval = (tsc.times[tsc.numberValues - 1] - tsc.times[0]) / tsc.numberValues;
        }
        return interval;
    }

    private static void selectIrregularInterval(RmaJComboBox<String> intervalCombo, int interval) {
        String epart = DssIntervalUtility.lookupIrregularInterval((int)(interval * 60), (String)"IR-Century");
        intervalCombo.setSelectedItem((Object)epart);
    }

    private static void selectRegularInterval(RmaJComboBox<String> intervalCombo, int intervalMinutes) {
        String e = DssIntervalUtility.lookupRegularInterval((int)(intervalMinutes * 60), (String)"1Day");
        intervalCombo.setSelectedItem((Object)e);
    }

    private class InterpolateAtRegularPanel
    extends MathPanel.MathCardListPanel {
        private TimeIntervalPanel _timeIntervalPanel;
        private TimeOffsetPanel _timeOffsetPanel;
        private JLabel _timeIntervalLabel;
        private JLabel _timeOffsetLabel;

        InterpolateAtRegularPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._timeIntervalLabel = new JLabel("Time Interval:");
            this._timeIntervalLabel.setDisplayedMnemonic('T');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._timeIntervalLabel, gbc);
            this._timeIntervalPanel = new TimeIntervalPanel();
            this._timeIntervalLabel.setLabelFor(this._timeIntervalPanel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._timeIntervalPanel, gbc);
            this._timeOffsetLabel = new JLabel("Set Time Offset:");
            this._timeOffsetLabel.setDisplayedMnemonic('O');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(13, 5, 0, 5);
            this.add((Component)this._timeOffsetLabel, gbc);
            this._timeOffsetPanel = new TimeOffsetPanel();
            this._timeOffsetLabel.setLabelFor(this._timeOffsetPanel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 5, 0, 5);
            this.add((Component)this._timeOffsetPanel, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            MathPanel.MathCardPanel.ComputeActionListener al = new MathPanel.MathCardPanel.ComputeActionListener();
            this._timeIntervalPanel.addActionListener(al);
            this._timeOffsetPanel.addKeyListener(kl);
            this._timeOffsetPanel.addActionListener(al);
        }

        @Override
        public boolean isComputable() {
            if (!this.isEnabled()) {
                this.setStatusLineText("Selected Data Set is not a Time Series");
                return false;
            }
            if (!this._timeIntervalPanel.hasValidData()) {
                this.setStatusLineText(null, this._timeIntervalLabel, " is incomplete.");
                return false;
            }
            if (!this._timeOffsetPanel.hasValidData()) {
                this.setStatusLineText(null, this._timeOffsetLabel, " is incomplete.");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                int sel = this._timeIntervalPanel._intervalCombo.getSelectedIndex();
                if (sel <= 0) {
                    int interval = TransformTab.estimateInterval(tsc);
                    TransformTab.selectRegularInterval(this._timeIntervalPanel._intervalCombo, interval);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public String getTimeIntervalString() {
            return this._timeIntervalPanel.getIntervalString();
        }

        public String getTimeOffsetString() {
            return this._timeOffsetPanel.getIntervalString();
        }
    }

    class IrregularToRegularPanel
    extends MathPanel.MathCardListPanel {
        protected JRadioButton _interpolateRadio;
        protected JRadioButton _snapRadio;
        private TimeIntervalPanel _timeIntervalPanelInterpolate;
        private TimeIntervalPanel _timeIntervalPanelSnap;
        private TimeOffsetPanel _timeOffsetPanelInterpolate;
        private TimeOffsetPanel _timeOffsetPanelSnap;
        private TimeOffsetPanel _timeBackPanel;
        private TimeOffsetPanel _timeForwardPanel;
        private JLabel _timeIntervalLabel;
        private JLabel _timeIntervalLabelSnap;
        private JLabel _timeOffsetLabel;
        private JLabel _timeOffsetLabelSnap;
        private JLabel _timeBackLabel;
        private JLabel _timeForwardLabel;

        IrregularToRegularPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._interpolateRadio = new JRadioButton("Interpolate   (fill-in values)");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 3;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._interpolateRadio, gbc);
            this._timeIntervalLabel = new JLabel("Time Interval:");
            this._timeIntervalLabel.setDisplayedMnemonic('T');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._timeIntervalLabel, gbc);
            this._timeIntervalPanelInterpolate = new TimeIntervalPanel();
            this._timeIntervalLabel.setLabelFor(this._timeIntervalPanelInterpolate);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._timeIntervalPanelInterpolate, gbc);
            this._timeOffsetLabel = new JLabel("Set Time Offset:");
            this._timeOffsetLabel.setDisplayedMnemonic('O');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(12, 5, 0, 5);
            this.add((Component)this._timeOffsetLabel, gbc);
            this._timeOffsetPanelInterpolate = new TimeOffsetPanel();
            this._timeOffsetLabel.setLabelFor(this._timeOffsetPanelInterpolate);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 5, 0, 5);
            this.add((Component)this._timeOffsetPanelInterpolate, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            this._snapRadio = new JRadioButton("Snap   (do not fill-in missing values)");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 3;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(15, 5, 0, 5);
            this.add((Component)this._snapRadio, gbc);
            this._timeIntervalLabelSnap = new JLabel("Time Interval:");
            this._timeIntervalLabelSnap.setDisplayedMnemonic('T');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._timeIntervalLabelSnap, gbc);
            this._timeIntervalPanelSnap = new TimeIntervalPanel();
            this._timeIntervalLabelSnap.setLabelFor(this._timeIntervalPanelSnap);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._timeIntervalPanelSnap, gbc);
            this._timeOffsetLabelSnap = new JLabel("Offset:");
            this._timeOffsetLabelSnap.setDisplayedMnemonic('O');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(12, 5, 0, 5);
            this.add((Component)this._timeOffsetLabelSnap, gbc);
            this._timeOffsetPanelSnap = new TimeOffsetPanel();
            this._timeOffsetLabelSnap.setLabelFor(this._timeOffsetPanelSnap);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 5, 0, 5);
            this.add((Component)this._timeOffsetPanelSnap, gbc);
            this._timeBackLabel = new JLabel("Tolerance Back:");
            this._timeBackLabel.setDisplayedMnemonic('B');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 7;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._timeBackLabel, gbc);
            this._timeBackPanel = new TimeOffsetPanel();
            this._timeBackLabel.setLabelFor(this._timeBackPanel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 7;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._timeBackPanel, gbc);
            this._timeForwardLabel = new JLabel("Tolerance Forward:");
            this._timeForwardLabel.setDisplayedMnemonic('F');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 8;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._timeForwardLabel, gbc);
            this._timeForwardPanel = new TimeOffsetPanel();
            this._timeForwardLabel.setLabelFor(this._timeForwardPanel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 8;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._timeForwardPanel, gbc);
            sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 9;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 9;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this._interpolateRadio);
            bg.add(this._snapRadio);
            this._interpolateRadio.setSelected(true);
            this.setEnables();
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            MathPanel.MathCardPanel.ComputeActionListener al = new MathPanel.MathCardPanel.ComputeActionListener();
            this._timeIntervalPanelInterpolate.addActionListener(al);
            this._timeOffsetPanelInterpolate.addKeyListener(kl);
            this._timeBackPanel.addKeyListener(kl);
            this._timeForwardPanel.addKeyListener(kl);
            this._timeOffsetPanelInterpolate.addActionListener(al);
            this._timeBackPanel.addActionListener(al);
            this._timeForwardPanel.addActionListener(al);
            this._interpolateRadio.addActionListener(al);
            this._snapRadio.addActionListener(al);
        }

        protected void setEnables() {
            boolean snap = this.isSnapSelected();
            boolean interpolate = !snap;
            this._timeIntervalPanelInterpolate.setEnabled(interpolate);
            this._timeOffsetPanelInterpolate.setEnabled(interpolate);
            this._timeIntervalPanelSnap.setEnabled(snap);
            this._timeOffsetPanelSnap.setEnabled(snap);
            this._timeBackPanel.setEnabled(snap);
            this._timeForwardPanel.setEnabled(snap);
        }

        @Override
        public boolean isComputable() {
            this.setEnables();
            if (this.isSnapSelected()) {
                if (!this._timeIntervalPanelSnap.hasValidData()) {
                    this.setStatusLineText(null, this._timeIntervalLabel, " is incomplete.");
                    return false;
                }
                if (!this._timeOffsetPanelSnap.hasValidData()) {
                    this.setStatusLineText(null, this._timeOffsetLabel, " is incomplete.");
                    return false;
                }
                if (!this._timeBackPanel.hasValidData()) {
                    this.setStatusLineText(null, this._timeBackLabel, " is incomplete");
                    return false;
                }
                if (!this._timeForwardPanel.hasValidData()) {
                    this.setStatusLineText(null, this._timeForwardLabel, " is incomplete");
                    return false;
                }
            } else {
                if (!this._timeIntervalPanelInterpolate.hasValidData()) {
                    this.setStatusLineText(null, this._timeIntervalLabel, " is incomplete.");
                    return false;
                }
                if (!this._timeOffsetPanelInterpolate.hasValidData()) {
                    this.setStatusLineText(null, this._timeOffsetLabel, " is incomplete.");
                    return false;
                }
            }
            this.clearStatusLineText();
            return true;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                TransformTab.initializeSelection(this._timeIntervalPanelInterpolate._intervalCombo, tsc);
                TransformTab.initializeSelection(this._timeIntervalPanelSnap._intervalCombo, tsc);
            }
        }

        public boolean isSnapSelected() {
            return this._snapRadio.isSelected();
        }

        public String getTimeIntervalString() {
            if (this.isSnapSelected()) {
                return this._timeIntervalPanelSnap.getIntervalString();
            }
            return this._timeIntervalPanelInterpolate.getIntervalString();
        }

        public String getTimeOffsetString() {
            if (this.isSnapSelected()) {
                return this._timeOffsetPanelSnap.getIntervalString();
            }
            return this._timeOffsetPanelInterpolate.getIntervalString();
        }

        public String getTimeBackString() {
            return this._timeBackPanel.getIntervalString();
        }

        public String getTimeForwardString() {
            return this._timeForwardPanel.getIntervalString();
        }
    }

    class IrregularToPseudoPanel
    extends MathPanel.MathCardListPanel {
        private TimeIntervalPanel _timeIntervalPanelInterpolate;
        private JLabel _timeIntervalLabel;
        protected boolean _computable = false;

        IrregularToPseudoPanel() {
            this.buildPanel();
        }

        public TimeSeriesMath compute(TimeSeriesMath tsmath) {
            try {
                DataContainer dc = tsmath.getData();
                if (dc instanceof TimeSeriesContainer) {
                    String path = dc.fullName;
                    String sinterval = this._timeIntervalPanelInterpolate.getIntervalString();
                    String pathConverted = DSSPathname.convertIrregularToPseudo((String)dc.fullName, (String)sinterval);
                    System.out.println("Converted path is " + pathConverted);
                    if (pathConverted.length() > 2) {
                        dc.fullName = pathConverted;
                        tsmath.setData(dc);
                        return tsmath;
                    }
                    throw new Exception("Unable to modify record to pseudo-regular interval");
                }
                throw new Exception("Recrod is not irregular-interval time series");
            }
            catch (Exception e) {
                System.out.println(e.toString());
                this.setStatusLineText(e.toString());
                return null;
            }
        }

        @Override
        protected void buildPanel() {
            GridBagConstraints gbc = new GridBagConstraints();
            this._timeIntervalLabel = new JLabel("Time Interval:");
            this._timeIntervalLabel.setDisplayedMnemonic('T');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(10, 5, 0, 5);
            this.add((Component)this._timeIntervalLabel, gbc);
            this._timeIntervalPanelInterpolate = new TimeIntervalPanel();
            this._timeIntervalLabel.setLabelFor(this._timeIntervalPanelInterpolate);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 5, 0, 5);
            this.add((Component)this._timeIntervalPanelInterpolate, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(10, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            new MathPanel.MathCardPanel.ComputeKeyListener();
            MathPanel.MathCardPanel.ComputeActionListener al = new MathPanel.MathCardPanel.ComputeActionListener();
            this._timeIntervalPanelInterpolate.addActionListener(al);
        }

        @Override
        public boolean isComputable() {
            if (!this._timeIntervalPanelInterpolate.hasValidData()) {
                this.setStatusLineText(null, this._timeIntervalLabel, " is incomplete.");
                return false;
            }
            if (this._computable) {
                this.clearStatusLineText();
            } else {
                this.setStatusLineText("Record is not an irregular interval time series data set");
            }
            return this._computable;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                TransformTab.initializeSelection(this._timeIntervalPanelInterpolate._intervalCombo, tsc);
                if (dc.fullName.toUpperCase().indexOf("/IR-") > 1) {
                    this.clearStatusLineText();
                    this._computable = true;
                } else {
                    this._computable = false;
                }
            } else {
                this._computable = false;
            }
        }

        public String getTimeIntervalString() {
            return this._timeIntervalPanelInterpolate.getIntervalString();
        }
    }

    class PseudoToIrregularPanel
    extends MathPanel.MathCardListPanel {
        protected boolean _computable = false;

        PseudoToIrregularPanel() {
            this.buildPanel();
        }

        public TimeSeriesMath compute(TimeSeriesMath tsmath) {
            try {
                DataContainer dc = tsmath.getData();
                if (dc instanceof TimeSeriesContainer) {
                    String pathConverted = DSSPathname.convertPseudoToIrregular((String)dc.fullName);
                    System.out.println("Converted path is " + pathConverted);
                    if (pathConverted.length() > 2) {
                        dc.fullName = pathConverted;
                        tsmath.setData(dc);
                        return tsmath;
                    }
                    throw new Exception("Unable to modify record to irregular interval");
                }
                throw new Exception("Record is not irregular-interval time series");
            }
            catch (Exception e) {
                System.out.println(e.toString());
                this.setStatusLineText(e.toString());
                return null;
            }
        }

        @Override
        protected void buildPanel() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
        }

        @Override
        public boolean isComputable() {
            if (this._computable) {
                this.clearStatusLineText();
            } else {
                this.setStatusLineText("Record is not an pseduo-regular interval time series data set");
            }
            return this._computable;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc instanceof TimeSeriesContainer) {
                if (dc.fullName.toUpperCase().indexOf("/~") > 1) {
                    this.clearStatusLineText();
                    this._computable = true;
                } else {
                    this._computable = false;
                }
            } else {
                this._computable = false;
            }
        }
    }

    class TransformTSPanel
    extends MathPanel.MathCardListPanel
    implements ActionListener {
        private TimeIntervalPanel _timeIntervalPanel;
        private TimeOffsetPanel _timeOffsetPanel;
        private RmaJComboBox _functionCombo;
        private RmaJRadioButton _timeIntervalRadio;
        private JLabel _timeOffsetLabel;
        private RmaJRadioButton _customIntervalRadio;
        private TimeOffsetPanel _customIntervalPanel;
        private JLabel _functionLabel;
        private RmaJCheckBox _setAsIrregularCB;
        private TimeIntervalPanel _blockSizePanel;
        private JLabel _blockSizeLabel;
        private TimeSeriesContainer _tsc = null;
        protected JLabel _typeLabel = null;

        TransformTSPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            int gridy = 0;
            this._functionLabel = new JLabel("Function Type:");
            this._functionLabel.setDisplayedMnemonic('u');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._functionLabel, gbc);
            this._functionCombo = new RmaJComboBox((Object[])_functionStrings);
            this._functionLabel.setLabelFor((Component)this._functionCombo);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.gridwidth = 1;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 15, 0, 5);
            this.add((Component)this._functionCombo, gbc);
            this._timeIntervalRadio = new RmaJRadioButton("New Period Interval:  ");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(8, 5, 0, 5);
            this.add((Component)this._timeIntervalRadio, gbc);
            this._timeIntervalPanel = new TimeIntervalPanel(1, true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 10, 0, 5);
            this.add((Component)this._timeIntervalPanel, gbc);
            this._customIntervalRadio = new RmaJRadioButton("Custom Period Interval:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(7, 5, 0, 5);
            this.add((Component)this._customIntervalRadio, gbc);
            this._customIntervalPanel = new TimeOffsetPanel(false);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 10, 0, 5);
            this.add((Component)this._customIntervalPanel, gbc);
            this._setAsIrregularCB = new RmaJCheckBox("Save as Irregular Interval (get time of occurrence).", false);
            this._setAsIrregularCB.setMnemonic('I');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
            this.add((Component)this._setAsIrregularCB, gbc);
            this._blockSizeLabel = new JLabel("Block Size:");
            this._blockSizeLabel.setDisplayedMnemonic('B');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 40, 0, 5);
            this.add((Component)this._blockSizeLabel, gbc);
            this._blockSizePanel = new TimeIntervalPanel(2);
            this._blockSizeLabel.setLabelFor(this._blockSizePanel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 10, 0, 5);
            this.add((Component)this._blockSizePanel, gbc);
            this._timeOffsetLabel = new JLabel("Set Time Offset:");
            this._timeOffsetLabel.setDisplayedMnemonic('O');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(13, 5, 0, 0);
            this.add((Component)this._timeOffsetLabel, gbc);
            this._timeOffsetPanel = new TimeOffsetPanel();
            this._timeOffsetLabel.setLabelFor(this._timeOffsetPanel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(10, 0, 0, 5);
            this.add((Component)this._timeOffsetPanel, gbc);
            this._typeLabel = new JLabel("Data Type: ");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(10, 5, 0, 0);
            this.add((Component)this._typeLabel, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            MathPanel.MathCardPanel.ComputeActionListener al = new MathPanel.MathCardPanel.ComputeActionListener();
            this._timeIntervalPanel.addActionListener(al);
            this._timeIntervalPanel.addActionListener(this);
            this._timeIntervalRadio.addActionListener((ActionListener)this);
            this._customIntervalRadio.addActionListener((ActionListener)this);
            this._timeOffsetPanel.addKeyListener(kl);
            this._timeOffsetPanel.addActionListener(al);
            this._customIntervalPanel.addKeyListener(kl);
            this._customIntervalPanel.addActionListener(al);
            this._blockSizePanel.addActionListener(al);
            this._setAsIrregularCB.addActionListener((ActionListener)this);
            this._functionCombo.setSelectedIndex(1);
            this._blockSizePanel._intervalCombo.setEnabled(false);
            this._timeIntervalRadio.setSelected(true);
            this._customIntervalRadio.setSelected(false);
            this._customIntervalPanel.setEnabled(false);
            ButtonGroup radioGroup = new ButtonGroup();
            radioGroup.add((AbstractButton)this._timeIntervalRadio);
            radioGroup.add((AbstractButton)this._customIntervalRadio);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e != null) {
                Object obj = e.getSource();
                if (obj == this._timeIntervalRadio) {
                    this._timeIntervalPanel.setEnabled(true);
                    this._customIntervalPanel.setEnabled(false);
                    this._setAsIrregularCB.setEnabled(true);
                    TransformTab.this.setComputeButtonEnabled(this.isComputable());
                } else if (obj == this._customIntervalRadio) {
                    this._timeIntervalPanel.setEnabled(false);
                    this._customIntervalPanel.setEnabled(true);
                    this._setAsIrregularCB.setSelected(true);
                    this._setAsIrregularCB.setEnabled(false);
                    TransformTab.this.setComputeButtonEnabled(this.isComputable());
                }
            }
            if (this._setAsIrregularCB.isSelected()) {
                this._blockSizePanel._intervalCombo.setEnabled(true);
            } else {
                this._blockSizePanel._intervalCombo.setEnabled(false);
            }
            if (!this._timeOffsetPanel.isOffsetSelected()) {
                this._timeOffsetPanel._offsetCombo.setEnabled(false);
            }
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this.actionPerformed(null);
        }

        @Override
        public boolean isComputable() {
            if (!this._timeIntervalPanel.hasValidData()) {
                this.setStatusLineText(null, (JComponent)this._timeIntervalRadio, " is incomplete");
                return false;
            }
            if (!this._timeOffsetPanel.hasValidData()) {
                this.setStatusLineText(null, this._timeOffsetLabel, " is incomplete");
                return false;
            }
            if (this._functionCombo.getSelectedIndex() == -1) {
                this.setStatusLineText("No ", this._functionLabel, " selected");
                return false;
            }
            if (this._customIntervalRadio.isSelected() && !this._customIntervalPanel.hasValidData()) {
                this.setStatusLineText("No ", (JComponent)this._customIntervalRadio, " given");
                return false;
            }
            Vector ds = this.getSelectedDataSets();
            DataContainer dc = (DataContainer)ds.firstElement();
            String type = null;
            if (dc instanceof TimeSeriesContainer) {
                type = ((TimeSeriesContainer)dc).type;
            }
            if (type != null) {
                this._typeLabel.setText("Data Type:  " + type);
            }
            this.clearStatusLineText();
            return true;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc instanceof TimeSeriesContainer) {
                this._tsc = (TimeSeriesContainer)dc;
                if (this._tsc != null) {
                    this._timeIntervalPanel.setMinimumInterval(this._tsc.interval);
                    int sel = this._timeIntervalPanel._intervalCombo.getSelectedIndex();
                    if (sel < 0) {
                        int interval = TransformTab.estimateInterval(this._tsc);
                        if (interval < 121) {
                            this._timeIntervalPanel._intervalCombo.setSelectedItem((Object)"1Day");
                            this._customIntervalPanel._offsetCombo.setSelectedItem((Object)"Day");
                        } else {
                            this._timeIntervalPanel._intervalCombo.setSelectedItem((Object)"1Year");
                            this._customIntervalPanel._offsetCombo.setSelectedItem((Object)"Year");
                        }
                        TransformTab.selectIrregularInterval(this._blockSizePanel._intervalCombo, interval);
                    }
                }
            }
        }

        public String getTimeIntervalString() {
            if (this._timeIntervalRadio.isSelected()) {
                return this._timeIntervalPanel.getIntervalString();
            }
            return this._customIntervalPanel.getIntervalString();
        }

        public String getTimeOffsetString() {
            return this._timeOffsetPanel.getIntervalString();
        }

        public String getFunction() {
            int idx = this._functionCombo.getSelectedIndex();
            if (idx < 0) {
                return null;
            }
            return _functions[idx];
        }

        public boolean isSetAsIrregular() {
            return this._setAsIrregularCB.isSelected();
        }

        public String getBlockSize() {
            return this._blockSizePanel.getIntervalString();
        }
    }

    private class RegularToIrregularPanel
    extends MathPanel.MathCardListPanel {
        private TimeIntervalPanel _timeIntervalPanel;
        private JLabel _timeIntervalLabel;
        private JLabel _RemoveMissingLabel;
        private TimeSeriesContainer _tsc;
        private CheckBoxPanel _RemoveMissingData;

        RegularToIrregularPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._timeIntervalLabel = new JLabel("Irregular Block Size:");
            this._timeIntervalLabel.setDisplayedMnemonic('B');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._timeIntervalLabel, gbc);
            this._timeIntervalPanel = new TimeIntervalPanel(2);
            this._timeIntervalLabel.setLabelFor(this._timeIntervalPanel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._timeIntervalPanel, gbc);
            this._RemoveMissingLabel = new JLabel("Remove Missing:");
            this._RemoveMissingLabel.setDisplayedMnemonic('B');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._RemoveMissingLabel, gbc);
            this._RemoveMissingData = new CheckBoxPanel("", true);
            this._RemoveMissingLabel.setLabelFor((Component)this._RemoveMissingData);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._RemoveMissingData, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            new MathPanel.MathCardPanel.ComputeKeyListener();
            MathPanel.MathCardPanel.ComputeActionListener al = new MathPanel.MathCardPanel.ComputeActionListener();
            this._timeIntervalPanel.addActionListener(al);
            this._RemoveMissingData.addActionListener((ActionListener)al);
        }

        @Override
        public boolean isComputable() {
            if (!this.isEnabled()) {
                this.setStatusLineText("Selected Data Set is not a Time Series");
                return false;
            }
            if (!this._timeIntervalPanel.hasValidData()) {
                this.setStatusLineText(null, this._timeIntervalLabel, " is incomplete.");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc instanceof TimeSeriesContainer) {
                this._tsc = (TimeSeriesContainer)dc;
                int sel = this._timeIntervalPanel._intervalCombo.getSelectedIndex();
                if (sel <= 0) {
                    TransformTab.selectIrregularInterval(this._timeIntervalPanel._intervalCombo, this._tsc.interval);
                }
            } else {
                this._tsc = null;
                this.setEnabled(false);
            }
        }

        public String getTimeIntervalString() {
            return this._timeIntervalPanel.getIntervalString();
        }

        private boolean getRemoveMissing() {
            return this._RemoveMissingData.isSelected();
        }
    }

    class TimeShiftPanel
    extends MathPanel.MathCardListPanel
    implements ActionListener {
        private TimeOffsetPanel _timeShiftPanel;
        private JLabel _timeShiftLabel;
        private JLabel _dateLabel;
        private RmaJCalendarField _dateField;
        private JLabel _timeLabel;
        private JTextField _timeField;
        private RmaJRadioButton _shiftByAmount;
        private RmaJRadioButton _shiftToDate;
        private ButtonGroup _radioGroup;
        private String _operation;
        private int _startTime = 0;

        TimeShiftPanel(String operation) {
            this._operation = operation;
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._shiftByAmount = new RmaJRadioButton(this._operation + " by Amount");
            this._shiftByAmount.setMnemonic('A');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._shiftByAmount, gbc);
            this._timeShiftLabel = new JLabel("Amount of time to " + this._operation.toLowerCase() + " by:");
            this._timeShiftLabel.setDisplayedMnemonic('T');
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(8, 5, 0, 5);
            this.add((Component)this._timeShiftLabel, gbc);
            this._timeShiftPanel = new TimeOffsetPanel(false);
            this._timeShiftPanel.setMinimumValue(Integer.MIN_VALUE);
            this._timeShiftLabel.setLabelFor(this._timeShiftPanel);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 5, 0, 5);
            this.add((Component)this._timeShiftPanel, gbc);
            this._shiftToDate = new RmaJRadioButton(this._operation + " to Date/Time");
            this._shiftToDate.setMnemonic('D');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)8, (int)5, (int)0, (int)5);
            this.add((Component)this._shiftToDate, gbc);
            JPanel datePanel = new JPanel();
            this._dateLabel = new JLabel("Date:");
            this._dateLabel.setDisplayedMnemonic('D');
            datePanel.add(this._dateLabel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 0);
            this.add((Component)datePanel, gbc);
            this._dateField = new RmaJCalendarField();
            this._dateField.setMargin(new Insets(0, 4, 0, 0));
            this._dateLabel.setLabelFor((Component)this._dateField);
            datePanel.add((Component)this._dateField);
            this._timeLabel = new JLabel("   Time:");
            this._timeLabel.setDisplayedMnemonic('D');
            datePanel.add(this._timeLabel);
            this._timeField = new JTextField();
            this._timeField.setMargin(new Insets(0, 5, 0, 0));
            this._timeField.setColumns(5);
            datePanel.add(this._timeField);
            this._radioGroup = new ButtonGroup();
            this._radioGroup.add((AbstractButton)this._shiftByAmount);
            this._radioGroup.add((AbstractButton)this._shiftToDate);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            this._shiftByAmount.addActionListener((ActionListener)this);
            this._shiftToDate.addActionListener((ActionListener)this);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._timeShiftPanel.addKeyListener(kl);
            this._dateField.addKeyListener((KeyListener)kl);
            this._timeField.addKeyListener(kl);
            this._shiftByAmount.addKeyListener((KeyListener)kl);
            this._shiftToDate.addKeyListener((KeyListener)kl);
            this._radioGroup.setSelected(this._shiftByAmount.getModel(), true);
            this._timeShiftPanel._offsetCombo.setSelectedItem((Object)"Year");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._timeShiftPanel.setEnabled(false);
            this._dateField.setEnabled(false);
            this._timeField.setEnabled(false);
            if (!this.isEnabled()) {
                return;
            }
            if (this._shiftByAmount.isSelected()) {
                this._timeShiftPanel.setEnabled(true);
            } else if (this._shiftToDate.isSelected()) {
                this._dateField.setEnabled(true);
                this._timeField.setEnabled(true);
            }
            TransformTab.this.setComputeButtonEnabled(this.isComputable());
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this.actionPerformed(null);
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            this._startTime = 0;
            if (dc instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                if (tsc.numberValues > 0) {
                    this._startTime = tsc.times[0];
                }
                if (this._dateField.getText().length() == 0 && this._timeField.getText().length() == 0) {
                    HecTime time = new HecTime();
                    time.set(this._startTime);
                    this._dateField.setText(time.date(104));
                    this._timeField.setText(time.time());
                }
            } else {
                this.setEnabled(false);
            }
            this.actionPerformed(null);
        }

        @Override
        public boolean isComputable() {
            if (!this.isEnabled()) {
                this.setStatusLineText("Selected DataSet is not a Time Series");
                return false;
            }
            if (this._shiftByAmount.isSelected()) {
                if (!this._timeShiftPanel.hasValidData()) {
                    this.setStatusLineText("Shift amount is incomplete");
                    return false;
                }
            } else if (this._shiftToDate.isSelected()) {
                if (!this._dateField.isValid(false) || this._dateField.getText().length() == 0) {
                    this.setStatusLineText("Date is incomplete");
                    return false;
                }
            } else {
                this.setStatusLineText("Shift amount or date not set");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        public String getTimeShiftString() {
            if (this._shiftByAmount.isSelected()) {
                return this._timeShiftPanel.getIntervalString();
            }
            if (this._shiftToDate.isSelected()) {
                HecTime time = new HecTime();
                int stat = time.setDate(this._dateField.getText());
                if (stat != 0) {
                    return "";
                }
                String s = this._timeField.getText();
                if (s.trim().length() == 0) {
                    s = "2400";
                }
                time.setTime(s);
                int diff = time.value() - this._startTime;
                String sdiff = Integer.toString(diff) + "Minute";
                return sdiff;
            }
            return "";
        }
    }

    class ExtractTimeSeriesPanel
    extends MathPanel.MathCardPanel
    implements ActionListener {
        private RmaJRadioButton _yearRadio;
        private RmaJRadioButton _monthRadio;
        private RmaJRadioButton _dayMonRadio;
        private RmaJRadioButton _dayWeekRadio;
        private RmaJRadioButton _timeRadio;
        private ButtonGroup _radioGroup;
        private RmaJIntegerField _startYearFld;
        private RmaJIntegerField _endYearFld;
        private RmaJComboBox _startMonCombo;
        private RmaJComboBox _endMonCombo;
        private RmaJComboBox _startDayMonCombo;
        private RmaJComboBox _endDayMonCombo;
        private RmaJComboBox _startDayWeekCombo;
        private RmaJComboBox _endDayWeekCombo;
        private RmaJ24HourTimeField _startTimeFld;
        private RmaJ24HourTimeField _endTimeFld;
        private RmaJIntegerField _timeWindowFld;
        private RmaJCheckBox _isInclusiveCB;
        private RmaJCheckBox _setAsIrregularCB;
        private String[] _months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        private String[] _days = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
        private String[] _dayNum = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "LastDay"};

        ExtractTimeSeriesPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._yearRadio = new RmaJRadioButton("Year");
            this._yearRadio.setMnemonic('Y');
            this._yearRadio.setName("YEAR");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._yearRadio, gbc);
            this._startYearFld = new RmaJIntegerField();
            this._startYearFld.setToolTipText("Enter starting year");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._startYearFld, gbc);
            JLabel label = new JLabel("to");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)label, gbc);
            this._endYearFld = new RmaJIntegerField();
            this._endYearFld.setToolTipText("Enter optional ending year");
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._endYearFld, gbc);
            this._monthRadio = new RmaJRadioButton("Month");
            this._monthRadio.setName("MONTH");
            this._monthRadio.setMnemonic('M');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._monthRadio, gbc);
            this._startMonCombo = new RmaJComboBox((Object[])this._months);
            this._startMonCombo.setSelectedIndex(0);
            this._startMonCombo.setToolTipText("Select starting month");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._startMonCombo, gbc);
            label = new JLabel("to");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)label, gbc);
            this._endMonCombo = new RmaJComboBox((Object[])this._months);
            this._endMonCombo.setToolTipText("Selected optional ending month");
            this._endMonCombo.setSelectedIndex(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._endMonCombo, gbc);
            this._dayMonRadio = new RmaJRadioButton("Day of Month");
            this._dayMonRadio.setName("DAYMON");
            this._dayMonRadio.setMnemonic('D');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._dayMonRadio, gbc);
            this._startDayMonCombo = new RmaJComboBox((Object[])this._dayNum);
            this._startDayMonCombo.setSelectedIndex(0);
            this._startDayMonCombo.setToolTipText("Select starting day of month");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._startDayMonCombo, gbc);
            label = new JLabel("to");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)label, gbc);
            this._endDayMonCombo = new RmaJComboBox((Object[])this._dayNum);
            this._endDayMonCombo.setSelectedIndex(0);
            this._endDayMonCombo.setToolTipText("Select optional ending day of month");
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._endDayMonCombo, gbc);
            this._dayWeekRadio = new RmaJRadioButton("Day of Week");
            this._dayWeekRadio.setName("DAYWEE");
            this._dayWeekRadio.setMnemonic('W');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._dayWeekRadio, gbc);
            this._startDayWeekCombo = new RmaJComboBox((Object[])this._days);
            this._startDayWeekCombo.setSelectedIndex(0);
            this._startDayWeekCombo.setToolTipText("Select starting day of week");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._startDayWeekCombo, gbc);
            label = new JLabel("to");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)label, gbc);
            this._endDayWeekCombo = new RmaJComboBox((Object[])this._days);
            this._endDayWeekCombo.setToolTipText("Select optional ending day of week");
            this._endDayWeekCombo.setSelectedIndex(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._endDayWeekCombo, gbc);
            this._timeRadio = new RmaJRadioButton("Time");
            this._timeRadio.setName("TIME");
            this._timeRadio.setMnemonic('T');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._timeRadio, gbc);
            this._startTimeFld = new RmaJ24HourTimeField();
            this._startTimeFld.setToolTipText("Enter starting time");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._startTimeFld, gbc);
            label = new JLabel("to");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)label, gbc);
            this._endTimeFld = new RmaJ24HourTimeField();
            this._endTimeFld.setToolTipText("Enter optional ending time");
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._endTimeFld, gbc);
            label = new JLabel("Time Window (minutes):");
            label.setDisplayedMnemonic('e');
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)label, gbc);
            this._timeWindowFld = new RmaJIntegerField();
            this._timeWindowFld.setMinValue(0);
            label.setLabelFor((Component)this._timeWindowFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 5;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._timeWindowFld, gbc);
            this._isInclusiveCB = new RmaJCheckBox("Inclusive", true);
            this._isInclusiveCB.setMnemonic('I');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this._setAsIrregularCB = new RmaJCheckBox("Set as Irregular", false);
            this._setAsIrregularCB.setMnemonic('S');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._setAsIrregularCB, gbc);
            gbc.gridy = 7;
            gbc.fill = 0;
            this.add((Component)new JPanel(), gbc);
            this._radioGroup = new ButtonGroup();
            this._radioGroup.add((AbstractButton)this._yearRadio);
            this._radioGroup.add((AbstractButton)this._monthRadio);
            this._radioGroup.add((AbstractButton)this._dayMonRadio);
            this._radioGroup.add((AbstractButton)this._dayWeekRadio);
            this._radioGroup.add((AbstractButton)this._timeRadio);
            this._yearRadio.addActionListener((ActionListener)this);
            this._monthRadio.addActionListener((ActionListener)this);
            this._dayMonRadio.addActionListener((ActionListener)this);
            this._dayWeekRadio.addActionListener((ActionListener)this);
            this._timeRadio.addActionListener((ActionListener)this);
            this._startMonCombo.addActionListener((ActionListener)this);
            this._startDayWeekCombo.addActionListener((ActionListener)this);
            this._startDayMonCombo.addActionListener((ActionListener)this);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._startTimeFld.addKeyListener((KeyListener)kl);
            this._startYearFld.addKeyListener((KeyListener)kl);
            this._endYearFld.addKeyListener((KeyListener)kl);
            this._endTimeFld.addKeyListener((KeyListener)kl);
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._startYearFld.setEnabled(false);
            this._endYearFld.setEnabled(false);
            this._startMonCombo.setEnabled(false);
            this._endMonCombo.setEnabled(false);
            this._startDayMonCombo.setEnabled(false);
            this._endDayMonCombo.setEnabled(false);
            this._startDayWeekCombo.setEnabled(false);
            this._endDayWeekCombo.setEnabled(false);
            this._startTimeFld.setEnabled(false);
            this._endTimeFld.setEnabled(false);
            this._timeWindowFld.setEnabled(false);
            if (!this.isEnabled()) {
                return;
            }
            if (this._yearRadio.isSelected()) {
                this._startYearFld.setEnabled(true);
                this._endYearFld.setEnabled(true);
            } else if (this._monthRadio.isSelected()) {
                this._startMonCombo.setEnabled(true);
                this._endMonCombo.setEnabled(true);
            } else if (this._dayMonRadio.isSelected()) {
                this._startDayMonCombo.setEnabled(true);
                this._endDayMonCombo.setEnabled(true);
            } else if (this._dayWeekRadio.isSelected()) {
                this._startDayWeekCombo.setEnabled(true);
                this._endDayWeekCombo.setEnabled(true);
            } else if (this._timeRadio.isSelected()) {
                this._startTimeFld.setEnabled(true);
                this._endTimeFld.setEnabled(true);
                this._timeWindowFld.setEnabled(true);
            }
            TransformTab.this.setComputeButtonEnabled(this.isComputable());
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            this.setEnabled(dc instanceof TimeSeriesContainer);
            this.actionPerformed(null);
        }

        @Override
        public boolean isComputable() {
            if (!this.isEnabled()) {
                this.setStatusLineText("Selected DataSet is not a Time Series");
                return false;
            }
            Enumeration<AbstractButton> e = this._radioGroup.getElements();
            boolean haveSelection = false;
            while (e.hasMoreElements()) {
                if (!e.nextElement().isSelected()) continue;
                haveSelection = true;
                break;
            }
            if (!haveSelection) {
                this.setStatusLineText("No Level of Time Specification Selected");
                return false;
            }
            if (this._yearRadio.isSelected()) {
                if (this._startYearFld.getText().length() < 1) {
                    this.setStatusLineText("No Start Year Entered");
                    return false;
                }
                if (this._endYearFld.getText().length() > 0 && this._startYearFld.getValue() > this._endYearFld.getValue()) {
                    this.setStatusLineText("Start Year must be before End Year");
                    return false;
                }
            } else if (this._monthRadio.isSelected()) {
                if (this._startMonCombo.getSelectedIndex() == -1 || "".equals(this._startMonCombo.getSelectedItem())) {
                    this.setStatusLineText("No Start Month Entered");
                    return false;
                }
            } else if (this._dayMonRadio.isSelected()) {
                if (this._startDayMonCombo.getSelectedIndex() == -1 || "".equals(this._startDayMonCombo.getSelectedItem())) {
                    this.setStatusLineText("No Start Day of Month Entered");
                    return false;
                }
            } else if (this._dayWeekRadio.isSelected()) {
                if (this._startDayWeekCombo.getSelectedIndex() == -1 || "".equals(this._startDayWeekCombo.getSelectedItem())) {
                    this.setStatusLineText("No Start Day of Week Entered");
                    return false;
                }
            } else if (this._timeRadio.isSelected() && this._startTimeFld.getText().length() < 1) {
                this.setStatusLineText("No Start Time Entered");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        public String getTimeLevelString() {
            Enumeration<AbstractButton> e = this._radioGroup.getElements();
            while (e.hasMoreElements()) {
                AbstractButton button = e.nextElement();
                if (!button.isSelected()) continue;
                return button.getName();
            }
            return null;
        }

        public String getRange() {
            String range = null;
            if (this._yearRadio.isSelected()) {
                range = this._startYearFld.getText();
                if (this._endYearFld.getText().length() > 0) {
                    range = range.concat("-").concat(this._endYearFld.getText());
                }
            } else if (this._monthRadio.isSelected()) {
                range = (String)this._startMonCombo.getSelectedItem();
                if (((String)this._endMonCombo.getSelectedItem()).length() > 0) {
                    range = range.concat("-").concat((String)this._endMonCombo.getSelectedItem());
                }
            } else if (this._dayMonRadio.isSelected()) {
                range = ((String)this._startDayMonCombo.getSelectedItem()).toUpperCase();
                if (((String)this._endDayMonCombo.getSelectedItem()).length() > 0) {
                    range = range.concat("-").concat(((String)this._endDayMonCombo.getSelectedItem()).toUpperCase());
                }
            } else if (this._dayWeekRadio.isSelected()) {
                range = (String)this._startDayWeekCombo.getSelectedItem();
                if (((String)this._endDayWeekCombo.getSelectedItem()).length() > 0) {
                    range = range.concat("-").concat((String)this._endDayWeekCombo.getSelectedItem());
                }
            } else if (this._timeRadio.isSelected()) {
                range = this._startTimeFld.getText();
                if (this._endTimeFld.getText().length() > 0) {
                    range = range.concat("-").concat(this._endTimeFld.getText());
                }
            }
            return range;
        }

        public boolean isInclusive() {
            return true;
        }

        public int getIntervalWindow() {
            return this._timeWindowFld.getValue();
        }

        public boolean getIsIrregular() {
            return this._setAsIrregularCB.isSelected();
        }
    }

    class TransformTimeSeriesPanel
    extends MathPanel.DataSetPanel {
        private RmaJComboBox _functionCombo;
        private JLabel _functionLabel;

        TransformTimeSeriesPanel() {
        }

        @Override
        protected void buildPanel() {
            super.buildPanel();
            this._functionLabel = new JLabel("Function Type:");
            this._functionLabel.setDisplayedMnemonic('u');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._functionLabel, gbc);
            this._functionCombo = new RmaJComboBox((Object[])_functionStrings);
            this._functionLabel.setLabelFor((Component)this._functionCombo);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._functionCombo, gbc);
        }

        @Override
        public boolean isComputable() {
            if (!super.isComputable()) {
                return false;
            }
            if (this._functionCombo.getSelectedIndex() == -1) {
                this.setStatusLineText("No ", this._functionLabel, " selected");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        public String getFunction() {
            int idx = this._functionCombo.getSelectedIndex();
            if (idx < 0) {
                return null;
            }
            return _functions[idx];
        }
    }
}

