/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dataui.tx.DataSourceList;
import hec.dataui.tx.awt.VerifyDataDlg;
import hec.dssgui.Help;
import hec.dssgui.ListSelection;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;

abstract class TsEditAction
extends AbstractAction {
    private static final String UNABLE_TO_EDIT = "Unable to edit";
    private final ListSelection _listSelection;

    TsEditAction(ListSelection listSelection) {
        this._listSelection = listSelection;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.edit(this._listSelection.readData());
    }

    final void edit(List<DataContainer>[] dataContainers) {
        List<TimeSeriesContainer> containers = this.validate(dataContainers);
        if (!containers.isEmpty()) {
            this.edit(containers);
        }
    }

    final void edit(List<TimeSeriesContainer> containers) {
        this._listSelection.checkNumberOpenWindows();
        int unitSystem = this._listSelection.getUnitSystem();
        DataSourceList dataSourceList = this.buildDataSourceList(containers);
        VerifyDataDlg editor = new VerifyDataDlg(dataSourceList, unitSystem);
        editor.setVisible(true);
        Help.setHelp((RootPaneContainer)editor, "26");
    }

    private List<TimeSeriesContainer> validate(List<? extends DataContainer>[] dataContainers) {
        List<? extends DataContainer> retval;
        if (dataContainers[1] != null && !dataContainers[1].isEmpty()) {
            JOptionPane.showMessageDialog(this._listSelection, "Paired Data cannot be graphically edited.", UNABLE_TO_EDIT, 2);
        }
        if (dataContainers[2] != null && !dataContainers[2].isEmpty()) {
            JOptionPane.showMessageDialog(this._listSelection, "Text Data cannot be graphically edited.", UNABLE_TO_EDIT, 2);
        }
        if (dataContainers[3] != null && !dataContainers[3].isEmpty()) {
            JOptionPane.showMessageDialog(this._listSelection, "Gridded Data cannot be graphically edited.\nUse program MetVue.", UNABLE_TO_EDIT, 2);
        }
        if ((retval = dataContainers[0]) == null) {
            retval = new ArrayList<DataContainer>();
        }
        return retval;
    }

    final ListSelection getListSelection() {
        return this._listSelection;
    }

    abstract DataSourceList buildDataSourceList(List<TimeSeriesContainer> var1);
}

