/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ListSelection;
import hec.dssgui.SelectRecords;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDssCatalog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UndeleteEditor
extends SelectRecords {
    protected DssDataManager _dataManager = null;

    public UndeleteEditor(JFrame parent, DssDataManager dataManager) {
        super(parent);
        String[] names;
        this._dataManager = dataManager;
        this.setTitle("Undelete Records");
        if (this._dataManager.getDssFileVersion() == 6) {
            Vector dataNameVector = new Vector();
            this._dataManager.searchDSSPaths("DELETE", dataNameVector);
            names = dataNameVector.toArray(new String[0]);
        } else {
            names = ((HecDssCatalog)this._dataManager.dataManager()).getPathnameListType(11, 0, 0);
        }
        this.populateTable(names);
    }

    public void setVisible(boolean visible) {
        if (visible && this._dataNamesTable.getRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No records in file available to undelete.", "", 2);
            return;
        }
        super.setVisible(visible);
    }

    @Override
    void jButtonOk_actionPerformed(ActionEvent event) {
        boolean exitOK = this.undeleteRecords(true);
        if (exitOK) {
            this.jButtonCancel_actionPerformed(event);
        }
    }

    @Override
    protected boolean apply_action() {
        this.undeleteRecords(false);
        if (this._dataNamesTable.getRowCount() == 0) {
            this.jButtonCancel_actionPerformed(null);
        }
        return true;
    }

    protected boolean undeleteRecords(boolean closeWindow) {
        Vector<Object> toUndelete = new Vector<Object>();
        Vector<Object> toKeep = new Vector<Object>();
        for (int i = 0; i < this._dataNamesTable.getRowCount(); ++i) {
            String select = this._dataNamesTable.getCell(i, 0).toString();
            if (select.equals("true")) {
                toUndelete.add(this._dataNamesTable.getValueAt(i, 1));
                continue;
            }
            toKeep.add(this._dataNamesTable.getValueAt(i, 1));
        }
        if (toUndelete.size() > 0) {
            int status = this._dataManager.undelete(toUndelete);
            if (status != 0 || this._dataManager.checkForSevereError()) {
                if (this._parent instanceof ListSelection) {
                    ((ListSelection)this._parent).checkForSevereError(this._dataManager);
                }
            } else {
                this._refreshCatalog = true;
                StringBuffer count = new StringBuffer();
                if (toKeep.size() == 0) {
                    count.append("All ");
                }
                count.append(toUndelete.size());
                count.append(" records undeleted.");
                JOptionPane.showMessageDialog((Component)((Object)this), count, "", 1);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Nothing selected to undelete.", "", 1);
        }
        if (!closeWindow) {
            String[] names = toKeep.toArray(new String[0]);
            this.populateTable(names);
        }
        return true;
    }
}

