/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui.factory.browser;

import hec.dssgui.BrowseDSS;
import hec.ui.browser.IBrowseCallback;
import hec.ui.browser.IBrowserFactory;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import rma.services.annotations.ServiceProvider;

@ServiceProvider(service=IBrowserFactory.class, path="hec.dssVue/BrowseDSS")
public class BrowseDSSFactory
implements IBrowserFactory {
    private BrowseDSS _browser;
    private Map<String, Object> _initializer = new HashMap<String, Object>();
    private IBrowseCallback _callback;

    public Object newInstance(IBrowseCallback callback) {
        String srcType = "";
        Boolean bNetwork = false;
        this._callback = callback;
        boolean remote = false;
        Object obj = this._initializer.get("networked");
        if (obj != null && obj instanceof Boolean) {
            remote = (Boolean)obj;
        }
        this._browser = new BrowseDSS(callback, "Browse DSS", remote);
        this.initBrowser();
        this._browser.setVisible(true);
        this._browser.toFront();
        return this._browser;
    }

    public void openBrowser(IBrowseCallback callback) {
        String fileName = "";
        boolean bNetwork = false;
        if (this._browser == null) {
            this.newInstance(callback);
        } else {
            boolean remote = this._browser.isRemote();
            Object obj = this._initializer.get("networked");
            if (obj != null && obj instanceof Boolean && (Boolean)obj != remote) {
                this._browser.dispose();
                this.newInstance(callback);
                return;
            }
            if (this._callback != callback) {
                this._browser.dispose();
                this.newInstance(callback);
                return;
            }
            this.initBrowser();
            this._browser.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowseDSSFactory.this._browser.toFront();
                }
            });
        }
    }

    public Map<String, Object> getInitializer() {
        HashMap<String, Object> initializer = new HashMap<String, Object>();
        if (this._browser != null) {
            initializer.put("title", this._browser.getTitle());
            initializer.put("directory", this._browser.getDirectory());
            initializer.put("networked", this._browser.isRemote());
        } else {
            initializer.put("title", null);
            initializer.put("directory", null);
            initializer.put("networked", null);
        }
        return initializer;
    }

    public void setInitializer(Map<String, Object> initializer) {
        if (initializer != null) {
            this._initializer = initializer;
        }
    }

    public void closeBrowser() {
        if (this._browser != null) {
            this._browser.setVisible(false);
            this._browser.dispose();
            this._browser = null;
        }
    }

    public String getTitle(String strType) {
        if (this._browser != null) {
            return this._browser.getTitle();
        }
        return "";
    }

    public void addWindowListener(WindowListener listener) {
        if (this._browser != null) {
            this._browser.addWindowListener(listener);
        }
    }

    public boolean isBrowser(Object browser) {
        return browser == this._browser;
    }

    public void toFront() {
        if (this._browser != null) {
            this._browser.toFront();
        }
    }

    private void initBrowser() {
        Object obj = this._initializer.get("title");
        if (obj != null && obj instanceof String) {
            String title = (String)obj;
            this._browser.setTitle(title);
        }
        if ((obj = this._initializer.get("directory")) != null && obj instanceof String) {
            String directory = (String)obj;
            this._browser.setDirectory(directory);
        }
    }
}

