/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui.grid;

import hec.dssgui.AbstractGridInfoTab;
import hec.dssgui.SingleGrid;
import hec.heclib.grid.GridData;
import hec.map.MapPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import rma.swing.RmaInsets;
import rma.util.PrintUtilities;

public class GridDataMapPanel
extends AbstractGridInfoTab {
    private MapPanel _mapPanel;
    private SingleGrid _map;

    public GridDataMapPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    public void buildControls() {
        this._mapPanel = new MapPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0000;
        this.add((Component)this._mapPanel, gbc);
    }

    @Override
    public void fillPanel(String pathStr, GridData gridData) {
        if (gridData == null) {
            return;
        }
        this._map = new SingleGrid(gridData, pathStr);
        ArrayList<SingleGrid> l = new ArrayList<SingleGrid>(1);
        l.add(this._map);
        this._mapPanel.resetManagerMaps(l);
        this._mapPanel.setExtents(this._map.getExtent(), false);
        this._mapPanel.scale().setRegionExtents(this._map.getExtent());
        this._mapPanel.paintMap();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GridDataMapPanel.this._mapPanel.viewport().setSize(GridDataMapPanel.this.getViewportSize());
                GridDataMapPanel.this._mapPanel.resetScrollbars();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                GridDataMapPanel.this._mapPanel.viewport().setSize(GridDataMapPanel.this.getViewportSize());
                GridDataMapPanel.this._mapPanel.resetScrollbars();
            }
        });
    }

    protected Dimension getViewportSize() {
        Dimension d = this.getSize();
        d.width -= this._mapPanel.getVerticalScrollBarWidth();
        d.height -= this._mapPanel.getHorizontalScrollBarHeight();
        d.width -= this._mapPanel.getMapToolPanel().getWidth();
        d.width -= 12;
        d.height -= 10;
        return d;
    }

    @Override
    public String getTabname() {
        return "Grid Display";
    }

    @Override
    public boolean print() {
        PrintUtilities.printComponent((Component)this._mapPanel.viewport());
        return true;
    }
}

