/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import rma.swing.RmaJTextField;

public class FilePanel {
    RmaJTextField fileNameText;
    String originalName;
    boolean _dirty = false;
    JPanel _panel;
    JButton editButton = null;
    protected EventListenerList listenerList = new EventListenerList();

    public FilePanel(JPanel panel, int yPosition, String labelText, String fileName, boolean canEdit) {
        this._panel = panel;
        this.originalName = fileName;
        JLabel label = new JLabel(labelText);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = yPosition;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(10, 5, 0, 0);
        this._panel.add((Component)label, gbc);
        this.fileNameText = new RmaJTextField();
        this.fileNameText.setText(fileName);
        label.setLabelFor((Component)this.fileNameText);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = yPosition;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(7, 5, 0, 0);
        this._panel.add((Component)this.fileNameText, gbc);
        this.fileNameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String filename = FilePanel.this.getFileName();
                if (FilePanel.this.editButton != null) {
                    FilePanel.this.editButton.setEnabled(filename != null && filename.length() > 0 && !filename.toLowerCase().endsWith(".csv"));
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String filename = FilePanel.this.getFileName();
                if (FilePanel.this.editButton != null) {
                    FilePanel.this.editButton.setEnabled(filename != null && filename.length() > 0 && !filename.toLowerCase().endsWith(".csv"));
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String filename = FilePanel.this.getFileName();
                if (FilePanel.this.editButton != null) {
                    FilePanel.this.editButton.setEnabled(filename != null && filename.length() > 0 && !filename.toLowerCase().endsWith(".csv"));
                }
            }
        });
        JButton browse = new JButton("Browse...");
        browse.setMnemonic('b');
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = yPosition;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 5, 0, 5);
        this._panel.add((Component)browse, gbc);
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String bname = FilePanel.this.browseAction(FilePanel.this.fileNameText.getText());
                if (bname != null) {
                    FilePanel.this.setFileName(bname);
                }
            }
        });
        if (canEdit) {
            this.editButton = new JButton("Edit...");
            this.editButton.setMnemonic('e');
            gbc = new GridBagConstraints();
            gbc.gridx = 5;
            gbc.gridy = yPosition;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.insets = new Insets(5, 5, 0, 5);
            this._panel.add((Component)this.editButton, gbc);
            this.editButton.setEnabled(fileName != null && fileName.strip().length() > 0);
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilePanel.this.edit();
                }
            });
        }
    }

    public String getFileName() {
        return this.fileNameText.getText();
    }

    public void setFileName(String name) {
        this.fileNameText.setText(name);
        this._dirty = true;
    }

    public boolean dirty() {
        if (this._dirty) {
            return true;
        }
        return !this.getFileName().equals(this.originalName);
    }

    protected String browseAction(String fileName) {
        String startDir = null;
        startDir = fileName.length() > 0 ? fileName : System.getProperty("user.dir");
        JFileChooser chooser = new JFileChooser(startDir);
        chooser.setDialogType(0);
        chooser.setApproveButtonText("OK");
        chooser.showOpenDialog(this._panel);
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        return selectedFile.getAbsolutePath().replace('\\', '/');
    }

    protected void edit() {
        ActionEvent event = new ActionEvent(this, 1001, "edit");
        this.fireActionPerformed(event);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }
}

