/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui.options;

import hec.dssgui.Help;
import hec.dssgui.ObservableClass;
import hec.dssgui.options.GeneralPanel;
import hec.dssgui.options.ShefPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observer;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJDialog;

public class OptionsDialog
extends RmaJDialog {
    private boolean _guiBuilt = false;
    private Frame _owner;
    protected Preferences _preferences;
    protected String _appDirectory;
    private ButtonCmdPanel cmdPanel;
    private JPanel jPanel1;
    private JTabbedPane optionsTabPane;
    protected ObservableClass _observer;
    protected GeneralPanel _generalPanel;
    protected ShefPanel _shefPanel;
    boolean fComponentsAdjusted = false;

    public OptionsDialog(Frame owner, Preferences preferences, String appDirectory, boolean modal) {
        super(owner, modal);
        this._owner = owner;
        this._preferences = preferences;
        this._appDirectory = appDirectory;
        this._observer = new ObservableClass();
        this._generalPanel = new GeneralPanel((JDialog)((Object)this));
        this._shefPanel = new ShefPanel(this._preferences, this._appDirectory);
        this.load();
    }

    protected void load() {
        this._shefPanel.load();
    }

    public String getShefParserFile() {
        return this._shefPanel.getShefParserFile();
    }

    public String getShefParmFile() {
        return this._shefPanel.getShefParmFile();
    }

    public String getShefSensorFile() {
        return this._shefPanel.getShefSensorFile();
    }

    public String getShefParameterFile() {
        return this._shefPanel.getShefParameterFile();
    }

    private void buildControls() {
        this.load();
        this.setTitle("Options");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setVisible(false);
        this.setSize(620, 200);
        this.setDefaultSize(620, 200);
        this.jPanel1 = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.jPanel1.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipady = 0;
        this.getContentPane().add((Component)this.jPanel1, gbc);
        this.optionsTabPane = new JTabbedPane(1);
        ImageIcon icon = new ImageIcon("images/middle.gif");
        this.optionsTabPane.addTab("General", icon, (Component)((Object)this._generalPanel), "General program options");
        this.optionsTabPane.addTab("SHEF", icon, (Component)((Object)this._shefPanel), "Set SHEF import parameter files");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.optionsTabPane, gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        Help.setHelp((RootPaneContainer)((Object)this), "32");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        OptionsDialog.this.jBok_actionPerformed();
                        break;
                    }
                    case 4: {
                        OptionsDialog.this.jBcancel_actionPerformed();
                    }
                }
            }
        });
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.pack();
        this._guiBuilt = true;
    }

    void JDialog1_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    private void jBok_actionPerformed() {
        int numModelTabs = this.optionsTabPane.getTabCount();
        for (int i = 0; i < numModelTabs; ++i) {
            DefaultJPanel panel = (DefaultJPanel)this.optionsTabPane.getComponentAt(i);
            if (panel.savePanel()) continue;
            return;
        }
        this.setVisible(false);
    }

    private void jBcancel_actionPerformed() {
        this.load();
        this.setVisible(false);
    }

    private void enterPressed() {
        JButton b = this.getRootPane().getDefaultButton();
        if (b == null) {
            return;
        }
        b.doClick();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (!this._guiBuilt) {
                this.buildControls();
            }
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            int numModelTabs = this.optionsTabPane.getTabCount();
            for (int i = 1; i < numModelTabs; ++i) {
                DefaultJPanel panel = (DefaultJPanel)this.optionsTabPane.getComponentAt(i);
                panel.fillPanel();
            }
        }
        super.setVisible(visible);
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
            this._generalPanel.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void done() {
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == OptionsDialog.this) {
                OptionsDialog.this.JDialog1_WindowClosing(event);
            }
        }
    }
}

