/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui.options;

import hec.dataui.importExport.shef.ShefParamEditor;
import hec.dataui.importExport.shef.ShefParameterFileEditor;
import hec.dataui.importExport.shef.ShefSensorFileEditor;
import hec.dssgui.options.FilePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;

public class ShefPanel
extends DefaultJPanel {
    protected String _shefParserFile;
    protected String _shefParserFileKey = "ShefParserFile";
    protected String _shefParserFileDefault;
    protected boolean _shefParserFileDirty = false;
    protected String _shefParmFile;
    protected String _shefParmFileKey = "ShefParmFile";
    protected String _shefParmFileDefault;
    protected boolean _shefParmFileDirty = false;
    protected String _shefSensorFile;
    protected String _shefSensorFileKey = "ShefSensorFile";
    protected String _shefSensorFileDefault;
    protected boolean _shefSensorFileDirty = false;
    protected String _shefParameterFile;
    protected String _shefParameterFileKey = "ShefParameterFile";
    protected String _shefParameterFileDefault;
    protected boolean _shefParameterFileDirty = false;
    protected Preferences _preferences;
    FilePanel shefparserPanel;
    FilePanel shefparmPanel;
    FilePanel shefSensorPanel;
    FilePanel shefParameterPanel;

    public String getShefParserFile() {
        return this._preferences.get(this._shefParserFileKey, this._shefParserFileDefault);
    }

    public String getShefParmFile() {
        return this._preferences.get(this._shefParmFileKey, this._shefParmFileDefault);
    }

    public String getShefSensorFile() {
        return this._preferences.get(this._shefSensorFileKey, this._shefSensorFileDefault);
    }

    public String getShefParameterFile() {
        return this._preferences.get(this._shefParameterFileKey, this._shefParameterFileDefault);
    }

    public static void copyDirectoryTree(final Path sourceDir, final Path targetDir, final boolean replaceExisting) throws IOException {
        Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetPath = targetDir.resolve(sourceDir.relativize(dir));
                if (!Files.exists(targetPath, new LinkOption[0])) {
                    Files.createDirectory(targetPath, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (replaceExisting) {
                    Files.copy(file, targetDir.resolve(sourceDir.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(file, targetDir.resolve(sourceDir.relativize(file)), new CopyOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public ShefPanel(Preferences preferences, String appDirectory) {
        this._preferences = preferences;
        this._shefParserFileDefault = Paths.get(appDirectory, "config", "Shef", "shefParser").toString();
        this._shefParmFileDefault = "";
        this._shefSensorFileDefault = Paths.get(appDirectory, "config", "Shef", "shef_sensors.csv").toString();
        this._shefParameterFileDefault = Paths.get(appDirectory, "config", "Shef", "shef_parameters.csv").toString();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 0, 0);
        this.shefparserPanel = new FilePanel((JPanel)((Object)this), 0, "shefParser Script:", this.getShefParserFile(), false);
        this.shefparmPanel = new FilePanel((JPanel)((Object)this), 1, "ShefParm File:", this.getShefParmFile(), true);
        this.shefSensorPanel = new FilePanel((JPanel)((Object)this), 2, "Sensor File:", this.getShefSensorFile(), true);
        this.shefParameterPanel = new FilePanel((JPanel)((Object)this), 3, "Parameter File:", this.getShefParameterFile(), true);
        JLabel l = new JLabel(" ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 4;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        this.add(l, gbc);
        JPanel p = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 5, 3, 5);
        this.add(p, gbc);
        JButton defaultButton = new JButton("Defaults");
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        p.add((Component)defaultButton, gbc);
        defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShefPanel.this.defaults();
            }
        });
        this.shefparmPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("edit")) {
                    ShefPanel.this.editShefParmFile(ShefPanel.this.getShefParmFile());
                }
            }
        });
        this.shefSensorPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("edit")) {
                    ShefPanel.this.editSensorFile(ShefPanel.this.getShefSensorFile());
                }
            }
        });
        this.shefParameterPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("edit")) {
                    ShefPanel.this.editParameterFile(ShefPanel.this.getShefParameterFile());
                }
            }
        });
        this.populateConfigDir(appDirectory);
    }

    protected void populateConfigDir(String appDirectory) {
        try {
            Path installationConfigDir;
            Path appConfigDir = Paths.get(appDirectory, "config");
            if (!Files.exists(appConfigDir, new LinkOption[0]) && Files.exists(installationConfigDir = Paths.get(System.getProperty("user.dir"), "config"), new LinkOption[0])) {
                ShefPanel.copyDirectoryTree(installationConfigDir, appConfigDir, false);
                System.out.println(String.format("Initialized configuration directory %s from %s", appConfigDir, installationConfigDir));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void load() {
        this._shefParserFile = this.getShefParserFile();
        this._shefParserFileDirty = false;
        this._shefParmFile = this.getShefParmFile();
        this._shefParmFileDirty = false;
        this._shefSensorFile = this.getShefSensorFile();
        this._shefSensorFileDirty = false;
        this._shefParameterFile = this.getShefParameterFile();
        this._shefParameterFileDirty = false;
        this.shefparserPanel.setFileName(this._shefParserFile);
        this.shefparmPanel.setFileName(this._shefParmFile);
        this.shefSensorPanel.setFileName(this._shefSensorFile);
        this.shefParameterPanel.setFileName(this._shefParameterFile);
    }

    public void defaults() {
        this.shefparserPanel.setFileName(this._shefParserFileDefault);
        this.shefparmPanel.setFileName(this._shefParmFileDefault);
        this.shefSensorPanel.setFileName(this._shefSensorFileDefault);
        this.shefParameterPanel.setFileName(this._shefParameterFileDefault);
    }

    public boolean savePanel() {
        if (this.shefparserPanel.dirty()) {
            this.saveShefParserFile();
        }
        if (this.shefparmPanel.dirty()) {
            this.saveShefParmFile();
        }
        if (this.shefSensorPanel.dirty()) {
            this.saveShefSensorFile();
        }
        if (this.shefParameterPanel.dirty()) {
            this.saveShefParameterFile();
        }
        return true;
    }

    protected void saveShefParserFile() {
        this._shefParserFile = this.shefparserPanel.getFileName();
        this._preferences.put(this._shefParserFileKey, this._shefParserFile);
        this._shefParserFileDirty = false;
    }

    protected void saveShefParmFile() {
        this._shefParmFile = this.shefparmPanel.getFileName();
        this._preferences.put(this._shefParmFileKey, this._shefParmFile);
        this._shefParmFileDirty = false;
    }

    protected void saveShefSensorFile() {
        this._shefSensorFile = this.shefSensorPanel.getFileName();
        this._preferences.put(this._shefSensorFileKey, this._shefSensorFile);
        this._shefSensorFileDirty = false;
    }

    protected void saveShefParameterFile() {
        this._shefParameterFile = this.shefParameterPanel.getFileName();
        this._preferences.put(this._shefParameterFileKey, this._shefParameterFile);
        this._shefParameterFileDirty = false;
    }

    protected void editShefParmFile(String fileName) {
        File file = new File(fileName);
        ShefParamEditor editor = new ShefParamEditor(file);
        editor.setVisible(true);
    }

    protected void editSensorFile(String fileName) {
        File file = new File(fileName);
        ShefSensorFileEditor editor = new ShefSensorFileEditor(file);
        editor.setTitle("SHEF Sensor File   " + fileName);
        editor.setVisible(true);
    }

    protected void editParameterFile(String fileName) {
        File file = new File(fileName);
        ShefParameterFileEditor editor = new ShefParameterFileEditor(file);
        editor.setTitle("SHEF Parameter File   " + fileName);
        editor.setVisible(true);
    }
}

