/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui.plugins.common;

import hec.dssgui.plugins.common.RetrievalControlFrame;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;

public class ProgressDialog
extends RmaJDialog {
    private Object _parent = null;
    private JProgressBar _currentRecordProgress;
    private int _numRecords;
    private JProgressBar _overallRecordProgress;
    private RmaJTextField _statusLine;
    private Runnable _runnable;
    private SetCurrentRecordSizeRunner _setCurrentRecordSizeRunner;
    private SetCurrentRecordValueRunner _setCurrentRecordValueRunner;
    private SetStatusRunner _setStatusRunner;
    private Object _parentApp = null;
    private int _currentRecord = 0;
    private boolean _showCancel = false;
    private SetIndeterminateRunner _setIndeterminateRunner;

    public ProgressDialog(Dialog parentApp, int numRecords) {
        super(parentApp, false);
        this._parentApp = parentApp;
        this._numRecords = numRecords;
        this.buildControls();
    }

    public ProgressDialog(Frame parentApp, Component parent, int numRecords, boolean showCancel) {
        super(parentApp, false);
        this._parentApp = parentApp;
        this._parent = parent;
        this._numRecords = numRecords;
        this._showCancel = showCancel;
        this.buildControls();
    }

    public ProgressDialog(Frame parentApp, Component parent, int numRecords) {
        super(parentApp, false);
        this._parentApp = parentApp;
        this._parent = parent;
        this._numRecords = numRecords;
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Retrieve Progress");
        this._currentRecordProgress = new JProgressBar(0, 1);
        this._currentRecordProgress.setStringPainted(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._currentRecordProgress, gbc);
        this._overallRecordProgress = new JProgressBar(0, this._numRecords);
        this._overallRecordProgress.setString("Overall");
        this._overallRecordProgress.setStringPainted(true);
        ++gbc.gridy;
        this.getContentPane().add((Component)this._overallRecordProgress, gbc);
        this._statusLine = new RmaJTextField();
        this._statusLine.setEditable(false);
        ++gbc.gridy;
        this.getContentPane().add((Component)this._statusLine, gbc);
        if (this._showCancel) {
            ButtonCmdPanel cmdPanel = new ButtonCmdPanel(4);
            cmdPanel.setApplyAlwaysOn(true);
            ++gbc.gridy;
            this.getContentPane().add((Component)cmdPanel, gbc);
            cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

                public void buttonCmdActionPerformed(ActionEvent event) {
                    switch (event.getID()) {
                        case 4: {
                            ProgressDialog.this.jButtonCancel_actionPerformed(event);
                        }
                    }
                }
            });
        }
        this.pack();
        Dimension d = this.getSize();
        d.width += 100;
        this.setSize(d);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this._setCurrentRecordSizeRunner = new SetCurrentRecordSizeRunner();
        this._setCurrentRecordValueRunner = new SetCurrentRecordValueRunner();
        this._setIndeterminateRunner = new SetIndeterminateRunner();
        this._setStatusRunner = new SetStatusRunner();
    }

    public void jButtonCancel_actionPerformed(ActionEvent event) {
    }

    public void setIndeterminate(boolean tf) {
        this._setIndeterminateRunner.setIndetermineate(tf);
    }

    public void setCurrentRecordSize(int size) {
        this._setCurrentRecordSizeRunner.setCurrentRecordSize(size);
        this.run(this._setCurrentRecordSizeRunner);
    }

    public void setCurrentRecordValue(int currentLocation) {
        this._setCurrentRecordValueRunner.setCurrentLocation(currentLocation);
        this.run(this._setCurrentRecordValueRunner);
    }

    public void setStatusMessage(String msg) {
        this._setStatusRunner.setStatusMessage(msg);
        this.run(this._setStatusRunner);
        if (this._parentApp instanceof RetrievalControlFrame) {
            ((RetrievalControlFrame)((Object)this._parentApp)).updateStatusField(msg);
        }
    }

    private void run(Runnable run) {
        SwingUtilities.invokeLater(run);
    }

    public void setRunnable(Runnable run) {
        this._runnable = run;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setStatusMessage("Ready");
        }
        if (visible && this._runnable != null) {
            Thread t = new Thread(this._runnable);
            t.setPriority(3);
            t.start();
        }
    }

    class SetCurrentRecordSizeRunner
    implements Runnable {
        int _size;

        SetCurrentRecordSizeRunner() {
        }

        public void setCurrentRecordSize(int size) {
            this._size = size;
        }

        @Override
        public void run() {
            ProgressDialog.this._overallRecordProgress.setValue(ProgressDialog.this._currentRecord++);
            ProgressDialog.this._currentRecordProgress.setMaximum(this._size);
            ProgressDialog.this._currentRecordProgress.setValue(0);
        }
    }

    class SetCurrentRecordValueRunner
    implements Runnable {
        int _currentLocation;

        SetCurrentRecordValueRunner() {
        }

        public void setCurrentLocation(int currentLocation) {
            this._currentLocation = currentLocation;
        }

        @Override
        public void run() {
            ProgressDialog.this._currentRecordProgress.setValue(this._currentLocation);
        }
    }

    class SetIndeterminateRunner
    implements Runnable {
        boolean _indeterminate;

        SetIndeterminateRunner() {
        }

        public void setIndetermineate(boolean indeterminate) {
            this._indeterminate = indeterminate;
        }

        @Override
        public void run() {
            ProgressDialog.this._currentRecordProgress.setIndeterminate(this._indeterminate);
        }
    }

    class SetStatusRunner
    implements Runnable {
        String _msg;

        SetStatusRunner() {
        }

        public void setStatusMessage(String msg) {
            this._msg = msg;
        }

        @Override
        public void run() {
            ProgressDialog.this._statusLine.setText(this._msg);
        }
    }
}

