/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui.plugins.common;

import hec.dssgui.ListSelection;
import hec.dssgui.plugins.common.ProgressDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import rma.swing.RmaJFrame;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public abstract class RetrievalControlFrame
extends RmaJFrame {
    protected static final int MAX_LAST_FILES_SIZE = 5;
    protected Frame _parent;
    protected String _fileName = "";
    protected JTextField _fileNameTxt = new JTextField();
    protected String _currentDirectory = "";
    protected String _currentFile = "default";
    protected String _dssFile = null;
    protected ProgressDialog _progressDialog;
    protected boolean _startedFromDssVue;
    protected LinkedList _lastFileList = new LinkedList();
    protected JMenu _fileMenu;

    protected abstract void saveSettings();

    protected boolean writeFile(File openFile, boolean selectedOnly) {
        return false;
    }

    protected boolean writeFile(File openFile) {
        return false;
    }

    protected abstract boolean readFile(File var1);

    protected int getNumberSelected() {
        return 1;
    }

    public void pickDSSFileAction() {
        File f;
        JFileChooser chooser = new JFileChooser(this._fileNameTxt.getText());
        chooser.setFileFilter((FileFilter)new RMAFilenameFilter("dss", "DSS Files"));
        if (chooser.showOpenDialog((Component)((Object)this)) == 0 && (f = chooser.getSelectedFile()) != null) {
            this._fileNameTxt.setText(f.getAbsolutePath());
        }
    }

    public void setCurrentDirectory(String currentDirectory) {
        this._currentDirectory = currentDirectory;
        this._fileNameTxt.setText(this._currentDirectory);
    }

    public void setDSSFileName(String dssFileName) {
        this._fileNameTxt.setText(dssFileName);
    }

    public void closeDialog() {
        this.saveSettings();
        this.setVisible(false);
        if (!this._startedFromDssVue) {
            System.exit(0);
        }
    }

    public void openFile(String fileExtension) {
        File selectedFile = null;
        boolean success = false;
        RMAFilenameFilter ff = new RMAFilenameFilter(new String[]{fileExtension}, "*." + fileExtension);
        JFileChooser chooser = new JFileChooser(this._currentDirectory);
        chooser.setFileFilter((FileFilter)ff);
        int returnVal = chooser.showOpenDialog((Component)((Object)this));
        if (returnVal == 0 && chooser.getSelectedFile() != null) {
            selectedFile = chooser.getSelectedFile();
            System.out.println("You chose to open this file: " + selectedFile.getName());
            this.openFile(selectedFile);
        }
    }

    public void openFile(File openFile) {
        String path;
        boolean success = this.readFile(openFile);
        this._currentDirectory = openFile.getParent();
        if (this._lastFileList.size() == 5) {
            this._lastFileList.removeLast();
        }
        if (this._lastFileList.contains(path = openFile.getAbsolutePath())) {
            this._lastFileList.remove(path);
            this._lastFileList.addFirst(path);
            this.buildLastFilesList();
        } else {
            this._lastFileList.addFirst(path);
            this.buildLastFilesList();
        }
        System.out.println("Current Directory: " + this._currentDirectory);
        if (success) {
            // empty if block
        }
    }

    public void saveFile(String fileExtension) {
        this.saveFile(fileExtension, false);
    }

    public void saveFile(String fileExtension, boolean selectedOnly) {
        int numb;
        if (selectedOnly && (numb = this.getNumberSelected()) == 0) {
            JOptionPane.showMessageDialog(null, "No stations selected to save", "Save Selected", 2);
            return;
        }
        File openFile = null;
        RMAFilenameFilter ff = new RMAFilenameFilter(new String[]{fileExtension}, "*." + fileExtension);
        JFileChooser chooser = new JFileChooser(this._currentDirectory);
        chooser.setFileFilter((FileFilter)ff);
        int returnVal = chooser.showSaveDialog((Component)((Object)this));
        if (returnVal == 0 && chooser.getSelectedFile() != null) {
            openFile = chooser.getSelectedFile();
            String name = openFile.getAbsolutePath();
            this.saveFile(name, fileExtension, selectedOnly);
        }
    }

    public void saveFile(String name, String fileExtension, boolean selectedOnly) {
        String path;
        File openFile = !name.endsWith(fileExtension) ? new File(name + "." + fileExtension) : new File(name);
        System.out.println("Saving to file: " + openFile.getName());
        this.writeFile(openFile, selectedOnly);
        this._currentDirectory = openFile.getParent();
        this._currentFile = openFile.getAbsolutePath();
        System.out.println("Current Directory: " + this._currentDirectory);
        System.out.println("Current File: " + this._currentFile);
        if (this._lastFileList.size() == 5) {
            this._lastFileList.removeLast();
        }
        if (this._lastFileList.contains(path = openFile.getAbsolutePath())) {
            this._lastFileList.remove(path);
            this._lastFileList.addFirst(path);
            this.buildLastFilesList();
        } else {
            this._lastFileList.addFirst(path);
            this.buildLastFilesList();
        }
        JOptionPane.showMessageDialog(null, "Saved Station List to file " + this._currentFile, "Save Station List", 1);
    }

    protected void buildLastFilesList() {
        Component menu;
        int cnt = this._fileMenu.getMenuComponentCount();
        for (int i = cnt - 1; i >= 0 && (menu = this._fileMenu.getMenuComponent(i)) instanceof ReloadMenuItem; --i) {
            this._fileMenu.remove(menu);
        }
        cnt = this._fileMenu.getMenuComponentCount();
        if (!(this._fileMenu.getMenuComponent(cnt - 1) instanceof JSeparator)) {
            this._fileMenu.addSeparator();
        }
        for (int i = 0; i < this._lastFileList.size(); ++i) {
            String path = (String)this._lastFileList.get(i);
            if (path == null || path.length() == 0) continue;
            ReloadMenuItem reloadMenu = new ReloadMenuItem(RMAIO.getFileFromPath((String)path), path);
            this._fileMenu.add(reloadMenu);
        }
    }

    public void updateStatusField(String message) {
        if (this._parent instanceof ListSelection) {
            ((ListSelection)this._parent).updateStatusField(message);
        }
    }

    protected class ReloadMenuItem
    extends JMenuItem {
        public ReloadMenuItem(String name, String path) {
            super(name);
            this.setToolTipText(path);
            this.setName(path);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f = new File(ReloadMenuItem.this.getName());
                    RetrievalControlFrame.this.openFile(f);
                }
            });
        }
    }
}

