/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui.waterquality;

import com.rma.paint.isoclineg2dplot.IsoclineContoursG2dObject;
import com.rma.paint.isoclineg2dplot.IsoclineG2dObject;
import com.rma.paint.isoclineg2dplot.PointerMouseAdapter;
import com.rma.paint.isoclinepaint.BiFunction;
import com.rma.paint.isoclinepaint.ColorGradient;
import com.rma.paint.isoclinepaint.DepthToElevationFunction;
import com.rma.paint.isoclinepaint.DoubleArrayFunction;
import com.rma.paint.isoclinepaint.Function;
import com.rma.paint.isoclinepaint.Gradient;
import com.rma.paint.isoclinepaint.IsoclineFunction;
import hec.data.Parameter;
import hec.geometry.Axis;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.ToolbarButtonProp;
import hec.gfx2d.ViewportToolbar;
import hec.gfx2d.ViewportToolbarProp;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class WaterQualityProfilePlotWindow
extends JFrame {
    private JCheckBox showContourLines;
    private String waterQualityValueParameter = "";
    private JEditorPane htmlPane;
    private JPanel legendPanel;
    private G2dPanel tempGradientPanel;
    private G2dPanel depthTempPanel;
    private G2dPanel tempTimeSeriesPanel;
    private IsoclineContoursG2dObject contours;
    private double minDepthBounds;
    private double maxDepthBounds;
    private double minDepthElevationBounds;
    private double maxDepthElevationBounds;
    private double minZValue;
    private double maxZValue;
    private NavigableMap<LocalDateTime, double[][]> dateToDepthTemperature = new TreeMap<LocalDateTime, double[][]>();
    private NavigableMap<Double, TimeSeriesContainer> depthTempTs;
    private DoubleArrayFunction wseFunction = null;
    private String waterQualityValueUnits;
    private String waterQualityLocationUnits;
    PairedDataSet depthTempPDC = null;
    TimeSeriesDataSet tempTimeSeries = null;

    public WaterQualityProfilePlotWindow() {
        this.buildComponents();
    }

    private void buildComponents() {
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        JSplitPane jsp = new JSplitPane();
        jsp.setDividerLocation(0.33);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        cp.add((Component)jsp, gbc);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        JPanel rightPanel = new JPanel(new GridBagLayout());
        jsp.setTopComponent(leftPanel);
        jsp.setBottomComponent(rightPanel);
        this.legendPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return WaterQualityProfilePlotWindow.this.tempGradientPanel.getPreferredSize();
            }
        };
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 0, 0);
        leftPanel.add((Component)this.legendPanel, gbc);
        this.legendPanel.setLayout(new GridBagLayout());
        this.htmlPane = new JEditorPane();
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.legendPanel.add((Component)jScrollPane, gbc);
        this.htmlPane.setContentType("text/html");
        this.showContourLines = new JCheckBox("Show Contour Lines");
        this.showContourLines.setSelected(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.legendPanel.add((Component)this.showContourLines, gbc);
        this.showContourLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaterQualityProfilePlotWindow.this.showContourLines(WaterQualityProfilePlotWindow.this.showContourLines.isSelected());
            }
        });
        this.depthTempPanel = new G2dPanel(){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                Dimension preferredSize1 = WaterQualityProfilePlotWindow.this.tempGradientPanel.getPreferredSize();
                preferredSize.height = preferredSize1.height;
                return preferredSize;
            }
        };
        this.depthTempPanel.setTitle("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 16;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 0);
        leftPanel.add((Component)this.depthTempPanel, gbc);
        this.tempGradientPanel = new G2dPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 12;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        rightPanel.add((Component)this.tempGradientPanel, gbc);
        this.tempTimeSeriesPanel = new G2dPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 14;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        rightPanel.add((Component)this.tempTimeSeriesPanel, gbc);
    }

    public static void main(String[] args) {
        WaterQualityProfilePlotWindow pw = new WaterQualityProfilePlotWindow();
        pw.setLocation(500, 500);
        pw.setSize(750, 300);
        pw.setVisible(true);
    }

    private void showContourLines(boolean visible) {
        this.contours.setShowContourLines(visible);
    }

    public void setData(List<TimeSeriesContainer> dataSet) {
        DSSPathname dssPathname;
        IsoclineFunction oclineFunction;
        TimeSeriesContainer wse = null;
        this.depthTempTs = new TreeMap<Double, TimeSeriesContainer>();
        String location = "";
        String xxx = "";
        Pattern pattern = Pattern.compile("(.*)([D|H|E])(\\d+\\,?\\d*)(.*)");
        double[] depths = new double[]{};
        ArrayList<Object> depthsList = new ArrayList<Object>();
        for (TimeSeriesContainer tsc : dataSet) {
            String tscLocation = tsc.location + tsc.subLocation;
            if ("ELEV".equalsIgnoreCase(tsc.parameter) && wse == null) {
                wse = tsc;
                continue;
            }
            this.waterQualityValueParameter = tsc.parameter;
            this.waterQualityValueUnits = tsc.units;
            Matcher matcher = pattern.matcher(tscLocation);
            Object depth1 = 0.0;
            if (!matcher.matches() || matcher.groupCount() != 4) continue;
            location = matcher.group(1);
            xxx = matcher.group(2);
            depth1 = RMAIO.parseDouble((String)matcher.group(3), (double)0.0);
            this.waterQualityLocationUnits = matcher.group(4);
            depthsList.add(depth1);
            this.depthTempTs.put((Double)depth1, tsc);
        }
        depths = new double[depthsList.size()];
        for (int i = 0; i < depths.length; ++i) {
            depths[i] = (Double)depthsList.get(i);
        }
        if (this.depthTempTs.isEmpty()) {
            return;
        }
        TreeMap<Integer, LocalDateTime> dateTimeLookup = new TreeMap<Integer, LocalDateTime>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("ddMMMyyyy, HH:mm");
        int depthIdx = 0;
        this.minDepthBounds = 2.147483647E9;
        this.maxDepthBounds = -2.147483648E9;
        this.minZValue = Double.MAX_VALUE;
        this.maxZValue = Double.MIN_VALUE;
        Set tsentrySet = this.depthTempTs.entrySet();
        for (Map.Entry entry : tsentrySet) {
            TimeSeriesContainer depthTempT = (TimeSeriesContainer)entry.getValue();
            String tscLocation = depthTempT.location + depthTempT.subLocation;
            Matcher matcher = pattern.matcher(tscLocation);
            Double depth1 = matcher.matches() && matcher.groupCount() >= 3 ? Double.valueOf(matcher.group(3).replace(',', '.')) : 0.0;
            this.minDepthBounds = Math.min(depth1, this.minDepthBounds);
            this.maxDepthBounds = Math.max(depth1, this.maxDepthBounds);
            this.minDepthElevationBounds = this.minDepthBounds;
            this.maxDepthElevationBounds = this.maxDepthBounds;
            for (int i = 0; i < depthTempT.numberValues; ++i) {
                double[][] function;
                LocalDateTime dateTime = (LocalDateTime)dateTimeLookup.get(depthTempT.times[i]);
                if (dateTime == null) {
                    HecTime hTime = new HecTime();
                    hTime.set(depthTempT.times[i], depthTempT.getTimeGranularitySeconds(), depthTempT.getJulianBaseDate());
                    dateTime = LocalDateTime.parse(hTime.dateAndTime(4), formatter);
                    dateTimeLookup.put(depthTempT.times[i], dateTime);
                }
                if ((function = (double[][])this.dateToDepthTemperature.get(dateTime)) == null) {
                    function = new double[2][this.depthTempTs.size()];
                    this.dateToDepthTemperature.put(dateTime, function);
                }
                function[0][depthIdx] = depth1;
                function[1][depthIdx] = depthTempT.values[i];
                if (!RMAConst.isValidValue((double)depthTempT.values[i])) continue;
                this.minZValue = Math.min(depthTempT.values[i], this.minZValue);
                this.maxZValue = Math.max(depthTempT.values[i], this.maxZValue);
            }
            ++depthIdx;
        }
        ArrayList<double[][]> depthFunctions = new ArrayList<double[][]>();
        ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
        Set entrySet = dateTimeLookup.entrySet();
        for (Map.Entry entry : entrySet) {
            arrayList.add((LocalDateTime)entry.getValue());
            depthFunctions.add((double[][])this.dateToDepthTemperature.get(entry.getValue()));
        }
        long toEpochSecond0 = !arrayList.isEmpty() ? ((LocalDateTime)arrayList.get(0)).toEpochSecond(ZoneOffset.UTC) : 0L;
        long toEpochSecond1 = !arrayList.isEmpty() ? ((LocalDateTime)arrayList.get(arrayList.size() - 1)).toEpochSecond(ZoneOffset.UTC) : 0L;
        WorldRect worldBounds = new WorldRect((double)toEpochSecond0, this.maxDepthBounds, (double)toEpochSecond1, this.minDepthBounds);
        IsoclineFunction plotFunction = oclineFunction = new IsoclineFunction(arrayList, depthFunctions);
        if (wse != null) {
            double minWSEBounds = 2.147483647E9;
            double maxWSEBounds = -2.147483648E9;
            double[][] function = new double[2][wse.numberValues];
            for (int i = 0; i < wse.numberValues; ++i) {
                minWSEBounds = Math.min(wse.values[i], minWSEBounds);
                maxWSEBounds = Math.max(wse.values[i], maxWSEBounds);
                LocalDateTime dateTime = (LocalDateTime)dateTimeLookup.get(wse.times[i]);
                if (dateTime == null) {
                    HecTime hTime = new HecTime();
                    hTime.set(wse.times[i], wse.getTimeGranularitySeconds(), wse.getJulianBaseDate());
                    dateTime = LocalDateTime.parse(hTime.dateAndTime(4), formatter);
                    dateTimeLookup.put(wse.times[i], dateTime);
                }
                function[0][i] = dateTime.toEpochSecond(ZoneOffset.UTC);
                function[1][i] = wse.values[i];
            }
            this.wseFunction = new DoubleArrayFunction(function);
            plotFunction = new DepthToElevationFunction((Function)this.wseFunction, (BiFunction)oclineFunction);
            worldBounds = new WorldRect(worldBounds.w, maxWSEBounds, worldBounds.e, minWSEBounds - this.maxDepthBounds);
            this.minDepthElevationBounds = worldBounds.s;
            this.maxDepthElevationBounds = worldBounds.n;
        }
        IsoclineG2dObject g2dObject = new IsoclineG2dObject();
        g2dObject.setYAxisName(this.wseFunction != null ? "Elevation (" + this.waterQualityLocationUnits + ")" : "Depth(" + this.waterQualityLocationUnits + ")");
        g2dObject.setYParameterId(this.wseFunction != null ? Parameter.PARAMID_ELEV : Parameter.PARAMID_DEPTH);
        Listener listener = new Listener();
        g2dObject.addPointOverListener((IsoclineG2dObject.PointOverListener)listener);
        g2dObject.setData((BiFunction)plotFunction, worldBounds);
        ArrayList<Double> gradientValues = new ArrayList<Double>();
        double minz = this.minZValue;
        double maxz = this.maxZValue;
        gradientValues.add(minz);
        gradientValues.add(minz + 0.33 * (maxz - minz));
        gradientValues.add(minz + 0.66 * (maxz - minz));
        gradientValues.add(minz + 1.0 * (maxz - minz));
        ColorGradient cc = new ColorGradient(gradientValues, Arrays.asList(Color.BLUE, Color.GREEN, Color.YELLOW, Color.RED));
        g2dObject.setColorGradient((Gradient)cc);
        this.contours = new IsoclineContoursG2dObject();
        this.contours.setYAxisName(g2dObject.getYAxisName());
        this.contours.setYParameterId(g2dObject.getYParameterId());
        ArrayList<Object> contourFunctions = new ArrayList<Object>();
        for (double depth : depths) {
            if (this.wseFunction != null) {
                contourFunctions.add(new DepthToElevationTimeSeries(depth, (Function<Double, Double>)this.wseFunction));
                continue;
            }
            contourFunctions.add(new ConstantDepthFunctionTimeSeries(depth));
        }
        this.contours.setData(contourFunctions, worldBounds);
        Map.Entry<LocalDateTime, double[][]> firstEntry = this.dateToDepthTemperature.lastEntry();
        if (firstEntry != null) {
            LocalDateTime key = firstEntry.getKey();
            double[][] value = firstEntry.getValue();
            long toEpochSecond = key.toEpochSecond(ZoneOffset.UTC);
            double depthElevation = 0.0;
            depthElevation = this.wseFunction != null ? this.wseFunction.compute(Double.valueOf(toEpochSecond)) : value[0][0];
            listener.pointOver(Double.valueOf(toEpochSecond), depthElevation);
        }
        Vector<Object> v = new Vector<Object>();
        v.add(g2dObject);
        v.add(this.contours);
        this.tempGradientPanel.setVisible(false);
        this.tempGradientPanel.buildComponents(v);
        this.tempGradientPanel.setLegendVisible(false);
        TitleDrawProp titleProperties = new TitleDrawProp();
        titleProperties.setLabel(this.waterQualityValueParameter);
        titleProperties.setFontSize(14);
        titleProperties.setMaxFontSize(14);
        titleProperties.setMinFontSize(14);
        titleProperties.setDrawTitle(true);
        this.tempGradientPanel.getTitlePanel().setProperties(titleProperties);
        ViewportToolbar viewportToolbar = this.tempGradientPanel.getViewportToolbar();
        ViewportToolbarProp properties = new ViewportToolbarProp();
        ToolbarButtonProp buttonProp = new ToolbarButtonProp();
        buttonProp.up = "Images/Point.gif";
        buttonProp.down = "Images/Point.gif";
        buttonProp.over = "Images/Point.gif";
        buttonProp.on = "Images/Point.gif";
        buttonProp.adapter = PointerMouseAdapter.class.getName();
        properties.addButtonProp(buttonProp);
        buttonProp = new ToolbarButtonProp();
        buttonProp.up = "Images/ZoomUp.gif";
        buttonProp.down = "Images/ZoomDown.gif";
        buttonProp.over = "Images/ZoomUp.gif";
        buttonProp.on = "Images/ZoomDown.gif";
        buttonProp.adapter = "hec.gfx2d.G2dZoomAdapter";
        properties.addButtonProp(buttonProp);
        viewportToolbar.configureToolbar(properties);
        Axis viewportAxis = this.tempGradientPanel.getViewportAxis(this.tempGradientPanel.getViewports()[0], 2);
        viewportAxis.setReversed(this.wseFunction != null);
        this.tempGradientPanel.setVisible(true);
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("<html><head><style>div.a {     text-indent: 10px;    white-space: nowrap}</style></head><body>");
        sbuilder.append("<h2>Location: </h2>");
        DSSPathname dSSPathname = dssPathname = this.depthTempTs.size() > 0 ? new DSSPathname(this.depthTempTs.firstEntry().getValue().fullName) : new DSSPathname();
        if (!dssPathname.aPart().isEmpty()) {
            sbuilder.append("<div class=\"a\">").append(dssPathname.aPart()).append("</div>");
        }
        if (!dssPathname.bPart().isEmpty()) {
            sbuilder.append("<div class=\"a\">").append(location).append("</div>");
        }
        if (xxx != null && xxx.length() > 0) {
            String xxx2 = xxx.equals("D") ? "Depth" : (xxx.equals("E") ? "Elevation" : "Height");
            sbuilder.append("<div class=\"a\">").append(xxx2).append(" ");
            Set keySet = this.depthTempTs.keySet();
            boolean firstTime = true;
            for (Double double1 : keySet) {
                if (!firstTime) {
                    sbuilder.append(", ");
                }
                sbuilder.append(double1);
                firstTime = false;
            }
        }
        if (!dssPathname.cPart().isEmpty()) {
            sbuilder.append("<div class=\"a\">").append(dssPathname.cPart()).append("</div>");
        }
        if (!dssPathname.ePart().isEmpty()) {
            sbuilder.append("<div class=\"a\">").append(dssPathname.ePart()).append("</div>");
        }
        if (!dssPathname.fPart().isEmpty()) {
            sbuilder.append("<div class=\"a\">").append(dssPathname.fPart()).append("</div>");
        }
        if (wse != null) {
            sbuilder.append("<h3><u>Water Surface Elevation</u></h3>").append(wse.fullName);
        }
        sbuilder.append("</body></html>");
        this.htmlPane.setText(sbuilder.toString());
    }

    private class Listener
    implements IsoclineG2dObject.PointOverListener {
        private Listener() {
        }

        public void pointOver(Double xval, Double yval) {
            TimeSeriesContainer newTimeSeriesContainer;
            LocalDateTime ldt = LocalDateTime.ofEpochSecond(xval.longValue(), 0, ZoneOffset.UTC);
            double depth = yval;
            boolean plotYAxisReveresed = WaterQualityProfilePlotWindow.this.wseFunction == null;
            String depthElevationLabel = "Depth";
            Map.Entry<LocalDateTime, double[][]> floorEntry = WaterQualityProfilePlotWindow.this.dateToDepthTemperature.floorEntry(ldt);
            double[][] value = floorEntry.getValue();
            double[][] tempValue = new double[2][value[0].length];
            if (WaterQualityProfilePlotWindow.this.wseFunction != null) {
                double wse = WaterQualityProfilePlotWindow.this.wseFunction.compute(Double.valueOf(ldt.toEpochSecond(ZoneOffset.UTC)));
                depth = wse - yval;
                depthElevationLabel = "Elevation";
                for (int i = 0; i < tempValue[0].length; ++i) {
                    tempValue[0][i] = wse - value[0][i];
                    tempValue[1][i] = value[1][i];
                }
            } else {
                System.arraycopy(value[0], 0, tempValue[0], 0, tempValue[0].length);
                System.arraycopy(value[1], 0, tempValue[1], 0, tempValue[1].length);
            }
            value = tempValue;
            ldt = floorEntry.getKey();
            PairedDataContainer pdc = new PairedDataContainer();
            pdc.xOrdinates = value[1];
            pdc.yOrdinates = new double[][]{value[0]};
            pdc.xunits = WaterQualityProfilePlotWindow.this.waterQualityValueParameter + " (" + WaterQualityProfilePlotWindow.this.waterQualityValueUnits + ")";
            pdc.yunits = depthElevationLabel + " (" + WaterQualityProfilePlotWindow.this.waterQualityLocationUnits + ")";
            pdc.curveVisible = new boolean[]{true};
            pdc.numberCurves = 1;
            pdc.numberOrdinates = value[0].length;
            WaterQualityProfilePlotWindow.this.depthTempPanel.setVisible(false);
            WaterQualityProfilePlotWindow.this.depthTempPDC = new PairedDataSet(pdc){

                public WorldRect getBounds() {
                    WorldRect wr = super.getBounds();
                    wr.w = WaterQualityProfilePlotWindow.this.minZValue;
                    wr.e = WaterQualityProfilePlotWindow.this.maxZValue;
                    wr.n = WaterQualityProfilePlotWindow.this.maxDepthElevationBounds;
                    wr.s = WaterQualityProfilePlotWindow.this.minDepthElevationBounds;
                    return wr;
                }
            };
            WaterQualityProfilePlotWindow.this.depthTempPDC.setName(ldt.toString());
            WaterQualityProfilePlotWindow.this.depthTempPanel.buildComponents(Collections.singletonList(WaterQualityProfilePlotWindow.this.depthTempPDC));
            Axis viewportAxis = WaterQualityProfilePlotWindow.this.depthTempPanel.getViewportAxis(WaterQualityProfilePlotWindow.this.depthTempPanel.getViewports()[0], 2);
            viewportAxis.setReversed(!plotYAxisReveresed);
            WaterQualityProfilePlotWindow.this.depthTempPanel.setLegendVisible(false);
            WaterQualityProfilePlotWindow.this.depthTempPanel.setVisible(true);
            TitleDrawProp properties = new TitleDrawProp();
            properties.setLabel(depthElevationLabel + " vs " + WaterQualityProfilePlotWindow.this.waterQualityValueParameter + " at Time: " + ldt.toString());
            properties.setFontSize(14);
            properties.setMaxFontSize(14);
            properties.setMinFontSize(14);
            properties.setDrawTitle(true);
            WaterQualityProfilePlotWindow.this.depthTempPanel.getTitlePanel().setProperties(properties);
            WaterQualityProfilePlotWindow.this.tempTimeSeriesPanel.setVisible(false);
            if (WaterQualityProfilePlotWindow.this.wseFunction != null) {
                int[] timeseriesTimes = new int[WaterQualityProfilePlotWindow.this.dateToDepthTemperature.size()];
                double[] timeseriesValues = new double[WaterQualityProfilePlotWindow.this.dateToDepthTemperature.size()];
                Set entrySet = WaterQualityProfilePlotWindow.this.dateToDepthTemperature.entrySet();
                int i = 0;
                Map.Entry<Double, TimeSeriesContainer> firstEntry = WaterQualityProfilePlotWindow.this.depthTempTs.firstEntry();
                for (Map.Entry entry : entrySet) {
                    LocalDateTime ldt1 = (LocalDateTime)entry.getKey();
                    double wse = WaterQualityProfilePlotWindow.this.wseFunction.compute(Double.valueOf(ldt1.toEpochSecond(ZoneOffset.UTC)));
                    double depthAtTime = wse - yval;
                    double[][] value1 = (double[][])entry.getValue();
                    if (depthAtTime >= 0.0) {
                        DoubleArrayFunction function = new DoubleArrayFunction(value1);
                        timeseriesValues[i] = function.compute(Double.valueOf(depthAtTime));
                        if (RMAConst.isUndefinedValue((double)timeseriesValues[i])) {
                            timeseriesValues[i] = Double.NEGATIVE_INFINITY;
                        }
                    } else {
                        timeseriesValues[i] = Double.NEGATIVE_INFINITY;
                    }
                    timeseriesTimes[i] = firstEntry.getValue().times[i];
                    ++i;
                }
                newTimeSeriesContainer = new TimeSeriesContainer();
                firstEntry.getValue().clone(newTimeSeriesContainer);
                newTimeSeriesContainer.times = timeseriesTimes;
                newTimeSeriesContainer.values = timeseriesValues;
            } else {
                Object tscEntry = WaterQualityProfilePlotWindow.this.depthTempTs.size() == 1 ? WaterQualityProfilePlotWindow.this.depthTempTs.firstEntry() : (WaterQualityProfilePlotWindow.this.depthTempTs.isEmpty() ? null : WaterQualityProfilePlotWindow.this.depthTempTs.floorEntry(depth));
                newTimeSeriesContainer = tscEntry != null ? tscEntry.getValue() : new TimeSeriesContainer();
            }
            WaterQualityProfilePlotWindow.this.tempTimeSeries = new TimeSeriesDataSet(newTimeSeriesContainer){

                public WorldRect getBounds() {
                    WorldRect wr = super.getBounds();
                    wr.s = WaterQualityProfilePlotWindow.this.minZValue;
                    wr.n = WaterQualityProfilePlotWindow.this.maxZValue;
                    return wr;
                }
            };
            WaterQualityProfilePlotWindow.this.tempTimeSeriesPanel.buildComponents(Collections.singletonList(WaterQualityProfilePlotWindow.this.tempTimeSeries));
            WaterQualityProfilePlotWindow.this.tempTimeSeries.setName(WaterQualityProfilePlotWindow.this.waterQualityValueParameter + " at " + depthElevationLabel + ": " + new DecimalFormat("###.00").format(yval) + " " + WaterQualityProfilePlotWindow.this.waterQualityLocationUnits);
            WaterQualityProfilePlotWindow.this.tempTimeSeriesPanel.setLegendVisible(false);
            properties = new TitleDrawProp();
            properties.setLabel(WaterQualityProfilePlotWindow.this.waterQualityValueParameter + " at " + depthElevationLabel + ": " + new DecimalFormat("###.00").format(yval) + " " + WaterQualityProfilePlotWindow.this.waterQualityLocationUnits);
            properties.setFontSize(14);
            properties.setMaxFontSize(14);
            properties.setMinFontSize(14);
            properties.setDrawTitle(true);
            WaterQualityProfilePlotWindow.this.tempTimeSeriesPanel.getTitlePanel().setProperties(properties);
            WaterQualityProfilePlotWindow.this.tempTimeSeriesPanel.setVisible(true);
        }
    }

    private class DepthToElevationTimeSeries
    implements Function<Double, Double> {
        private final Function<Double, Double> wseFunction;
        private final double depth;

        public DepthToElevationTimeSeries(double depth, Function<Double, Double> wseFunction) {
            this.depth = depth;
            this.wseFunction = wseFunction;
        }

        public Double compute(Double x) {
            return (Double)this.wseFunction.compute((Object)x) - this.depth;
        }
    }

    private class ConstantDepthFunctionTimeSeries
    implements Function<Double, Double> {
        private final double depth;

        public ConstantDepthFunctionTimeSeries(double depth) {
            this.depth = depth;
        }

        public Double compute(Double x) {
            return this.depth;
        }
    }
}

