/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ComputationException;
import hec.statistics.ContDist;
import hec.statistics.EquationSolverBiSearch;
import hec.statistics.EquationSolverMultiVariateNewton;
import hec.statistics.EquationSolverNelderMead;
import hec.statistics.EquationSolverNewton;
import hec.statistics.EquationSolverNewtonBiSearch;
import hec.statistics.FunctionMinimizer;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.bootstrap.BootstrapAnalysis;
import hec.statistics.bootstrap.BootstrapAnalysisContainer;
import hec.statistics.bootstrap.CombinedAnalysis;
import hec.statistics.bootstrap.ConfidenceLimitAnalysis;
import hec.statistics.bootstrap.ExpectedProbabilityAnalysis;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public abstract class AbstractContDist
implements ContDist {
    private final EquationSolverBiSearch invCDFSolverBiSearch = new EquationSolverBiSearch(){

        @Override
        public double f(double x) {
            return AbstractContDist.this.getCDF(x);
        }
    };
    private final EquationSolverNewton invCDFSolverNewton = new EquationSolverNewton(){

        @Override
        public double f(double x) {
            return AbstractContDist.this.getCDF(x);
        }

        @Override
        public double dfdx(double x) {
            return AbstractContDist.this.getPDF(x);
        }
    };
    private final EquationSolverNewtonBiSearch invCDFSolverNewtonBiSearch = new EquationSolverNewtonBiSearch(){

        @Override
        public double f(double x) {
            return AbstractContDist.this.getCDF(x);
        }

        @Override
        public double dfdx(double x) {
            return AbstractContDist.this.getPDF(x);
        }
    };

    @Override
    public boolean fitSampleData(double[] sample) {
        return this.fitSampleData(sample, FittingMethod.ProductMoments);
    }

    @Override
    public boolean fitSampleData(double[] sample, FittingMethod method) {
        switch (method) {
            default: {
                ProductMoments pm = new ProductMoments(sample);
                return this.fitSampleData(pm);
            }
            case LinearMoments: {
                LinearMoments lm = new LinearMoments(sample);
                return this.fitSampleData(lm);
            }
            case MaximumLikelihood: 
        }
        MaximumLikelihood ml = new MaximumLikelihood(sample, MaximumLikelihood.MinimizationMethod.NEWTON);
        return this.fitSampleData(ml);
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        return AbstractContDist.fitSampleDataWithMaximumLikelihood(ml, this);
    }

    public static boolean fitSampleDataWithMaximumLikelihood(final MaximumLikelihood ml, final ContDist dist) {
        FunctionMinimizer solver = MaximumLikelihood.MinimizationMethod.SIMPLEX.equals((Object)ml.getMinimizationMethod()) ? new EquationSolverNelderMead(){

            @Override
            public double f(double[] pars) {
                dist.setParamVals(pars);
                return -dist.getLogLikelihood(ml.getSample());
            }
        } : new EquationSolverMultiVariateNewton(){

            @Override
            public double f(double[] pars) {
                dist.setParamVals(pars);
                return -dist.getLogLikelihood(ml.getSample());
            }

            @Override
            public void jacobian(double[] x, double[] result) {
                dist.setParamVals(x);
                double[] jac = dist.getLogLikelihoodJacobian(ml.getSample());
                if (jac == null) {
                    super.jacobian(x, result);
                } else {
                    for (int i = 0; i < x.length; ++i) {
                        result[i] = jac[i];
                    }
                }
            }

            @Override
            public void hessian(double[] x, double[] result) {
                dist.setParamVals(x);
                double[] hess = dist.getLogLikelihoodHessian(ml.getSample());
                if (hess == null) {
                    super.hessian(x, result);
                } else {
                    for (int i = 0; i < hess.length; ++i) {
                        result[i] = hess[i];
                    }
                }
            }
        };
        double[][] bounds = dist.getParamBounds(ml.getSample());
        for (int i = 0; i < bounds.length; ++i) {
            for (int j = 0; j < bounds[i].length; ++j) {
                if (NumericalConstants.isValidValue((double)bounds[i][j])) continue;
                return false;
            }
        }
        double[] params = solver.minimize(bounds, 1.0E-9, 250);
        dist.setParamVals(params);
        for (int i = 0; i < params.length; ++i) {
            if (!Double.isNaN(params[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        return null;
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        return null;
    }

    @Override
    public double[][] getParamBounds(double[] data) {
        this.fitSampleData(data);
        double[] paramVals = this.getParamVals();
        double[][] retval = new double[2][this.getParamVals().length];
        for (int i = 0; i < paramVals.length; ++i) {
            retval[0][i] = paramVals[i] - Math.abs(paramVals[i]) * 0.2;
            retval[1][i] = paramVals[i] + Math.abs(paramVals[i]) * 0.2;
        }
        return retval;
    }

    @Override
    public BootstrapAnalysisContainer getConfidenceLimitCurves(FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] confidenceLimitOrdinates, double[] expectedProbabilityOrdinates, boolean isComputeBinWidthsInLog, double confidence, double relError, int minIter, int maxIter, boolean computeExpectedProbability, boolean computeConfidenceLimits) throws ComputationException {
        BootstrapAnalysis ba;
        if (computeExpectedProbability && computeConfidenceLimits) {
            ba = new CombinedAnalysis(expectedProbabilityOrdinates, isComputeBinWidthsInLog, this, method, sampleSize, confidenceLimitValues, confidenceLimitOrdinates, confidence, relError, minIter, maxIter);
        } else if (computeExpectedProbability && !computeConfidenceLimits) {
            ba = new ExpectedProbabilityAnalysis(isComputeBinWidthsInLog, expectedProbabilityOrdinates, this, method, sampleSize, confidenceLimitValues, confidenceLimitOrdinates, confidence, relError, minIter, maxIter);
        } else if (!computeExpectedProbability && computeConfidenceLimits) {
            ba = new ConfidenceLimitAnalysis(this, method, sampleSize, confidenceLimitValues, confidenceLimitOrdinates, confidence, relError, minIter, maxIter);
        } else {
            return null;
        }
        return ba.compute();
    }

    @Override
    public Object clone() {
        try {
            AbstractContDist clonedDist = (AbstractContDist)super.clone();
            return clonedDist;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Error: Clone not supported");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getSummaryDef(String format) {
        String[] pNames = this.getParamNames();
        double[] pVals = this.getParamVals();
        if (pNames == null) {
            return "";
        }
        Object summary = "";
        for (int i = 0; i < pNames.length; ++i) {
            summary = (String)summary + pNames[i] + "=" + String.format(format, pVals[i]) + (i < pNames.length - 1 ? "," : "");
        }
        return summary;
    }

    protected final double invCDFBiSearch(double p, double xMin, double xMax, double tolX) {
        return this.invCDFSolverBiSearch.biSearch(p, xMin, xMax, tolX);
    }

    protected final double invCDFNewton(double p, double valGuess, double tolP, int maxIter) {
        return this.invCDFSolverNewton.newton(p, valGuess, tolP, maxIter);
    }

    protected final double invCDFNewtonBiSearch(double p, double xMin, double xMax, double tolX, int maxIter) {
        return this.invCDFSolverNewtonBiSearch.newtonBiSearch(p, xMin, xMax, tolX, maxIter);
    }

    public double getExpectedValue() {
        double EV = 0.0;
        double p = 0.0;
        for (int i = 0; i < 100; ++i) {
            p = ((double)i + 0.5) / 100.0;
            EV += this.invCDF(p) * 0.01;
        }
        return EV;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double retval = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            retval += Math.log(this.getPDF(sample[i]));
        }
        return retval;
    }

    public static enum FittingMethod {
        ProductMoments("Standard Product Moments"),
        LinearMoments("L- Moments"),
        MaximumLikelihood("Maximum Likelihood Estimation");

        private final String _name;

        private FittingMethod(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public static String getShortName(FittingMethod fittingMethod) {
            switch (fittingMethod) {
                case ProductMoments: {
                    return "(" + FittingMethod.getFittingMethodsInitials(fittingMethod.toString()).substring(1) + ")";
                }
            }
            return "(" + FittingMethod.getFittingMethodsInitials(fittingMethod.toString()) + ")";
        }

        private static String getFittingMethodsInitials(String fittingMethod) {
            Pattern p = Pattern.compile("((^| )[A-Za-z])");
            Matcher m = p.matcher(fittingMethod);
            Object initials = "";
            while (m.find()) {
                initials = (String)initials + m.group().trim();
            }
            return ((String)initials).toUpperCase();
        }
    }
}

