/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.BetaDist;
import hec.statistics.LinearMoments;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;

public class Beta4ParamDist
extends BetaDist {
    private double _left;
    private double _right;

    public Beta4ParamDist() {
        this(2.0, 2.0, 0.0, 1.0);
    }

    public Beta4ParamDist(double shape0, double shape1, double left, double right) {
        super(shape0, shape1);
        if (left > right) {
            right = left;
        }
        this._left = left;
        this._right = right;
    }

    public Beta4ParamDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public Beta4ParamDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        double kurt = pm.getKurt();
        double skew = pm.getSkew();
        double term1 = kurt - skew * skew - 1.0;
        double term2 = 1.5 * skew * skew - kurt + 3.0;
        if (term1 < 1.0E-5 || term2 < 1.0E-5) {
            this.setShape0(Double.NaN);
            this.setShape1(Double.NaN);
            this.setLeft(Double.NaN);
            this.setRight(Double.NaN);
            return false;
        }
        double v = 3.0 * term1 / term2;
        double term3 = Math.sqrt((2.0 + v) * (2.0 + v) * skew * skew + 16.0 * (1.0 + v));
        double term = (2.0 + v) * Math.abs(skew) / term3;
        this.setShape0(0.5 * v * (1.0 - term));
        this.setShape1(0.5 * v * (1.0 + term));
        double range = 0.5 * pm.getStDv() * term3;
        this.setLeft(pm.getMean() - this.getShape0() * range / v);
        this.setRight(pm.getMean() + this.getShape1() * range / v);
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setShape0(Double.NaN);
        this.setShape1(Double.NaN);
        this.setLeft(Double.NaN);
        this.setRight(Double.NaN);
        return false;
    }

    public void setLeft(double left) {
        this._left = left;
    }

    public double getLeft() {
        return this._left;
    }

    public void setRight(double right) {
        this._right = right;
    }

    public double getRight() {
        return this._right;
    }

    @Override
    public String getType() {
        return "Beta4Param";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Shape0", "Shape1", "Left", "Right"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getShape0(), this.getShape1(), this.getLeft(), this.getRight()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setShape0(vals[0]);
        this.setShape1(vals[1]);
        this.setLeft(vals[2]);
        this.setRight(vals[3]);
    }

    @Override
    public Object clone() {
        Beta4ParamDist clonedDist = (Beta4ParamDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("Beta4ParamDistEnd")) {
                    return;
                }
                if (type.equals("Shape0")) {
                    this.setShape0(Double.parseDouble(param));
                } else if (type.equals("Shape1")) {
                    this.setShape1(Double.parseDouble(param));
                } else if (type.equals("Left")) {
                    this.setLeft(Double.parseDouble(param));
                } else if (type.equals("Right")) {
                    this.setRight(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read Beta4ParamDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "Beta4ParamDistBegin");
        TextFile.writeLine(writer, "Shape0:" + this.getShape0());
        TextFile.writeLine(writer, "Shape1:" + this.getShape1());
        TextFile.writeLine(writer, "Left:" + this.getLeft());
        TextFile.writeLine(writer, "Right:" + this.getRight());
        TextFile.writeLine(writer, "Beta4ParamDistEnd");
    }

    @Override
    public double getPDF(double value) {
        double range = this.getRight() - this.getLeft();
        return super.getPDF((value - this.getLeft()) / range) / range;
    }

    @Override
    public double getCDF(double value) {
        double range = this.getRight() - this.getLeft();
        return super.getCDF((value - this.getLeft()) / range);
    }

    @Override
    public double invCDF(double p) {
        double range = this.getRight() - this.getLeft();
        double r = this.getRight();
        double l = this.getLeft();
        this.setLeft(0.0);
        this.setRight(1.0);
        double val = super.invCDF(p);
        this.setLeft(l);
        this.setRight(r);
        return this.getLeft() + range * val;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        int n = sample.length;
        double sumLogxml = 0.0;
        double sumLogrmx = 0.0;
        for (int i = 0; i < n; ++i) {
            sumLogxml += Math.log(sample[i] - this.getLeft());
            sumLogrmx += Math.log(this.getRight() - sample[i]);
        }
        return (this._shape0 - 1.0) * sumLogxml + (this._shape1 - 1.0) * sumLogrmx - (double)n * Math.log(SpecialFunctions.beta(this._shape0, this._shape1)) - (double)n * (this._shape0 + this._shape1 - 1.0) * Math.log(this.getRight() - this.getLeft());
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        double[] retval = new double[4];
        int n = sample.length;
        double sumLogxml = 0.0;
        double sumLogrmx = 0.0;
        double sum1overxml = 0.0;
        double sum1overrmx = 0.0;
        for (int i = 0; i < n; ++i) {
            sumLogxml += Math.log(sample[i] - this.getLeft());
            sumLogrmx += Math.log(this.getRight() - sample[i]);
            sum1overxml += 1.0 / (sample[i] - this.getLeft());
            sum1overrmx += 1.0 / (this.getRight() - sample[i]);
        }
        double dgab = SpecialFunctions.digamma(this._shape0 + this._shape1);
        double dga = SpecialFunctions.digamma(this._shape0);
        double dgb = SpecialFunctions.digamma(this._shape1);
        retval[0] = sumLogxml - (double)n * (dga - dgab) - (double)n * Math.log(this.getRight() - this.getLeft());
        retval[1] = sumLogrmx - (double)n * (dgb - dgab) - (double)n * Math.log(this.getRight() - this.getLeft());
        retval[2] = -(this._shape0 - 1.0) * sum1overxml + (double)n * (this._shape0 + this._shape1 - 1.0) * (1.0 / (this.getRight() - this.getLeft()));
        retval[3] = (this._shape1 - 1.0) * sum1overrmx - (double)n * (this._shape0 + this._shape1 - 1.0) * (1.0 / (this.getRight() - this.getLeft()));
        return retval;
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        int n = sample.length;
        double sum1overxml = 0.0;
        double sum1overrmx = 0.0;
        double sum1overxml2 = 0.0;
        double sum1overrmx2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d1 = sample[i] - this.getLeft();
            double d2 = this.getRight() - sample[i];
            sum1overxml += 1.0 / d1;
            sum1overrmx += 1.0 / d2;
            sum1overxml2 += 1.0 / (d1 * d1);
            sum1overrmx2 += 1.0 / (d2 * d2);
        }
        double dg = SpecialFunctions.trigamma(this._shape0 + this._shape1);
        double dada = (double)n * (SpecialFunctions.trigamma(this._shape0) - dg);
        double dadb = (double)n * -dg;
        double dadl = sum1overxml - (double)n / (this.getRight() - this.getLeft());
        double dadr = (double)n / (this.getRight() - this.getLeft());
        double dbda = dadb;
        double dbdb = (double)n * (SpecialFunctions.trigamma(this._shape1) - dg);
        double dbdl = (double)(-n) / (this.getRight() - this.getLeft());
        double dbdr = -sum1overrmx + (double)n / (this.getRight() - this.getLeft());
        double dlda = dadl;
        double dldb = dbdl;
        double dldl = (this._shape0 - 1.0) * sum1overxml2 - (double)n * (this._shape0 + this._shape1 - 1.0) / ((this.getRight() - this.getLeft()) * (this.getRight() - this.getLeft()));
        double dldr = (double)n * (this._shape0 + this._shape1 - 1.0) * (1.0 / ((this.getRight() - this.getLeft()) * (this.getRight() - this.getLeft())));
        double drda = dadr;
        double drdb = dbdr;
        double drdl = dldr;
        double drdr = (this._shape1 - 1.0) * sum1overrmx2 - (double)n * (this._shape0 + this._shape1 - 1.0) * (1.0 / ((this.getRight() - this.getLeft()) * (this.getRight() - this.getLeft())));
        return new double[]{dada, dadb, dadl, dadr, dbda, dbdb, dbdl, dbdr, dlda, dldb, dldl, dldr, drda, drdb, drdl, drdr};
    }

    @Override
    public double[][] getParamBounds(double[] data) {
        double[][] retval = new double[2][4];
        double[] sortedData = new double[data.length];
        System.arraycopy(data, 0, sortedData, 0, data.length);
        Arrays.sort(sortedData);
        double min = sortedData[0];
        double max = sortedData[sortedData.length - 1];
        double[] betaData = new double[sortedData.length];
        for (int i = 0; i < sortedData.length; ++i) {
            betaData[i] = (sortedData[i] - min) / (max - min);
        }
        BetaDist dist = new BetaDist();
        dist.fitSampleData(betaData);
        retval[0][0] = dist.getShape0() - 0.25 * dist.getShape0();
        retval[1][0] = dist.getShape0() + 0.25 * dist.getShape0();
        retval[0][1] = dist.getShape1() - 0.25 * dist.getShape1();
        retval[1][1] = dist.getShape1() + 0.25 * dist.getShape1();
        retval[0][2] = min - 0.25 * min;
        retval[1][2] = min;
        retval[0][3] = max;
        retval[1][3] = max + 0.25 * max;
        return retval;
    }
}

