/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverNewton;
import hec.statistics.LinearMoments;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class BetaDist
extends AbstractContDist {
    protected static final double MIN_SHAPE0 = 1.0E-5;
    protected static final double MIN_SHAPE1 = 1.0E-5;
    protected double _shape0;
    protected double _shape1;

    public BetaDist() {
        this(2.0, 2.0);
    }

    public BetaDist(double shape0, double shape1) {
        this.setShape0(shape0);
        this.setShape1(shape1);
    }

    public BetaDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public BetaDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        double term = pm.getMean() * (1.0 - pm.getMean()) / (pm.getStDv() * pm.getStDv()) - 1.0;
        if (term < 1.0E-5 || pm.getMean() < 1.0E-5 || pm.getMean() > 0.99999) {
            this.setShape0(Double.NaN);
            this.setShape1(Double.NaN);
            return false;
        }
        this.setShape0(pm.getMean() * term);
        this.setShape1((1.0 - pm.getMean()) * term);
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        final double l1 = lm.getL1();
        double l2 = lm.getL2();
        if (l1 < 1.0E-5 || l1 > 0.99999 || l2 >= l1 * (1.0 - l1)) {
            this.setShape0(Double.NaN);
            this.setShape1(Double.NaN);
            return false;
        }
        EquationSolverNewton solverShape0 = new EquationSolverNewton(){
            private static final double sqrtPi = 1.772453850905516;

            private double q(double x) {
                return Math.exp(SpecialFunctions.logGamma(x + 0.5) - SpecialFunctions.logGamma(x));
            }

            @Override
            public double f(double x) {
                double fn;
                if (x == 0.0) {
                    fn = l1 * (1.0 - l1);
                } else {
                    double termQa = this.q(x);
                    double termQb = this.q(x * (1.0 / l1 - 1.0));
                    double termQp = this.q(x / l1);
                    fn = l1 * termQa * termQb / (x * 1.772453850905516 * termQp);
                }
                return 1.0 / (fn * fn);
            }
        };
        this.setShape0(solverShape0.newton(1.0 / (l2 * l2), 1.0, 1.0E-10, 100, 1.0E-10));
        this.setShape1(this.getShape0() * (1.0 / l1 - 1.0));
        return !Double.isNaN(this.getShape0());
    }

    public void setShape0(double shape0) {
        if (shape0 <= 1.0E-5) {
            shape0 = 1.0E-5;
        }
        this._shape0 = shape0;
    }

    public double getShape0() {
        return this._shape0;
    }

    public void setShape1(double shape1) {
        if (shape1 <= 1.0E-5) {
            shape1 = 1.0E-5;
        }
        this._shape1 = shape1;
    }

    public double getShape1() {
        return this._shape1;
    }

    @Override
    public String getType() {
        return "Beta";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Shape0", "Shape1"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getShape0(), this.getShape1()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setShape0(vals[0]);
        this.setShape1(vals[1]);
    }

    @Override
    public Object clone() {
        BetaDist clonedDist = (BetaDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("BetaDistEnd")) {
                    return;
                }
                if (type.equals("Shape0")) {
                    this.setShape0(Double.parseDouble(param));
                } else if (type.equals("Shape1")) {
                    this.setShape1(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read BetaDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "BetaDistBegin");
        TextFile.writeLine(writer, "Shape0:" + this.getShape0());
        TextFile.writeLine(writer, "Shape1:" + this.getShape1());
        TextFile.writeLine(writer, "BetaDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this._shape0 > 0.0 && this._shape1 > 0.0) {
            if (value <= 0.0 || value >= 1.0) {
                return 0.0;
            }
            return Math.pow(value, this._shape0 - 1.0) * Math.pow(1.0 - value, this._shape1 - 1.0) / SpecialFunctions.beta(this._shape0, this._shape1);
        }
        return Double.NaN;
    }

    @Override
    public double getCDF(double value) {
        if (this._shape0 > 0.0 && this._shape1 > 0.0) {
            if (value <= 0.0) {
                return 0.0;
            }
            if (value >= 1.0) {
                return 1.0;
            }
            return SpecialFunctions.regIncompleteBeta(this._shape0, this._shape1, value);
        }
        return Double.NaN;
    }

    @Override
    public double invCDF(double p) {
        if (this._shape0 > 0.0 && this._shape1 > 0.0) {
            if (p <= 0.0) {
                return 0.0;
            }
            if (p >= 1.0) {
                return 1.0;
            }
            return this.invCDFNewtonBiSearch(p, 0.0, 1.0, 1.0E-8, 100);
        }
        return Double.NaN;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        int n = sample.length;
        double sumLogx = 0.0;
        double sumLog1mx = 0.0;
        for (int i = 0; i < n; ++i) {
            sumLogx += Math.log(sample[i]);
            sumLog1mx += Math.log(1.0 - sample[i]);
        }
        return (double)(-n) * Math.log(SpecialFunctions.beta(this._shape0, this._shape1)) + (this._shape0 - 1.0) * sumLogx + (this._shape1 - 1.0) * sumLog1mx;
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        double[] retval = new double[2];
        int n = sample.length;
        double sumLogx = 0.0;
        double sumLog1mx = 0.0;
        for (int i = 0; i < n; ++i) {
            sumLogx += Math.log(sample[i]);
            sumLog1mx += Math.log(1.0 - sample[i]);
        }
        double dg = SpecialFunctions.digamma(this._shape0 + this._shape1);
        retval[0] = -((double)n * SpecialFunctions.digamma(this._shape0) - (double)n * dg - sumLogx);
        retval[1] = -((double)n * SpecialFunctions.digamma(this._shape1) - (double)n * dg - sumLog1mx);
        return retval;
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        double dg = SpecialFunctions.trigamma(this._shape0 + this._shape1);
        double dg1a = (double)sample.length * (SpecialFunctions.trigamma(this._shape0) - dg);
        double dg1b = (double)sample.length * -dg;
        double dg2b = (double)sample.length * (SpecialFunctions.trigamma(this._shape1) - dg);
        return new double[]{dg1a, dg1b, dg1b, dg2b};
    }
}

