/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class ChiSqDist
extends AbstractContDist {
    private double _dof;

    public ChiSqDist() {
        this(1.0);
    }

    public ChiSqDist(double dof) {
        this.setDof(dof);
    }

    public ChiSqDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public ChiSqDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (pm.getMean() < 1.0) {
            this.setDof(Double.NaN);
            return false;
        }
        this.setDof(pm.getMean());
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        if (lm.getL1() < 1.0) {
            this.setDof(Double.NaN);
            return false;
        }
        this.setDof(lm.getL1());
        return true;
    }

    public void setDof(double dof) {
        if (dof <= 1.0) {
            dof = 1.0;
        }
        this._dof = dof;
    }

    public double getDof() {
        return this._dof;
    }

    @Override
    public String getType() {
        return "Chi-Squared";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"DegFreedom"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getDof()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setDof(vals[0]);
    }

    @Override
    public Object clone() {
        ChiSqDist clonedDist = (ChiSqDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("ChiSqDistEnd")) {
                    return;
                }
                if (type.equals("Dof")) {
                    this.setDof(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read ChiSqDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "ChiSqDistBegin");
        TextFile.writeLine(writer, "Dof:" + this.getDof());
        TextFile.writeLine(writer, "ChiSqDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        return Math.exp(-0.5 * value + (0.5 * this._dof - 1.0) * Math.log(value) - 0.5 * this._dof * Math.log(2.0) - SpecialFunctions.logGamma(0.5 * this._dof));
    }

    @Override
    public double getCDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        return SpecialFunctions.regIncompleteGamma(0.5 * this._dof, 0.5 * value);
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double xMin = 0.0;
        double xMax = 1.0;
        for (int j = 0; j < 100; ++j) {
            double pMax = this.getCDF(xMax);
            if (pMax > p) {
                return this.invCDFNewtonBiSearch(p, xMin, xMax, 1.0E-12, 100);
            }
            xMax *= 2.0;
        }
        return Double.NaN;
    }
}

