/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DecimalFormat;

public class ClipData
implements Cloneable {
    private boolean _minClip = false;
    private double _minVal = Double.NEGATIVE_INFINITY;
    private double _minProb = 0.0;
    private boolean _maxClip = false;
    private double _maxVal = Double.POSITIVE_INFINITY;
    private double _maxProb = 1.0;

    public void setMinClip(boolean minClip) {
        this._minClip = minClip;
    }

    public boolean hasMinClip() {
        return this._minClip;
    }

    public void setMinVal(double minVal) {
        this._minVal = minVal;
    }

    public double getMinVal() {
        return this._minVal;
    }

    public void setMinProb(double minProb) {
        this._minProb = minProb;
    }

    public double getMinProb() {
        return this._minProb;
    }

    public void setMaxClip(boolean maxClip) {
        this._maxClip = maxClip;
    }

    public boolean hasMaxClip() {
        return this._maxClip;
    }

    public void setMaxVal(double maxVal) {
        this._maxVal = maxVal;
    }

    public double getMaxVal() {
        return this._maxVal;
    }

    public void setMaxProb(double maxProb) {
        this._maxProb = maxProb;
    }

    public double getMaxProb() {
        return this._maxProb;
    }

    public String[] getClipParamNames() {
        int nParam = 0;
        nParam += this.hasMinClip() ? 1 : 0;
        String[] pNames = new String[nParam += this.hasMaxClip() ? 1 : 0];
        int idx = 0;
        if (this.hasMinClip()) {
            pNames[idx++] = "Min";
        }
        if (this.hasMaxClip()) {
            pNames[idx++] = "Max";
        }
        return pNames;
    }

    public double[] getClipParamVals() {
        int nParam = 0;
        nParam += this.hasMinClip() ? 1 : 0;
        double[] pVals = new double[nParam += this.hasMaxClip() ? 1 : 0];
        int idx = 0;
        if (this.hasMinClip()) {
            pVals[idx++] = this.getMinVal();
        }
        if (this.hasMaxClip()) {
            pVals[idx++] = this.getMaxVal();
        }
        return pVals;
    }

    public String getSummary(String format) {
        String[] pNames = this.getClipParamNames();
        double[] pVals = this.getClipParamVals();
        if (pNames == null || pNames.length == 0) {
            return "No clipping";
        }
        DecimalFormat df = new DecimalFormat("##.##");
        Object summary = "";
        for (int i = 0; i < pNames.length; ++i) {
            summary = (String)summary + pNames[i] + "=" + String.format(format, pVals[i]) + (i < pNames.length - 1 ? "," : "");
            if (pNames[i].equals("Min")) {
                summary = (String)summary + "(" + df.format(this.getMinProb() * 100.0) + "%)";
            }
            if (!pNames[i].equals("Max")) continue;
            summary = (String)summary + "(" + df.format(100.0 - this.getMaxProb() * 100.0) + "%)";
        }
        return summary;
    }

    public Object clone() {
        try {
            ClipData clonedData = (ClipData)super.clone();
            clonedData.setMinClip(this.hasMinClip());
            clonedData.setMinVal(this.getMinVal());
            clonedData.setMinProb(this.getMinProb());
            clonedData.setMaxClip(this.hasMaxClip());
            clonedData.setMaxVal(this.getMaxVal());
            clonedData.setMaxProb(this.getMaxProb());
            return clonedData;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Error: Clone not supported");
            e.printStackTrace();
            return null;
        }
    }

    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("ClipDataEnd")) {
                    return;
                }
                if (type.equals("MinClip")) {
                    this.setMinClip(Boolean.parseBoolean(param));
                } else if (type.equals("MinVal")) {
                    this.setMinVal(Double.parseDouble(param));
                } else if (type.equals("MaxClip")) {
                    this.setMaxClip(Boolean.parseBoolean(param));
                } else if (type.equals("MaxVal")) {
                    this.setMaxVal(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read UnifDist Data.   " + e);
            e.printStackTrace();
        }
    }

    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "ClipDataBegin");
        TextFile.writeLine(writer, "MinClip:" + this.hasMinClip());
        TextFile.writeLine(writer, "MinVal:" + this.getMinVal());
        TextFile.writeLine(writer, "MaxClip:" + this.hasMaxClip());
        TextFile.writeLine(writer, "MaxVal:" + this.getMaxVal());
        TextFile.writeLine(writer, "ClipDataEnd");
    }
}

