/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.NormalDist;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.List;

public class CompositeDistribution
extends AbstractContDist {
    public static final String COMPOSITE_DISTRIBUTION = "composite_distribution";
    List<AbstractContDist> _distList = new ArrayList<AbstractContDist>();

    public void setDistributionList(List<AbstractContDist> distList) {
        this._distList.clear();
        this._distList.addAll(distList);
    }

    @Override
    public double getPDF(double value) {
        double intermediateVariable = 1.0;
        for (AbstractContDist dist : this._distList) {
            intermediateVariable *= 1.0 - dist.getPDF(value);
        }
        double retval = 1.0 - intermediateVariable;
        return retval;
    }

    @Override
    public double getCDF(double value) {
        double intermediateVariable = 1.0;
        for (AbstractContDist dist : this._distList) {
            intermediateVariable *= dist.getCDF(value);
        }
        double retval = intermediateVariable;
        return retval;
    }

    @Override
    public double invCDF(double p) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (AbstractContDist dist : this._distList) {
            double value = dist.invCDF(p);
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        return this.invCDFNewton(p, (min + max) / 2.0, 1.0E-5, 1000);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        return false;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        return false;
    }

    @Override
    public void read(BufferedReader reader) {
    }

    @Override
    public void write(BufferedWriter writer) {
    }

    @Override
    public String getType() {
        return COMPOSITE_DISTRIBUTION;
    }

    @Override
    public String[] getParamNames() {
        return new String[0];
    }

    @Override
    public double[] getParamVals() {
        return new double[0];
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
    }

    public static void main(String[] args) {
        NormalDist dist1 = new NormalDist(10.0, 3.0);
        NormalDist dist2 = new NormalDist(10.0, 3.0);
        NormalDist dist3 = new NormalDist(10.0, 3.0);
        NormalDist dist4 = new NormalDist(10.0, 3.0);
        ArrayList<AbstractContDist> distList = new ArrayList<AbstractContDist>();
        distList.add(dist1);
        distList.add(dist2);
        distList.add(dist3);
        distList.add(dist4);
        CompositeDistribution cd = new CompositeDistribution();
        cd.setDistributionList(distList);
        double pdf = cd.getPDF(10.0);
        cd.getCDF(10.0);
        double[] exceedProbs = new double[]{0.2, 0.5, 5.0, 10.0, 25.0, 50.0, 75.0, 90.0, 95.0, 99.0};
        double[] individual = new double[10];
        double[] combined = new double[10];
        double[] individualCDF = new double[10];
        double[] combinedCDF = new double[10];
        double[][] confidenceInterval = new double[10][2];
        for (int i = 0; i < exceedProbs.length; ++i) {
            individual[i] = dist1.invCDF(1.0 - exceedProbs[i] / 100.0);
            combined[i] = cd.invCDF(1.0 - exceedProbs[i] / 100.0);
            individualCDF[i] = dist1.getCDF(individual[i]);
            combinedCDF[i] = cd.getCDF(individual[i]);
        }
        cd.getCDF(10.0);
    }

    private double computeMean(int n, double p) {
        double retval = 0.0;
        for (int i = 2; i <= n; ++i) {
            retval += 0.5 * (this.getObservedFlow(i - 1, n) + this.getObservedFlow(i, n)) * this.incompleteBetaFactor(i, n, p);
        }
        return retval;
    }

    private double computeVariance(double M, int n, double p) {
        double retval = 0.0;
        for (int i = 2; i <= n; ++i) {
            retval += 0.5 * (Math.pow(this.getObservedFlow(i - 1, n) - M, 2.0) + Math.pow(this.getObservedFlow(i, n) - M, 2.0) * this.incompleteBetaFactor(i, n, p));
        }
        return retval;
    }

    private double incompleteBetaFactor(int i, int n, double p) {
        return (SpecialFunctions.incompleteBeta(i, n - i + 1, p) - SpecialFunctions.incompleteBeta(i - 1, n - i, p)) / (SpecialFunctions.incompleteBeta(n, 1.0, p) - SpecialFunctions.incompleteBeta(1.0, n, p));
    }

    private double getObservedFlow(int i, int n) {
        return this.invCDF(this.weibull(i, n));
    }

    private double weibull(int m, int n) {
        return (double)m / ((double)n + 1.0);
    }
}

