/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.ContDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.LogPearson3Dist;
import hec.statistics.NormalDist;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConfidenceLimits {
    private ContDist _dist;
    private AbstractContDist.FittingMethod _method;
    private int _sampleSize;
    private double[] _confidenceLimitValues;
    private double _minConfLimit;
    private double _maxConfLimit;
    private double[] _probabilityOrdinates;
    private double[] _independentVariableOrdinates;
    private double _confidence;
    private double _zAlpha;
    private double _relError;
    private int _minIter;
    private int _maxIter;
    private boolean _sampleProbabilityOrdinates = true;
    private boolean _keepOutputsInProbabilitySpace = false;
    private Lock[] _locks;
    private HistDist[] _ordHistDists;
    private AtomicInteger _numIter = new AtomicInteger(0);
    private AtomicBoolean _converge = new AtomicBoolean(false);
    private double[][] _confidenceLimitCurves;
    private final long seed = 12345L;

    public double[] getOrdinates() {
        return this._probabilityOrdinates;
    }

    public double[] getIndependentVariableOrdinates() {
        return this._independentVariableOrdinates;
    }

    public HistDist[] getOrdinateHistograms() {
        return this._ordHistDists;
    }

    public int getNumIter() {
        return this._numIter.get();
    }

    public boolean getConverge() {
        return this._converge.get();
    }

    public double[][] getConfidenceLimitCurves() {
        return this.getConfidenceLimitCurves(true);
    }

    public double[][] getConfidenceLimitCurves(boolean sampleProbabilityOrdinates) {
        if (this._confidenceLimitCurves == null || this._sampleProbabilityOrdinates != sampleProbabilityOrdinates) {
            this._sampleProbabilityOrdinates = sampleProbabilityOrdinates;
            this.computeConfidenceCurves();
        }
        return this._confidenceLimitCurves;
    }

    public ConfidenceLimits(ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        this._dist = dist;
        this._method = method;
        this._sampleSize = sampleSize;
        this._confidenceLimitValues = confidenceLimitValues;
        this._probabilityOrdinates = ordinates;
        this._confidence = confidence;
        this._relError = relError;
        this._minIter = minIter;
        this._maxIter = maxIter;
        if (this._dist != null && this._probabilityOrdinates != null) {
            this._independentVariableOrdinates = new double[this._probabilityOrdinates.length];
            for (int i = 0; i < this._probabilityOrdinates.length; ++i) {
                this._independentVariableOrdinates[i] = this._dist.invCDF(this._probabilityOrdinates[i]);
            }
        }
    }

    public void computeConfidenceCurves() {
        int k;
        if (this._dist == null || this._sampleSize <= 0 || this._confidenceLimitValues == null || this._probabilityOrdinates == null || this._relError <= 0.0 || this._confidence >= 1.0 || this._minIter <= 0 || this._maxIter <= this._minIter) {
            return;
        }
        NormalDist n = new NormalDist();
        this._zAlpha = n.invCDF(0.5 + 0.5 * this._confidence);
        Random rnd = new Random(12345L);
        int initMinBins = 50;
        int initMaxBins = 10000;
        int numOrdinates = this._probabilityOrdinates.length;
        double[][] initData = new double[numOrdinates][this._minIter];
        double[] oneSampleSet = new double[this._sampleSize];
        ContDist distFit = null;
        for (int i = 0; i < this._minIter; ++i) {
            for (int j = 0; j < this._sampleSize; ++j) {
                oneSampleSet[j] = this._dist.invCDF(rnd.nextDouble());
            }
            try {
                distFit = (ContDist)this._dist.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            distFit.fitSampleData(oneSampleSet, this._method);
            for (int k2 = 0; k2 < numOrdinates; ++k2) {
                initData[k2][i] = this.getSampledValue(distFit, k2);
            }
        }
        this._minConfLimit = Arrays.stream(this._confidenceLimitValues).min().getAsDouble();
        this._maxConfLimit = Arrays.stream(this._confidenceLimitValues).max().getAsDouble();
        this._ordHistDists = new HistDist[numOrdinates];
        for (k = 0; k < numOrdinates; ++k) {
            Arrays.sort(initData[k]);
            double min = initData[k][0];
            double max = initData[k][this._minIter - 1];
            int qIdx = (int)(this._minConfLimit * (double)this._minIter);
            double lowQVal = initData[k][qIdx];
            double prelimBinWidth = lowQVal * this._relError * 0.2;
            int numBins = (int)((max - min) / prelimBinWidth);
            numBins = Math.min(Math.max(numBins, initMinBins), initMaxBins);
            this._ordHistDists[k] = new HistDist(numBins, min, max);
            this._ordHistDists[k].addObservations(initData[k]);
        }
        this._numIter.set(this._minIter);
        this._locks = new Lock[numOrdinates];
        for (k = 0; k < numOrdinates; ++k) {
            this._locks[k] = new ReentrantLock();
        }
        this._converge.set(false);
        ForkJoinPool pool = new ForkJoinPool();
        SyncSample sample = new SyncSample(Runtime.getRuntime().availableProcessors());
        pool.invoke(sample);
        int numCurves = this._confidenceLimitValues.length;
        this._confidenceLimitCurves = new double[numCurves][numOrdinates];
        for (int j = 0; j < numCurves; ++j) {
            for (int k3 = 0; k3 < numOrdinates; ++k3) {
                this._confidenceLimitCurves[j][k3] = this.getConfidenceCurveValue(k3, j);
            }
        }
    }

    private double getConfidenceCurveValue(int ordinate, int curve) {
        if (this._sampleProbabilityOrdinates || this._keepOutputsInProbabilitySpace) {
            return this._ordHistDists[ordinate].invCDF(this._confidenceLimitValues[curve]);
        }
        return this._dist.invCDF(this._ordHistDists[ordinate].invCDF(this._confidenceLimitValues[curve]));
    }

    private double getSampledValue(ContDist distFit, int k) {
        if (this._sampleProbabilityOrdinates) {
            return distFit.invCDF(this._probabilityOrdinates[k]);
        }
        return distFit.getCDF(this._independentVariableOrdinates[k]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncAddObservation(int k, double observation) {
        this._locks[k].lock();
        try {
            boolean bl = this._ordHistDists[k].addObservation(observation);
            return bl;
        }
        finally {
            this._locks[k].unlock();
        }
    }

    private boolean syncAllOrdinatesConverged() {
        if (this._ordHistDists == null) {
            return true;
        }
        int numOrdinates = this._ordHistDists.length;
        for (int k = 0; k < numOrdinates; ++k) {
            if (this.syncOrdinateConverged(k)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncOrdinateConverged(int k) {
        HistDist histDist = this._ordHistDists[k];
        this._locks[k].lock();
        try {
            double qVal = histDist.invCDF(this._minConfLimit);
            double qSlope = histDist.getPDF(qVal);
            double variance = this._minConfLimit * (1.0 - this._minConfLimit) / ((double)histDist.getNumObs() * qSlope * qSlope);
            if (!(Math.abs(this._zAlpha * Math.sqrt(variance) / qVal) <= this._relError * 0.5)) {
                boolean bl = false;
                return bl;
            }
            qVal = histDist.invCDF(this._maxConfLimit);
            qSlope = histDist.getPDF(qVal);
            variance = this._maxConfLimit * (1.0 - this._maxConfLimit) / ((double)histDist.getNumObs() * qSlope * qSlope);
            if (!(Math.abs(this._zAlpha * Math.sqrt(variance) / qVal) <= this._relError * 0.5)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this._locks[k].unlock();
        }
        return true;
    }

    public static double[][] computeWithEmpirical(double[] prob, double[] values, int years, double lowerConfidenceLevel, double upperConfidenceLevel) {
        EmpiricalDist dist = new EmpiricalDist(prob, values);
        double[] ords = new double[prob.length];
        for (int i = 0; i < prob.length; ++i) {
            ords[i] = prob[prob.length - 1 - i];
        }
        ConfidenceLimits confidenceLimits = new ConfidenceLimits(dist, AbstractContDist.FittingMethod.ProductMoments, years, new double[]{lowerConfidenceLevel, upperConfidenceLevel}, ords, 0.0, 0.025, 100, 10000);
        return confidenceLimits.getConfidenceLimitCurves();
    }

    public static void main(String[] args) {
        int n = Runtime.getRuntime().availableProcessors();
        System.out.println("Processors: " + n);
        LogPearson3Dist lp3 = new LogPearson3Dist(3.031, 0.661, -0.87);
        long startTime = System.currentTimeMillis();
        ConfidenceLimits cf = new ConfidenceLimits(lp3, AbstractContDist.FittingMethod.ProductMoments, 80, new double[]{0.05, 0.95}, new double[]{0.001, 0.01, 0.1, 0.5, 0.9, 0.99, 0.999}, 0.9, 0.05, 100, 1000000);
        double[][] probabilityParameterCurves = cf.getConfidenceLimitCurves(true);
        double[] probabilityParameterExpectedProbability = cf.getExpectedProbability();
        double[][] independentParameterCurves = cf.getConfidenceLimitCurves(false);
        double[] independentParameterExpectedProbability = cf.getExpectedProbability();
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        System.out.println("Compute Time(s): " + (double)totalTime / 1000.0);
        System.out.println("Iterations     : " + cf.getNumIter());
        System.out.println("Time(ms)/iter  : " + (double)totalTime / (double)cf.getNumIter());
        System.out.println("done");
    }

    private double[] getExpectedProbability() {
        double[] retval = new double[this._probabilityOrdinates.length];
        for (int k = 0; k < retval.length; ++k) {
            retval[k] = this._sampleProbabilityOrdinates || this._keepOutputsInProbabilitySpace ? this._ordHistDists[k]._mean : this._dist.invCDF(this._ordHistDists[k]._mean);
        }
        return retval;
    }

    private class HistDist {
        private int[] _bins;
        private double _binWidth = 0.0;
        private double _min;
        private double _max;
        private int _numObs = 0;
        private double _mean = 0.0;

        public HistDist(int numBins, double min, double max) {
            if (numBins <= 0 || min > max) {
                return;
            }
            this._min = min;
            this._max = max;
            this._binWidth = (max - min) / (double)numBins;
            this._bins = new int[numBins];
            Arrays.fill(this._bins, 0);
        }

        public int getNumObs() {
            return this._numObs;
        }

        public boolean addObservation(double obs) {
            int numBinsToAdd;
            if (this._binWidth <= 0.0 || Double.isInfinite(obs) || Double.isNaN(obs)) {
                return false;
            }
            if (obs < this._min) {
                numBinsToAdd = (int)Math.ceil((this._min - obs) / this._binWidth);
                int[] oldBins = this._bins;
                this._bins = new int[oldBins.length + numBinsToAdd];
                Arrays.fill(this._bins, 0);
                System.arraycopy(oldBins, 0, this._bins, numBinsToAdd, oldBins.length);
                this._min -= (double)numBinsToAdd * this._binWidth;
            } else if (obs > this._max) {
                numBinsToAdd = (int)Math.ceil((obs - this._max) / this._binWidth);
                int[] oldBins = this._bins;
                this._bins = new int[oldBins.length + numBinsToAdd];
                Arrays.fill(this._bins, 0);
                System.arraycopy(oldBins, 0, this._bins, 0, oldBins.length);
                this._max += (double)numBinsToAdd * this._binWidth;
            }
            int idx = (int)((obs - this._min) / this._binWidth);
            int n = idx = idx < this._bins.length ? idx : this._bins.length - 1;
            this._bins[n] = this._bins[n] + 1;
            ++this._numObs;
            this.recomputeMean(obs);
            return true;
        }

        public void recomputeMean(double obs) {
            this._mean += (obs - this._mean) / (double)this._numObs;
        }

        public boolean addObservations(double[] obsArray) {
            if (obsArray == null) {
                return false;
            }
            int num = obsArray.length;
            for (int i = 0; i < num; ++i) {
                if (this.addObservation(obsArray[i])) continue;
                return false;
            }
            return true;
        }

        public double invCDF(double q) {
            if (this._numObs <= 0 || q <= 0.0) {
                return this._min;
            }
            if (q >= 1.0) {
                return this._max;
            }
            double qObs = q * (double)this._numObs;
            if (q <= 0.5) {
                int binObs;
                int idx = 0;
                int cumObs = binObs = this._bins[idx];
                while (qObs > (double)cumObs) {
                    binObs = this._bins[++idx];
                    cumObs += binObs;
                }
                return this._min + this._binWidth * ((double)(idx + 1) - ((double)cumObs - qObs) / (double)binObs);
            }
            int idx = this._bins.length - 1;
            int binObs = this._bins[idx];
            int cumObs = this._numObs - binObs;
            while (qObs < (double)cumObs) {
                binObs = this._bins[--idx];
                cumObs -= binObs;
            }
            return this._max - this._binWidth * ((double)(this._bins.length - idx) + (qObs - (double)cumObs) / (double)binObs);
        }

        public double getCDF(double val) {
            if (this._numObs <= 0 || val <= this._min) {
                return 0.0;
            }
            if (val >= this._max) {
                return 1.0;
            }
            double dIdx = (val - this._min) / this._binWidth;
            if (dIdx <= 0.0) {
                return 0.0;
            }
            if (dIdx >= (double)this._bins.length) {
                return 1.0;
            }
            if (dIdx <= (double)(this._bins.length / 2)) {
                int idx = (int)Math.floor(dIdx);
                double cumObs = 0.0;
                for (int i = 0; i < idx; ++i) {
                    cumObs += (double)this._bins[i];
                }
                return (cumObs += (dIdx - (double)idx) * (double)this._bins[idx]) / (double)this._numObs;
            }
            int idx = (int)Math.floor(dIdx);
            double cumObs = this._numObs;
            for (int i = this._bins.length - 1; i > idx; --i) {
                cumObs -= (double)this._bins[i];
            }
            return (cumObs -= ((double)(idx + 1) - dIdx) * (double)this._bins[idx]) / (double)this._numObs;
        }

        public double getPDF(double val) {
            int idx = (int)((val - this._min) / this._binWidth);
            if (idx < 0 || idx >= this._bins.length) {
                return 0.0;
            }
            return (double)this._bins[idx] / (this._binWidth * (double)this._numObs);
        }
    }

    private class SyncSample
    extends RecursiveAction {
        private static final long serialVersionUID = 3524889643976333282L;
        private int _numForks;

        public SyncSample(int numForks) {
            this._numForks = numForks;
        }

        @Override
        protected void compute() {
            if (this._numForks <= 0) {
                Random rnd = new Random(12345L);
                double[] oneSampleSet = new double[ConfidenceLimits.this._sampleSize];
                int numOrdinates = ConfidenceLimits.this._ordHistDists.length;
                ContDist distFit = null;
                try {
                    distFit = (ContDist)ConfidenceLimits.this._dist.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                while (ConfidenceLimits.this._numIter.get() < ConfidenceLimits.this._maxIter && !ConfidenceLimits.this._converge.get()) {
                    for (int j = 0; j < ConfidenceLimits.this._sampleSize; ++j) {
                        oneSampleSet[j] = ConfidenceLimits.this._dist.invCDF(rnd.nextDouble());
                    }
                    distFit.fitSampleData(oneSampleSet, ConfidenceLimits.this._method);
                    for (int k = 0; k < numOrdinates; ++k) {
                        double obs = ConfidenceLimits.this.getSampledValue(distFit, k);
                        ConfidenceLimits.this.syncAddObservation(k, obs);
                    }
                    ConfidenceLimits.this._numIter.incrementAndGet();
                    ConfidenceLimits.this._converge.set(ConfidenceLimits.this.syncAllOrdinatesConverged());
                }
            } else {
                ArrayList<SyncSample> subSamples = new ArrayList<SyncSample>();
                for (int i = 0; i < this._numForks; ++i) {
                    subSamples.add(new SyncSample(0));
                }
                SyncSample.invokeAll(subSamples);
            }
        }
    }
}

