/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.EigenvalueDecomposition;
import hec.statistics.NormalDist;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import hec.statistics.util.XML;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jdom.Content;
import org.jdom.Element;

public class CorrelationMatrix
implements Cloneable {
    Map<String, Map<String, Double>> _corMatrix;
    List<String> _variables = new ArrayList<String>();
    private static final String SET_NAME = "Set Name";
    private static final String VARIABLES = "Input Variables";
    private static final String CORR = "Correlation";
    private String _setName;
    private boolean _valid = true;
    private double[][] _cholMat;

    public CorrelationMatrix() {
        this._corMatrix = new HashMap<String, Map<String, Double>>();
    }

    public CorrelationMatrix(String setName) {
        this._corMatrix = new HashMap<String, Map<String, Double>>();
        this.setCorrelationSetName(setName);
    }

    public CorrelationMatrix(List<String> variables, String setName) {
        this._corMatrix = new HashMap<String, Map<String, Double>>();
        this.initMatrixWithStrings(variables);
        this.setCorrelationSetName(setName);
    }

    public void initMatrixWithStrings(List<String> variables) {
        this._variables = variables;
        for (int i = 0; i < variables.size(); ++i) {
            HashMap<String, Double> tempMap = new HashMap<String, Double>();
            for (int j = 0; j < i + 1; ++j) {
                if (i == j) {
                    tempMap.put(variables.get(j), 1.0);
                    continue;
                }
                tempMap.put(variables.get(j), 0.0);
            }
            this._corMatrix.put(variables.get(i), tempMap);
        }
    }

    public void setCorMatrix(Map<String, Map<String, Double>> corMatrix) {
        this._corMatrix = corMatrix;
    }

    public Map<String, Map<String, Double>> getCorMatrix() {
        return this._corMatrix;
    }

    public double[][] getArrayCorMatrix() {
        List<String> keys = this.getKeys();
        if (keys == null) {
            return null;
        }
        double[][] m = new double[keys.size()][];
        for (int i = 0; i < keys.size(); ++i) {
            String keyRow = keys.get(i);
            m[i] = new double[i + 1];
            for (int j = 0; j < i; ++j) {
                m[i][j] = this.getCorEntry(keyRow, keys.get(j));
                if (!Double.isInfinite(m[i][j]) && !Double.isNaN(m[i][j])) continue;
                m[i][j] = 0.0;
            }
            m[i][i] = 1.0;
        }
        return m;
    }

    public double[][] getFullCorrMatrix() {
        List<String> keys = this.getKeys();
        if (keys == null) {
            return null;
        }
        double[][] m = new double[keys.size()][];
        for (int i = 0; i < keys.size(); ++i) {
            String keyRow = keys.get(i);
            m[i] = new double[keys.size()];
            for (int j = 0; j < keys.size(); ++j) {
                m[i][j] = this.getCorEntry(keyRow, keys.get(j));
                if (!Double.isInfinite(m[i][j]) && !Double.isNaN(m[i][j])) continue;
                m[i][j] = 0.0;
            }
            m[i][i] = 1.0;
        }
        return m;
    }

    private double[] getArrayVariateMatrix(Map<String, Double> variateMatrix) {
        NormalDist dist = new NormalDist(0.0, 1.0);
        List<String> keys = this.getKeys();
        if (keys == null) {
            return null;
        }
        double[] m = new double[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            m[i] = dist.invCDF(variateMatrix.get(keys.get(i)));
        }
        return m;
    }

    private void setArrayVariateMatrix(Map<String, Double> variateMatrix, double[] correlatedVariates) {
        NormalDist dist = new NormalDist(0.0, 1.0);
        List<String> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            variateMatrix.put(keys.get(i), dist.getCDF(correlatedVariates[i]));
        }
    }

    public void setCorEntry(String keyRow, String keyCol, Double corValue) {
        Map<String, Double> corRow = this._corMatrix.get(keyRow);
        if (corRow == null) {
            corRow = new HashMap<String, Double>();
            this._corMatrix.put(keyRow, corRow);
        }
        if (corValue == null || corValue.isInfinite() || corValue.isNaN()) {
            corRow.put(keyCol, 0.0);
        } else {
            corRow.put(keyCol, corValue);
        }
        Map<String, Double> corCol = this._corMatrix.get(keyCol);
        if (corCol == null) {
            corCol = new HashMap<String, Double>();
            this._corMatrix.put(keyCol, corCol);
        }
        if (corValue == null || corValue.isInfinite() || corValue.isNaN()) {
            corCol.put(keyRow, 0.0);
        } else {
            corCol.put(keyRow, corValue);
        }
    }

    public Double getCorEntry(String keyRow, String keyCol) {
        Map<String, Double> corRow = this._corMatrix.get(keyRow);
        Double entryDbl1 = null;
        Double entryDbl2 = null;
        if (corRow != null && (entryDbl1 = corRow.get(keyCol)) != null) {
            return entryDbl1;
        }
        corRow = this._corMatrix.get(keyCol);
        if (corRow != null && (entryDbl2 = corRow.get(keyRow)) != null) {
            return entryDbl2;
        }
        if (entryDbl1 == null && entryDbl2 == null) {
            return Double.NaN;
        }
        return 0.0;
    }

    public List<String> getKeys() {
        ArrayList<String> shortName = new ArrayList<String>();
        for (String var : this._variables) {
            shortName.add(var);
        }
        return shortName;
    }

    public CorrelationMatrix clone() {
        CorrelationMatrix clonedCor = null;
        clonedCor = new CorrelationMatrix();
        ArrayList<String> clonedVariableList = new ArrayList<String>();
        for (String var : this._variables) {
            clonedVariableList.add(var);
        }
        clonedCor.initMatrixWithStrings(clonedVariableList);
        if (this._corMatrix != null) {
            clonedCor.setCorrelationSetName(this.getCorrelationSetName());
            for (int i = 0; i < this._variables.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    clonedCor.setCorEntry(this._variables.get(i), this._variables.get(j), this.getCorEntry(this._variables.get(i), this._variables.get(j)));
                }
            }
        }
        return clonedCor;
    }

    public boolean dataOK(String[] error) {
        if (error == null || error.length < 1) {
            return false;
        }
        boolean corOK = true;
        double[][] corArray = this.getArrayCorMatrix();
        if (corArray != null) {
            for (int i = 0; i < corArray.length && corOK; ++i) {
                for (int j = 0; j < i && corOK; ++j) {
                    corOK = corOK && -1.0 <= corArray[i][j] && corArray[i][j] <= 1.0;
                }
            }
        }
        boolean pdOK = this.cholesky(null);
        return corOK && pdOK;
    }

    public boolean saveData(Element corElem) {
        if (this._corMatrix != null) {
            Object[] keyArray = this._corMatrix.keySet().toArray(new String[0]);
            Arrays.sort(keyArray);
            for (int i = 0; i < keyArray.length; ++i) {
                Map<String, Double> corRow = this._corMatrix.get(keyArray[i]);
                if (corRow == null) continue;
                Object[] keyRowArray = corRow.keySet().toArray(new String[0]);
                Arrays.sort(keyRowArray);
                for (int j = 0; j < keyRowArray.length && ((String)keyRowArray[j]).compareTo((String)keyArray[i]) <= 0; ++j) {
                    Double corEntry = corRow.get(keyRowArray[j]);
                    if (corEntry == null) {
                        corEntry = Double.NaN;
                    }
                    Element entryElem = new Element("Entry");
                    entryElem.setAttribute("CompPt1", (String)keyArray[i]);
                    entryElem.setAttribute("CompPt2", (String)keyRowArray[j]);
                    entryElem.setAttribute(CORR, corEntry.toString());
                    corElem.addContent((Content)entryElem);
                }
            }
        }
        return true;
    }

    public boolean loadData(Element corElem) {
        this._corMatrix = new HashMap<String, Map<String, Double>>();
        List entries = corElem.getChildren();
        if (entries == null) {
            return false;
        }
        HashSet<String> keySet = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            Element entryElem = (Element)entries.get(i);
            if (entryElem == null) continue;
            String key1 = entryElem.getAttributeValue("CompPt1");
            keySet.add(key1);
            String key2 = entryElem.getAttributeValue("CompPt2");
            keySet.add(key2);
            Double corVal = XML.getAttributeValueAsDouble(entryElem, CORR, 0.0);
            if (key1.equals(key2)) continue;
            this.setCorEntry(key1, key2, corVal);
            this.setCorEntry(key2, key1, corVal);
        }
        String[] keyArray = keySet.toArray(new String[0]);
        for (int i = 0; i < keyArray.length; ++i) {
            this.setCorEntry(keyArray[i], keyArray[i], new Double(1.0));
        }
        return true;
    }

    public boolean cholesky(double[][] L) {
        int j;
        int i;
        double[][] A = this.getArrayCorMatrix();
        int n = A.length;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < i; ++j) {
                if (A[i][j] != 1.0) continue;
                A[i][j] = 0.9999999999999999;
            }
        }
        if (L == null) {
            L = new double[n][];
        }
        for (i = 0; i < n; ++i) {
            L[i] = new double[i + 1];
            for (j = 0; j <= i; ++j) {
                double sum = 0.0;
                for (int k = 0; k < j; ++k) {
                    sum += L[i][k] * L[j][k];
                }
                if (i == j) {
                    L[i][i] = Math.sqrt(A[i][i] - sum);
                    continue;
                }
                L[i][j] = 1.0 / L[j][j] * (A[i][j] - sum);
            }
            if (!Double.isNaN(L[i][i]) && !Double.isInfinite(L[i][i])) continue;
            return false;
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j <= i; ++j) {
                if (L[i][j] > 0.99999) {
                    L[i][j] = 1.0;
                }
                if (!(L[i][j] < 1.0E-5)) continue;
                L[i][j] = 0.0;
            }
        }
        this._cholMat = L;
        return true;
    }

    public void read(BufferedReader reader) {
        String line = "";
        String type = "";
        String param = "";
        while (!line.equals("CorrelationMatrixEnd")) {
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            type = StringUtil.getFirstToken(line, ":");
            param = StringUtil.getSecondToken(line, ":");
            if (type.equals(SET_NAME)) {
                this.setCorrelationSetName(param);
                continue;
            }
            if (type.equals(VARIABLES)) {
                ArrayList<String> vars = new ArrayList<String>();
                while (param.contains(",")) {
                    vars.add(param.substring(0, param.indexOf(",")));
                    param = param.substring(param.indexOf(",") + 1, param.length());
                }
                this.initMatrixWithStrings(vars);
                continue;
            }
            if (!type.equals(CORR)) continue;
            for (int i = 0; i < this._variables.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    if (!param.contains(",")) continue;
                    this.setCorEntry(this._variables.get(i), this._variables.get(j), Double.valueOf(param.substring(0, param.indexOf(","))));
                    param = param.substring(param.indexOf(",") + 1, param.length());
                }
            }
        }
    }

    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "CorrelationMatrixBegin");
        TextFile.writeLine(writer, "Set Name:" + this.getCorrelationSetName());
        String variableList = "";
        for (int i = 0; i < this._variables.size(); ++i) {
            variableList = variableList.concat(this._variables.get(i) + ",");
        }
        TextFile.writeLine(writer, "Input Variables:" + variableList);
        String valueList = "";
        for (int i = 0; i < this._variables.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                valueList = valueList.concat(this.getCorEntry(this._variables.get(i), this._variables.get(j)) + ",");
            }
        }
        TextFile.writeLine(writer, "Correlation:" + valueList);
        TextFile.writeLine(writer, "CorrelationMatrixEnd");
    }

    public String getCorrelationSetName() {
        return this._setName;
    }

    public void setCorrelationSetName(String setName) {
        this._setName = setName;
    }

    private void setValid(boolean b) {
        this._valid = b;
    }

    public boolean isValid() {
        this.setValid(this.dataOK(new String[1]));
        return this._valid;
    }

    public void makeVariatesCorrelated(Map<String, Double> variateMap) {
        if (this._cholMat == null) {
            this.cholesky(null);
        }
        if (this._valid) {
            double[] correlatedVariates = this.correlateVariates(this.getArrayVariateMatrix(variateMap));
            this.setArrayVariateMatrix(variateMap, correlatedVariates);
        }
    }

    public double[] correlateVariates(double[] variates) {
        double[] result = new double[this._cholMat.length];
        for (int i = 0; i < this._cholMat.length; ++i) {
            result[i] = 0.0;
            for (int j = 0; j < this._cholMat[i].length; ++j) {
                int n = i;
                result[n] = result[n] + this._cholMat[i][j] * variates[j];
            }
        }
        return result;
    }

    public List<String> getVariables() {
        return this._variables;
    }

    public void setVariables(List<String> variables) {
        this._variables = variables;
    }

    public double[] calculateEigenvalues() {
        EigenvalueDecomposition eigenDecomposition = new EigenvalueDecomposition(this.getFullCorrMatrix());
        double[] eigenValues = new double[eigenDecomposition.getEigenValues().length];
        for (int i = 0; i < eigenValues.length; ++i) {
            eigenValues[i] = eigenDecomposition.getEigenValues()[eigenValues.length - i - 1];
        }
        return eigenValues;
    }

    public static void main(String[] args) {
        int i;
        ArrayList<String> vars = new ArrayList<String>();
        vars.add("var1");
        vars.add("var2");
        vars.add("var3");
        CorrelationMatrix corrMat = new CorrelationMatrix("test");
        corrMat.initMatrixWithStrings(vars);
        corrMat.setCorEntry("var1", "var2", 1.0);
        corrMat.setCorEntry("var1", "var3", 1.0);
        corrMat.setCorEntry("var3", "var2", 1.0);
        double[][] matrix = corrMat.getFullCorrMatrix();
        DecimalFormat df = new DecimalFormat("#.###");
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            if (i2 == 0) {
                System.out.print("Correlation Matrix : [" + df.format(matrix[i2][0]));
            } else {
                System.out.print("                     [" + df.format(matrix[i2][0]));
            }
            for (int j = 1; j < matrix[i2].length; ++j) {
                System.out.print(", " + df.format(matrix[i2][j]));
            }
            System.out.print("]" + System.getProperty("line.separator"));
        }
        System.out.print(System.getProperty("line.separator"));
        double[] eigenVector = corrMat.calculateEigenvalues();
        System.out.print("Eigen Values : [" + df.format(eigenVector[0]));
        for (int i3 = 1; i3 < eigenVector.length; ++i3) {
            System.out.print(", " + df.format(eigenVector[i3]));
        }
        System.out.print("]" + System.getProperty("line.separator") + System.getProperty("line.separator"));
        HashMap<String, Double> randomNumbers = new HashMap<String, Double>();
        long seed = 12345L;
        Random rnd = new Random(seed);
        for (String name : vars) {
            randomNumbers.put(name, rnd.nextDouble());
        }
        System.out.print("Uncorrelated random numbers : [" + df.format(randomNumbers.get(vars.get(0))));
        for (i = 1; i < vars.size(); ++i) {
            System.out.print(", " + df.format(randomNumbers.get(vars.get(i))));
        }
        System.out.print("]" + System.getProperty("line.separator"));
        corrMat.makeVariatesCorrelated(randomNumbers);
        System.out.print("Correlated random numbers : [" + df.format(randomNumbers.get(vars.get(0))));
        for (i = 1; i < vars.size(); ++i) {
            System.out.print(", " + df.format(randomNumbers.get(vars.get(i))));
        }
        System.out.print("]" + System.getProperty("line.separator"));
    }

    public void fillInCorrelations(CorrelationMatrix tempCorrMatrix) {
        for (String key : tempCorrMatrix.getKeys()) {
            for (String key2 : tempCorrMatrix.getKeys()) {
                this.setCorEntry(key, key2, tempCorrMatrix.getCorEntry(key, key2));
            }
        }
    }
}

