/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.Parseable;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiscreteDist<E extends Parseable> {
    protected List<Singleton> _valueList = new ArrayList<Singleton>();
    private double _totalWeight = 0.0;

    private void computeTotalWeight() {
        this._totalWeight = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            this._totalWeight += this.getWeight(i);
        }
    }

    public int size() {
        return this._valueList.size();
    }

    public void clear() {
        this._valueList.clear();
    }

    public boolean isEmpty() {
        return this._valueList.isEmpty();
    }

    public void add(int index, double weight, E value) {
        if (weight < 0.0) {
            weight = 0.0;
        }
        Singleton sing = new Singleton(this, weight, value);
        this._valueList.add(index, sing);
        this.computeTotalWeight();
    }

    public void add(double weight, E value) {
        if (weight < 0.0) {
            weight = 0.0;
        }
        Singleton sing = new Singleton(this, weight, value);
        this._valueList.add(sing);
        this.computeTotalWeight();
    }

    public void set(int index, double weight, E value) {
        if (weight < 0.0) {
            weight = 0.0;
        }
        Singleton sing = new Singleton(this, weight, value);
        this._valueList.set(index, sing);
        this.computeTotalWeight();
    }

    public void setWeight(int index, double weight) {
        if (weight < 0.0) {
            weight = 0.0;
        }
        Singleton sing = this._valueList.get(index);
        sing.setWeight(weight);
        this.computeTotalWeight();
    }

    public void setValue(int index, E value) {
        Singleton sing = this._valueList.get(index);
        sing.setValue(value);
    }

    public void remove(int index) {
        this._valueList.remove(index);
        this.computeTotalWeight();
    }

    public E getValue(int index) {
        Singleton sing = this._valueList.get(index);
        return sing.getValue();
    }

    public double getWeight(int index) {
        Singleton sing = this._valueList.get(index);
        return sing.getWeight();
    }

    public double getTotalWeight() {
        return this._totalWeight;
    }

    public double getProb(int index) {
        return this.getWeight(index) / this.getTotalWeight();
    }

    public Object clone() {
        DiscreteDist clonedDist = new DiscreteDist();
        for (int i = 0; i < this.size(); ++i) {
            Singleton sing = this._valueList.get(i);
            clonedDist.add(sing.getWeight(), sing.getValue());
        }
        return clonedDist;
    }

    public void read(BufferedReader reader) {
        try {
            this.clear();
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("DiscreteDistEnd")) {
                    return;
                }
                if (type.equals("EntryBegin")) {
                    Singleton sing = new Singleton(this);
                    sing.read(reader);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read UnifDist Data.   " + e);
            e.printStackTrace();
        }
    }

    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "DiscreteDistBegin");
        for (int i = 0; i < this.size(); ++i) {
            this._valueList.get(i).write(writer);
        }
        TextFile.writeLine(writer, "DiscrteDistEnd");
    }

    public double getPDF(E value) {
        for (int i = 0; i < this.size(); ++i) {
            if (value != this.getValue(i)) continue;
            return this.getProb(i);
        }
        return 0.0;
    }

    public double getCDF(E value) {
        double prob = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            prob += this.getProb(i);
            if (value != this.getValue(i)) continue;
            return prob;
        }
        return Double.NaN;
    }

    public int invCDFidx(double p) {
        if (p < 0.0) {
            return 0;
        }
        if (p > 1.0) {
            return this.size() - 1;
        }
        double weight = p * this.getTotalWeight();
        for (int i = 0; i < this.size(); ++i) {
            double wi = this.getWeight(i);
            if (weight <= wi) {
                return i;
            }
            weight -= wi;
        }
        return 0;
    }

    public E invCDF(double p) {
        if (p < 0.0 || p > 1.0) {
            return null;
        }
        return this.getValue(this.invCDFidx(p));
    }

    public Map<E, Double> getMap() {
        HashMap<E, Double> eMap = new HashMap<E, Double>();
        for (int i = 0; i < this.size(); ++i) {
            E val = this.getValue(i);
            if (val == null) continue;
            double p = this.getProb(i);
            eMap.put(val, p);
        }
        return eMap;
    }

    public Map<String, Double> getParsedMap() {
        HashMap<String, Double> pMap = new HashMap<String, Double>();
        for (int i = 0; i < this.size(); ++i) {
            E val = this.getValue(i);
            if (val == null) continue;
            double p = this.getProb(i);
            pMap.put(val.toString(), p);
        }
        return pMap;
    }

    public List<E> getValueList() {
        ArrayList<E> eList = new ArrayList<E>();
        for (int i = 0; i < this.size(); ++i) {
            E val = this.getValue(i);
            if (val == null) continue;
            eList.add(val);
        }
        return eList;
    }

    public List<String> getParsedValueList() {
        ArrayList<String> eList = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            E val = this.getValue(i);
            if (val == null) continue;
            eList.add(val.toString());
        }
        return eList;
    }

    public class Singleton {
        private double _weight;
        private E _value;
        final /* synthetic */ DiscreteDist this$0;

        Singleton(DiscreteDist this$0) {
            this.this$0 = this$0;
            this._weight = 0.0;
            this._value = null;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        Singleton(double value, E e) {
            void weight;
            this.this$0 = (DiscreteDist)this$0;
            this._weight = weight;
            this._value = value;
        }

        public void setWeight(double weight) {
            this._weight = weight;
        }

        public double getWeight() {
            return this._weight;
        }

        public void setValue(E value) {
            this._value = value;
        }

        public E getValue() {
            return this._value;
        }

        public void write(BufferedWriter writer) {
            TextFile.writeLine(writer, "EntryBegin");
            TextFile.writeLine(writer, "Weight:" + Double.toString(this.getWeight()));
            TextFile.writeLine(writer, "Class:" + this.getValue().getClass().getName());
            this.getValue().write(writer);
            TextFile.writeLine(writer, "EntryEnd");
        }

        public void read(BufferedReader reader) {
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (line.length() == 0) {
                        line = reader.readLine();
                        continue;
                    }
                    String type = StringUtil.getFirstToken(line, ":");
                    String param = StringUtil.getSecondToken(line, ":");
                    if (type.equals("EntryEnd")) {
                        return;
                    }
                    if (type.equals("Weight")) {
                        this.setWeight(Double.parseDouble(param));
                    } else if (type.equals("Class")) {
                        Parseable val = (Parseable)Class.forName(param).newInstance();
                        val.read(reader);
                        this.setValue(val);
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                System.out.println("Failed to read Singleton Data. " + e);
                e.printStackTrace();
            }
        }
    }
}

