/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.Beta4ParamDist;
import hec.statistics.BetaDist;
import hec.statistics.ChiSqDist;
import hec.statistics.ContDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.ExponentialDist;
import hec.statistics.GammaDist;
import hec.statistics.GenLogisticDist;
import hec.statistics.GenParetoDist;
import hec.statistics.GevDist;
import hec.statistics.GumbelDist;
import hec.statistics.LinearMoments;
import hec.statistics.Log10NormalDist;
import hec.statistics.LogLogisticDist;
import hec.statistics.LogNormalDist;
import hec.statistics.LogPearson3B17BDist;
import hec.statistics.LogPearson3Dist;
import hec.statistics.LogisticDist;
import hec.statistics.NormalB17BDist;
import hec.statistics.NormalDist;
import hec.statistics.Pearson3B17BDist;
import hec.statistics.Pearson3Dist;
import hec.statistics.ProductMoments;
import hec.statistics.ShiftedExponentialDist;
import hec.statistics.ShiftedGammaDist;
import hec.statistics.ShiftedLogNormalDist;
import hec.statistics.TriangDist;
import hec.statistics.UnifDist;

public enum DistributionTypes {
    BETA(BetaDist.class, "Beta"),
    BETA4PAR(Beta4ParamDist.class, "4 Parameter Beta"),
    CHISQUARED(ChiSqDist.class, "Chi-Squared"),
    EMPIRICAL(EmpiricalDist.class, "Empirical"),
    EXPONENTIAL(ExponentialDist.class, "Exponential"),
    GAMMA(GammaDist.class, "Gamma"),
    GENERALIZEDEXTREMEVALUE(GevDist.class, "Generalized Extreme Value"),
    GENERALIZEDLOGISTIC(GenLogisticDist.class, "Generalized Logistic"),
    GENERALIZEDPARETO(GenParetoDist.class, "Generalized Pareto"),
    GUMBEL(GumbelDist.class, "Gumbel"),
    LOGISTIC(LogisticDist.class, "Logistic"),
    NORMAL(NormalDist.class, "Normal"),
    NORMALB17B(NormalB17BDist.class, "Normal B17B"),
    PEARSONIII(Pearson3Dist.class, "Pearson III"),
    PEARSONIIIB17B(Pearson3B17BDist.class, "Pearson III B17B"),
    UNIFORM(UnifDist.class, "Uniform"),
    TRIANGULAR(TriangDist.class, "Triangular"),
    LOGLOGISTIC(LogLogisticDist.class, "Log-Logistic"),
    LOGNORMAL(LogNormalDist.class, "Ln-Normal"),
    LOG10NORMAL(Log10NormalDist.class, "Log10-Normal"),
    LOG10NORMALB17B(Log10NormalDist.class, "Log-Normal B17B"),
    LOGPEARSONIII(LogPearson3Dist.class, "Log-Pearson III"),
    LOGPEARSONIIIB17B(LogPearson3B17BDist.class, "Log-Pearson III B17B"),
    SHIFTEDEXPONENTIAL(ShiftedExponentialDist.class, "Shifted Exponential"),
    SHIFTEDGAMMA(ShiftedGammaDist.class, "Shifted Gamma"),
    SHIFTEDLOGNORMAL(ShiftedLogNormalDist.class, "Shifted Ln-Normal");

    private final Class<ContDist> _class;
    private final String _name;

    private DistributionTypes(Class<?> distClass, String name) {
        this._class = distClass;
        this._name = name;
    }

    public String toString() {
        return this._name;
    }

    public Class<ContDist> getDistClass() {
        return this._class;
    }

    public ContDist getInstance() {
        try {
            return this._class.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public ContDist getInstance(double[] values) {
        ContDist instance = this.getInstance();
        if (instance == null) {
            return null;
        }
        instance.fitSampleData(values);
        return instance;
    }

    public ContDist getInstance(double[] values, AbstractContDist.FittingMethod method) {
        ContDist instance = this.getInstance();
        if (instance == null) {
            return null;
        }
        instance.fitSampleData(values, method);
        return instance;
    }

    public ContDist getInstance(ProductMoments pm) {
        ContDist instance = this.getInstance();
        if (instance == null) {
            return null;
        }
        instance.fitSampleData(pm);
        return instance;
    }

    public ContDist getInstance(LinearMoments lm) {
        ContDist instance = this.getInstance();
        if (instance == null) {
            return null;
        }
        instance.fitSampleData(lm);
        return instance;
    }
}

