/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;

public class EmpiricalClipDist
extends EmpiricalDist
implements ClipDist {
    private ClipData _clip = new ClipData(){

        @Override
        public void setMinVal(double minVal) {
            super.setMinVal(minVal);
            super.setMinProb(EmpiricalClipDist.super.getCDF(minVal));
        }

        @Override
        public void setMinProb(double minProb) {
            super.setMinProb(minProb);
            super.setMinVal(EmpiricalClipDist.super.invCDF(minProb));
        }

        @Override
        public void setMaxVal(double maxVal) {
            super.setMaxVal(maxVal);
            super.setMaxProb(EmpiricalClipDist.super.getCDF(maxVal));
        }

        @Override
        public void setMaxProb(double maxProb) {
            super.setMaxProb(maxProb);
            super.setMaxVal(EmpiricalClipDist.super.invCDF(maxProb));
        }
    };
    static final int COMPUTE_FLAG = 0;

    public EmpiricalClipDist() {
    }

    public EmpiricalClipDist(EmpiricalDist.InterpType interpType) {
        super(interpType);
    }

    public EmpiricalClipDist(double[] cumProbs, double[] values) {
        super(cumProbs, values);
    }

    public EmpiricalClipDist(EmpiricalDist.InterpType interpType, double[] cumProbs, double[] values) {
        super(interpType, cumProbs, values);
    }

    @Override
    public ClipData getClipData() {
        return this._clip;
    }

    @Override
    public String[] getClipParamNames() {
        if (this.getClipData() == null) {
            return new String[0];
        }
        return this.getClipData().getClipParamNames();
    }

    @Override
    public double[] getClipParamVals() {
        if (this.getClipData() == null) {
            return new double[0];
        }
        return this.getClipData().getClipParamVals();
    }

    @Override
    public String getSummaryClip(String format) {
        if (this.getClipData() == null) {
            return "";
        }
        return this.getClipData().getSummary(format);
    }

    @Override
    public Object clone() {
        EmpiricalClipDist clonedDist = (EmpiricalClipDist)super.clone();
        clonedDist._clip = (ClipData)this._clip.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            this.clear();
            ArrayList<Double> cumList = new ArrayList<Double>();
            ArrayList<Double> valList = new ArrayList<Double>();
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("EmpiricalClipDistEnd")) {
                    double[] cumProbs = new double[cumList.size()];
                    double[] values = new double[valList.size()];
                    for (int i = 0; i < valList.size(); ++i) {
                        cumProbs[i] = (Double)cumList.get(i);
                        values[i] = (Double)valList.get(i);
                    }
                    this.addAll(cumProbs, values);
                    return;
                }
                if (type.equals("InterpType")) {
                    this.setInterpType(EmpiricalDist.InterpType.valueOf(param));
                } else if (type.equals("Entry")) {
                    String param1 = StringUtil.getFirstToken(param, ",");
                    String param2 = StringUtil.getSecondToken(param, ",");
                    cumList.add(Double.parseDouble(param1));
                    valList.add(Double.parseDouble(param2));
                } else if (type.equals("ClipDataBegin")) {
                    this._clip.read(reader);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read EmpiricalClipDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "EmpiricalClipDistBegin");
        TextFile.writeLine(writer, "InterpType:" + this.getInterpType().toString());
        for (int i = 0; i < this.size(); ++i) {
            TextFile.writeLine(writer, "Entry:" + this.getCumProb(i) + "," + this.getValue(i));
        }
        this._clip.write(writer);
        TextFile.writeLine(writer, "EmpiricalClipDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal() || this.getClipData().hasMaxClip() && value > this.getClipData().getMaxVal()) {
            return 0.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return super.getPDF(value) / rescale;
    }

    @Override
    public double getCDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal()) {
            return 0.0;
        }
        if (this.getClipData().hasMaxClip() && value >= this.getClipData().getMaxVal()) {
            return 1.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return (super.getCDF(value) - minProb) / rescale;
    }

    @Override
    public double invCDF(double p) {
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return super.invCDF(minProb + p * rescale);
    }
}

