/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class EmpiricalDist
extends AbstractContDist {
    private InterpType _interpType = InterpType.LINEAR;
    protected double[] _values = new double[0];
    private double[] _cumProbs = new double[0];

    public EmpiricalDist() {
    }

    public EmpiricalDist(InterpType interpType) {
        this.setInterpType(interpType);
    }

    public EmpiricalDist(double[] cumProbs, double[] values) {
        this.setCumProbs(cumProbs);
        this.setValues(values);
    }

    public EmpiricalDist(InterpType interpType, double[] cumProbs, double[] values) {
        this.setInterpType(interpType);
        this.setCumProbs(cumProbs);
        this.setValues(values);
    }

    public EmpiricalDist(InterpType interpType, double[] values) {
        this.setInterpType(interpType);
        this.fitSampleData(values);
    }

    public EmpiricalDist(double[] sample) {
        this.fitSampleData(sample);
    }

    @Override
    public boolean fitSampleData(double[] sample, AbstractContDist.FittingMethod method) {
        this.setCumProbs(EmpiricalDist.getSampleCDF(sample.length));
        this.setValues(sample);
        return true;
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        this.setCumProbs(new double[0]);
        this.setValues(new double[0]);
        return false;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setCumProbs(new double[0]);
        this.setValues(new double[0]);
        return false;
    }

    private static double[] getSampleCDF(int n) {
        double[] cdf = new double[n];
        for (int i = 0; i < n; ++i) {
            cdf[i] = ((double)i + 0.5) / (double)n;
        }
        return cdf;
    }

    public void setInterpType(InterpType interpType) {
        this._interpType = interpType;
    }

    public InterpType getInterpType() {
        return this._interpType;
    }

    public int size() {
        return this._values.length;
    }

    public void clear() {
        this._values = new double[0];
        this._cumProbs = new double[0];
    }

    public boolean isEmpty() {
        return this._values.length == 0;
    }

    public double getCumProb(int index) {
        return this._cumProbs[index];
    }

    public double getExceed(int index) {
        return 1.0 - this.getCumProb(index);
    }

    public double getValue(int index) {
        if (this._values.length == 0) {
            return 0.0;
        }
        return this._values[index];
    }

    public void setCumProbs(double[] cumProbs) {
        double[] cumProbsCopy = new double[cumProbs.length];
        System.arraycopy(cumProbs, 0, cumProbsCopy, 0, cumProbs.length);
        Arrays.sort(cumProbsCopy);
        this._cumProbs = cumProbs;
    }

    public void setExceedProbs(double[] exceedProbs) {
        int size = this.size();
        double[] cumProbs = new double[size];
        for (int i = 0; i < size; ++i) {
            cumProbs[i] = 1.0 - exceedProbs[i];
        }
        this.setCumProbs(cumProbs);
    }

    public void setValues(double[] values) {
        double[] valuesCopy = new double[values.length];
        System.arraycopy(values, 0, valuesCopy, 0, values.length);
        Arrays.sort(valuesCopy);
        this._values = valuesCopy;
    }

    public double[] getCumProbs() {
        int size = this.size();
        double[] cumProbs = new double[size];
        for (int i = 0; i < size; ++i) {
            cumProbs[i] = this.getCumProb(i);
        }
        return cumProbs;
    }

    public double[] getExceedProbs() {
        int size = this.size();
        double[] exceedProbs = new double[size];
        for (int i = 0; i < size; ++i) {
            exceedProbs[i] = this.getExceed(i);
        }
        return exceedProbs;
    }

    public double[] getValues() {
        int size = this.size();
        double[] values = new double[size];
        for (int i = 0; i < size; ++i) {
            values[i] = this.getValue(i);
        }
        return values;
    }

    public void remove(int index) {
        int i;
        int size = this.size();
        double[] cumProbs = new double[size - 1];
        double[] values = new double[size - 1];
        for (i = 0; i < index; ++i) {
            cumProbs[i] = this.getCumProb(i);
            values[i] = this.getValue(i);
        }
        for (i = index + 1; i < size; ++i) {
            cumProbs[i - 1] = this.getCumProb(i);
            values[i - 1] = this.getValue(i);
        }
        this.setCumProbs(cumProbs);
        this.setValues(values);
    }

    public void add(double cumProb, double value) {
        if (cumProb < 0.0) {
            cumProb = 0.0;
        }
        if (cumProb > 1.0) {
            cumProb = 1.0;
        }
        int size = this.size();
        double[] vals = this.getValues();
        int index = Arrays.binarySearch(vals, value);
        if (index >= 0) {
            if (index > 0 && this.getCumProb(index - 1) > cumProb) {
                return;
            }
            if (index < size - 1 && this.getCumProb(index + 1) < cumProb) {
                return;
            }
            this._cumProbs[index] = cumProb;
        } else {
            int i;
            if ((index = -(index + 1)) > 0 && this.getCumProb(index - 1) > cumProb) {
                return;
            }
            if (index < size && this.getCumProb(index) < cumProb) {
                return;
            }
            double[] cumProbs = new double[size + 1];
            double[] values = new double[size + 1];
            for (i = 0; i < index; ++i) {
                cumProbs[i] = this.getCumProb(i);
                values[i] = this.getValue(i);
            }
            cumProbs[index] = cumProb;
            values[index] = value;
            for (i = index + 1; i <= size; ++i) {
                cumProbs[i] = this.getCumProb(i - 1);
                values[i] = this.getValue(i - 1);
            }
            this.setCumProbs(cumProbs);
            this.setValues(values);
        }
    }

    public void addAll(double[] cumProbs, double[] values) {
        if (cumProbs == null || values == null) {
            return;
        }
        if (cumProbs.length != values.length) {
            return;
        }
        int len = cumProbs.length;
        for (int i = 0; i < len; ++i) {
            this.add(cumProbs[i], values[i]);
        }
    }

    @Override
    public String getType() {
        return "Empirical";
    }

    @Override
    public String[] getParamNames() {
        return new String[0];
    }

    @Override
    public double[] getParamVals() {
        return new double[0];
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
    }

    public double[] getParamVals(int row) {
        double[] vals = new double[]{this._cumProbs[row], this._values[row]};
        return vals;
    }

    public int getNumRows() {
        return this._values.length;
    }

    @Override
    public String getSummaryDef(String format) {
        return "User-defined";
    }

    @Override
    public Object clone() {
        EmpiricalDist clonedDist = (EmpiricalDist)super.clone();
        clonedDist.setCumProbs((double[])this._cumProbs.clone());
        clonedDist.setValues((double[])this._values.clone());
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            this.clear();
            ArrayList<Double> cumList = new ArrayList<Double>();
            ArrayList<Double> valList = new ArrayList<Double>();
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("EmpiricalDistEnd")) {
                    double[] cumProbs = new double[cumList.size()];
                    double[] values = new double[valList.size()];
                    for (int i = 0; i < valList.size(); ++i) {
                        cumProbs[i] = (Double)cumList.get(i);
                        values[i] = (Double)valList.get(i);
                    }
                    this.addAll(cumProbs, values);
                    return;
                }
                if (type.equals("InterpType")) {
                    this.setInterpType(InterpType.valueOf(param));
                } else if (type.equals("Entry")) {
                    String param1 = StringUtil.getFirstToken(param, ",");
                    String param2 = StringUtil.getSecondToken(param, ",");
                    cumList.add(Double.parseDouble(param1));
                    valList.add(Double.parseDouble(param2));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read EmpiricalDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "EmpiricalDistBegin");
        TextFile.writeLine(writer, "InterpType:" + this.getInterpType().toString());
        for (int i = 0; i < this.size(); ++i) {
            TextFile.writeLine(writer, "Entry:" + this.getCumProb(i) + "," + this.getValue(i));
        }
        TextFile.writeLine(writer, "EmpiricalDistEnd");
    }

    @Override
    public double getPDF(double value) {
        int index = Arrays.binarySearch(this.getValues(), value);
        switch (this.getInterpType()) {
            case LINEAR: {
                if (index >= 0) {
                    int size = this.size();
                    double pdfLeft = index == 0 ? 0.0 : (this.getCumProb(index) - this.getCumProb(index - 1)) / (this.getValue(index) - this.getValue(index - 1));
                    double pdfRight = index < size - 1 ? (this.getCumProb(index + 1) - this.getCumProb(index)) / (this.getValue(index + 1) - this.getValue(index)) : 0.0;
                    double pdfValue = 0.5 * (pdfLeft + pdfRight);
                    return pdfValue;
                }
                int size = this.size();
                if ((index = -(index + 1)) == 0) {
                    return 0.0;
                }
                if (index < size) {
                    double pdfValue = (this.getCumProb(index) - this.getCumProb(index - 1)) / (this.getValue(index) - this.getValue(index - 1));
                    return pdfValue;
                }
                return 0.0;
            }
            case STEP: {
                if (index >= 0) {
                    if (index == 0) {
                        return this.getCumProb(0);
                    }
                    return this.getCumProb(index) - this.getCumProb(index - 1);
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    public double getCDF(double value) {
        int index = Arrays.binarySearch(this.getValues(), value);
        switch (this.getInterpType()) {
            case LINEAR: {
                if (index >= 0) {
                    return this.getCumProb(index);
                }
                int size = this.size();
                if ((index = -(index + 1)) == 0) {
                    return 0.0;
                }
                if (index < size) {
                    double weight = (value - this.getValue(index - 1)) / (this.getValue(index) - this.getValue(index - 1));
                    return (1.0 - weight) * this.getCumProb(index - 1) + weight * this.getCumProb(index);
                }
                return 1.0;
            }
            case STEP: {
                if (index >= 0) {
                    return this.getCumProb(index);
                }
                int size = this.size();
                if ((index = -(index + 1)) == 0) {
                    return 0.0;
                }
                if (index < size) {
                    return this.getCumProb(index - 1);
                }
                return 1.0;
            }
        }
        return 0.0;
    }

    @Override
    public double invCDF(double p) {
        int index = Arrays.binarySearch(this.getCumProbs(), p);
        switch (this.getInterpType()) {
            case LINEAR: {
                if (index >= 0) {
                    return this.getValue(index);
                }
                int size = this.size();
                if ((index = -(index + 1)) == 0) {
                    return this.getValue(0);
                }
                if (index < size) {
                    double weight = (p - this.getCumProb(index - 1)) / (this.getCumProb(index) - this.getCumProb(index - 1));
                    return (1.0 - weight) * this.getValue(index - 1) + weight * this.getValue(index);
                }
                return this.getValue(size - 1);
            }
            case STEP: {
                if (index >= 0) {
                    return this.getValue(index);
                }
                int size = this.size();
                if ((index = -(index + 1)) < size) {
                    return this.getValue(index);
                }
                return this.getValue(size - 1);
            }
        }
        return 0.0;
    }

    public double computeMean() {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        if (size == 1) {
            return this.getValue(0);
        }
        double meanVal = 0.0;
        switch (this.getInterpType()) {
            case LINEAR: {
                int i = 0;
                double valR = this.getValue(i);
                double cdfR = this.getCumProb(i);
                double stepPDF = cdfR - 0.0;
                meanVal += valR * stepPDF;
                double valL = valR;
                double cdfL = cdfR;
                for (i = 1; i < size; ++i) {
                    valR = this.getValue(i);
                    cdfR = this.getCumProb(i);
                    stepPDF = cdfR - cdfL;
                    double stepVal = (valL + valR) / 2.0;
                    meanVal += stepPDF * stepVal;
                    valL = valR;
                    cdfL = cdfR;
                }
                i = size - 1;
                valR = this.getValue(i);
                cdfR = 1.0;
                stepPDF = cdfR - cdfL;
                meanVal += valR * stepPDF;
                valL = valR;
                cdfL = cdfR;
                break;
            }
            case STEP: {
                double stepPDF;
                double cdfR;
                int i;
                double cdfL = 0.0;
                for (i = 0; i < size - 1; ++i) {
                    cdfR = this.getCumProb(i);
                    stepPDF = cdfR - cdfL;
                    meanVal += this.getValue(i) * stepPDF;
                    cdfL = cdfR;
                }
                i = size - 1;
                cdfR = 1.0;
                stepPDF = cdfR - cdfL;
                meanVal += this.getValue(i) * stepPDF;
                cdfL = cdfR;
            }
        }
        return meanVal;
    }

    public double computeStDv() {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        if (size == 1) {
            return 0.0;
        }
        double meanVal = this.computeMean();
        double expect2 = 0.0;
        switch (this.getInterpType()) {
            case LINEAR: {
                int i = 0;
                double valR = this.getValue(i);
                double cdfR = this.getCumProb(i);
                double stepPDF = cdfR - 0.0;
                expect2 += valR * valR * stepPDF;
                double valL = valR;
                double cdfL = cdfR;
                for (i = 1; i < size; ++i) {
                    valR = this.getValue(i);
                    cdfR = this.getCumProb(i);
                    stepPDF = cdfR - cdfL;
                    double stepVal = (valL * valL + valL * valR + valR * valR) / 3.0;
                    expect2 += stepVal * stepPDF;
                    valL = valR;
                    cdfL = cdfR;
                }
                i = size - 1;
                valR = this.getValue(i);
                cdfR = 1.0;
                stepPDF = cdfR - cdfL;
                expect2 += valR * stepPDF;
                valL = valR;
                cdfL = cdfR;
                break;
            }
            case STEP: {
                double stepPDF;
                double cdfR;
                int i;
                double cdfL = 0.0;
                for (i = 0; i < size - 1; ++i) {
                    cdfR = this.getCumProb(i);
                    stepPDF = cdfR - cdfL;
                    expect2 += this.getValue(i) * this.getValue(i) * stepPDF;
                    cdfL = cdfR;
                }
                i = size - 1;
                cdfR = 1.0;
                stepPDF = cdfR - cdfL;
                expect2 += this.getValue(i) * this.getValue(i) * stepPDF;
                cdfL = cdfR;
            }
        }
        return expect2 - meanVal * meanVal;
    }

    public static enum InterpType {
        LINEAR,
        STEP;

    }
}

