/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ContDist;
import hec.statistics.EquationSolverBiSearch;
import hec.statistics.UncertainDistributionCalculator;
import hec.statistics.util.Interpolate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EnsembleDistribution
implements UncertainDistributionCalculator {
    private final Set<ContDist> _distributions;
    private double[] _realizedCumulativeProbabilities;
    private final Map<Double, double[]> _cachedVerticalDistributions = new HashMap<Double, double[]>();
    private final EquationSolverBiSearch _solver = new MyEquationSolverBiSearch();

    public EnsembleDistribution(int estimatedSize) {
        this._distributions = Collections.synchronizedSet(new HashSet(estimatedSize));
    }

    public double invCDF(double cumulativeProbability) {
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        for (ContDist dist : this._distributions) {
            double val = dist.invCDF(cumulativeProbability);
            if (!Double.isFinite(val)) continue;
            if (val > max) {
                max = val;
            }
            if (!(val < min)) continue;
            min = val;
        }
        return this._solver.biSearch(cumulativeProbability, min, max, 1.0E-6);
    }

    public double getCDF(double value) {
        double retval = 0.0;
        for (ContDist dist : this._distributions) {
            retval += dist.getCDF(value);
        }
        return retval /= (double)this._distributions.size();
    }

    private void computeRealizedProbabilities() {
        if (this._realizedCumulativeProbabilities == null || this._realizedCumulativeProbabilities.length != this._distributions.size()) {
            this._realizedCumulativeProbabilities = new double[this._distributions.size()];
            for (int i = 0; i < this._distributions.size(); ++i) {
                this._realizedCumulativeProbabilities[i] = ((double)i + 0.5) / (double)this._distributions.size();
            }
        }
    }

    public void clear() {
        this._distributions.clear();
        this.clearCachedResources();
    }

    public void add(ContDist distribution) {
        this._distributions.add(distribution);
    }

    public int size() {
        return this._distributions.size();
    }

    public double[] getVerticalCrossDistributionSample(double cumulativeProbability) {
        double[] retval = new double[this._distributions.size()];
        int distIndex = -1;
        for (ContDist dist : this._distributions) {
            retval[++distIndex] = dist.invCDF(cumulativeProbability);
        }
        Arrays.sort(retval);
        return retval;
    }

    public double[] getHorizontalCrossDistributionSample(double value) {
        double[] retval = new double[this._distributions.size()];
        int distIndex = -1;
        for (ContDist dist : this._distributions) {
            retval[++distIndex] = dist.getCDF(value);
        }
        Arrays.sort(retval);
        return retval;
    }

    @Override
    public double evaluate(double confidenceLimit, double exceedanceProbability) {
        double[] vertDist;
        double retval;
        this.computeRealizedProbabilities();
        if (!this._cachedVerticalDistributions.containsKey(exceedanceProbability)) {
            this._cachedVerticalDistributions.put(exceedanceProbability, this.getVerticalCrossDistributionSample(1.0 - exceedanceProbability));
        }
        if ((retval = Interpolate.interpolatePairedArrays(confidenceLimit, this._realizedCumulativeProbabilities, vertDist = this._cachedVerticalDistributions.get(exceedanceProbability))) < 1.0E-5) {
            retval = 1.0E-5;
        }
        return retval;
    }

    public void clearCachedResources() {
        this._cachedVerticalDistributions.clear();
    }

    private class MyEquationSolverBiSearch
    extends EquationSolverBiSearch {
        private MyEquationSolverBiSearch() {
        }

        @Override
        public double f(double x) {
            return EnsembleDistribution.this.getCDF(x);
        }
    }
}

