/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.FunctionMinimizer;
import hec.statistics.LinearAlgebra;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public abstract class EquationSolverMultiVariateNewton
implements FunctionMinimizer {
    private static final double DX = 1.0E-5;
    private double[][] _bounds;

    public abstract double f(double[] var1);

    public void jacobian(double[] x, double[] result) {
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            x[n] = x[n] + 1.0E-5;
            double eval = this.f(x);
            int n2 = i;
            x[n2] = x[n2] - 1.0E-5;
            result[i] = (this.f(x) - eval) / 1.0E-5;
        }
    }

    public void hessian(double[] x, double[] hessianResult) {
        double[] jac1 = new double[x.length];
        double[] jac2 = new double[x.length];
        this.jacobian(x, jac1);
        int i = 0;
        while (i < x.length) {
            int n = i;
            x[n] = x[n] + 1.0E-5;
            this.jacobian(x, jac2);
            for (int j = 0; j < x.length; ++j) {
                hessianResult[i * x.length + j] = (jac1[j] - jac2[j]) / 1.0E-5;
            }
            int n2 = i++;
            x[n2] = x[n2] - 1.0E-5;
        }
    }

    @Override
    public final double[] minimize(double[][] bounds, double tolY, int maxIter) {
        double[] x = new double[bounds[0].length];
        this._bounds = bounds;
        double[] xNew = this.getInitGuess();
        double[] multMat = new double[x.length];
        double[] hessian = new double[x.length * x.length];
        double[] normalizedHessian = new double[x.length * x.length];
        double[] invertHessian = new double[x.length * x.length];
        double[] jacobian = new double[x.length];
        double yNew = this.f(xNew);
        double normFactor = 1.0;
        for (int i = 0; i < maxIter; ++i) {
            int j;
            for (j = 0; j < multMat.length; ++j) {
                x[j] = xNew[j];
                xNew[j] = Double.NaN;
            }
            double yOld = yNew;
            yNew = Double.NaN;
            this.hessian(x, hessian);
            for (j = 0; j < normalizedHessian.length; ++j) {
                normalizedHessian[j] = hessian[j];
                invertHessian[j] = normalizedHessian[j];
            }
            this.jacobian(x, jacobian);
            while (true) {
                if (!LinearAlgebra.invertMatrix(invertHessian)) {
                    if (!this.isValid(invertHessian)) {
                        for (j = 0; j < x.length; ++j) {
                            x[i] = Double.NaN;
                        }
                        return x;
                    }
                    this.normalizeMatrix(x.length, normFactor, normalizedHessian, invertHessian);
                    continue;
                }
                LinearAlgebra.matMultAB(invertHessian, jacobian, multMat, x.length, x.length, 1);
                for (j = 0; j < multMat.length; ++j) {
                    xNew[j] = x[j] + multMat[j];
                }
                for (j = 0; j < xNew.length; ++j) {
                    if (NumericalConstants.isValidValue((double)xNew[j])) continue;
                    return xNew;
                }
                if (!this.boundValues(xNew) && NumericalConstants.isValidValue((double)(yNew = this.f(xNew)))) break;
                this.normalizeMatrix(x.length, normFactor, normalizedHessian, invertHessian);
            }
            double yDiff = yNew - yOld;
            if (!(Math.abs(yDiff) <= tolY)) continue;
            return x;
        }
        double[] retval = new double[x.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = Double.NaN;
        }
        return retval;
    }

    private boolean isValid(double[] mat) {
        for (int i = 0; i < mat.length; ++i) {
            if (NumericalConstants.isValidValue((double)mat[i])) continue;
            return false;
        }
        return true;
    }

    private void normalizeMatrix(int length, double normFactor, double[] normalizedHessian, double[] invertHessian) {
        int j;
        for (j = 0; j < length; ++j) {
            int n = j * length + j;
            normalizedHessian[n] = normalizedHessian[n] + normalizedHessian[j * length + j] * normFactor;
        }
        for (j = 0; j < normalizedHessian.length; ++j) {
            invertHessian[j] = normalizedHessian[j];
        }
    }

    private boolean boundValues(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) {
                return true;
            }
            if (values[i] < this._bounds[0][i]) {
                return true;
            }
            if (!(values[i] > this._bounds[1][i])) continue;
            return true;
        }
        return false;
    }

    private double[] getInitGuess() {
        double[] retval = new double[this._bounds[0].length];
        for (int j = 0; j < retval.length; ++j) {
            retval[j] = this._bounds[0][j] + (this._bounds[1][j] - this._bounds[0][j]) * 0.5;
        }
        return retval;
    }

    public static void main(String[] args) {
        EquationSolverMultiVariateNewton solver = new EquationSolverMultiVariateNewton(){

            @Override
            public double f(double[] x) {
                return 2.0 * (x[0] * x[0]) * (x[1] * x[1]) + x[0] * x[0] * x[1] - 2.0 * x[0] - x[1] * x[1];
            }
        };
        double[][] initPars = new double[][]{{1.0, -1.0}, {1.0, -1.0}};
        double[] newPars = solver.minimize(initPars, 1.0E-8, 25);
        solver.f(newPars);
        System.out.println("x:" + newPars[0] + ",y:" + newPars[1]);
    }
}

