/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.FunctionMinimizer;
import java.util.Arrays;
import java.util.Random;

public abstract class EquationSolverNelderMead
implements FunctionMinimizer {
    int _numPoints;
    int _numPars;
    int _maxIter = 1000;
    double _criteria = 1.0E-9;
    int _iter;
    double[][] _parameterVals;
    double _alpha = 1.0;
    double _gamma = 2.0;
    double _rho = -0.5;
    double _sigma = -0.5;
    private double[][] _bounds;
    private final long seed = 12345L;

    @Override
    public double[] minimize(double[][] bounds, double tolY, int maxIter) {
        this._criteria = tolY;
        this._maxIter = maxIter;
        this.init(bounds);
        while (this._iter < this._maxIter) {
            this.mutateSimplex();
            double[] evals = this.getEvaluations();
            Arrays.sort(evals);
            double diff = this.getRelativeAverageDiff();
            if (diff < this._criteria) break;
            ++this._iter;
        }
        return this._parameterVals[EquationSolverNelderMead.getBestIndex(this.getEvaluations())];
    }

    private double getRelativeAverageDiff() {
        double[] max = Arrays.copyOf(this._parameterVals[0], this._numPars);
        double[] min = Arrays.copyOf(this._parameterVals[0], this._numPars);
        for (int i = 1; i < this._numPoints; ++i) {
            for (int j = 0; j < this._numPars; ++j) {
                if (max[j] < this._parameterVals[i][j]) {
                    max[j] = this._parameterVals[i][j];
                    continue;
                }
                if (!(min[j] > this._parameterVals[i][j])) continue;
                min[j] = this._parameterVals[i][j];
            }
        }
        double aveDiff = 0.0;
        for (int j = 0; j < this._numPars; ++j) {
            aveDiff += Math.abs((max[j] - min[j]) / (max[j] * (double)this._numPars));
        }
        return aveDiff;
    }

    private void mutateSimplex() {
        double[] expanded;
        double expandedEval;
        double[] evals = this.getEvaluations();
        double[] sortedEvals = Arrays.copyOf(evals, evals.length);
        Arrays.sort(sortedEvals);
        int index = EquationSolverNelderMead.getWorstIndex(evals);
        double[] centroid = this.getCentroid(index);
        double[] reflected = this.reflect(index, centroid, this._alpha);
        double reflectedEval = this.f(reflected);
        if (sortedEvals[0] <= reflectedEval && reflectedEval < sortedEvals[this._numPoints - 1]) {
            this._parameterVals[index] = reflected;
            return;
        }
        if (reflectedEval < sortedEvals[0] && (expandedEval = this.f(expanded = this.reflect(index, centroid, this._gamma))) < sortedEvals[0]) {
            this._parameterVals[index] = expanded;
            return;
        }
        double[] contracted = this.reflect(index, centroid, this._rho);
        double contractedEval = this.f(contracted);
        if (contractedEval < sortedEvals[this._numPoints - 1]) {
            this._parameterVals[index] = contracted;
            return;
        }
        index = EquationSolverNelderMead.getBestIndex(evals);
        for (int i = 0; i < this._numPoints; ++i) {
            if (i == index) continue;
            double[] shrink = this.reflect(i, centroid, this._sigma);
            this._parameterVals[i] = shrink;
        }
    }

    private void init(double[][] bounds) {
        this._bounds = bounds;
        this._numPars = bounds[0].length;
        this._numPoints = this._numPars + 1;
        if (this._numPoints < 3) {
            this._numPoints = 3;
        }
        this._parameterVals = new double[this._numPoints][this._numPars];
        Random rnd = new Random(12345L);
        for (int i = 0; i < this._numPoints; ++i) {
            boolean init = true;
            while (init || this.boundValues(this._parameterVals[i])) {
                init = false;
                for (int j = 0; j < this._numPars; ++j) {
                    this._parameterVals[i][j] = bounds[0][j] + (bounds[1][j] - bounds[0][j]) * rnd.nextDouble();
                }
            }
        }
        this._iter = 0;
    }

    private double[] getEvaluations() {
        double[] evals = new double[this._numPoints];
        for (int i = 0; i < this._numPoints; ++i) {
            evals[i] = this.f(this._parameterVals[i]);
        }
        return evals;
    }

    private double[] getCentroid(int exclude) {
        double[] retval = new double[this._numPars];
        for (int i = 0; i < this._numPoints; ++i) {
            if (i == exclude) continue;
            for (int j = 0; j < this._numPars; ++j) {
                int n = j;
                retval[n] = retval[n] + this._parameterVals[i][j] / (double)(this._numPoints - 1);
            }
        }
        return retval;
    }

    private double[] reflect(int index, double[] centroid, double factor) {
        double[] retval = new double[this._numPars];
        boolean init = true;
        int j = 0;
        while (init || this.boundValues(retval)) {
            if (init) {
                init = false;
            } else {
                if (j >= 100) break;
                factor *= 0.8;
            }
            for (int i = 0; i < centroid.length; ++i) {
                retval[i] = centroid[i] + factor * (centroid[i] - this._parameterVals[index][i]);
            }
            ++j;
        }
        return retval;
    }

    private boolean boundValues(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] < this._bounds[0][i]) {
                return true;
            }
            if (values[i] > this._bounds[1][i]) {
                return true;
            }
            double eval = this.f(values);
            if (!Double.isNaN(eval) && !Double.isInfinite(eval)) continue;
            return true;
        }
        return false;
    }

    private static int getBestIndex(double[] array) {
        double minVal = array[0];
        int retval = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] < minVal)) continue;
            minVal = array[i];
            retval = i;
        }
        return retval;
    }

    private static int getWorstIndex(double[] array) {
        double maxVal = array[0];
        int retval = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > maxVal)) continue;
            maxVal = array[i];
            retval = i;
        }
        return retval;
    }

    public abstract double f(double[] var1);

    public static void main(String[] args) {
        EquationSolverNelderMead solver = new EquationSolverNelderMead(){

            @Override
            public double f(double[] pars) {
                double x = pars[0];
                double y = pars[1];
                return EquationSolverNelderMead.banana(x, y);
            }
        };
        double success = 0.0;
        for (int i = 0; i < 100000; ++i) {
            double[][] dArrayArray = new double[][]{{-3.0, -3.0}, {3.0, 3.0}};
            double[] result = solver.minimize(dArrayArray, 1.0E-6, 1000);
            if (Math.abs(result[0] - 1.0) < 0.001 && Math.abs(result[1] - 1.0) < 0.001) {
                success += 0.001;
            } else {
                System.out.println(solver._iter);
                System.out.println(solver.getEvaluations()[0] + "," + solver.getEvaluations()[1]);
                System.out.println(result[0] + " : " + result[1]);
            }
            System.out.println(i);
        }
        System.out.println("Success rate: " + success + "%");
    }

    private static final double banana(double x, double y) {
        return Math.pow(1.0 - x, 2.0) + 100.0 * Math.pow(y - Math.pow(x, 2.0), 2.0);
    }
}

