/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

public abstract class EquationSolverNewton {
    public static final double SMALL_DX = 1.0E-10;

    public abstract double f(double var1);

    public double dfdx(double x) {
        return (this.f(x + 1.0E-10) - this.f(x)) / 1.0E-10;
    }

    public double dfdx(double x, double dx) {
        return (this.f(x + dx) - this.f(x)) / dx;
    }

    public final double newton(double y, double xGuess, double tolY, int maxIter, double dx) {
        double x = xGuess;
        double testY = this.f(x) - y;
        for (int i = 0; i < maxIter; ++i) {
            double dfdx = this.dfdx(x, dx);
            if (Double.MIN_VALUE > Math.abs(dfdx)) {
                return x;
            }
            if (!(Math.abs(testY = this.f(x -= testY / dfdx) - y) <= tolY)) continue;
            return x;
        }
        return Double.NaN;
    }

    public final double newton(double y, double xGuess, double tolY, int maxIter) {
        double x = xGuess;
        double testY = this.f(xGuess) - y;
        for (int i = 0; i < maxIter; ++i) {
            double dfdx = this.dfdx(x);
            if (Double.MIN_VALUE > Math.abs(dfdx)) {
                return x;
            }
            if (!(Math.abs(testY = this.f(x -= testY / dfdx) - y) <= tolY)) continue;
            return x;
        }
        return Double.NaN;
    }
}

