/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

public abstract class EquationSolverNewtonBiSearch {
    private static final double DX = 1.0E-10;

    public abstract double f(double var1);

    public double dfdx(double x) {
        return (this.f(x + 1.0E-10) - this.f(x)) / 1.0E-10;
    }

    public final double newtonBiSearch(double y, double xMin, double xMax, double tolX, int maxIter) {
        double dxold;
        double xh;
        double xl;
        double fl = this.f(xMin) - y;
        double fh = this.f(xMax) - y;
        if (fl == 0.0) {
            return xMin;
        }
        if (fh == 0.0) {
            return xMax;
        }
        if (fl < 0.0) {
            xl = xMin;
            xh = xMax;
        } else {
            xh = xMin;
            xl = xMax;
        }
        double rtsOld = xl;
        double rts = 0.5 * (xMin + xMax);
        double dx = dxold = Math.abs(xMax - xMin);
        double frts = this.f(rts) - y;
        double dfrts = this.dfdx(rts);
        for (int j = 1; j <= maxIter; ++j) {
            if (((rts - xh) * dfrts - frts) * ((rts - xl) * dfrts - frts) > 0.0 || Math.abs(2.0 * frts) > Math.abs(dxold * dfrts)) {
                dxold = dx;
                dx = 0.5 * (xh - xl);
                rts = xl + dx;
                if (xl == rts || rts == rtsOld) {
                    return rts;
                }
            } else {
                dxold = dx;
                double temp = rts;
                dx = frts / dfrts;
                if (temp == (rts -= dx)) {
                    return rts;
                }
            }
            rtsOld = rts;
            if (Math.abs(dx) < tolX) {
                return rts;
            }
            frts = this.f(rts) - y;
            dfrts = this.dfdx(rts);
            if (frts < 0.0) {
                xl = rts;
                continue;
            }
            xh = rts;
        }
        return Double.NaN;
    }

    public static void main(String[] args) {
        EquationSolverNewtonBiSearch solver = new EquationSolverNewtonBiSearch(){

            @Override
            public double f(double x) {
                return x * Math.exp(-x * x);
            }

            @Override
            public double dfdx(double x) {
                return (1.0 - 2.0 * x * x) * Math.exp(-x * x);
            }
        };
        double x = solver.newtonBiSearch(0.0, -5.0, 1.0, 1.0E-8, 100);
        System.out.println("X = " + x);
    }
}

