/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.StandardNormalDistribution;
import hec.statistics.Traingular;
import hec.statistics.Uniform;
import java.io.BufferedWriter;

public class ErrorBound {
    public static int compute(int idebug, int itype, int np, int kp, double stlev, double tstdup, double tstdlw, double[] x, double[] txerru, double[] txerrl, double[] xboth, double[] xratio, double[] xlim1, double[] xlim2, double[] xlim3, double[] xlim4) {
        int i;
        int i2;
        double[] xerry = new double[np];
        double[] xerrl = new double[np];
        double[] xerru = new double[np];
        double tol = 1.0E-4;
        int ierr = 0;
        BufferedWriter ip = null;
        if (np > kp) {
            ierr = 1;
            return ierr;
        }
        if (itype == 0) {
            return ierr;
        }
        if (itype > 4) {
            double stdup = tstdup;
            double stdlw = tstdlw;
            if (itype == 7) {
                stdup = tstdup - stlev;
                if (stdup < 0.0) {
                    stdup = 0.0;
                }
                stdlw = stlev - tstdlw;
                if (tstdlw - stlev > 0.0) {
                    stdlw = 0.0;
                }
            }
            if ((ierr = ErrorBound.raterr(ip, idebug, np, kp, stlev, stdup, stdlw, x, xerru, xerrl)) > 0) {
                return ierr;
            }
        }
        if (itype == 3 || itype == 7) {
            for (i2 = 0; i2 < np; ++i2) {
                if (itype == 3) {
                    xerru[i2] = txerru[i2] - x[i2];
                    if (xerru[i2] < 0.0) {
                        xerru[i2] = 0.0;
                    }
                    xerrl[i2] = x[i2] - txerrl[i2];
                    if (txerrl[i2] - x[i2] > 0.0) {
                        xerrl[i2] = 0.0;
                    }
                }
                xboth[i2] = xerru[i2] + xerrl[i2];
                xratio[i2] = 0.0;
                if (!(xboth[i2] > 0.0)) continue;
                xratio[i2] = xerrl[i2] / xboth[i2];
            }
        } else if (itype <= 2) {
            for (i2 = 0; i2 < np; ++i2) {
                xerru[i2] = txerru[i2];
                xerrl[i2] = txerrl[i2];
            }
        }
        double[] climit = new double[4];
        if (itype == 1 || itype == 5) {
            climit[0] = 0.97725;
            climit[1] = 0.8413;
            climit[2] = 0.1587;
            climit[3] = 0.02275;
        } else if (itype == 2 || itype == 6) {
            climit[0] = 0.97725;
            climit[1] = 0.8413;
            climit[2] = 0.1587;
            climit[3] = 0.02275;
        } else {
            climit[0] = 0.95;
            climit[1] = 0.75;
            climit[2] = 0.25;
            climit[3] = 0.05;
        }
        if (itype == 2 || itype == 6) {
            for (i = 0; i < np; ++i) {
                if (x[i] <= 0.0) {
                    ierr = 1;
                    return ierr;
                }
                x[i] = Math.log10(x[i]);
            }
        }
        ErrorBound.errcrv(ip, itype, np, kp, climit[0], x, xerru, xerrl, xboth, xratio, xlim1);
        ErrorBound.errcrv(ip, itype, np, kp, climit[1], x, xerru, xerrl, xboth, xratio, xlim2);
        ErrorBound.errcrv(ip, itype, np, kp, climit[2], x, xerru, xerrl, xboth, xratio, xlim3);
        ErrorBound.errcrv(ip, itype, np, kp, climit[3], x, xerru, xerrl, xboth, xratio, xlim4);
        if (itype == 2 || itype == 6) {
            for (i = 0; i < np; ++i) {
                x[i] = Math.pow(10.0, x[i]);
                xlim1[i] = Math.pow(10.0, xlim1[i]);
                xlim2[i] = Math.pow(10.0, xlim2[i]);
                xlim3[i] = Math.pow(10.0, xlim3[i]);
                xlim4[i] = Math.pow(10.0, xlim4[i]);
            }
        }
        if (itype > 4) {
            for (i = 0; i < np; ++i) {
                txerru[i] = xerru[i];
                txerrl[i] = xerrl[i];
            }
        }
        return ierr;
    }

    public static void errcrv(BufferedWriter ip, int itype, int np, int kp, double climit, double[] x, double[] xerru, double[] xerrl, double[] xboth, double[] xratio, double[] xlim) {
        if (itype == 0) {
            for (int i = 0; i < np; ++i) {
                xlim[i] = x[i];
            }
        }
        if (itype == 1 || itype == 5) {
            double xk = StandardNormalDistribution.getDeviate(climit);
            for (int i = 0; i < np; ++i) {
                xlim[i] = x[i] + xerru[i] * xk;
                if (!(xlim[i] <= x[0])) continue;
                xlim[i] = x[0];
            }
        } else if (itype == 2 || itype == 6) {
            double xk = StandardNormalDistribution.getDeviate(climit);
            for (int i = 0; i < np; ++i) {
                xlim[i] = x[i] + xerru[i] * xk;
            }
        } else if (itype == 3 || itype == 7) {
            Traingular.compute(np, kp, climit, x, xerrl, xerru, xboth, xratio, xlim);
        } else if (itype == 4 || itype == 8) {
            Uniform.compute(np, kp, climit, x, xerru, xlim);
        }
    }

    private static int raterr(BufferedWriter ip, int idebug, int nrat, int krat, double stlev, double stdup, double stdlw, double[] srat, double[] serrup, double[] serrlw) {
        int i;
        int ierr = 0;
        if (stlev <= srat[0]) {
            ierr = 1;
            return ierr;
        }
        int j = 0;
        boolean loopBroken = false;
        for (int i2 = 1; i2 < nrat; ++i2) {
            j = i2;
            if (!(srat[i2] > stlev)) continue;
            loopBroken = true;
            break;
        }
        if (!loopBroken) {
            j = nrat;
            if (Math.abs(stlev - srat[nrat - 1]) > 0.001) {
                ierr = 1;
                return ierr;
            }
        }
        double stdif = stlev - srat[0];
        serrup[0] = 0.0;
        serrlw[0] = 0.0;
        for (i = 1; i < j; ++i) {
            double c = (srat[i] - srat[0]) / stdif;
            serrup[i] = c * stdup;
            serrlw[i] = c * stdlw;
        }
        for (i = j; i < nrat; ++i) {
            serrup[i] = stdup;
            serrlw[i] = stdlw;
        }
        if (idebug > 0) {
            // empty if block
        }
        return ierr;
    }

    public static void main(String[] args) {
        double[] xvalues = new double[]{10.0, 50.0};
        double[] yvalues = new double[]{20.0, 60.0};
        double[] xerrl = new double[]{30.0, 70.0};
        double[] xerru = new double[]{40.0, 80.0};
        int numPts = xvalues.length;
        double[] xboth = new double[numPts];
        double[] xratio = new double[numPts];
        double[] xlim1 = new double[numPts];
        double[] xlim2 = new double[numPts];
        double[] xlim3 = new double[numPts];
        double[] xlim4 = new double[numPts];
        ErrorBound.compute(0, 3, numPts, numPts, 0.0, 0.0, 0.0, yvalues, xerru, xerrl, xboth, xratio, xlim1, xlim2, xlim3, xlim4);
        System.out.println("");
    }
}

