/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class ExponentialDist
extends AbstractContDist {
    protected static final double MIN_SCALE = 1.0E-5;
    private double _scale;

    public ExponentialDist() {
        this(1.0);
    }

    public ExponentialDist(double scale) {
        this.setScale(scale);
    }

    public ExponentialDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public ExponentialDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (pm.getMean() < 1.0E-5) {
            this.setScale(Double.NaN);
            return false;
        }
        this.setScale(pm.getMean());
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        if (lm.getL1() < 1.0E-5) {
            this.setScale(Double.NaN);
            return false;
        }
        this.setScale(lm.getL1());
        return true;
    }

    public void setScale(double scale) {
        if (scale <= 1.0E-5) {
            scale = 1.0E-5;
        }
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    @Override
    public String getType() {
        return "Exponential";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Scale"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getScale()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setScale(vals[0]);
    }

    @Override
    public Object clone() {
        ExponentialDist clonedDist = (ExponentialDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("ExponentialDistEnd")) {
                    return;
                }
                if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read ExponentialDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "ExponentialDistBegin");
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "ExponentialDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        return Math.exp(-value / this.getScale()) / this.getScale();
    }

    @Override
    public double getCDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-value / this.getScale());
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return -Math.log(1.0 - p) * this.getScale();
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        this._scale = 0.0;
        for (int i = 0; i < ml.getSample().length; ++i) {
            this._scale += ml.getSample()[i] / (double)ml.getSample().length;
        }
        return true;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double summation = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            summation += sample[i];
        }
        return (double)sample.length * Math.log(1.0 / this.getScale()) - 1.0 / this.getScale() * summation;
    }
}

