/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverNewton;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class GammaDist
extends AbstractContDist {
    protected static final double MIN_SHAPE = 1.0E-5;
    protected static final double MIN_SCALE = 1.0E-5;
    private double _shape;
    private double _scale;

    public GammaDist() {
        this(2.0, 1.0);
    }

    public GammaDist(double shape, double scale) {
        this.setShape(shape);
        this.setScale(scale);
    }

    public GammaDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public GammaDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        double var = pm.getStDv() * pm.getStDv();
        double shape = pm.getMean() * pm.getMean() / var;
        double scale = var / pm.getMean();
        if (shape < 1.0E-5 || scale < 1.0E-5) {
            this.setShape(Double.NaN);
            this.setScale(Double.NaN);
            return false;
        }
        this.setShape(shape);
        this.setScale(scale);
        return !Double.isNaN(shape);
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        if (lm.getL1() <= 1.0E-5 || lm.getL2() <= 1.0E-5 || lm.getL2() / lm.getL1() > 0.99999) {
            this.setShape(Double.NaN);
            this.setScale(Double.NaN);
            return false;
        }
        EquationSolverNewton solverShapeL = new EquationSolverNewton(){
            private static final double LN4 = 1.3862943611198906;

            @Override
            public double f(double x) {
                if (x == 0.0) {
                    return 0.0;
                }
                double lnf = SpecialFunctions.logGamma(2.0 / x + 1.0) - 1.0 / x * 1.3862943611198906 - 2.0 * SpecialFunctions.logGamma(1.0 / x + 1.0);
                return Math.exp(lnf);
            }
        };
        double shapeInv = solverShapeL.newton(lm.getL2() / lm.getL1(), 0.0, 1.0E-10, 100, 1.0E-10);
        this.setShape(1.0 / shapeInv);
        this.setScale(lm.getL1() / this.getShape());
        return !Double.isNaN(shapeInv);
    }

    public void setShape(double shape) {
        if (shape <= 1.0E-5) {
            shape = 1.0E-5;
        }
        this._shape = shape;
    }

    public double getShape() {
        return this._shape;
    }

    public void setScale(double scale) {
        if (scale <= 1.0E-5) {
            scale = 1.0E-5;
        }
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    @Override
    public String getType() {
        return "Gamma";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Shape", "Scale"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getShape(), this.getScale()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setShape(vals[0]);
        this.setScale(vals[1]);
    }

    @Override
    public Object clone() {
        GammaDist clonedDist = (GammaDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("GammaDistEnd")) {
                    return;
                }
                if (type.equals("Shape")) {
                    this.setShape(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read GammaDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "GammaDistBegin");
        TextFile.writeLine(writer, "Shape:" + this.getShape());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "GammaDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        return Math.exp(-value / this._scale + (this._shape - 1.0) * Math.log(value) - this._shape * Math.log(this._scale) - SpecialFunctions.logGamma(this._shape));
    }

    @Override
    public double getCDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        if (value >= Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return SpecialFunctions.regIncompleteGamma(this._shape, value / this._scale);
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double xMin = 0.0;
        double xMax = 1.0;
        for (int j = 0; j < 100; ++j) {
            double pMax = this.getCDF(xMax);
            if (pMax > p) {
                return this.invCDFNewtonBiSearch(p, xMin, xMax, 1.0E-12, 100);
            }
            xMax *= 2.0;
        }
        return Double.NaN;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double sumLog = 0.0;
        double sumX = 0.0;
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            sumLog += Math.log(sample[i]);
            sumX += sample[i];
        }
        return (this.getShape() - 1.0) * sumLog - (double)n * Math.log(SpecialFunctions.gamma(this.getShape())) - (double)n * this.getShape() * Math.log(this.getScale()) - sumX / this.getScale();
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        int iter;
        double mean = this.getMean(ml.getSample());
        double logMean = Math.log(mean);
        double meanLog = this.getMeanLog(ml.getSample());
        double shape = 1.0E-8;
        double shapeNew = 0.5 / (logMean * meanLog);
        for (iter = 0; iter < 100 && Math.abs(shapeNew - shape) > 1.0E-5 && NumericalConstants.isValidValue((double)shapeNew); ++iter) {
            if (shapeNew > 0.0) {
                shape = shapeNew;
            }
            shapeNew = 1.0 / (1.0 / shape + (meanLog - logMean + Math.log(shape) - SpecialFunctions.digamma(shape)) / (shape * shape * (1.0 / shape - SpecialFunctions.trigamma(shape))));
        }
        if (NumericalConstants.isValidValue((double)shapeNew) && iter < 100) {
            this.setShape(shapeNew);
            this.setScale(mean / this.getShape());
            return true;
        }
        this.setShape(Double.NaN);
        this.setScale(Double.NaN);
        return false;
    }

    private double getMean(double[] sample) {
        double retval = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            retval += sample[i];
        }
        return retval / (double)sample.length;
    }

    private double getMeanLog(double[] sample) {
        double retval = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            retval += Math.log(sample[i]);
        }
        return retval / (double)sample.length;
    }

    public static void main(String[] args) {
        GammaDist g = new GammaDist(9.0, 0.5);
        System.out.println(g.invCDF(0.0) + "," + g.invCDF(0.5) + "," + g.invCDF(0.999) + "," + g.invCDF(1.0));
        g = new GammaDist(1.0, 2.0);
        System.out.println(g.invCDF(0.0) + "," + g.invCDF(0.5) + "," + g.invCDF(0.999) + "," + g.invCDF(1.0));
    }
}

