/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverBiSearch;
import hec.statistics.LinearMoments;
import hec.statistics.LogisticDist;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Random;

public class GenLogisticDist
extends AbstractContDist {
    private static final double MIN_SCALE = 1.0E-5;
    private double _loctn;
    private double _scale;
    private double _shape;

    public GenLogisticDist() {
        this(0.0, 1.0, 0.0);
    }

    public GenLogisticDist(double loctn, double scale, double shape) {
        this.setLoctn(loctn);
        this.setScale(scale);
        this.setShape(shape);
    }

    public GenLogisticDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public GenLogisticDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (Math.abs(pm.getSkew()) >= 0.33333) {
            this.setLoctn(Double.NaN);
            this.setScale(Double.NaN);
            this.setShape(Double.NaN);
            return false;
        }
        EquationSolverBiSearch solverShapeP = new EquationSolverBiSearch(){

            @Override
            public double f(double x) {
                if (x == 0.0) {
                    return 0.0;
                }
                double pix = Math.PI * x;
                double termA1 = pix / Math.sin(pix);
                double termA2 = 2.0 * pix / Math.sin(2.0 * pix);
                double termA3 = 3.0 * pix / Math.sin(3.0 * pix);
                return Math.signum(x) * (1.0 - 3.0 * termA1 + 3.0 * termA2 - termA3) / Math.pow(1.0 - 2.0 * termA1 + termA2, 1.5);
            }
        };
        this.setShape(solverShapeP.biSearch(pm.getSkew(), -0.33333, 0.33333, 1.0E-10));
        if (this.getShape() == 0.0) {
            this.setScale(Math.sqrt(3.0) * pm.getStDv() / Math.PI);
            this.setLoctn(pm.getMean());
            return true;
        }
        double pix = Math.PI * this.getShape();
        double termA1 = pix / Math.sin(pix);
        double termA2 = 2.0 * pix / Math.sin(2.0 * pix);
        this.setScale(pm.getStDv() * Math.abs(this.getShape()) / Math.sqrt(1.0 - 2.0 * termA1 + termA2));
        this.setLoctn(pm.getMean() - this.getScale() / this.getShape() * (1.0 - termA1));
        return !Double.isNaN(this.getShape());
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setShape(-lm.getT3());
        if (Math.abs(this.getShape()) < 1.0E-5) {
            this.setScale(lm.getL2());
            this.setLoctn(lm.getL1());
            return true;
        }
        double term = Math.PI * this.getShape();
        this.setScale(lm.getL2() * Math.sin(term) / term);
        this.setLoctn(lm.getL1() - (this.getScale() - lm.getL2()) / this.getShape());
        return !Double.isNaN(this.getShape());
    }

    public void setLoctn(double loctn) {
        this._loctn = loctn;
    }

    public double getLoctn() {
        return this._loctn;
    }

    public void setScale(double scale) {
        if (scale <= 1.0E-5) {
            scale = 1.0E-5;
        }
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    public void setShape(double shape) {
        this._shape = shape;
    }

    public double getShape() {
        return this._shape;
    }

    @Override
    public String getType() {
        return "GenLogistic";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Loctn", "Scale", "Shape"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getLoctn(), this.getScale(), this.getShape()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setLoctn(vals[0]);
        this.setScale(vals[1]);
        this.setShape(vals[2]);
    }

    @Override
    public Object clone() {
        GenLogisticDist clonedDist = (GenLogisticDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("GenLogisticDistEnd")) {
                    return;
                }
                if (type.equals("Loctn")) {
                    this.setLoctn(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                } else if (type.equals("Shape")) {
                    this.setShape(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read GenLogisticDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "GenLogisticDistBegin");
        TextFile.writeLine(writer, "Loctn:" + this.getLoctn());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "Shape:" + this.getShape());
        TextFile.writeLine(writer, "GenLogisticDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this._shape < 0.0 && value <= this._loctn + this._scale / this._shape) {
            return 0.0;
        }
        if (this._shape > 0.0 && value >= this._loctn + this._scale / this._shape) {
            return 0.0;
        }
        double tx = SpecialFunctions.t(this._loctn, this._scale, this._shape, value);
        return Math.pow(tx, 1.0 - this._shape) / (this._scale * (1.0 + tx) * (1.0 + tx));
    }

    @Override
    public double getCDF(double value) {
        if (this._shape < 0.0 && value <= this._loctn + this._scale / this._shape) {
            return 0.0;
        }
        if (this._shape > 0.0 && value >= this._loctn + this._scale / this._shape) {
            return 1.0;
        }
        return 1.0 / (1.0 + SpecialFunctions.t(this._loctn, this._scale, this._shape, value));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return this._shape < 0.0 ? this._loctn + this._scale / this._shape : Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return this._shape > 0.0 ? this._loctn + this._scale / this._shape : Double.POSITIVE_INFINITY;
        }
        return SpecialFunctions.tInv(this._loctn, this._scale, this._shape, 1.0 / p - 1.0);
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        if (this.getShape() == 0.0) {
            return LogisticDist.getLogisticDistributionLikelihood(sample, this.getLoctn(), this.getScale());
        }
        int n = sample.length;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double tx = 1.0 - this._shape * (sample[i] - this._loctn) / this._scale;
            sum1 += Math.log(tx);
            sum2 += Math.log(1.0 + Math.pow(tx, 1.0 / this._shape));
        }
        return (1.0 / this.getShape() - 1.0) * sum1 - (double)n * Math.log(this.getScale()) - 2.0 * sum2;
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        double[] retval = new double[3];
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        double sum5 = 0.0;
        double sum6 = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            double diff = sample[i] - this.getLoctn();
            double one = 1.0 - this.getShape() * diff / this.getScale();
            double oneExp = Math.pow(one, 1.0 / this.getShape());
            double oneExp2 = Math.pow(one, 1.0 / this.getShape() - 1.0);
            sum1 += 1.0 / one;
            double expFrac = oneExp2 / (oneExp + 1.0);
            sum2 += expFrac;
            sum3 += diff / one;
            sum4 += diff * expFrac;
            sum5 += oneExp / (oneExp + 1.0) * (-Math.log(one) / (this.getShape() * this.getShape()) - diff / (this.getScale() * this.getShape() * one));
            sum6 += -Math.log(one) / (this.getShape() * this.getShape()) - diff * (1.0 / this.getShape() - 1.0) / (this.getScale() * one);
        }
        double firstConst = 1.0 / this.getShape() - 1.0;
        retval[0] = firstConst * (this.getShape() / this.getScale()) * sum1 - 2.0 / this.getScale() * sum2;
        retval[1] = firstConst * (this.getShape() / (this.getScale() * this.getScale())) * sum3 - (double)sample.length / this.getScale() - 2.0 / (this.getScale() * this.getScale()) * sum4;
        retval[2] = sum6 - 2.0 * sum5;
        return retval;
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        double dmdm1 = 0.0;
        double dmdm2 = 0.0;
        double dmdm = 0.0;
        double dmds = 0.0;
        double dmdk = 0.0;
        double dsds = 0.0;
        double dsdk = 0.0;
        double dkdk = 0.0;
        double k2 = this.getShape() * this.getShape();
        double s2 = this.getScale() * this.getScale();
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            double diff = sample[i] - this.getLoctn();
            double one = 1.0 - this.getShape() * diff / this.getScale();
            double oneExp = Math.pow(one, 1.0 / this.getShape());
            double oneExp2 = Math.pow(one, 1.0 / this.getShape() - 1.0);
            double oneExpPlus1Squared = (oneExp + 1.0) * (oneExp + 1.0);
            double other = this.getShape() * diff - this.getScale();
            double other2 = other * other;
            double expFrac = oneExp / (oneExp + 1.0);
            double diffExpFrac = oneExp * (-other * Math.log(-other / this.getScale()) - diff * this.getShape() * (this.getShape() * (oneExp + 1.0) - 1.0)) / (this.getShape() * this.getShape() * other2 * oneExpPlus1Squared);
            dmdm1 += 1.0 / other2;
            dmdm2 += (this.getShape() * oneExp + this.getShape() - 1.0) * oneExp / (oneExpPlus1Squared * other2);
            dmds += oneExp * (this.getScale() * (oneExp + 1.0) - diff) / (oneExpPlus1Squared * this.getScale() * other2);
            dmdk += -(diff - this.getScale()) / other2 - 2.0 * diffExpFrac;
            dsds += (this.getShape() - 1.0) / (this.getScale() * this.getScale()) * diff * (this.getShape() * diff - 2.0 * this.getScale()) / other2 + 2.0 / (this.getScale() * this.getScale()) * diff * oneExp * (oneExp * (this.getShape() * diff - 2.0 * this.getScale()) - 2.0 * this.getScale() + (this.getShape() + 1.0) * diff) / (other2 * oneExpPlus1Squared);
            dsdk += -2.0 * diff * oneExp * (-other * Math.log(-other / this.getScale()) - diff * this.getShape() * (this.getShape() * (oneExp + 1.0) - 1.0)) / (this.getScale() * this.getShape() * this.getShape() * other2 * oneExpPlus1Squared) - diff * (diff - this.getScale()) / (this.getScale() * other2);
            double dexpFrac = -oneExp * (other * Math.log(one) - diff * this.getShape()) / (k2 * other * oneExpPlus1Squared);
            double dlnOneOther = diff / (this.getScale() * this.getScale() * other);
            double dDiff2OverSOther2 = diff * (2.0 * diff * this.getShape() - this.getScale()) / (k2 * (diff * this.getShape() - this.getScale()) * (diff * this.getShape() - this.getScale()));
            dkdk += 2.0 * (dexpFrac * Math.log(one) / s2 + expFrac * dlnOneOther) + 2.0 * (dexpFrac * diff / (this.getShape() * this.getScale() * one) + expFrac * dDiff2OverSOther2) - dlnOneOther + -diff * (k2 * -diff + 2.0 * diff * this.getShape() - this.getScale()) / (k2 * other2);
        }
        dmdm = -dmdm1 * (this.getShape() - 1.0) * this.getShape() - 2.0 * dmdm2;
        dmds *= -2.0;
        return new double[]{dmdm, dmds += -dmdm1 * (this.getShape() - 1.0), dmdk, dmds, dsds += (double)(-n) / (this.getScale() * this.getScale()), dsdk, dmdk, dsdk, dkdk};
    }

    @Override
    public double[][] getParamBounds(double[] data) {
        this.fitSampleData(data, AbstractContDist.FittingMethod.LinearMoments);
        double[] paramVals = this.getParamVals();
        double[][] retval = new double[2][this.getParamVals().length];
        for (int i = 0; i < paramVals.length; ++i) {
            retval[0][i] = paramVals[i] - Math.abs(paramVals[i]) * 0.2;
            retval[1][i] = paramVals[i] + Math.abs(paramVals[i]) * 0.2;
        }
        return retval;
    }

    public static void main(String[] args) {
        GenLogisticDist dist = new GenLogisticDist(2.0, 1.5, 0.55);
        double[] sample = new double[100000];
        long seed = 12345L;
        Random rnd = new Random(seed);
        for (int i = 0; i < sample.length; ++i) {
            sample[i] = dist.invCDF(rnd.nextDouble());
        }
        dist.fitSampleData(new MaximumLikelihood(sample, MaximumLikelihood.MinimizationMethod.NEWTON));
        dist.getParamVals();
    }
}

