/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class GenParetoDist
extends AbstractContDist {
    private static final double MIN_SCALE = 1.0E-5;
    private double _loctn;
    private double _scale;
    private double _shape;

    public GenParetoDist() {
        this(0.0, 1.0, 0.0);
    }

    public GenParetoDist(double loctn, double scale, double shape) {
        this.setLoctn(loctn);
        this.setScale(scale);
        this.setShape(shape);
    }

    public GenParetoDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public GenParetoDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        double sk2 = pm.getSkew() * pm.getSkew();
        double sk4 = sk2 * sk2;
        double sk6 = sk4 * sk2;
        double a3 = 27.0 * sk6 + 180.0 * sk4 + 272.0 * sk2 - 64.0;
        double b3 = 64.0 * Math.sqrt(sk6 + 8.0 * sk4 + 16.0 * sk2);
        double norm = Math.sqrt(a3 * a3 + b3 * b3);
        double angle = Math.atan2(b3, a3);
        double a = Math.cbrt(norm) * Math.cos(angle / 3.0);
        double b = Math.cbrt(norm) * Math.sin(angle / 3.0);
        double shape = 0.125 * (3.0 * sk2 + 4.0 + Math.sqrt(3.0) * b - a);
        if (shape < -0.3333333333333333) {
            this.setLoctn(Double.NaN);
            this.setScale(Double.NaN);
            this.setShape(Double.NaN);
            return false;
        }
        this.setShape(shape);
        this.setScale(pm.getStDv() * (1.0 + shape) * Math.sqrt(1.0 + 2.0 * shape));
        this.setLoctn(pm.getMean() - this.getScale() / (1.0 + shape));
        return !Double.isNaN(shape);
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setShape((1.0 - 3.0 * lm.getT3()) / (1.0 + lm.getT3()));
        this.setScale((1.0 + this.getShape()) * (2.0 + this.getShape()) * lm.getL2());
        this.setLoctn(lm.getL1() - this.getScale() / (1.0 + this.getShape()));
        return true;
    }

    public void setLoctn(double loctn) {
        this._loctn = loctn;
    }

    public double getLoctn() {
        return this._loctn;
    }

    public void setScale(double scale) {
        if (scale <= 1.0E-5) {
            scale = 1.0E-5;
        }
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    public void setShape(double shape) {
        this._shape = shape;
    }

    public double getShape() {
        return this._shape;
    }

    @Override
    public String getType() {
        return "GenPareto";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Loctn", "Scale", "Shape"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getLoctn(), this.getScale(), this.getShape()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setLoctn(vals[0]);
        this.setScale(vals[1]);
        this.setShape(vals[2]);
    }

    @Override
    public Object clone() {
        GenParetoDist clonedDist = (GenParetoDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("GenParetoDistEnd")) {
                    return;
                }
                if (type.equals("Loctn")) {
                    this.setLoctn(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                } else if (type.equals("Shape")) {
                    this.setShape(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read GenParetoDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "GenParetoDistBegin");
        TextFile.writeLine(writer, "Locatn:" + this.getLoctn());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "Shape:" + this.getShape());
        TextFile.writeLine(writer, "GenParetoDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (value <= this._loctn) {
            return 0.0;
        }
        if (this._shape > 0.0 && value >= this._loctn + this._scale / this._shape) {
            return 0.0;
        }
        return Math.pow(SpecialFunctions.t(this._loctn, this._scale, this._shape, value), 1.0 - this._shape) / this._scale;
    }

    @Override
    public double getCDF(double value) {
        if (value <= this._loctn) {
            return 0.0;
        }
        if (this._shape > 0.0 && value >= this._loctn + this._scale / this._shape) {
            return 1.0;
        }
        return 1.0 - SpecialFunctions.t(this._loctn, this._scale, this._shape, value);
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return this._loctn;
        }
        if (p >= 1.0) {
            return this._shape > 0.0 ? this._loctn + this._scale / this._shape : Double.POSITIVE_INFINITY;
        }
        return SpecialFunctions.tInv(this._loctn, this._scale, this._shape, 1.0 - p);
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        int n = sample.length;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double diff = sample[i] - this.getLoctn();
            if (diff <= 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            sum += Math.log(1.0 - this.getShape() * diff / this.getScale());
        }
        return (double)n * Math.log(1.0 / this.getScale()) + (1.0 / this.getShape() - 1.0) * sum;
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        double dm = 0.0;
        double ds = 0.0;
        double dk1 = 0.0;
        double dk2 = 0.0;
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            double diff = sample[i] - this.getLoctn();
            double kdiff = diff * this.getShape();
            double other = kdiff - this.getScale();
            dm += (this.getShape() - 1.0) / other;
            ds += diff / other;
            dk1 += Math.log(1.0 - this.getShape() * diff / this.getScale());
            dk2 += diff / other;
        }
        ds *= -(1.0 - this.getShape()) / this.getScale();
        double dk = -1.0 / (this.getShape() * this.getShape()) * dk1 + (1.0 / this.getShape() - 1.0) * dk2;
        return new double[]{dm, ds += (double)(-n) / this.getScale(), dk};
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        int n = sample.length;
        double dmdm = 0.0;
        double dmds = 0.0;
        double dmdk = 0.0;
        double dsdm = 0.0;
        double dsds = 0.0;
        double dsdk = 0.0;
        double dkdm = 0.0;
        double dkds = 0.0;
        double dkdk = 0.0;
        double k2 = this.getShape() * this.getShape();
        for (int i = 0; i < n; ++i) {
            double diff = sample[i] - this.getLoctn();
            double kdiff = this.getShape() * diff;
            double other = kdiff - this.getScale();
            double other2 = other * other;
            dmdm += (this.getShape() - k2) / other2;
            dmds += (1.0 - this.getShape()) / other2;
            dmdk += -(diff - this.getScale()) / other2;
            dsds += diff * (this.getShape() * diff - 2.0 * this.getScale()) / other2;
            dsdk += diff * (diff - this.getScale()) / other2;
            dkdk += -2.0 * Math.log(-other / this.getScale()) / (k2 * this.getShape()) + 2.0 * diff / (k2 * other) + diff * diff * (1.0 / this.getShape() - 1.0) / other2;
        }
        dsdm = dmds;
        dsds *= (this.getShape() - 1.0) / (this.getScale() * this.getScale());
        dkdm = dmdk;
        dkds = dsdk *= -1.0 / this.getScale();
        return new double[]{dmdm, dmds, dmdk, dsdm, dsds += (double)(-n) / (this.getScale() * this.getScale()), dsdk, dkdm, dkds, dkdk};
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        double[] sample = ml.getSample();
        double minVal = Double.MAX_VALUE;
        double maxVal = -1.7976931348623157E308;
        double mean = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            if (sample[i] < minVal) {
                minVal = sample[i];
            }
            if (sample[i] > maxVal) {
                maxVal = sample[i];
            }
            mean += sample[i];
        }
        mean /= (double)sample.length;
        double loc = minVal - Math.abs(minVal) * 1.0E-16;
        if (minVal == 0.0) {
            loc = -1.0E-16;
        }
        int i = 16;
        while (Math.abs(minVal - loc) == 0.0) {
            loc = minVal - Math.abs(minVal) * Math.pow(10.0, -i);
            --i;
        }
        this.fitWithLoc(loc, mean, maxVal, sample);
        double ll = this.getLogLikelihood(sample);
        double[] baseParVals = this.getParamVals();
        this.fitSampleData(new LinearMoments(ml.getSample()));
        this.fitWithLoc(loc, Double.NaN, maxVal, sample);
        double[] lParVals = this.getParamVals();
        double ll2 = this.getLogLikelihood(sample);
        this.fitSampleData(new ProductMoments(ml.getSample()));
        this.fitWithLoc(loc, Double.NaN, maxVal, sample);
        double[] pParVals = this.getParamVals();
        double ll3 = this.getLogLikelihood(sample);
        if (Double.isNaN(ll) && Double.isNaN(ll2) && Double.isNaN(ll3)) {
            this.setLoctn(Double.NaN);
            this.setScale(Double.NaN);
            this.setShape(Double.NaN);
            return false;
        }
        if (!Double.isNaN(ll) && ll > ll2 && ll > ll3) {
            this.setParamVals(baseParVals);
        } else if (!Double.isNaN(ll2) && ll2 > ll3) {
            this.setParamVals(lParVals);
        } else {
            this.setParamVals(pParVals);
        }
        return true;
    }

    private void fitWithLoc(double loc, double mean, double maxVal, double[] sample) {
        this.setLoctn(loc);
        if (!Double.isNaN(mean)) {
            this.setScale(mean - loc);
            double meanL = 0.0;
            for (int i = 0; i < sample.length; ++i) {
                meanL += Math.log((sample[i] - loc) / this.getScale());
            }
            this.setShape(meanL /= (double)sample.length);
        }
        double ll = this.getLogLikelihood(sample);
        double newLL = Double.MAX_VALUE;
        for (int iter = 0; Math.abs(ll - newLL) > 1.0E-8 && iter < 500; ++iter) {
            ll = newLL;
            double s = 0.0;
            double k = 0.0;
            for (int i = 0; i < sample.length; ++i) {
                k += -Math.log(1.0 - this.getShape() * (sample[i] - this.getLoctn()) / this.getScale()) / (double)sample.length;
                s += (sample[i] - this.getLoctn()) / (1.0 - this.getShape() * (sample[i] - this.getLoctn()) / this.getScale());
            }
            s *= (1.0 - this.getShape()) / (double)sample.length;
            if (1.0 - k * (maxVal - this.getLoctn()) / this.getScale() <= 0.0) {
                k = this.getScale() / (maxVal - this.getLoctn()) - Math.abs(this.getScale() / (maxVal - this.getLoctn())) * 1.0E-4;
            }
            this.setShape(k);
            if (1.0 - this.getShape() * (maxVal - this.getLoctn()) / s <= 0.0) {
                s = this.getShape() * (maxVal - this.getLoctn()) + Math.abs(this.getShape() * (maxVal - this.getLoctn())) * 1.0E-4;
            }
            this.setScale(s);
            newLL = this.getLogLikelihood(sample);
        }
    }
}

