/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.GevDist;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class GevClipDist
extends GevDist
implements ClipDist {
    private ClipData _clip = new ClipData(){

        @Override
        public void setMinVal(double minVal) {
            super.setMinVal(minVal);
            super.setMinProb(GevClipDist.super.getCDF(minVal));
        }

        @Override
        public void setMinProb(double minProb) {
            super.setMinProb(minProb);
            GevDist gd = new GevDist(GevClipDist.this.getLoctn(), GevClipDist.this.getScale(), GevClipDist.this.getShape());
            super.setMinVal(gd.invCDF(minProb));
        }

        @Override
        public void setMaxVal(double maxVal) {
            super.setMaxVal(maxVal);
            super.setMaxProb(GevClipDist.super.getCDF(maxVal));
        }

        @Override
        public void setMaxProb(double maxProb) {
            super.setMaxProb(maxProb);
            GevDist gd = new GevDist(GevClipDist.this.getLoctn(), GevClipDist.this.getScale(), GevClipDist.this.getShape());
            super.setMaxVal(gd.invCDF(maxProb));
        }
    };
    static final int COMPUTE_FLAG = 0;

    public GevClipDist() {
    }

    public GevClipDist(double loctn, double scale, double shape) {
        super(loctn, scale, shape);
    }

    @Override
    public ClipData getClipData() {
        return this._clip;
    }

    @Override
    public String[] getClipParamNames() {
        if (this.getClipData() == null) {
            return new String[0];
        }
        return this.getClipData().getClipParamNames();
    }

    @Override
    public double[] getClipParamVals() {
        if (this.getClipData() == null) {
            return new double[0];
        }
        return this.getClipData().getClipParamVals();
    }

    @Override
    public String getSummaryClip(String format) {
        if (this.getClipData() == null) {
            return "";
        }
        return this.getClipData().getSummary(format);
    }

    @Override
    public Object clone() {
        GevClipDist clonedDist = (GevClipDist)super.clone();
        clonedDist._clip = (ClipData)this._clip.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("GevClipDistEnd")) {
                    return;
                }
                if (type.equals("Loctn")) {
                    this.setLoctn(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                } else if (type.equals("Shape")) {
                    this.setShape(Double.parseDouble(param));
                } else if (type.equals("ClipDataBegin")) {
                    this._clip.read(reader);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read GevClipDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "GevClipDistBegin");
        TextFile.writeLine(writer, "Loctn:" + this.getLoctn());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "Shape:" + this.getShape());
        this._clip.write(writer);
        TextFile.writeLine(writer, "GevClipDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal() || this.getClipData().hasMaxClip() && value > this.getClipData().getMaxVal()) {
            return 0.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return super.getPDF(value) / rescale;
    }

    @Override
    public double getCDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal()) {
            return 0.0;
        }
        if (this.getClipData().hasMaxClip() && value >= this.getClipData().getMaxVal()) {
            return 1.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return (super.getCDF(value) - minProb) / rescale;
    }

    @Override
    public double invCDF(double p) {
        GevDist gd = new GevDist(this.getLoctn(), this.getScale(), this.getShape());
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return gd.invCDF(minProb + p * rescale);
    }
}

